/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NBacnetPropertyValue;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.stack.DeviceRegistry;
import java.util.logging.Level;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.export.BBacnetScheduleDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.DataTypeNotSupportedException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetBooleanScheduleDescriptor
extends BBacnetScheduleDescriptor {
    public static final int BOOLEAN_IDX = 0;
    public static final int ENUMERATED_IDX = 1;
    public static final BEnumRange BOOL_DATA_TYPE_RANGE = BEnumRange.make((String[])new String[]{bacnetLexicon.get("BacnetBooleanScheduleDescriptor.boolean"), bacnetLexicon.get("BacnetBooleanScheduleDescriptor.enumerated")});
    public static final Property scheduleDataType = BBacnetBooleanScheduleDescriptor.newProperty((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BOOL_DATA_TYPE_RANGE), null);
    public static final Type TYPE = Sys.loadType(BBacnetBooleanScheduleDescriptor.class);

    public BEnum getScheduleDataType() {
        return (BEnum)this.get(scheduleDataType);
    }

    public void setScheduleDataType(BEnum v) {
        this.set(scheduleDataType, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    private boolean isAsnBoolean() {
        return this.getScheduleDataType().getOrdinal() == 0;
    }

    public BBacnetBooleanScheduleDescriptor() {
        this.setScheduleDataType((BEnum)BDynamicEnum.make((int)this.getScheduleDataType().getOrdinal(), (BEnumRange)BOOL_DATA_TYPE_RANGE));
    }

    @Override
    public void doWritePresentValue() {
        BBooleanSchedule sched = (BBooleanSchedule)this.getSchedule();
        if (sched != null && sched.getEffective().isEffective(BAbsTime.now())) {
            BStatusBoolean out = sched.getOut();
            byte[] booleanWriteVal = AsnUtil.toAsnNull();
            byte[] enumeratedWriteVal = AsnUtil.toAsnNull();
            if (!out.getStatus().isNull()) {
                booleanWriteVal = AsnUtil.toAsnBoolean(out.getValue());
                enumeratedWriteVal = AsnUtil.toAsnEnumerated(out.getValue() ? 1 : 0);
            }
            SlotCursor c = this.getListOfObjectPropertyReferences().getProperties();
            while (c.next(BBacnetDeviceObjectPropertyReference.class)) {
                BBacnetDeviceObjectPropertyReference ref = (BBacnetDeviceObjectPropertyReference)c.get();
                byte[] writeVal = booleanWriteVal;
                PropertyInfo pi = BBacnetNetwork.localDevice().getPropertyInfo(ref.getObjectId().getObjectType(), ref.getPropertyId());
                if (ref.isDeviceIdUsed() && !ref.getDeviceId().equals((Object)BBacnetNetwork.localDevice().getObjectId())) {
                    BBacnetAddress addr;
                    BBacnetDevice device = BBacnetNetwork.bacnet().doLookupDeviceById(ref.getDeviceId());
                    if (device != null) {
                        pi = device.getPropertyInfo(ref.getObjectId().getObjectType(), ref.getPropertyId());
                    }
                    if (pi != null) {
                        switch (pi.getAsnType()) {
                            case 9: {
                                writeVal = enumeratedWriteVal;
                                break;
                            }
                        }
                    }
                    if ((addr = DeviceRegistry.getDeviceAddress(ref.getDeviceId())) == null) {
                        try {
                            BacnetDescriptorUtil.parseLogDeviceObjectProperty(null, ref);
                        }
                        catch (Exception e) {
                            log.warning("BacnetException parsing device object property " + ref + "::" + e);
                        }
                        addr = DeviceRegistry.getDeviceAddress(ref.getDeviceId());
                    }
                    if (addr != null) {
                        try {
                            this.client().writeProperty(addr, ref.getObjectId(), ref.getPropertyId(), ref.getPropertyArrayIndex(), writeVal, this.getPriorityForWriting());
                        }
                        catch (BacnetException e) {
                            log.warning("BacnetException writing schedule output to " + ref + "::" + (Object)((Object)e));
                        }
                        continue;
                    }
                    log.warning("Unable to write Schedule output " + out + " to " + ref + ": unable to resolve device address!");
                    continue;
                }
                BIBacnetExportObject o = BBacnetNetwork.localDevice().lookupBacnetObject(ref.getObjectId());
                if (pi != null) {
                    switch (pi.getAsnType()) {
                        case 9: {
                            writeVal = enumeratedWriteVal;
                            break;
                        }
                    }
                }
                try {
                    ErrorType err = o.writeProperty(new NBacnetPropertyValue(ref.getPropertyId(), ref.getPropertyArrayIndex(), writeVal, this.getPriorityForWriting()));
                    if (err == null) continue;
                    throw new ErrorException(err);
                }
                catch (Exception e) {
                    log.warning("Unable to write schedule output " + out + " from " + this + " to local object " + ref + ": " + e);
                }
            }
            this.setLastEffectiveValue((BStatusValue)out.newCopy());
        }
    }

    @Override
    final boolean isScheduleTypeLegal(BWeeklySchedule sched) {
        return sched instanceof BBooleanSchedule;
    }

    @Override
    protected boolean isEqual(int ansTypeOfRefObj, int asnTypeOfSchedule) {
        if (ansTypeOfRefObj == asnTypeOfSchedule) {
            return true;
        }
        if (ansTypeOfRefObj == 9) {
            this.setScheduleDataType((BEnum)BDynamicEnum.make((int)1, (BEnumRange)BOOL_DATA_TYPE_RANGE));
            return true;
        }
        if (ansTypeOfRefObj == 1) {
            this.setScheduleDataType((BEnum)BDynamicEnum.make((int)0, (BEnumRange)BOOL_DATA_TYPE_RANGE));
            return true;
        }
        return false;
    }

    @Override
    int getAsnType() {
        switch (this.getScheduleDataType().getOrdinal()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 9;
            }
        }
        throw new IllegalStateException("Invalid Schedule Data Type for " + this + ":" + this.getScheduleDataType().getOrdinal());
    }

    private byte[] encodeToAsn(boolean value) {
        if (this.isAsnBoolean()) {
            return AsnUtil.toAsnBoolean(value);
        }
        return AsnUtil.toAsnEnumerated(value);
    }

    @Override
    final Property getScheduleOutputProperty() {
        return BBooleanSchedule.out;
    }

    @Override
    BStatusValue getEffectiveValueFrom(BStatusValue statusValue) {
        BStatusBoolean ret = new BStatusBoolean(false, BStatus.nullStatus);
        if (statusValue instanceof BStatusNumeric) {
            ret.setValue(((BStatusNumeric)statusValue).getValue() > 0.0);
        } else if (statusValue instanceof BStatusEnum) {
            ret.setValue(((BStatusEnum)statusValue).getValue().getOrdinal() == 0);
        } else if (statusValue instanceof BStatusBoolean) {
            ret = (BStatusBoolean)statusValue.newCopy(true);
        }
        return ret;
    }

    @Override
    protected PropertyValue readProperty(int pId, int ndx) {
        BBooleanSchedule sched = (BBooleanSchedule)this.getSchedule();
        if (sched == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        switch (pId) {
            case 85: {
                BAbsTime currentTime = BAbsTime.now();
                BStatusBoolean out = !sched.isEffective(currentTime) && this.getLastEffectiveValue() != null ? (BStatusBoolean)this.getLastEffectiveValue() : sched.getOut();
                if (out.getStatus().isNull()) {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnNull());
                }
                return new NReadPropertyResult(pId, ndx, this.encodeToAsn(out.getValue()));
            }
            case 174: {
                BStatusBoolean sb = (BStatusBoolean)sched.getDefaultOutput();
                if (sb.getStatus().isNull()) {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnNull());
                }
                return new NReadPropertyResult(pId, ndx, this.encodeToAsn(sb.getValue()));
            }
        }
        return super.readProperty(pId, ndx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BBooleanSchedule sched = (BBooleanSchedule)this.getSchedule();
        if (sched == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(val);
                switch (pId) {
                    case 85: {
                        if (!((BStatusValue)sched.get("out")).getStatus().isDisabled()) {
                            return new NErrorType(2, 40);
                        }
                        int applicationTag = asnIn.peekApplicationTag();
                        switch (applicationTag) {
                            case 0: {
                                sched.getIn().set(BStatusValue.status, (BValue)BStatus.make((BStatus)sched.getIn().getStatus(), (int)64, (boolean)false), BLocalBacnetDevice.getBacnetContext());
                                sched.getOut().set(BStatusValue.status, (BValue)BStatus.make((BStatus)sched.getOut().getStatus(), (int)64, (boolean)true), BLocalBacnetDevice.getBacnetContext());
                                return null;
                            }
                            case 1: {
                                if (this.isAsnBoolean()) {
                                    BStatusBoolean inval = (BStatusBoolean)sched.getIn().newCopy();
                                    inval.setValue(asnIn.readBoolean());
                                    inval.setStatusNull(false);
                                    sched.set(BBooleanSchedule.in, (BValue)inval, BLocalBacnetDevice.getBacnetContext());
                                    return null;
                                }
                            }
                            case 9: {
                                if (this.isAsnBoolean()) break;
                                BStatusBoolean inval = (BStatusBoolean)sched.getIn().newCopy();
                                inval.setValue(AsnUtil.fromOnlyBinaryPv(asnIn));
                                inval.setStatusNull(false);
                                sched.set(BBooleanSchedule.in, (BValue)inval, BLocalBacnetDevice.getBacnetContext());
                                return null;
                            }
                            default: {
                                return new NErrorType(2, 9);
                            }
                        }
                        return null;
                    }
                }
                return super.writeProperty(pId, ndx, val, pri);
            }
        }
        catch (OutOfRangeException oore) {
            log.info("Value out of range writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)oore));
            return new NErrorType(2, 37);
        }
        catch (DataTypeNotSupportedException dtnse) {
            log.info("Datatype not supported writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)dtnse));
            return new NErrorType(2, 47);
        }
        catch (AsnException e) {
            log.info("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.info("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
        catch (Exception e) {
            log.log(Level.INFO, "Exception writing property " + pId + " in object " + (Object)((Object)this.getObjectId()), e);
            return new NErrorType(2, 0);
        }
    }

    @Override
    protected ErrorType doWriteScheduleDefaultValue(AsnInputStream asnInputStream, int applicationTag) throws Exception {
        BBooleanSchedule sched = (BBooleanSchedule)this.getSchedule();
        switch (applicationTag) {
            case 1: {
                if (this.isAsnBoolean()) {
                    BStatusBoolean defval = (BStatusBoolean)sched.getDefaultOutput().newCopy();
                    defval.setValue(asnIn.readBoolean());
                    defval.setStatusNull(false);
                    sched.set(BControlSchedule.defaultOutput, (BValue)defval, BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            case 9: {
                if (this.isAsnBoolean()) break;
                BStatusBoolean defval = (BStatusBoolean)sched.getDefaultOutput().newCopy();
                defval.setValue(AsnUtil.fromOnlyBinaryPv(asnIn));
                defval.setStatusNull(false);
                sched.set(BControlSchedule.defaultOutput, (BValue)defval, BLocalBacnetDevice.getBacnetContext());
                return null;
            }
        }
        return new NErrorType(2, 9);
    }
}

