/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.enums.access;

import javax.baja.bacnet.BacnetConst;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BBacnetAccessUserType
extends BFrozenEnum
implements BacnetConst {
    public static final int ASSET = 0;
    public static final int GROUP = 1;
    public static final int PERSON = 2;
    public static final BBacnetAccessUserType asset = new BBacnetAccessUserType(0);
    public static final BBacnetAccessUserType group = new BBacnetAccessUserType(1);
    public static final BBacnetAccessUserType person = new BBacnetAccessUserType(2);
    public static final Type TYPE = Sys.loadType(BBacnetAccessUserType.class);
    public static final BBacnetAccessUserType DEFAULT = asset;
    public static final int MAX_ASHRAE_ID = 2;
    public static final int MAX_RESERVED_ID = 63;
    public static final int MAX_ID = 65535;

    public Type getType() {
        return TYPE;
    }

    public static BBacnetAccessUserType make(int ordinal) {
        return (BBacnetAccessUserType)asset.getRange().get(ordinal, false);
    }

    public static BBacnetAccessUserType make(String tag) {
        return (BBacnetAccessUserType)asset.getRange().get(tag);
    }

    private BBacnetAccessUserType(int ordinal) {
        super(ordinal);
    }

    public static String tag(int id) {
        if (DEFAULT.getRange().isOrdinal(id)) {
            return DEFAULT.getRange().getTag(id);
        }
        if (BBacnetAccessUserType.isAshrae(id)) {
            return ASHRAE_PREFIX + id;
        }
        if (BBacnetAccessUserType.isProprietary(id)) {
            return PROPRIETARY_PREFIX + id;
        }
        throw new InvalidEnumException(id);
    }

    public static int ordinal(String tag) {
        try {
            return DEFAULT.getRange().tagToOrdinal(tag);
        }
        catch (InvalidEnumException e) {
            if (tag.startsWith(ASHRAE_PREFIX)) {
                return Integer.parseInt(tag.substring(ASHRAE_PREFIX_LENGTH));
            }
            if (tag.startsWith(PROPRIETARY_PREFIX)) {
                return Integer.parseInt(tag.substring(PROPRIETARY_PREFIX_LENGTH));
            }
            throw e;
        }
    }

    public static boolean isProprietary(int id) {
        return id > 63 && id <= 65535;
    }

    public static boolean isAshrae(int id) {
        return id > 2 && id <= 63;
    }

    public static boolean isValid(int id) {
        return id <= 65535;
    }

    public static boolean isFixed(int id) {
        return id <= 2;
    }
}

