/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.enums;

import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BacnetConst;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BBacnetObjectType
extends BFrozenEnum
implements BacnetConst {
    public static final int ANALOG_INPUT = 0;
    public static final int ANALOG_OUTPUT = 1;
    public static final int ANALOG_VALUE = 2;
    public static final int BINARY_INPUT = 3;
    public static final int BINARY_OUTPUT = 4;
    public static final int BINARY_VALUE = 5;
    public static final int CALENDAR = 6;
    public static final int COMMAND = 7;
    public static final int DEVICE = 8;
    public static final int EVENT_ENROLLMENT = 9;
    public static final int FILE = 10;
    public static final int GROUP = 11;
    public static final int LOOP = 12;
    public static final int MULTI_STATE_INPUT = 13;
    public static final int MULTI_STATE_OUTPUT = 14;
    public static final int NOTIFICATION_CLASS = 15;
    public static final int PROGRAM = 16;
    public static final int SCHEDULE = 17;
    public static final int AVERAGING = 18;
    public static final int MULTI_STATE_VALUE = 19;
    public static final int TREND_LOG = 20;
    public static final int LIFE_SAFETY_POINT = 21;
    public static final int LIFE_SAFETY_ZONE = 22;
    public static final int ACCUMULATOR = 23;
    public static final int PULSE_CONVERTER = 24;
    public static final int EVENT_LOG = 25;
    public static final int GLOBAL_GROUP = 26;
    public static final int TREND_LOG_MULTIPLE = 27;
    public static final int LOAD_CONTROL = 28;
    public static final int STRUCTURED_VIEW = 29;
    public static final int ACCESS_DOOR = 30;
    public static final int UNASSIGNED_31 = 31;
    public static final int ACCESS_CREDENTIAL = 32;
    public static final int ACCESS_POINT = 33;
    public static final int ACCESS_RIGHTS = 34;
    public static final int ACCESS_USER = 35;
    public static final int ACCESS_ZONE = 36;
    public static final int CREDENTIAL_DATA_INPUT = 37;
    public static final int NETWORK_SECURITY = 38;
    public static final int BITSTRING_VALUE = 39;
    public static final int CHARACTER_STRING_VALUE = 40;
    public static final int DATE_PATTERN_VALUE = 41;
    public static final int DATE_VALUE = 42;
    public static final int DATE_TIME_PATTERN_VALUE = 43;
    public static final int DATE_TIME_VALUE = 44;
    public static final int INTEGER_VALUE = 45;
    public static final int LARGE_ANALOG_VALUE = 46;
    public static final int OCTET_STRING_VALUE = 47;
    public static final int POSITIVE_INTEGER_VALUE = 48;
    public static final int TIME_PATTERN_VALUE = 49;
    public static final int TIME_VALUE = 50;
    public static final int NOTIFICATION_FORWARDER = 51;
    public static final int ALERT_ENROLLMENT = 52;
    public static final int CHANNEL = 53;
    public static final int LIGHTING_OUTPUT = 54;
    public static final BBacnetObjectType analogInput = new BBacnetObjectType(0);
    public static final BBacnetObjectType analogOutput = new BBacnetObjectType(1);
    public static final BBacnetObjectType analogValue = new BBacnetObjectType(2);
    public static final BBacnetObjectType binaryInput = new BBacnetObjectType(3);
    public static final BBacnetObjectType binaryOutput = new BBacnetObjectType(4);
    public static final BBacnetObjectType binaryValue = new BBacnetObjectType(5);
    public static final BBacnetObjectType calendar = new BBacnetObjectType(6);
    public static final BBacnetObjectType command = new BBacnetObjectType(7);
    public static final BBacnetObjectType device = new BBacnetObjectType(8);
    public static final BBacnetObjectType eventEnrollment = new BBacnetObjectType(9);
    public static final BBacnetObjectType file = new BBacnetObjectType(10);
    public static final BBacnetObjectType group = new BBacnetObjectType(11);
    public static final BBacnetObjectType loop = new BBacnetObjectType(12);
    public static final BBacnetObjectType multiStateInput = new BBacnetObjectType(13);
    public static final BBacnetObjectType multiStateOutput = new BBacnetObjectType(14);
    public static final BBacnetObjectType notificationClass = new BBacnetObjectType(15);
    public static final BBacnetObjectType program = new BBacnetObjectType(16);
    public static final BBacnetObjectType schedule = new BBacnetObjectType(17);
    public static final BBacnetObjectType averaging = new BBacnetObjectType(18);
    public static final BBacnetObjectType multiStateValue = new BBacnetObjectType(19);
    public static final BBacnetObjectType trendLog = new BBacnetObjectType(20);
    public static final BBacnetObjectType lifeSafetyPoint = new BBacnetObjectType(21);
    public static final BBacnetObjectType lifeSafetyZone = new BBacnetObjectType(22);
    public static final BBacnetObjectType accumulator = new BBacnetObjectType(23);
    public static final BBacnetObjectType pulseConverter = new BBacnetObjectType(24);
    public static final BBacnetObjectType eventLog = new BBacnetObjectType(25);
    public static final BBacnetObjectType globalGroup = new BBacnetObjectType(26);
    public static final BBacnetObjectType trendLogMultiple = new BBacnetObjectType(27);
    public static final BBacnetObjectType loadControl = new BBacnetObjectType(28);
    public static final BBacnetObjectType structuredView = new BBacnetObjectType(29);
    public static final BBacnetObjectType accessDoor = new BBacnetObjectType(30);
    public static final BBacnetObjectType unassigned31 = new BBacnetObjectType(31);
    public static final BBacnetObjectType accessCredential = new BBacnetObjectType(32);
    public static final BBacnetObjectType accessPoint = new BBacnetObjectType(33);
    public static final BBacnetObjectType accessRights = new BBacnetObjectType(34);
    public static final BBacnetObjectType accessUser = new BBacnetObjectType(35);
    public static final BBacnetObjectType accessZone = new BBacnetObjectType(36);
    public static final BBacnetObjectType credentialDataInput = new BBacnetObjectType(37);
    public static final BBacnetObjectType networkSecurity = new BBacnetObjectType(38);
    public static final BBacnetObjectType bitstringValue = new BBacnetObjectType(39);
    public static final BBacnetObjectType characterStringValue = new BBacnetObjectType(40);
    public static final BBacnetObjectType datePatternValue = new BBacnetObjectType(41);
    public static final BBacnetObjectType dateValue = new BBacnetObjectType(42);
    public static final BBacnetObjectType dateTimePatternValue = new BBacnetObjectType(43);
    public static final BBacnetObjectType dateTimeValue = new BBacnetObjectType(44);
    public static final BBacnetObjectType integerValue = new BBacnetObjectType(45);
    public static final BBacnetObjectType largeAnalogValue = new BBacnetObjectType(46);
    public static final BBacnetObjectType octetStringValue = new BBacnetObjectType(47);
    public static final BBacnetObjectType positiveIntegerValue = new BBacnetObjectType(48);
    public static final BBacnetObjectType timePatternValue = new BBacnetObjectType(49);
    public static final BBacnetObjectType timeValue = new BBacnetObjectType(50);
    public static final BBacnetObjectType notificationForwarder = new BBacnetObjectType(51);
    public static final BBacnetObjectType alertEnrollment = new BBacnetObjectType(52);
    public static final BBacnetObjectType channel = new BBacnetObjectType(53);
    public static final BBacnetObjectType lightingOutput = new BBacnetObjectType(54);
    public static final Type TYPE = Sys.loadType(BBacnetObjectType.class);
    public static final BBacnetObjectType DEFAULT = analogInput;
    public static final int MAX_ASHRAE_ID = 52;
    public static final int MAX_RESERVED_ID = 127;
    public static final int MAX_ID = 1023;
    private static final String INVALID_OBJECT_TYPE = "INVALID";
    private static int[] sfPr0 = new int[]{22, 21, 19, 16, 14, 13, 12, 5, 4, 3, 2, 1, 0};
    private static int[] sfPr4 = new int[]{24, 23, 17};
    private static int[] sfPr6 = new int[]{30, 28};
    private static int[] sfPr7 = new int[]{28, 27, 25, 20};
    private static int[] pr10 = new int[]{46, 45, 48, 40};
    private static long statusFlagsObjectTypes = BBacnetObjectType.bitmask(sfPr0);
    private static long statusFlagsObjectTypesPR4 = BBacnetObjectType.bitmask(sfPr4) | statusFlagsObjectTypes;
    private static long statusFlagsObjectTypesPR6 = BBacnetObjectType.bitmask(sfPr6) | statusFlagsObjectTypesPR4;
    private static long statusFlagsObjectTypesPR7 = BBacnetObjectType.bitmask(sfPr7) | statusFlagsObjectTypesPR6;
    private static long statusFlagsObjectTypesPR10 = BBacnetObjectType.bitmask(pr10) | statusFlagsObjectTypesPR7;
    private static int[] covPr0 = new int[]{22, 21, 19, 14, 13, 12, 5, 4, 3, 2, 1, 0};
    private static int[] covPr4 = new int[]{24};
    private static int[] covPr6 = new int[]{30, 28};
    private static long covObjectTypes = BBacnetObjectType.bitmask(covPr0);
    private static long covObjectTypesPR4 = BBacnetObjectType.bitmask(covPr4) | covObjectTypes;
    private static long covObjectTypesPR6 = BBacnetObjectType.bitmask(covPr6) | covObjectTypesPR4;
    private static long covObjectTypesPR10 = BBacnetObjectType.bitmask(pr10) | covObjectTypesPR6;
    private static IntHashMap stagByOType = new IntHashMap();
    private static IntHashMap objectIdFacets;

    public Type getType() {
        return TYPE;
    }

    public static BBacnetObjectType make(int ordinal) {
        return (BBacnetObjectType)analogInput.getRange().get(ordinal, false);
    }

    public static BBacnetObjectType make(String tag) {
        return (BBacnetObjectType)analogInput.getRange().get(tag);
    }

    private BBacnetObjectType(int ordinal) {
        super(ordinal);
    }

    public static String tag(int id) {
        if (DEFAULT.getRange().isOrdinal(id)) {
            return DEFAULT.getRange().getTag(id);
        }
        if (BBacnetObjectType.isAshrae(id)) {
            return ASHRAE_PREFIX + id;
        }
        if (BBacnetObjectType.isProprietary(id)) {
            return PROPRIETARY_PREFIX + id;
        }
        return "INVALID:" + id;
    }

    public static int ordinal(String tag) {
        try {
            return DEFAULT.getRange().tagToOrdinal(tag);
        }
        catch (InvalidEnumException e) {
            if (tag.startsWith(ASHRAE_PREFIX)) {
                return Integer.parseInt(tag.substring(ASHRAE_PREFIX_LENGTH));
            }
            if (tag.startsWith(PROPRIETARY_PREFIX)) {
                return Integer.parseInt(tag.substring(PROPRIETARY_PREFIX_LENGTH));
            }
            if (tag.startsWith(INVALID_OBJECT_TYPE)) {
                return -1;
            }
            throw e;
        }
    }

    public static boolean isProprietary(int id) {
        return id > 127 && id <= 1023;
    }

    public static boolean isAshrae(int id) {
        return id > 52 && id <= 127;
    }

    public static boolean isValid(int id) {
        return id <= 1023;
    }

    public static boolean isFixed(int id) {
        return id <= 52;
    }

    @Deprecated
    public static final boolean hasStatusFlags(int ordinal) {
        return BBacnetObjectType.hasStatusFlags(ordinal, null);
    }

    public static final boolean hasStatusFlags(int ordinal, BBacnetDevice device) {
        int pr = 0;
        if (device != null) {
            pr = device.getProtocolRevision();
        }
        return BBacnetObjectType.hasStatusFlags(ordinal, pr);
    }

    public static final boolean hasStatusFlags(int ordinal, int pr) {
        if (ordinal > 52) {
            return false;
        }
        long chk = 1L << ordinal;
        if (pr > 9) {
            return (chk & statusFlagsObjectTypesPR10) != 0L;
        }
        if (pr > 6) {
            return (chk & statusFlagsObjectTypesPR7) != 0L;
        }
        if (pr > 5) {
            return (chk & statusFlagsObjectTypesPR6) != 0L;
        }
        if (pr > 3) {
            return (chk & statusFlagsObjectTypesPR4) != 0L;
        }
        return (chk & statusFlagsObjectTypes) != 0L;
    }

    @Deprecated
    public static final boolean canSupportCov(int ordinal) {
        return BBacnetObjectType.canSupportCov(ordinal, null);
    }

    public static final boolean canSupportCov(int ordinal, BBacnetDevice device) {
        int pr = 0;
        if (device != null) {
            pr = device.getProtocolRevision();
        }
        return BBacnetObjectType.canSupportCov(ordinal, pr);
    }

    public static final boolean canSupportCov(int ordinal, int pr) {
        if (ordinal > 52) {
            return false;
        }
        long chk = 1L << ordinal;
        if (pr > 9) {
            return (chk & covObjectTypesPR10) != 0L;
        }
        if (pr > 5) {
            return (chk & covObjectTypesPR6) != 0L;
        }
        if (pr > 3) {
            return (chk & covObjectTypesPR4) != 0L;
        }
        return (chk & covObjectTypes) != 0L;
    }

    public static long bitmask(int ... bits) {
        long mask = 0L;
        for (int i = 0; i < bits.length; ++i) {
            mask |= 1L << bits[i];
        }
        return mask;
    }

    public static String getShortTag(int type) {
        String s = (String)stagByOType.get(type);
        if (s != null) {
            return s;
        }
        return type + ":";
    }

    public static BFacets getObjectIdFacets(int objectType) {
        return (BFacets)objectIdFacets.get(objectType);
    }

    static {
        stagByOType.put(0, (Object)"AI");
        stagByOType.put(1, (Object)"AO");
        stagByOType.put(2, (Object)"AV");
        stagByOType.put(3, (Object)"BI");
        stagByOType.put(4, (Object)"BO");
        stagByOType.put(5, (Object)"BV");
        stagByOType.put(6, (Object)"CAL");
        stagByOType.put(7, (Object)"CMD");
        stagByOType.put(8, (Object)"DEV");
        stagByOType.put(9, (Object)"EE");
        stagByOType.put(10, (Object)"FILE");
        stagByOType.put(11, (Object)"GRP");
        stagByOType.put(12, (Object)"LP");
        stagByOType.put(13, (Object)"MSI");
        stagByOType.put(14, (Object)"MSO");
        stagByOType.put(15, (Object)"NC");
        stagByOType.put(16, (Object)"PGM");
        stagByOType.put(17, (Object)"SCH");
        stagByOType.put(18, (Object)"AVG");
        stagByOType.put(19, (Object)"MSV");
        stagByOType.put(20, (Object)"LOG");
        stagByOType.put(21, (Object)"LSP");
        stagByOType.put(22, (Object)"LSZ");
        stagByOType.put(23, (Object)"ACC");
        stagByOType.put(24, (Object)"PC");
        stagByOType.put(25, (Object)"ELOG");
        stagByOType.put(27, (Object)"TLM");
        stagByOType.put(28, (Object)"LCO");
        stagByOType.put(29, (Object)"SVO");
        stagByOType.put(30, (Object)"DOOR");
        stagByOType.put(40, (Object)"CSV");
        stagByOType.put(46, (Object)"LAV");
        stagByOType.put(45, (Object)"INT");
        stagByOType.put(48, (Object)"PINT");
        objectIdFacets = new IntHashMap();
        objectIdFacets.put(0, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{0}, (String[])new String[]{analogInput.getTag()})));
        objectIdFacets.put(1, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{1}, (String[])new String[]{analogOutput.getTag()})));
        objectIdFacets.put(2, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{2}, (String[])new String[]{analogValue.getTag()})));
        objectIdFacets.put(3, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{3}, (String[])new String[]{binaryInput.getTag()})));
        objectIdFacets.put(4, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{4}, (String[])new String[]{binaryOutput.getTag()})));
        objectIdFacets.put(5, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{5}, (String[])new String[]{binaryValue.getTag()})));
        objectIdFacets.put(6, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{6}, (String[])new String[]{calendar.getTag()})));
        objectIdFacets.put(7, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{7}, (String[])new String[]{command.getTag()})));
        objectIdFacets.put(8, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{8}, (String[])new String[]{device.getTag()})));
        objectIdFacets.put(9, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{9}, (String[])new String[]{eventEnrollment.getTag()})));
        objectIdFacets.put(10, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{10}, (String[])new String[]{file.getTag()})));
        objectIdFacets.put(11, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{11}, (String[])new String[]{group.getTag()})));
        objectIdFacets.put(12, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{12}, (String[])new String[]{loop.getTag()})));
        objectIdFacets.put(13, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{13}, (String[])new String[]{multiStateInput.getTag()})));
        objectIdFacets.put(14, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{14}, (String[])new String[]{multiStateOutput.getTag()})));
        objectIdFacets.put(15, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{15}, (String[])new String[]{notificationClass.getTag()})));
        objectIdFacets.put(16, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{16}, (String[])new String[]{program.getTag()})));
        objectIdFacets.put(17, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{17}, (String[])new String[]{schedule.getTag()})));
        objectIdFacets.put(18, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{18}, (String[])new String[]{averaging.getTag()})));
        objectIdFacets.put(19, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{19}, (String[])new String[]{multiStateValue.getTag()})));
        objectIdFacets.put(20, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{20}, (String[])new String[]{trendLog.getTag()})));
        objectIdFacets.put(21, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{21}, (String[])new String[]{lifeSafetyPoint.getTag()})));
        objectIdFacets.put(22, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{22}, (String[])new String[]{lifeSafetyZone.getTag()})));
        objectIdFacets.put(23, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{23}, (String[])new String[]{accumulator.getTag()})));
        objectIdFacets.put(24, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{24}, (String[])new String[]{pulseConverter.getTag()})));
        objectIdFacets.put(46, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{46}, (String[])new String[]{largeAnalogValue.getTag()})));
        objectIdFacets.put(45, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{45}, (String[])new String[]{integerValue.getTag()})));
        objectIdFacets.put(48, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{48}, (String[])new String[]{positiveIntegerValue.getTag()})));
        objectIdFacets.put(40, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{40}, (String[])new String[]{characterStringValue.getTag()})));
    }
}

