/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes.access;

import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectReference;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BBacnetAccessRule
extends BStruct
implements BIBacnetDataType {
    public static final Property timeRangeSpecifier = BBacnetAccessRule.newProperty((int)0, (int)1, null);
    public static final Property timeRange = BBacnetAccessRule.newProperty((int)0, (BValue)new BBacnetDeviceObjectPropertyReference(), null);
    public static final Property locationSpecifier = BBacnetAccessRule.newProperty((int)0, (int)1, null);
    public static final Property location = BBacnetAccessRule.newProperty((int)0, (BValue)new BBacnetDeviceObjectReference(), null);
    public static final Property enable = BBacnetAccessRule.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BBacnetAccessRule.class);
    public static final int SPECIFIED = 0;
    public static final int TIME_RANGE_SPECIFIER_TAG = 0;
    public static final int TIME_RANGE_TAG = 1;
    public static final int LOCATION_SPECIFIER_TAG = 2;
    public static final int LOCATION_TAG = 3;
    public static final int ENABLE_TAG = 4;
    public static final int MAX_ENCODED_SIZE = 16;

    public int getTimeRangeSpecifier() {
        return this.getInt(timeRangeSpecifier);
    }

    public void setTimeRangeSpecifier(int v) {
        this.setInt(timeRangeSpecifier, v, null);
    }

    public BBacnetDeviceObjectPropertyReference getTimeRange() {
        return (BBacnetDeviceObjectPropertyReference)this.get(timeRange);
    }

    public void setTimeRange(BBacnetDeviceObjectPropertyReference v) {
        this.set(timeRange, (BValue)v, null);
    }

    public int getLocationSpecifier() {
        return this.getInt(locationSpecifier);
    }

    public void setLocationSpecifier(int v) {
        this.setInt(locationSpecifier, v, null);
    }

    public BBacnetDeviceObjectReference getLocation() {
        return (BBacnetDeviceObjectReference)this.get(location);
    }

    public void setLocation(BBacnetDeviceObjectReference v) {
        this.set(location, (BValue)v, null);
    }

    public boolean getEnable() {
        return this.getBoolean(enable);
    }

    public void setEnable(boolean v) {
        this.setBoolean(enable, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBacnetAccessRule() {
    }

    public BBacnetAccessRule(int timeRangeSpecifier, BBacnetDeviceObjectPropertyReference timeRange, int locationSpecifier, BBacnetDeviceObjectReference location, boolean enable) {
        this.setTimeRangeSpecifier(timeRangeSpecifier);
        this.setTimeRange(timeRange);
        this.setLocationSpecifier(locationSpecifier);
        this.setLocation(location);
        this.setEnable(enable);
    }

    public String toString(Context context) {
        StringBuilder sb = new StringBuilder("BBacnetAccessRule:");
        sb.append(this.getTimeRangeSpecifier()).append(":").append(this.getTimeRange()).append(":").append(this.getLocationSpecifier()).append(":").append(this.getLocation()).append(":").append(this.getEnable());
        return sb.toString();
    }

    @Override
    public void writeAsn(AsnOutput out) {
        int trs = this.getTimeRangeSpecifier();
        out.writeEnumerated(0, trs);
        if (trs == 0) {
            out.writeOpeningTag(0);
            this.getTimeRange().writeAsn(out);
            out.writeClosingTag(0);
        }
        int ls = this.getLocationSpecifier();
        out.writeEnumerated(2, ls);
        if (ls == 0) {
            out.writeOpeningTag(2);
            this.getTimeRange().writeAsn(out);
            out.writeClosingTag(2);
        }
        out.writeBoolean(4, this.getEnable());
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        int trs = in.readEnumerated(0);
        this.setInt(timeRangeSpecifier, trs, noWrite);
        if (trs == 0 && in.isContextTag(0)) {
            in.skipTag();
            this.getTimeRange().readAsn(in);
            in.skipTag();
        }
        int ls = in.readEnumerated(2);
        this.setInt(locationSpecifier, ls, noWrite);
        if (ls == 0 && in.isContextTag(2)) {
            in.skipTag();
            this.getLocation().readAsn(in);
            in.skipTag();
        }
    }
}

