/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetRecipient;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BBacnetRecipientProcess
extends BStruct
implements BIBacnetDataType {
    public static final Property recipient = BBacnetRecipientProcess.newProperty((int)0, (BValue)new BBacnetRecipient(), null);
    public static final Property processIdentifier = BBacnetRecipientProcess.newProperty((int)0, (BValue)BBacnetUnsigned.make(0L), null);
    public static final Type TYPE = Sys.loadType(BBacnetRecipientProcess.class);
    public static final int RECIPIENT_TAG = 0;
    public static final int PROCESS_ID_TAG = 1;

    public BBacnetRecipient getRecipient() {
        return (BBacnetRecipient)this.get(recipient);
    }

    public void setRecipient(BBacnetRecipient v) {
        this.set(recipient, (BValue)v, null);
    }

    public BBacnetUnsigned getProcessIdentifier() {
        return (BBacnetUnsigned)this.get(processIdentifier);
    }

    public void setProcessIdentifier(BBacnetUnsigned v) {
        this.set(processIdentifier, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBacnetRecipientProcess() {
    }

    public BBacnetRecipientProcess(BBacnetRecipient recipient, BBacnetUnsigned processIdentifier) {
        this.setRecipient(recipient);
        this.setProcessIdentifier(processIdentifier);
    }

    @Override
    public void writeAsn(AsnOutput out) {
        out.writeOpeningTag(0);
        this.getRecipient().writeAsn(out);
        out.writeClosingTag(0);
        out.writeUnsigned(1, this.getProcessIdentifier());
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        int tag = in.peekTag();
        if (!in.isOpeningTag(0)) {
            throw new AsnException("Invalid tag: " + tag);
        }
        in.skipTag();
        this.getRecipient().readAsn(in);
        in.skipTag();
        this.set(processIdentifier, (BValue)in.readUnsigned(1), noWrite);
    }

    public String toString(Context cx) {
        if (cx != null && cx.equals(BacnetConst.nameContext)) {
            return this.getRecipient().toString(cx) + "_id_" + this.getProcessIdentifier().toString();
        }
        return "recip:" + this.getRecipient().toString(cx) + "; procID:" + this.getProcessIdentifier().toString();
    }
}

