/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetAction;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.enums.BBacnetBinaryPv;
import javax.baja.bacnet.enums.BBacnetDeviceStatus;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetFileAccessMethod;
import javax.baja.bacnet.enums.BBacnetLifeSafetyMode;
import javax.baja.bacnet.enums.BBacnetLifeSafetyOperation;
import javax.baja.bacnet.enums.BBacnetLifeSafetyState;
import javax.baja.bacnet.enums.BBacnetMaintenance;
import javax.baja.bacnet.enums.BBacnetNodeType;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BBacnetPolarity;
import javax.baja.bacnet.enums.BBacnetProgramError;
import javax.baja.bacnet.enums.BBacnetProgramRequest;
import javax.baja.bacnet.enums.BBacnetProgramState;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.enums.BBacnetRestartReason;
import javax.baja.bacnet.enums.BBacnetShedState;
import javax.baja.bacnet.enums.BBacnetSilencedState;
import javax.baja.bacnet.enums.BBacnetWriteStatus;
import javax.baja.bacnet.enums.access.BBacnetAccessCredentialDisable;
import javax.baja.bacnet.enums.access.BBacnetAccessCredentialDisableReason;
import javax.baja.bacnet.enums.access.BBacnetAccessEvent;
import javax.baja.bacnet.enums.access.BBacnetAccessZoneOccupancyState;
import javax.baja.bacnet.enums.access.BBacnetDoorAlarmState;
import javax.baja.bacnet.enums.access.BBacnetDoorSecuredStatus;
import javax.baja.bacnet.enums.access.BBacnetDoorStatus;
import javax.baja.bacnet.enums.access.BBacnetDoorValue;
import javax.baja.bacnet.enums.access.BBacnetLockStatus;
import javax.baja.bacnet.enums.lighting.BBacnetLightingInProgress;
import javax.baja.bacnet.enums.lighting.BBacnetLightingOperation;
import javax.baja.bacnet.enums.lighting.BBacnetLightingTransition;
import javax.baja.bacnet.enums.security.BBacnetSecurityLevel;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public final class BBacnetPropertyStates
extends BComponent
implements BIBacnetDataType {
    public static final Property choice = BBacnetPropertyStates.newProperty((int)4, (int)0, null);
    public static final Type TYPE = Sys.loadType(BBacnetPropertyStates.class);
    private static final int MAX_TAG = 254;
    public static final int BOOLEAN_VALUE_TAG = 0;
    public static final int BINARY_VALUE_TAG = 1;
    public static final int EVENT_TYPE_TAG = 2;
    public static final int POLARITY_TAG = 3;
    public static final int PROGRAM_CHANGE_TAG = 4;
    public static final int PROGRAM_STATE_TAG = 5;
    public static final int REASON_FOR_HALT_TAG = 6;
    public static final int RELIABILITY_TAG = 7;
    public static final int STATE_TAG = 8;
    public static final int SYSTEM_STATUS_TAG = 9;
    public static final int UNITS_TAG = 10;
    public static final int UNSIGNED_VALUE_TAG = 11;
    public static final int LIFE_SAFETY_MODE_TAG = 12;
    public static final int LIFE_SAFETY_STATE_TAG = 13;
    public static final int RESTART_REASON_TAG = 14;
    public static final int DOOR_ALARM_TAG = 15;
    public static final int ACTION_TAG = 16;
    public static final int DOOR_SECURED_STATUS_TAG = 17;
    public static final int DOOR_STATUS_TAG = 18;
    public static final int DOOR_VALUE_TAG = 19;
    public static final int FILE_ACCESS_METHOD_TAG = 20;
    public static final int LOCK_STATUS_TAG = 21;
    public static final int LIFE_SAFETY_OPERATION_TAG = 22;
    public static final int MAINTENANCE_TAG = 23;
    public static final int NODE_TYPE_TAG = 24;
    public static final int NOTIFY_TYPE_TAG = 25;
    public static final int SECURITY_LEVEL_TAG = 26;
    public static final int SHED_STATE_TAG = 27;
    public static final int SILENCED_STATE_TAG = 28;
    public static final int RESERVED29_TAG = 29;
    public static final int ACCESS_EVENT_TAG = 30;
    public static final int ZONE_OCCUPANCY_TAG = 31;
    public static final int ACCESS_CREDENTIAL_DISABLE_REASON_TAG = 32;
    public static final int ACCESS_CREDENTIAL_DISABLE_TAG = 33;
    public static final int AUTHENTICATION_STATUS_TAG = 34;
    public static final int BACKUP_STATE_TAG = 36;
    public static final int WRITE_STATUS_TAG = 37;
    public static final int LIGHTING_IN_PROGRESS_TAG = 38;
    public static final int LIGHTING_OPERATION_TAG = 39;
    public static final int LIGHTING_TRANSITION_TAG = 40;
    private static final int MAX_DEFINED_CHOICE = 40;
    private static final int MAX_ASHRAE_CHOICE = 63;
    private static final Lexicon lex = Lexicon.make((String)"bacnet");
    private static String[] tags = new String[]{lex.getText("BacnetPropertyStates.booleanValue"), lex.getText("BacnetPropertyStates.binaryValue"), lex.getText("BacnetPropertyStates.eventType"), lex.getText("BacnetPropertyStates.polarity"), lex.getText("BacnetPropertyStates.programChange"), lex.getText("BacnetPropertyStates.programState"), lex.getText("BacnetPropertyStates.reasonForHalt"), lex.getText("BacnetPropertyStates.reliability"), lex.getText("BacnetPropertyStates.state"), lex.getText("BacnetPropertyStates.systemStatus"), lex.getText("BacnetPropertyStates.units"), lex.getText("BacnetPropertyStates.unsignedValue"), lex.getText("BacnetPropertyStates.lifeSafetyMode"), lex.getText("BacnetPropertyStates.lifeSafetyState"), lex.getText("BacnetPropertyStates.restartReason"), lex.getText("BacnetPropertyStates.doorAlarmState"), lex.getText("BacnetPropertyStates.action"), lex.getText("BacnetPropertyStates.doorSecuredStatus"), lex.getText("BacnetPropertyStates.doorStatus"), lex.getText("BacnetPropertyStates.doorValue"), lex.getText("BacnetPropertyStates.fileAccessMethod"), lex.getText("BacnetPropertyStates.lockStatus"), lex.getText("BacnetPropertyStates.lifeSafetyOperation"), lex.getText("BacnetPropertyStates.maintenance"), lex.getText("BacnetPropertyStates.nodeType"), lex.getText("BacnetPropertyStates.notifyType"), lex.getText("BacnetPropertyStates.securityLevel"), lex.getText("BacnetPropertyStates.shedState"), lex.getText("BacnetPropertyStates.silencedState"), lex.getText("BacnetPropertyStates.reserved29"), lex.getText("BacnetPropertyStates.accessEvent"), lex.getText("BacnetPropertyStates.zoneOccupancyState"), lex.getText("BacnetPropertyStates.accessCredentialDisableReason"), lex.getText("BacnetPropertyStates.accessCredentialDisable"), lex.getText("BacnetPropertyStates.authenticationStatus"), lex.getText("BacnetPropertyStates.reserved35"), lex.getText("BacnetPropertyStates.backupState"), lex.getText("BacnetPropertyStates.writeStatus"), lex.getText("BacnetPropertyStates.lightingInProgress"), lex.getText("BacnetPropertyStates.lightingOperation"), lex.getText("BacnetPropertyStates.lightingTransition"), lex.getText("BacnetPropertyStates.ashrae"), lex.getText("BacnetPropertyStates.proprietary"), lex.getText("BacnetPropertyStates.invalid")};
    private static final int ASHRAE_CHOICE_INDEX = 41;
    private static final int PROPRIETARY_CHOICE_INDEX = 42;
    private static final int INVALID_CHOICE_INDEX = 43;
    public static final String BOOLEAN_VALUE_SLOT_NAME = "booleanValue";
    public static final String BINARY_VALUE_SLOT_NAME = "binaryValue";
    public static final String UNSIGNED_VALUE_SLOT_NAME = "unsignedValue";
    private static final String[] slotNames = new String[]{"booleanValue", "binaryValue", "eventType", "polarity", "programChange", "programState", "reasonForHalt", "reliability", "state", "systemStatus", "units", "unsignedValue", "lifeSafetyMode", "lifeSafetyState", "restartReason", "doorAlarmState", "action", "doorSecuredStatus", "doorStatus", "doorValue", "fileAccessMethod", "lockStatus", "lifeSafetyOperation", "maintenance", "nodeType", "notifyType", "securityLevel", "shedState", "silencedState", "reserved29", "accessEvent", "zoneOccupancyState", "accessCredentialDisableReason", "accessCredentialDisable", "authenticationStatus", "reserved35", "backupState", "reserved37", "lightingInProgress", "lightingOperation", "lightingTransition"};

    public int getChoice() {
        return this.getInt(choice);
    }

    public void setChoice(int v) {
        this.setInt(choice, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BBacnetPropertyStates makeBinaryPv(boolean value) {
        BBacnetPropertyStates propertyStates = new BBacnetPropertyStates();
        propertyStates.setChoice(1);
        propertyStates.add(BINARY_VALUE_SLOT_NAME, (BValue)BBacnetBinaryPv.make(value));
        return propertyStates;
    }

    public static BBacnetPropertyStates makeUnsigned(long value) {
        BBacnetPropertyStates propertyStates = new BBacnetPropertyStates();
        propertyStates.setChoice(11);
        propertyStates.add(UNSIGNED_VALUE_SLOT_NAME, (BValue)BBacnetUnsigned.make(value));
        return propertyStates;
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        BComplex parent = this.getParent();
        if (parent != null) {
            parent.asComponent().changed(this.getPropertyInParent(), cx);
        }
    }

    public final void subscribed() {
        BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty(this);
        if (vp != null) {
            vp.childSubscribed(this);
        }
    }

    public final void unsubscribed() {
        BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty(this);
        if (vp != null) {
            vp.childUnsubscribed(this);
        }
    }

    public BCategoryMask getAppliedCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getAppliedCategoryMask();
        }
        return super.getAppliedCategoryMask();
    }

    public BCategoryMask getCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getCategoryMask();
        }
        return super.getCategoryMask();
    }

    public BPermissions getPermissions(Context cx) {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getPermissions(cx);
        }
        return super.getPermissions(cx);
    }

    public String toString(Context cx) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTag());
        int choice = this.getChoice();
        switch (choice) {
            case 0: {
                sb.append((BBoolean)this.get(BOOLEAN_VALUE_SLOT_NAME));
                break;
            }
            case 11: {
                sb.append((Object)((BBacnetUnsigned)this.get(UNSIGNED_VALUE_SLOT_NAME)));
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                sb.append((BEnum)this.get(slotNames[choice]));
                break;
            }
        }
        return sb.toString();
    }

    @Override
    public void writeAsn(AsnOutput out) {
        int choice = this.getChoice();
        switch (choice) {
            case 0: {
                out.writeBoolean(0, (BBoolean)this.get(BOOLEAN_VALUE_SLOT_NAME));
                break;
            }
            case 11: {
                out.writeUnsigned(11, (BBacnetUnsigned)this.get(UNSIGNED_VALUE_SLOT_NAME));
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                out.writeEnumerated(choice, (BEnum)this.get(slotNames[choice]));
                break;
            }
        }
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        int tag = in.peekTag();
        if (tag < 0 || tag > 254) {
            throw new AsnException("Invalid tag: " + tag);
        }
        this.setInt(choice, tag, noWrite);
        this.removeAll(noWrite);
        switch (tag) {
            case 0: {
                this.add(BOOLEAN_VALUE_SLOT_NAME, (BValue)BBoolean.make((boolean)in.readBoolean(tag)), noWrite);
                break;
            }
            case 1: {
                this.add(BINARY_VALUE_SLOT_NAME, (BValue)BBacnetBinaryPv.make(in.readEnumerated(tag)), noWrite);
                break;
            }
            case 2: {
                this.add("eventType", (BValue)BDynamicEnum.make((int)in.readEnumerated(tag), (BEnumRange)BBacnetEventType.DEFAULT.getRange()), noWrite);
                break;
            }
            case 3: {
                this.add("polarity", (BValue)BBacnetPolarity.make(in.readEnumerated(tag)), noWrite);
                break;
            }
            case 4: {
                this.add("programChange", (BValue)BBacnetProgramRequest.make(in.readEnumerated(tag)), noWrite);
                break;
            }
            case 5: {
                this.add("programState", (BValue)BBacnetProgramState.make(in.readEnumerated(tag)), noWrite);
                break;
            }
            case 6: {
                this.add("reasonForHalt", (BValue)BDynamicEnum.make((int)in.readEnumerated(tag), (BEnumRange)BBacnetProgramError.DEFAULT.getRange()), noWrite);
                break;
            }
            case 7: {
                this.add("reliability", (BValue)BDynamicEnum.make((int)in.readEnumerated(tag), (BEnumRange)BBacnetReliability.DEFAULT.getRange()), noWrite);
                break;
            }
            case 8: {
                this.add("state", (BValue)BDynamicEnum.make((int)in.readEnumerated(tag), (BEnumRange)BBacnetEventState.DEFAULT.getRange()), noWrite);
                break;
            }
            case 9: {
                this.add("systemStatus", (BValue)BDynamicEnum.make((int)in.readEnumerated(tag), (BEnumRange)BBacnetDeviceStatus.DEFAULT.getRange()), noWrite);
                break;
            }
            case 10: {
                this.add("units", (BValue)BDynamicEnum.make((int)in.readEnumerated(tag), (BEnumRange)BBacnetEngineeringUnits.DEFAULT.getRange()), noWrite);
                break;
            }
            case 11: {
                this.add(UNSIGNED_VALUE_SLOT_NAME, (BValue)BBacnetUnsigned.make(in.readUnsignedInteger(tag)), noWrite);
                break;
            }
            case 12: {
                this.add("lifeSafetyMode", (BValue)BDynamicEnum.make((int)in.readEnumerated(tag), (BEnumRange)BBacnetLifeSafetyMode.DEFAULT.getRange()), noWrite);
                break;
            }
            case 13: {
                this.add("lifeSafetyState", (BValue)BDynamicEnum.make((int)in.readEnumerated(tag), (BEnumRange)BBacnetLifeSafetyState.DEFAULT.getRange()), noWrite);
                break;
            }
            case 14: {
                this.add("restartReason", (BValue)BDynamicEnum.make((int)in.readEnumerated(tag), (BEnumRange)BBacnetRestartReason.DEFAULT.getRange()), noWrite);
                break;
            }
            case 15: {
                this.addEnum((BEnum)BBacnetDoorAlarmState.DEFAULT, in, tag);
                break;
            }
            case 16: {
                this.addEnum((BEnum)BBacnetAction.DEFAULT, in, tag);
                break;
            }
            case 17: {
                this.addEnum((BEnum)BBacnetDoorSecuredStatus.DEFAULT, in, tag);
                break;
            }
            case 18: {
                this.addEnum((BEnum)BBacnetDoorStatus.DEFAULT, in, tag);
                break;
            }
            case 19: {
                this.addEnum((BEnum)BBacnetDoorValue.DEFAULT, in, tag);
                break;
            }
            case 20: {
                this.addEnum((BEnum)BBacnetFileAccessMethod.DEFAULT, in, tag);
                break;
            }
            case 21: {
                this.addEnum((BEnum)BBacnetLockStatus.DEFAULT, in, tag);
                break;
            }
            case 22: {
                this.addEnum((BEnum)BBacnetLifeSafetyOperation.DEFAULT, in, tag);
                break;
            }
            case 23: {
                this.addEnum((BEnum)BBacnetMaintenance.DEFAULT, in, tag);
                break;
            }
            case 24: {
                this.addEnum((BEnum)BBacnetNodeType.DEFAULT, in, tag);
                break;
            }
            case 25: {
                this.addEnum((BEnum)BBacnetNotifyType.DEFAULT, in, tag);
                break;
            }
            case 26: {
                this.addEnum((BEnum)BBacnetSecurityLevel.DEFAULT, in, tag);
                break;
            }
            case 27: {
                this.addEnum((BEnum)BBacnetShedState.DEFAULT, in, tag);
                break;
            }
            case 28: {
                this.addEnum((BEnum)BBacnetSilencedState.DEFAULT, in, tag);
                break;
            }
            case 30: {
                this.addEnum((BEnum)BBacnetAccessEvent.DEFAULT, in, tag);
                break;
            }
            case 31: {
                this.addEnum((BEnum)BBacnetAccessZoneOccupancyState.DEFAULT, in, tag);
                break;
            }
            case 32: {
                this.addEnum((BEnum)BBacnetAccessCredentialDisableReason.DEFAULT, in, tag);
                break;
            }
            case 33: {
                this.addEnum((BEnum)BBacnetAccessCredentialDisable.DEFAULT, in, tag);
                break;
            }
            case 36: {
                this.addEnum((BEnum)BBacnetBackupState.DEFAULT, in, tag);
                break;
            }
            case 37: {
                this.addEnum((BEnum)BBacnetWriteStatus.DEFAULT, in, tag);
                break;
            }
            case 38: {
                this.addEnum((BEnum)BBacnetLightingInProgress.DEFAULT, in, tag);
                break;
            }
            case 39: {
                this.addEnum((BEnum)BBacnetLightingOperation.DEFAULT, in, tag);
                break;
            }
            case 40: {
                this.addEnum((BEnum)BBacnetLightingTransition.DEFAULT, in, tag);
                break;
            }
            default: {
                in.skipTag();
            }
        }
    }

    private final void addEnum(BEnum defEnum, AsnInput in, int tag) throws AsnException {
        this.add(slotNames[tag], (BValue)BDynamicEnum.make((int)in.readEnumerated(tag), (BEnumRange)defEnum.getRange()), noWrite);
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetPropertyStates", 2);
        out.prop((Object)"virtual", BacnetVirtualUtil.isVirtual(this));
        out.endProps();
    }

    private String getTag() {
        int ch = this.getChoice();
        if (ch < 0 || ch > 254) {
            ch = 43;
        }
        if (ch <= 40) {
            return tags[ch];
        }
        ch = ch <= 63 ? 41 : 42;
        return tags[ch];
    }
}

