/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.asn.AsnUtil;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BErrorType;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BBacnetPropertyAccessResult
extends BComponent
implements PropertyValue,
BIBacnetDataType {
    public static final Property objectId = BBacnetPropertyAccessResult.newProperty((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Property propertyId = BBacnetPropertyAccessResult.newProperty((int)1, (int)85, null);
    public static final Property propertyArrayIndex = BBacnetPropertyAccessResult.newProperty((int)1, (int)-1, null);
    public static final Property deviceId = BBacnetPropertyAccessResult.newProperty((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Property value = BBacnetPropertyAccessResult.newProperty((int)1, (BValue)BBacnetNull.DEFAULT, null);
    public static final Property error = BBacnetPropertyAccessResult.newProperty((int)1, (BValue)new BErrorType(), null);
    public static final Type TYPE = Sys.loadType(BBacnetPropertyAccessResult.class);
    public static final int OBJECT_ID_TAG = 0;
    public static final int PROPERTY_ID_TAG = 1;
    public static final int PROPERTY_ARRAY_INDEX_TAG = 2;
    public static final int DEVICE_ID_TAG = 3;
    public static final int PROPERTY_VALUE_TAG = 4;
    public static final int PROPERTY_ACCESS_ERROR_TAG = 5;
    private boolean isError = false;
    private byte[] propertyValue = null;

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    @Override
    public int getPropertyId() {
        return this.getInt(propertyId);
    }

    public void setPropertyId(int v) {
        this.setInt(propertyId, v, null);
    }

    @Override
    public int getPropertyArrayIndex() {
        return this.getInt(propertyArrayIndex);
    }

    public void setPropertyArrayIndex(int v) {
        this.setInt(propertyArrayIndex, v, null);
    }

    public BBacnetObjectIdentifier getDeviceId() {
        return (BBacnetObjectIdentifier)this.get(deviceId);
    }

    public void setDeviceId(BBacnetObjectIdentifier v) {
        this.set(deviceId, (BValue)v, null);
    }

    public BValue getValue() {
        return this.get(value);
    }

    public void setValue(BValue v) {
        this.set(value, v, null);
    }

    public BErrorType getError() {
        return (BErrorType)this.get(error);
    }

    public void setError(BErrorType v) {
        this.set(error, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBacnetPropertyAccessResult() {
    }

    public BBacnetPropertyAccessResult(int propertyId) {
        this.setPropertyId(propertyId);
    }

    public BBacnetPropertyAccessResult(int propertyId, int propertyArrayIndex) {
        this.setPropertyId(propertyId);
        this.setPropertyArrayIndex(propertyArrayIndex);
    }

    public void changed(Property p, Context cx) {
        if (p.equals(value)) {
            this.propertyValue = null;
        } else if (p.equals(error)) {
            this.isError = !this.getError().isDefault();
            this.propertyValue = null;
        }
    }

    @Override
    public byte[] getPropertyValue() {
        if (this.propertyValue == null && !this.isError) {
            this.propertyValue = AsnUtil.toAsn(this.getValue());
        }
        return this.propertyValue;
    }

    @Override
    public int getPriority() {
        return -1;
    }

    @Override
    public ErrorType getPropertyAccessError() {
        return this.getError();
    }

    @Override
    public int getErrorClass() {
        return this.getPropertyAccessError().getErrorClass();
    }

    @Override
    public int getErrorCode() {
        return this.getPropertyAccessError().getErrorCode();
    }

    @Override
    public boolean isError() {
        return this.isError;
    }

    public boolean isPropertyArrayIndexUsed() {
        return this.getPropertyArrayIndex() != -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeAsn(AsnOutput out) {
        out.writeObjectIdentifier(0, this.getObjectId());
        out.writeEnumerated(1, this.getPropertyId());
        if (this.isPropertyArrayIndexUsed()) {
            out.writeUnsignedInteger(2, this.getPropertyArrayIndex());
        }
        out.writeObjectIdentifier(3, this.getDeviceId());
        if (!this.isError) {
            BValue v = this.getValue();
            if (!(v instanceof BIBacnetDataType)) throw new IllegalStateException("propertyValue type " + v.getType() + " is not a BIBacnetDataType!");
            out.writeOpeningTag(4);
            ((BIBacnetDataType)v).writeAsn(out);
            out.writeClosingTag(4);
            return;
        } else {
            out.writeOpeningTag(5);
            this.getError().writeAsn(out);
            out.writeClosingTag(5);
        }
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        this.set(objectId, (BValue)in.readObjectIdentifier(0), noWrite);
        this.setInt(propertyId, in.readEnumerated(1), noWrite);
        int tag = in.peekTag();
        if (in.isValueTag(2)) {
            this.setInt(propertyArrayIndex, in.readUnsignedInt(2), noWrite);
            tag = in.peekTag();
        } else {
            this.setInt(propertyArrayIndex, -1, noWrite);
        }
        this.set(deviceId, (BValue)in.readObjectIdentifier(3), noWrite);
        if (in.isOpeningTag(4)) {
            this.isError = false;
            this.propertyValue = in.readEncodedValue(4);
            BValue pv = AsnUtil.asnToValue(this.propertyValue);
            this.set(value, pv, noWrite);
            this.getError().setToDefault(noWrite);
        } else if (in.isOpeningTag(5)) {
            this.isError = true;
            this.propertyValue = null;
            in.skipTag();
            this.getError().readAsn(in);
            in.skipTag();
        } else {
            throw new AsnException("Invalid tag: " + tag);
        }
    }

    public String toString(Context cx) {
        StringBuilder sb = new StringBuilder();
        sb.append(BBacnetPropertyIdentifier.tag(this.getPropertyId()));
        if (this.isPropertyArrayIndexUsed()) {
            sb.append(" [").append(this.getPropertyArrayIndex()).append("] ");
        }
        sb.append(":");
        if (this.isError) {
            sb.append(this.getError().toString(cx));
        } else {
            sb.append(this.getValue().toString(cx));
        }
        return sb.toString();
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("\n  " + BBacnetPropertyIdentifier.tag(this.getPropertyId()));
        if (this.isPropertyArrayIndexUsed()) {
            sb.append("[" + this.getPropertyArrayIndex() + "]");
        }
        if (this.isError) {
            sb.append("\n  err:" + this.getError().toString());
        } else {
            sb.append("\n  val:" + this.getValue().toString());
        }
        return sb.toString();
    }
}

