/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetPropertyStates;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetLifeSafetyState;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="choice", type="int", defaultValue="0")
public class BBacnetFaultParameter
extends BComponent
implements BIBacnetDataType {
    public static final Property choice = BBacnetFaultParameter.newProperty((int)0, (int)0, null);
    public static final Type TYPE = Sys.loadType(BBacnetFaultParameter.class);
    public static final int NONE = 0;
    public static final int FAULT_CHARACTERSTRING = 1;
    public static final int FAULT_CHARACTERSTRING_LIST_OF_FAULT_VALUES = 0;
    public static final int FAULT_EXTENDED = 2;
    public static final int FAULT_EXTENDED_VENDOR_ID = 0;
    public static final int FAULT_EXTENDED_EXTENDED_FAULT_TYPE = 1;
    public static final int FAULT_EXTENDED_PARAMETERS = 2;
    public static final int FAULT_LIFE_SAFETY = 3;
    public static final int FAULT_LIFE_SAFETY_LIST_OF_FAULT_VALUES = 0;
    public static final int FAULT_LIFE_SAFETY_MODE_PROPERTY_REFERENCE = 1;
    public static final int FAULT_STATE = 4;
    public static final int FAULT_STATE_LIST_OF_FAULT_VALUES = 0;
    public static final int FAULT_STATUS_FLAGS = 5;
    public static final int FAULT_STATUS_FLAGS_STATUS_FLAGS_REFERENCE = 0;
    private static final Logger logger = Logger.getLogger("bacnet.datatypes");

    public int getChoice() {
        return this.getInt(choice);
    }

    public void setChoice(int v) {
        this.setInt(choice, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    @Override
    public void writeAsn(AsnOutput out) {
        int choice = this.getChoice();
        out.writeOpeningTag(choice);
        try {
            switch (choice) {
                case 0: {
                    out.writeNull();
                    break;
                }
                case 1: {
                    out.writeOpeningTag(0);
                    ((BBacnetListOf)this.get("listOfFaultValues")).writeAsn(out);
                    out.writeClosingTag(0);
                    break;
                }
                case 2: {
                    out.writeUnsigned(0, (BBacnetUnsigned)this.get("vendorId"));
                    out.writeUnsigned(1, (BBacnetUnsigned)this.get("extendedFaultType"));
                    out.writeEncodedValue(2, ((BBlob)this.get("parameters")).copyBytes());
                    break;
                }
                case 3: {
                    out.writeOpeningTag(0);
                    ((BBacnetListOf)this.get("listOfFaultValues")).writeAsn(out);
                    out.writeClosingTag(0);
                    out.writeOpeningTag(1);
                    ((BBacnetDeviceObjectPropertyReference)this.get("modePropertyReference")).writeAsn(out);
                    out.writeClosingTag(1);
                    break;
                }
                case 4: {
                    out.writeOpeningTag(0);
                    ((BBacnetListOf)this.get("listOfFaultValues")).writeAsn(out);
                    out.writeClosingTag(0);
                    break;
                }
                case 5: {
                    out.writeOpeningTag(0);
                    ((BBacnetDeviceObjectPropertyReference)this.get("statusFlagsReference")).writeAsn(out);
                    out.writeClosingTag(0);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "BBacnetFaultParameter writeAsn failure", e);
        }
        out.writeClosingTag(choice);
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        int tag = in.peekTag();
        if (tag < 0) {
            throw new AsnException("Invalid tag: " + tag);
        }
        if (tag != this.getChoice()) {
            this.removeAll(noWrite);
        }
        this.setInt(choice, tag, noWrite);
        in.skipTag();
        BBacnetListOf listOfFaultValues = null;
        switch (tag) {
            case 0: {
                in.readNull();
                break;
            }
            case 1: {
                listOfFaultValues = new BBacnetListOf(BString.TYPE);
                listOfFaultValues.readAsn(AsnInputStream.make(in.readEncodedValue(0)));
                BacUtil.setOrAdd(this, "listOfFaultValues", (BValue)listOfFaultValues, noWrite);
                break;
            }
            case 2: {
                BacUtil.setOrAdd(this, "vendorId", (BValue)BBacnetUnsigned.make(in.readUnsignedInteger(0)), noWrite);
                BacUtil.setOrAdd(this, "extendedFaultType", (BValue)BBacnetUnsigned.make(in.readUnsignedInteger(1)), noWrite);
                BacUtil.setOrAdd(this, "parameters", (BValue)BBlob.make((byte[])in.readEncodedValue(2)), noWrite);
                break;
            }
            case 3: {
                listOfFaultValues = new BBacnetListOf(BBacnetLifeSafetyState.TYPE);
                listOfFaultValues.readAsn(AsnInputStream.make(in.readEncodedValue(0)));
                BacUtil.setOrAdd(this, "listOfFaultValues", (BValue)listOfFaultValues, noWrite);
                BBacnetDeviceObjectPropertyReference modePropertyReference = new BBacnetDeviceObjectPropertyReference();
                in.skipTag();
                modePropertyReference.readAsn(in);
                in.skipTag();
                BacUtil.setOrAdd(this, "modePropertyReference", (BValue)modePropertyReference, noWrite);
                break;
            }
            case 4: {
                listOfFaultValues = new BBacnetListOf(BBacnetPropertyStates.TYPE);
                listOfFaultValues.readAsn(AsnInputStream.make(in.readEncodedValue(0)));
                BacUtil.setOrAdd(this, "listOfFaultValues", (BValue)listOfFaultValues, noWrite);
                break;
            }
            case 5: {
                BBacnetDeviceObjectPropertyReference statusFlagsReference = new BBacnetDeviceObjectPropertyReference();
                in.skipTag();
                statusFlagsReference.readAsn(in);
                in.skipTag();
                BacUtil.setOrAdd(this, "statusFlagsReference", (BValue)statusFlagsReference, noWrite);
            }
        }
        in.skipTag();
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetFaultParameter", 2);
        out.prop((Object)"virtual", BacnetVirtualUtil.isVirtual(this));
        out.endProps();
    }
}

