/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.config;

import javax.baja.bacnet.config.BBacnetCreatableObject;
import javax.baja.bacnet.datatypes.BBacnetAny;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDateRange;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.nre.util.Array;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetSchedule
extends BBacnetCreatableObject {
    public static final Property objectId = BBacnetSchedule.newProperty((int)8, (BValue)BBacnetObjectIdentifier.make(17), (BFacets)BBacnetSchedule.makeFacets(75, 12));
    public static final Property objectType = BBacnetSchedule.newProperty((int)1, (BValue)BDynamicEnum.make((int)17, (BEnumRange)BEnumRange.make((Type)BBacnetObjectType.TYPE)), (BFacets)BBacnetSchedule.makeFacets(79, 9));
    public static final Property presentValue = BBacnetSchedule.newProperty((int)0, (BValue)new BBacnetAny(), (BFacets)BBacnetSchedule.makeFacets(85, -4));
    public static final Property facets = BBacnetSchedule.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Property effectivePeriod = BBacnetSchedule.newProperty((int)0, (BValue)new BBacnetDateRange(), (BFacets)BBacnetSchedule.makeFacets(32, -1));
    public static final Property listOfObjectPropertyReferences = BBacnetSchedule.newProperty((int)0, (BValue)new BBacnetListOf(BBacnetDeviceObjectPropertyReference.TYPE), (BFacets)BBacnetSchedule.makeFacets(54, -3));
    public static final Property priorityForWriting = BBacnetSchedule.newProperty((int)0, (BValue)BBacnetUnsigned.make(16L), (BFacets)BBacnetSchedule.makeFacets(88, 2));
    public static final Type TYPE = Sys.loadType(BBacnetSchedule.class);

    public BBacnetAny getPresentValue() {
        return (BBacnetAny)this.get(presentValue);
    }

    public void setPresentValue(BBacnetAny v) {
        this.set(presentValue, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BBacnetDateRange getEffectivePeriod() {
        return (BBacnetDateRange)this.get(effectivePeriod);
    }

    public void setEffectivePeriod(BBacnetDateRange v) {
        this.set(effectivePeriod, (BValue)v, null);
    }

    public BBacnetListOf getListOfObjectPropertyReferences() {
        return (BBacnetListOf)this.get(listOfObjectPropertyReferences);
    }

    public void setListOfObjectPropertyReferences(BBacnetListOf v) {
        this.set(listOfObjectPropertyReferences, (BValue)v, null);
    }

    public BBacnetUnsigned getPriorityForWriting() {
        return (BBacnetUnsigned)this.get(priorityForWriting);
    }

    public void setPriorityForWriting(BBacnetUnsigned v) {
        this.set(priorityForWriting, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public String toString(Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getObjectId().toString(context)).append(nameContext.equals(context) ? (char)'_' : ':').append(this.getPresentValue().toString(context));
        return sb.toString();
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (this.device().getProtocolRevision() >= 4) {
            if (this.get(BBacnetPropertyIdentifier.scheduleDefault.getTag()) == null) {
                this.add(BBacnetPropertyIdentifier.scheduleDefault.getTag(), (BValue)new BBacnetAny(), 0, BBacnetSchedule.makeFacets(174, -4), null);
            }
            if (this.get(BBacnetPropertyIdentifier.statusFlags.getTag()) == null) {
                this.add(BBacnetPropertyIdentifier.statusFlags.getTag(), (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), 0, BBacnetSchedule.makeFacets(111, 8, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP), null);
            }
            if (this.get(BBacnetPropertyIdentifier.reliability.getTag()) == null) {
                this.add(BBacnetPropertyIdentifier.reliability.getTag(), (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BBacnetReliability.TYPE)), 0, BBacnetSchedule.makeFacets(103, 9), null);
            }
            if (this.get(BBacnetPropertyIdentifier.outOfService.getTag()) == null) {
                this.add(BBacnetPropertyIdentifier.outOfService.getTag(), (BValue)BBoolean.FALSE, 0, BBacnetSchedule.makeFacets(81, 1), null);
            }
            this.buildPolledProperties();
        }
    }

    @Override
    public BFacets getSlotFacets(Slot slot) {
        if (slot == presentValue) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    @Override
    public Property getPresentValueProperty() {
        return presentValue;
    }

    @Override
    protected void addObjectInitialValues(Array<PropertyValue> listOfInitialValues) {
        this.addPriorityForWriting(this.getPriorityForWriting(), listOfInitialValues);
        Property scheduleDefault = this.getProperty("scheduleDefault");
        if (scheduleDefault != null) {
            this.addScheduleDefault(scheduleDefault, listOfInitialValues);
        }
        this.addListOfObjectPropertyReferences(listOfObjectPropertyReferences, listOfInitialValues);
    }
}

