/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.config;

import com.tridium.bacnet.datatypes.BNcRecipientList;
import javax.baja.bacnet.config.BBacnetCreatableObject;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDestination;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetRecipient;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetNotificationClass
extends BBacnetCreatableObject {
    public static final Property objectId = BBacnetNotificationClass.newProperty((int)8, (BValue)BBacnetObjectIdentifier.make(15), (BFacets)BBacnetNotificationClass.makeFacets(75, 12));
    public static final Property objectType = BBacnetNotificationClass.newProperty((int)1, (BValue)BDynamicEnum.make((int)15, (BEnumRange)BEnumRange.make((Type)BBacnetObjectType.TYPE)), (BFacets)BBacnetNotificationClass.makeFacets(79, 9));
    public static final Property notificationClass = BBacnetNotificationClass.newProperty((int)1, (BValue)BBacnetUnsigned.DEFAULT, (BFacets)BBacnetNotificationClass.makeFacets(17, 2));
    public static final Property priority = BBacnetNotificationClass.newProperty((int)1, (BValue)new BBacnetArray(BBacnetUnsigned.TYPE, 3), (BFacets)BBacnetNotificationClass.makeFacets(86, -2));
    public static final Property ackRequired = BBacnetNotificationClass.newProperty((int)0, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetEventTransitionBits")), (BFacets)BBacnetNotificationClass.makeFacets(1, 8, BacnetBitStringUtil.BACNET_EVENT_TRANSITION_BITS_MAP));
    public static final Property recipientList = BBacnetNotificationClass.newProperty((int)0, (BValue)new BNcRecipientList(BBacnetDestination.TYPE), (BFacets)BBacnetNotificationClass.makeFacets(102, -3));
    public static final Action addDestination = BBacnetNotificationClass.newAction((int)0, (BValue)new BBacnetDestination(), null);
    public static final Action removeDestination = BBacnetNotificationClass.newAction((int)0, (BValue)new BBacnetDestination(), null);
    public static final Action removeRecipient = BBacnetNotificationClass.newAction((int)0, (BValue)new BBacnetRecipient(), null);
    public static final Type TYPE = Sys.loadType(BBacnetNotificationClass.class);

    public BBacnetUnsigned getNotificationClass() {
        return (BBacnetUnsigned)this.get(notificationClass);
    }

    public void setNotificationClass(BBacnetUnsigned v) {
        this.set(notificationClass, (BValue)v, null);
    }

    public BBacnetArray getPriority() {
        return (BBacnetArray)this.get(priority);
    }

    public void setPriority(BBacnetArray v) {
        this.set(priority, (BValue)v, null);
    }

    public BBacnetBitString getAckRequired() {
        return (BBacnetBitString)this.get(ackRequired);
    }

    public void setAckRequired(BBacnetBitString v) {
        this.set(ackRequired, (BValue)v, null);
    }

    public BBacnetListOf getRecipientList() {
        return (BBacnetListOf)this.get(recipientList);
    }

    public void setRecipientList(BBacnetListOf v) {
        this.set(recipientList, (BValue)v, null);
    }

    public void addDestination(BBacnetDestination dest) {
        this.invoke(addDestination, (BValue)dest, null);
    }

    public void removeDestination(BBacnetDestination dest) {
        this.invoke(removeDestination, (BValue)dest, null);
    }

    public void removeRecipient(BBacnetRecipient recip) {
        this.invoke(removeRecipient, (BValue)recip, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void doAddDestination(BBacnetDestination dest) {
        this.getRecipientList().addListElement((BValue)dest, null);
    }

    public void doRemoveDestination(BBacnetDestination dest) {
        this.getRecipientList().removeListElement((BValue)dest, null);
    }

    public void doRemoveRecipient(BBacnetRecipient recip) {
        this.network().postAsync(new NCRemoveRecipientRequest(recip));
        this.upload(new BUploadParameters());
    }

    @Override
    protected void addObjectInitialValues(Array<PropertyValue> listOfInitialValues) {
        this.addPriority(priority, listOfInitialValues);
        this.addAckRequired(ackRequired, listOfInitialValues);
        this.addRecipientist(recipientList, listOfInitialValues);
    }

    class NCRemoveRecipientRequest
    implements Runnable {
        public BBacnetRecipient recip;

        NCRemoveRecipientRequest(BBacnetRecipient recip) {
            this.recip = recip;
        }

        @Override
        public void run() {
            SlotCursor sc = BBacnetNotificationClass.this.getRecipientList().getProperties();
            while (sc.next(BBacnetDestination.class)) {
                BBacnetDestination d = (BBacnetDestination)sc.get();
                if (!d.getRecipient().equivalent(this.recip)) continue;
                BBacnetNotificationClass.this.getRecipientList().removeListElement((BValue)d, null);
            }
        }
    }
}

