/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.config;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.datatypes.BReadFileConfig;
import com.tridium.bacnet.datatypes.BWriteFileConfig;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetFileAccessMethod;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.FileData;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetFile
extends BBacnetObject {
    public static final Property objectId = BBacnetFile.newProperty((int)8, (BValue)BBacnetObjectIdentifier.make(10), (BFacets)BBacnetFile.makeFacets(75, 12));
    public static final Property objectType = BBacnetFile.newProperty((int)1, (BValue)BDynamicEnum.make((int)10, (BEnumRange)BEnumRange.make((Type)BBacnetObjectType.TYPE)), (BFacets)BBacnetFile.makeFacets(79, 9));
    public static final Property fileType = BBacnetFile.newProperty((int)1, (String)"", (BFacets)BBacnetFile.makeFacets(43, 7));
    public static final Property fileSize = BBacnetFile.newProperty((int)0, (BValue)BBacnetUnsigned.make(0L), (BFacets)BBacnetFile.makeFacets(42, 2));
    public static final Property modificationDate = BBacnetFile.newProperty((int)1, (BValue)new BBacnetDateTime(), (BFacets)BBacnetFile.makeFacets(71, -1));
    public static final Property archive = BBacnetFile.newProperty((int)0, (boolean)false, (BFacets)BBacnetFile.makeFacets(13, 1));
    public static final Property readOnly = BBacnetFile.newProperty((int)1, (boolean)true, (BFacets)BBacnetFile.makeFacets(99, 1));
    public static final Property fileAccessMethod = BBacnetFile.newProperty((int)1, (BValue)BBacnetFileAccessMethod.streamAccess, (BFacets)BBacnetFile.makeFacets(41, 9));
    public static final Property fileOrd = BBacnetFile.newProperty((int)64, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"baja:IFile"));
    public static final Action read = BBacnetFile.newAction((int)0, null);
    public static final Action write = BBacnetFile.newAction((int)0, (BValue)BBlob.DEFAULT, null);
    public static final Action readFile = BBacnetFile.newAction((int)4, (BValue)new BReadFileConfig(), null);
    public static final Action writeFile = BBacnetFile.newAction((int)4, (BValue)new BWriteFileConfig(), null);
    public static final Type TYPE = Sys.loadType(BBacnetFile.class);
    private static final int ACK_HEADER_SIZE = 30;
    private BIFile file;

    public String getFileType() {
        return this.getString(fileType);
    }

    public void setFileType(String v) {
        this.setString(fileType, v, null);
    }

    public BBacnetUnsigned getFileSize() {
        return (BBacnetUnsigned)this.get(fileSize);
    }

    public void setFileSize(BBacnetUnsigned v) {
        this.set(fileSize, (BValue)v, null);
    }

    public BBacnetDateTime getModificationDate() {
        return (BBacnetDateTime)this.get(modificationDate);
    }

    public void setModificationDate(BBacnetDateTime v) {
        this.set(modificationDate, (BValue)v, null);
    }

    public boolean getArchive() {
        return this.getBoolean(archive);
    }

    public void setArchive(boolean v) {
        this.setBoolean(archive, v, null);
    }

    public boolean getReadOnly() {
        return this.getBoolean(readOnly);
    }

    public void setReadOnly(boolean v) {
        this.setBoolean(readOnly, v, null);
    }

    public BBacnetFileAccessMethod getFileAccessMethod() {
        return (BBacnetFileAccessMethod)this.get(fileAccessMethod);
    }

    public void setFileAccessMethod(BBacnetFileAccessMethod v) {
        this.set(fileAccessMethod, (BValue)v, null);
    }

    public BOrd getFileOrd() {
        return (BOrd)this.get(fileOrd);
    }

    public void setFileOrd(BOrd v) {
        this.set(fileOrd, (BValue)v, null);
    }

    public BBlob read() {
        return (BBlob)this.invoke(read, null, null);
    }

    public void write(BBlob arg) {
        this.invoke(write, (BValue)arg, null);
    }

    public void readFile(BStruct arg) {
        this.invoke(readFile, (BValue)arg, null);
    }

    public void writeFile(BStruct arg) {
        this.invoke(writeFile, (BValue)arg, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.getFile();
    }

    @Override
    public void stopped() {
        this.file = null;
    }

    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(fileOrd)) {
            this.getFile();
        }
    }

    @Override
    public String toString(Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getObjectId().toString(context)).append(" local: " + this.getFileOrd());
        return sb.toString();
    }

    public static byte[] readFile(BBacnetDevice device, BBacnetObjectIdentifier objectId) throws BacnetException {
        int fileSize = AsnUtil.fromAsnUnsignedInt(BBacnetFile.client().readProperty(device.getAddress(), objectId, 42));
        int fileAccessMethod = AsnUtil.fromAsnEnumerated(BBacnetFile.client().readProperty(device.getAddress(), objectId, 41));
        if (fileAccessMethod == 1) {
            return BBacnetFile.readFileDataStream(device, objectId, fileSize, 0, fileSize);
        }
        int recordCount = AsnUtil.fromAsnUnsignedInt(BBacnetFile.client().readProperty(device.getAddress(), objectId, 141));
        BBacnetOctetString[] recs = BBacnetFile.readFileDataRecord(device, objectId, fileSize, 0, recordCount);
        ByteArrayOutputStream os = new ByteArrayOutputStream(fileSize);
        for (int i = 0; i < recs.length; ++i) {
            if (recs[i] == null) continue;
            os.write(recs[i].getBytes(), 0, recs[i].length());
        }
        return os.toByteArray();
    }

    public BBlob doRead() {
        try {
            byte[] fileData = BBacnetFile.readFile(this.device(), this.getObjectId());
            return BBlob.make((byte[])fileData);
        }
        catch (BacnetException e) {
            log.log(Level.SEVERE, "Unable to read file contents for " + (Object)((Object)this.getObjectId()) + " : " + (Object)((Object)e), (Throwable)((Object)e));
            throw new BajaRuntimeException((Throwable)((Object)e));
        }
    }

    public void doReadFile(BStruct arg) {
        BBacnetNetwork.bacnet().postAsync(new ReadFileReq((BReadFileConfig)arg, this));
    }

    public void doWriteFile(BStruct arg) {
        BBacnetNetwork.bacnet().postAsync(new WriteFileReq((BWriteFileConfig)arg, this));
    }

    public static void writeFile(BBacnetDevice device, BBacnetObjectIdentifier objectId, byte[] fileData) throws BacnetException {
        BBacnetFile.writeFileDataStream(device, objectId, 0, fileData);
    }

    public static void writeFile(BBacnetDevice device, BBacnetObjectIdentifier objectId, int count, BBacnetOctetString[] fileRecordData) throws BacnetException {
        BBacnetFile.writeFileDataRecord(device, objectId, 0, count, fileRecordData);
    }

    public void doWrite(BBlob arg) {
        byte[] fileData = arg.copyBytes();
        if (this.getFileAccessMethod() == BBacnetFileAccessMethod.streamAccess) {
            try {
                BBacnetFile.writeFileDataStream(this.device(), this.getObjectId(), 0, fileData);
            }
            catch (BacnetException e) {
                log.log(Level.SEVERE, "Unable to write file contents for " + (Object)((Object)this.getObjectId()) + " : " + (Object)((Object)e), (Throwable)((Object)e));
                throw new BajaRuntimeException((Throwable)((Object)e));
            }
        }
        Array a = new Array(BBacnetOctetString.class);
        AsnInputStream asn = new AsnInputStream(fileData);
        try {
            while (asn.available() > 0) {
                a.add((Object)asn.readBacnetOctetString());
            }
            BBacnetOctetString[] fileRecordData = (BBacnetOctetString[])a.trim();
            BBacnetFile.writeFileDataRecord(this.device(), this.getObjectId(), 0, fileRecordData.length, fileRecordData);
        }
        catch (AsnException e) {
            log.severe("File data is not in array of encoded BACnetOctetStrings");
            throw new BajaRuntimeException((Throwable)((Object)e));
        }
        catch (BacnetException e) {
            log.log(Level.SEVERE, "Unable to write file record contents for " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e), (Throwable)((Object)e));
            throw new BajaRuntimeException((Throwable)((Object)e));
        }
    }

    private BIFile getFile() {
        try {
            if (!fileOrd.isEquivalentToDefaultValue((BValue)this.getFileOrd())) {
                BObject o = this.getFileOrd().get((BObject)this);
                this.file = o instanceof BIFile ? (BIFile)o : null;
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to resolve file ord for " + this + ": " + this.getFileOrd(), e);
            this.file = null;
        }
        return this.file;
    }

    private static BBacnetClientLayer client() {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient();
    }

    private static BBacnetOctetString[] readFileDataRecord(BBacnetDevice device, BBacnetObjectIdentifier objectId, int fileSize, int fileStartRecord, int requestedRecordCount) throws BacnetException {
        if (!device.isServiceSupported("atomicReadFile")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.atomicReadFile"));
        }
        BBacnetOctetString[] data = new BBacnetOctetString[requestedRecordCount];
        for (int i = 0; i < requestedRecordCount; ++i) {
            FileData ack = BBacnetFile.client().atomicReadFile(device.getAddress(), objectId, 1, fileStartRecord + i, 1L);
            data[i] = ack.getFileRecordData()[0];
            if (ack.isEndOfFile()) break;
        }
        return data;
    }

    private static byte[] readFileDataStream(BBacnetDevice device, BBacnetObjectIdentifier objectId, int fileSize, int fileStartPosition, int requestedOctetCount) throws BacnetException {
        FileData ack;
        if (!device.isServiceSupported("atomicReadFile")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.atomicReadFile"));
        }
        byte[] data = new byte[fileSize];
        if (fileSize < requestedOctetCount) {
            requestedOctetCount = fileSize;
        }
        int maxReturnableFileSize = device.getMaxAPDULengthAccepted();
        int myMax = BBacnetNetwork.localDevice().getMaxAPDULengthAccepted();
        if (myMax < maxReturnableFileSize) {
            maxReturnableFileSize = myMax;
        }
        int start = fileStartPosition;
        int len = maxReturnableFileSize -= 30;
        int lastByte = start + requestedOctetCount;
        do {
            ack = BBacnetFile.client().atomicReadFile(device.getAddress(), objectId, 0, start, len);
            byte[] b = ack.getFileData();
            System.arraycopy(b, 0, data, start, b.length);
        } while (!ack.isEndOfFile() && (start += len) < lastByte);
        return data;
    }

    private static void writeFileDataRecord(BBacnetDevice device, BBacnetObjectIdentifier objectId, int fileStartRecord, int recordCount, BBacnetOctetString[] fileRecordData) throws BacnetException {
        if (!device.isServiceSupported("atomicWriteFile")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.atomicWriteFile"));
        }
        if (fileRecordData == null) {
            throw new IllegalArgumentException("fileRecordData is null!");
        }
        int writeCount = recordCount;
        if (fileStartRecord + recordCount > fileRecordData.length) {
            writeCount = fileRecordData.length - fileStartRecord;
        }
        int maxApdu = device.getMaxAPDULengthAccepted();
        int myMax = BBacnetNetwork.localDevice().getMaxAPDULengthAccepted();
        if (myMax < maxApdu) {
            maxApdu = myMax;
        }
        maxApdu -= 30;
        int recNdx = fileStartRecord;
        int start = fileStartRecord;
        do {
            int len = 0;
            Array a = new Array(BBacnetOctetString.class);
            do {
                a.add((Object)fileRecordData[recNdx]);
            } while (++recNdx < writeCount && (len += fileRecordData[recNdx].length()) + fileRecordData[recNdx].length() < maxApdu);
            BBacnetOctetString[] recData = (BBacnetOctetString[])a.trim();
            BBacnetFile.client().atomicWriteFileRecord(device.getAddress(), objectId, start, recData.length, recData);
            start = recNdx;
        } while (recNdx < writeCount);
    }

    private static void writeFileDataStream(BBacnetDevice device, BBacnetObjectIdentifier objectId, int fileStartPosition, byte[] fileData) throws BacnetException {
        int copylen;
        if (!device.isServiceSupported("atomicWriteFile")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.atomicWriteFile"));
        }
        int writeLength = fileData.length;
        int maxApdu = device.getMaxAPDULengthAccepted();
        int myMax = BBacnetNetwork.localDevice().getMaxAPDULengthAccepted();
        if (myMax < maxApdu) {
            maxApdu = myMax;
        }
        int start = fileStartPosition;
        int len = maxApdu -= 30;
        do {
            if (start + (copylen = len) > writeLength) {
                copylen = writeLength - start;
            }
            byte[] b = new byte[copylen];
            System.arraycopy(fileData, start, b, 0, copylen);
            BBacnetFile.client().atomicWriteFileStream(device.getAddress(), objectId, start, b);
        } while ((start += copylen) < writeLength);
    }

    class WriteFileReq
    implements Runnable {
        BWriteFileConfig parms;
        BBacnetFile bacnetFile;

        WriteFileReq(BWriteFileConfig arg, BBacnetFile f) {
            this.parms = arg;
            this.bacnetFile = f;
        }

        @Override
        public void run() {
            block19: {
                int remoteStart = this.parms.getRemoteStart();
                int localStart = this.parms.getLocalStart();
                byte[] fileData = null;
                RandomAccessFile src = null;
                try {
                    if (this.bacnetFile.file == null) {
                        throw new NullOrdException("No local source file specified for BACnet File " + this.bacnetFile);
                    }
                    File f = ((BLocalFileStore)this.bacnetFile.file.getStore()).getLocalFile();
                    long flen = f.length() - (long)localStart;
                    if (flen > Integer.MAX_VALUE) {
                        throw new BajaRuntimeException("Local file data length " + flen + " is too long to write to BACnet!");
                    }
                    int len = (int)flen;
                    fileData = new byte[len];
                    src = new RandomAccessFile(f, "r");
                    src.seek(localStart);
                    src.read(fileData, 0, len);
                }
                catch (IOException e) {
                    BBacnetObject.log.log(Level.SEVERE, "IOException reading from local file " + this.bacnetFile.file, e);
                    throw new BajaRuntimeException((Throwable)e);
                }
                finally {
                    if (src != null) {
                        try {
                            src.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                try {
                    int fileAccessMethod = AsnUtil.fromAsnEnumerated(BBacnetFile.client().readProperty(this.bacnetFile.device().getAddress(), this.bacnetFile.getObjectId(), 41));
                    if (fileAccessMethod == 1) {
                        BBacnetFile.writeFileDataStream(this.bacnetFile.device(), this.bacnetFile.getObjectId(), remoteStart, fileData);
                        break block19;
                    }
                    Array a = new Array(BBacnetOctetString.class);
                    AsnInputStream asn = new AsnInputStream(fileData);
                    try {
                        while (asn.available() > 0) {
                            a.add((Object)asn.readBacnetOctetString());
                        }
                        BBacnetOctetString[] fileRecordData = (BBacnetOctetString[])a.trim();
                        BBacnetFile.writeFileDataRecord(BBacnetFile.this.device(), BBacnetFile.this.getObjectId(), remoteStart, fileRecordData.length, fileRecordData);
                    }
                    catch (AsnException e) {
                        BBacnetObject.log.severe("File data is not in array of encoded BACnetOctetStrings");
                        throw new BajaRuntimeException((Throwable)((Object)e));
                    }
                }
                catch (BacnetException e) {
                    BBacnetObject.log.log(Level.SEVERE, "Unable to write file record contents for " + (Object)((Object)BBacnetFile.this.getObjectId()) + ": " + (Object)((Object)e), (Throwable)((Object)e));
                    throw new BajaRuntimeException((Throwable)((Object)e));
                }
            }
        }
    }

    static class ReadFileReq
    implements Runnable {
        BReadFileConfig parms;
        BBacnetFile bacnetFile;

        ReadFileReq(BReadFileConfig arg, BBacnetFile f) {
            this.parms = arg;
            this.bacnetFile = f;
        }

        @Override
        public void run() {
            int start = this.parms.getStart();
            int count = this.parms.getCount();
            byte[] fileData = null;
            try {
                int fileSize = AsnUtil.fromAsnUnsignedInt(BBacnetFile.client().readProperty(this.bacnetFile.device().getAddress(), this.bacnetFile.getObjectId(), 42));
                int fileAccessMethod = AsnUtil.fromAsnEnumerated(BBacnetFile.client().readProperty(this.bacnetFile.device().getAddress(), this.bacnetFile.getObjectId(), 41));
                if (fileAccessMethod == 1) {
                    fileData = BBacnetFile.readFileDataStream(this.bacnetFile.device(), this.bacnetFile.getObjectId(), fileSize, start, count);
                } else {
                    BBacnetOctetString[] recs = BBacnetFile.readFileDataRecord(this.bacnetFile.device(), this.bacnetFile.getObjectId(), fileSize, start, count);
                    ByteArrayOutputStream os = new ByteArrayOutputStream(fileSize);
                    for (int i = 0; i < recs.length; ++i) {
                        if (recs[i] == null) continue;
                        os.write(recs[i].getBytes(), 0, recs[i].length());
                    }
                    fileData = os.toByteArray();
                }
            }
            catch (BacnetException e) {
                BBacnetObject.log.log(Level.SEVERE, "Unable to read file contents for " + (Object)((Object)this.bacnetFile.getObjectId()) + " : " + (Object)((Object)e), (Throwable)((Object)e));
                throw new BajaRuntimeException((Throwable)((Object)e));
            }
            if (fileData != null) {
                RandomAccessFile out = null;
                try {
                    if (this.bacnetFile.file == null) {
                        throw new NullOrdException("No local target file specified for BACnet File " + this.bacnetFile);
                    }
                    if (this.bacnetFile.file.isReadonly()) {
                        throw new IllegalStateException("Unable to write to file " + this.bacnetFile.getFileOrd());
                    }
                    File f = ((BLocalFileStore)this.bacnetFile.file.getStore()).getLocalFile();
                    out = new RandomAccessFile(f, "rw");
                    out.write(fileData);
                }
                catch (IOException e) {
                    BBacnetObject.log.log(Level.SEVERE, "IOException writing to local file " + this.bacnetFile.file, e);
                    throw new BajaRuntimeException((Throwable)e);
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }
}

