/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.config;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.enums.BBacnetBinaryPv;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BBacnetBinary
extends BBacnetObject {
    public static final Property presentValue = BBacnetBinary.newProperty((int)0, (BValue)BBacnetBinaryPv.inactive, (BFacets)BBacnetBinary.makeFacets(85, 9));
    public static final Property facets = BBacnetBinary.newProperty((int)5, (BValue)BFacets.DEFAULT, null);
    public static final Property statusFlags = BBacnetBinary.newProperty((int)1, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), (BFacets)BBacnetBinary.makeFacets(111, 8, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP));
    public static final Property eventState = BBacnetBinary.newProperty((int)1, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BBacnetEventState.TYPE)), (BFacets)BBacnetBinary.makeFacets(36, 9));
    public static final Property outOfService = BBacnetBinary.newProperty((int)0, (boolean)false, (BFacets)BBacnetBinary.makeFacets(81, 1));
    public static final Type TYPE = Sys.loadType(BBacnetBinary.class);

    public BBacnetBinaryPv getPresentValue() {
        return (BBacnetBinaryPv)this.get(presentValue);
    }

    public void setPresentValue(BBacnetBinaryPv v) {
        this.set(presentValue, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BBacnetBitString getStatusFlags() {
        return (BBacnetBitString)this.get(statusFlags);
    }

    public void setStatusFlags(BBacnetBitString v) {
        this.set(statusFlags, (BValue)v, null);
    }

    public BEnum getEventState() {
        return (BEnum)this.get(eventState);
    }

    public void setEventState(BEnum v) {
        this.set(eventState, (BValue)v, null);
    }

    public boolean getOutOfService() {
        return this.getBoolean(outOfService);
    }

    public void setOutOfService(boolean v) {
        this.setBoolean(outOfService, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public String toString(Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getObjectId().toString(context)).append(" = " + this.getPresentValue().toString(context));
        return sb.toString();
    }

    @Override
    public BFacets getSlotFacets(Slot slot) {
        if (slot == presentValue) {
            return this.getFacets();
        }
        if (slot.getName().equals("alarmValue")) {
            return this.getFacets();
        }
        if (slot.getName().equals("feedbackValue")) {
            return this.getFacets();
        }
        if (slot.getName().equals("relinquishDefault")) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    @Override
    public void setOutputFacets() {
        BString activeText = (BString)this.get("activeText");
        BString inactiveText = (BString)this.get("inactiveText");
        BFacets f = BFacets.makeBoolean((BString)(activeText != null ? activeText : BString.make((String)"true")), (BString)(inactiveText != null ? inactiveText : BString.make((String)"false")));
        this.setFacets(f);
    }

    @Override
    public Property getPresentValueProperty() {
        return presentValue;
    }
}

