/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.config;

import java.util.logging.Level;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public abstract class BBacnetAnalog
extends BBacnetObject {
    public static final Property presentValue = BBacnetAnalog.newProperty((int)0, (int)0, (BFacets)BBacnetAnalog.makeFacets(85, 4));
    public static final Property facets = BBacnetAnalog.newProperty((int)1, (BValue)BFacets.DEFAULT, null);
    public static final Property statusFlags = BBacnetAnalog.newProperty((int)1, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), (BFacets)BBacnetAnalog.makeFacets(111, 8, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP));
    public static final Property eventState = BBacnetAnalog.newProperty((int)1, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BBacnetEventState.TYPE)), (BFacets)BBacnetAnalog.makeFacets(36, 9));
    public static final Property outOfService = BBacnetAnalog.newProperty((int)0, (boolean)false, (BFacets)BBacnetAnalog.makeFacets(81, 1));
    public static final Property units = BBacnetAnalog.newProperty((int)0, (BValue)BDynamicEnum.make((int)95, (BEnumRange)BEnumRange.make((Type)BBacnetEngineeringUnits.TYPE)), (BFacets)BBacnetAnalog.makeFacets(117, 9));
    public static final Type TYPE = Sys.loadType(BBacnetAnalog.class);
    private static final double LN_10 = Math.log(10.0);

    public float getPresentValue() {
        return this.getFloat(presentValue);
    }

    public void setPresentValue(float v) {
        this.setFloat(presentValue, v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BBacnetBitString getStatusFlags() {
        return (BBacnetBitString)this.get(statusFlags);
    }

    public void setStatusFlags(BBacnetBitString v) {
        this.set(statusFlags, (BValue)v, null);
    }

    public BEnum getEventState() {
        return (BEnum)this.get(eventState);
    }

    public void setEventState(BEnum v) {
        this.set(eventState, (BValue)v, null);
    }

    public boolean getOutOfService() {
        return this.getBoolean(outOfService);
    }

    public void setOutOfService(boolean v) {
        this.setBoolean(outOfService, v, null);
    }

    public BEnum getUnits() {
        return (BEnum)this.get(units);
    }

    public void setUnits(BEnum v) {
        this.set(units, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public String toString(Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getObjectId().toString(context)).append(" = " + this.getPresentValue());
        return sb.toString();
    }

    @Override
    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)presentValue)) {
            return this.getFacets();
        }
        if (slot.getName().equals("highLimit")) {
            return this.getFacets();
        }
        if (slot.getName().equals("lowLimit")) {
            return this.getFacets();
        }
        if (slot.getName().equals("deadband")) {
            return this.getFacets();
        }
        if (slot.getName().equals("resolution")) {
            return this.getFacets();
        }
        if (slot.getName().equals("covIncrement")) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    @Override
    public void setOutputFacets() {
        try {
            BUnit u = null;
            try {
                u = BBacnetEngineeringUnits.getNiagaraUnits(this.getUnits().getOrdinal());
            }
            catch (Exception e) {
                log.info(this + ":Can't make BUnits from BacnetEngineeringUnits:" + this.getUnits());
            }
            BFloat res = (BFloat)this.get("resolution");
            BInteger precision = BInteger.make((int)2);
            if (res != null && res.getFloat() > 0.0f) {
                precision = BInteger.make((int)((int)Math.ceil(-(Math.log(res.getFloat()) / LN_10))));
            }
            BFloat minPV = (BFloat)this.get("minPresValue");
            BFloat maxPV = (BFloat)this.get("maxPresValue");
            if (minPV == null) {
                minPV = BFloat.make((float)Float.NEGATIVE_INFINITY);
            }
            if (maxPV == null) {
                maxPV = BFloat.make((float)Float.POSITIVE_INFINITY);
            }
            if (minPV.getFloat() == -3.4028235E38f) {
                minPV = BFloat.make((float)Float.NEGATIVE_INFINITY);
            }
            if (maxPV.getFloat() == Float.MAX_VALUE) {
                maxPV = BFloat.make((float)Float.POSITIVE_INFINITY);
            }
            BFacets f = BFacets.makeNumeric((BUnit)u, (BInteger)precision, (BNumber)minPV, (BNumber)maxPV);
            this.setFacets(f);
        }
        catch (Exception e) {
            log.log(Level.INFO, this + ":Exception in setOutputFacets()", e);
        }
    }

    @Override
    public Property getPresentValueProperty() {
        return presentValue;
    }
}

