/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.alarm;

import java.util.Map;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.alarm.ext.BOffnormalAlgorithm;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alarmValues", type="BBacnetBitString", defaultValue="BBacnetBitString.make(new boolean[] {false, false, true, true})", flags=64, facets={@Facet(value="BacnetBitStringUtil.BACNET_STATUS_FLAGS_FACETS")}), @NiagaraProperty(name="lastMonitoredValue", type="BBacnetBitString", defaultValue="BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength(\"BacnetStatusFlags\"))", flags=69, facets={@Facet(value="BacnetBitStringUtil.BACNET_STATUS_FLAGS_FACETS")})})
public class BBacnetStatusAlgorithm
extends BOffnormalAlgorithm {
    public static final Property alarmValues = BBacnetStatusAlgorithm.newProperty((int)64, (BValue)BBacnetBitString.make(new boolean[]{false, false, true, true}), (BFacets)BacnetBitStringUtil.BACNET_STATUS_FLAGS_FACETS);
    public static final Property lastMonitoredValue = BBacnetStatusAlgorithm.newProperty((int)69, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), (BFacets)BacnetBitStringUtil.BACNET_STATUS_FLAGS_FACETS);
    public static final Type TYPE = Sys.loadType(BBacnetStatusAlgorithm.class);
    private TwoState current = new NormalState();
    BBacnetBitString monitoredValue;

    public BBacnetBitString getAlarmValues() {
        return (BBacnetBitString)this.get(alarmValues);
    }

    public void setAlarmValues(BBacnetBitString v) {
        this.set(alarmValues, (BValue)v, null);
    }

    public BBacnetBitString getLastMonitoredValue() {
        return (BBacnetBitString)this.get(lastMonitoredValue);
    }

    public void setLastMonitoredValue(BBacnetBitString v) {
        this.set(lastMonitoredValue, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        BAlarmState currentState = ((BAlarmSourceExt)this.getParent()).getAlarmState();
        if (currentState == BAlarmState.offnormal) {
            this.current = new OffnormalState();
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        this.executePoint();
    }

    public void writeAlarmData(BStatusValue out, Map map) {
        super.writeAlarmData(out, map);
    }

    public BAlarmState checkAlarms(BStatusValue out, long toAlarmTimeDelay, long toNormalTimeDelay) {
        BAlarmState currentState = ((BAlarmSourceExt)this.getParent()).getAlarmState();
        if (this.current instanceof ValidateOffnormalState) {
            return this.current.evaluate(this.isNormal(out), toAlarmTimeDelay);
        }
        if (this.current instanceof ValidateReturnFromOffnormalState) {
            return this.current.evaluate(this.isNormal(out), toNormalTimeDelay);
        }
        if (currentState == BAlarmState.offnormal) {
            this.current = new OffnormalState();
            return this.current.evaluate(this.isNormal(out), toNormalTimeDelay);
        }
        this.current = new NormalState();
        return this.current.evaluate(this.isNormal(out), toAlarmTimeDelay);
    }

    protected BacnetStatus isNormal(BStatusValue out) {
        if (this.monitoredValue != null) {
            if (this.monitoredValue.equals((Object)BBacnetBitString.emptyBitString(4))) {
                this.setLastMonitoredValue(this.monitoredValue);
                return BacnetStatus.NORMAL;
            }
            if (this.checkForBitIncrease()) {
                this.setLastMonitoredValue(this.monitoredValue);
                return BacnetStatus.OFFNORMAL;
            }
            this.setLastMonitoredValue(this.monitoredValue);
        }
        return BacnetStatus.IGNORE;
    }

    private boolean checkForBitIncrease() {
        for (int i = 0; i < this.monitoredValue.getBits().length; ++i) {
            if (this.monitoredValue.getBits()[i] == this.getLastMonitoredValue().getBits()[i] || this.getLastMonitoredValue().getBits()[i] || !this.getAlarmValues().getBit(i)) continue;
            return true;
        }
        return false;
    }

    public void setStausFlags(BBacnetBitString bacnetStatusFlags) {
        int size = bacnetStatusFlags.getBits().length;
        boolean[] copyBits = new boolean[size];
        for (int i = 0; i < size; ++i) {
            copyBits[i] = this.getAlarmValues().getBit(i) ? bacnetStatusFlags.getBit(i) : false;
        }
        this.monitoredValue = BBacnetBitString.make(copyBits);
    }

    public void setStatusFlagsOnExtWhenOutOfServiceIsChanged(boolean outOfService) {
        if (outOfService) {
            if (this.monitoredValue == null) {
                this.setLastMonitoredValue(BBacnetBitString.make(new boolean[]{false, false, false, false}));
                this.monitoredValue = BBacnetBitString.make(new boolean[]{false, false, false, true});
            } else {
                this.monitoredValue = BBacnetBitString.make(new boolean[]{this.getLastMonitoredValue().getBit(0), this.getLastMonitoredValue().getBit(1), this.getLastMonitoredValue().getBit(2), true});
            }
        } else {
            this.monitoredValue = BBacnetBitString.make(new boolean[]{this.getLastMonitoredValue().getBit(0), this.getLastMonitoredValue().getBit(1), this.getLastMonitoredValue().getBit(2), false});
        }
    }

    private void transition(TwoState state) {
        this.current = state;
    }

    private BAlarmState getAlarmStateForOffnormalStatus(long timeDelay) {
        if (timeDelay == 0L) {
            this.transition(new OffnormalState());
            return BAlarmState.offnormal;
        }
        this.transition(new ValidateOffnormalState(timeDelay));
        return null;
    }

    static enum BacnetStatus {
        NORMAL,
        OFFNORMAL,
        IGNORE;

    }

    private class ValidateReturnFromOffnormalState
    extends ValidateState {
        public ValidateReturnFromOffnormalState(long timeDelay) {
            BBacnetStatusAlgorithm.this.startTimer(timeDelay);
        }

        @Override
        public String tag() {
            return "ValidateReturnFromOffnormalState";
        }

        @Override
        public BAlarmState evaluate(BacnetStatus bacnetStatus, long timeDelay) {
            if (bacnetStatus == BacnetStatus.NORMAL) {
                if (BBacnetStatusAlgorithm.this.isTimerExpired()) {
                    BBacnetStatusAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
            } else {
                BBacnetStatusAlgorithm.this.transition(new OffnormalState());
                return null;
            }
            return null;
        }
    }

    private class OffnormalState
    extends TwoState {
        private OffnormalState() {
        }

        @Override
        public String tag() {
            return "OffnormalState";
        }

        @Override
        public BAlarmState evaluate(BacnetStatus bacnetStatus, long timeDelay) {
            if (bacnetStatus == BacnetStatus.NORMAL) {
                if (timeDelay == 0L) {
                    BBacnetStatusAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
                BBacnetStatusAlgorithm.this.transition(new ValidateReturnFromOffnormalState(timeDelay));
                return null;
            }
            if (bacnetStatus == BacnetStatus.OFFNORMAL) {
                return BBacnetStatusAlgorithm.this.getAlarmStateForOffnormalStatus(timeDelay);
            }
            return null;
        }
    }

    private class ValidateOffnormalState
    extends ValidateState {
        public ValidateOffnormalState(long timeDelay) {
            BBacnetStatusAlgorithm.this.startTimer(timeDelay);
        }

        @Override
        public String tag() {
            return "ValidateOffnormalState";
        }

        @Override
        public BAlarmState evaluate(BacnetStatus bacnetStatus, long timeDelay) {
            if (bacnetStatus == BacnetStatus.NORMAL) {
                BBacnetStatusAlgorithm.this.transition(new NormalState());
                return null;
            }
            if (BBacnetStatusAlgorithm.this.isTimerExpired()) {
                BBacnetStatusAlgorithm.this.transition(new OffnormalState());
                return BAlarmState.offnormal;
            }
            return null;
        }
    }

    private class NormalState
    extends TwoState {
        private NormalState() {
        }

        @Override
        public String tag() {
            return "Normal";
        }

        @Override
        public BAlarmState evaluate(BacnetStatus bacnetStatus, long timeDelay) {
            if (bacnetStatus == BacnetStatus.OFFNORMAL) {
                return BBacnetStatusAlgorithm.this.getAlarmStateForOffnormalStatus(timeDelay);
            }
            return null;
        }
    }

    private abstract class ValidateState
    extends TwoState {
        private ValidateState() {
        }
    }

    private abstract class TwoState {
        public TwoState() {
            BBacnetStatusAlgorithm.this.cancelTimer();
        }

        public abstract String tag();

        public abstract BAlarmState evaluate(BacnetStatus var1, long var2);
    }
}

