/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.alarm;

import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.server.BEventHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetAlarmConst;
import javax.baja.bacnet.alarm.BBacnetEventProcessor;
import javax.baja.data.BIDataValue;
import javax.baja.driver.alarm.BAlarmDeviceExt;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetAlarmDeviceExt
extends BAlarmDeviceExt
implements BacnetAlarmConst {
    public static final Property alarmClass = BBacnetAlarmDeviceExt.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassEditor")));
    public static final Property niagaraProcessId = BBacnetAlarmDeviceExt.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BLong.make((long)0L), (String)"max", (BIDataValue)BLong.make((long)Integer.MAX_VALUE)));
    public static final Type TYPE = Sys.loadType(BBacnetAlarmDeviceExt.class);
    private static final Logger logger = Logger.getLogger("bacnet");

    public long getNiagaraProcessId() {
        return this.getLong(niagaraProcessId);
    }

    public void setNiagaraProcessId(long v) {
        this.setLong(niagaraProcessId, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        return this.getEventHandler().doAckAlarm(ackRequest);
    }

    public void doRouteAlarm(BAlarmRecord record) throws Exception {
        try {
            BString s = (BString)record.getAlarmFacet("processId");
            if (s != null) {
                long processId = Long.parseLong(s.getString());
                boolean noEventProcessor = true;
                if (processId == this.getNiagaraProcessId()) {
                    noEventProcessor = false;
                    BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                    as.routeAlarm(record);
                }
                SlotCursor sc = this.getProperties();
                while (sc.next(BBacnetEventProcessor.class)) {
                    BBacnetEventProcessor proc = (BBacnetEventProcessor)sc.get();
                    if (proc.getProcessId() != processId) continue;
                    noEventProcessor = false;
                    proc.routeAlarm(record);
                }
                if (noEventProcessor) {
                    logger.info("AlarmDeviceExt(procId " + this.getNiagaraProcessId() + "): no event processor for alarm record:\n" + record);
                }
            }
        }
        catch (ServiceNotFoundException e) {
            logger.log(Level.SEVERE, "AlarmDeviceExt.processEvent:Unable to find Alarm Service!", e);
        }
    }

    private BEventHandler getEventHandler() {
        return ((BBacnetStack)((BBacnetNetwork)this.getNetwork()).getBacnetComm()).getServer().getEventHandler();
    }
}

