/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server.object;

import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.services.BacnetReject;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.confirmed.CreateObjectAck;
import com.tridium.bacnet.services.confirmed.CreateObjectRequest;
import com.tridium.bacnet.services.confirmed.DeleteObjectAck;
import com.tridium.bacnet.services.confirmed.DeleteObjectRequest;
import com.tridium.bacnet.services.error.CreateObjectError;
import com.tridium.bacnet.services.error.DeleteObjectError;
import com.tridium.bacnet.stack.server.ServiceHandler;
import com.tridium.bacnet.stack.server.object.BBacnetObjectCreator;
import com.tridium.bacnet.stack.server.object.BBacnetObjectDeletor;
import com.tridium.bacnet.stack.server.object.BCalendarCreator;
import com.tridium.bacnet.stack.server.object.BCalendarDeletor;
import com.tridium.bacnet.stack.server.object.BEventEnrollmentCreator;
import com.tridium.bacnet.stack.server.object.BEventEnrollmentDeletor;
import com.tridium.bacnet.stack.server.object.BNotificationClassCreator;
import com.tridium.bacnet.stack.server.object.BNotificationClassDeletor;
import com.tridium.bacnet.stack.server.object.BScheduleCreator;
import com.tridium.bacnet.stack.server.object.BScheduleDeletor;
import com.tridium.bacnet.stack.server.object.BTrendLogCreator;
import com.tridium.bacnet.stack.server.object.BTrendLogDeletor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="createEnabled", type="boolean", defaultValue="false", flags=0), @NiagaraProperty(name="deleteEnabled", type="boolean", defaultValue="false", flags=0)})
public class BObjectHandler
extends BComponent
implements ServiceHandler,
BacnetConfirmedServiceChoice {
    public static final Property createEnabled = BObjectHandler.newProperty((int)0, (boolean)false, null);
    public static final Property deleteEnabled = BObjectHandler.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BObjectHandler.class);
    private static final int UNKNOWN_OBJECT_TYPE = -1;
    private static final Logger logger = Logger.getLogger("bacnet.server.object.handler");

    public boolean getCreateEnabled() {
        return this.getBoolean(createEnabled);
    }

    public void setCreateEnabled(boolean v) {
        this.setBoolean(createEnabled, v, null);
    }

    public boolean getDeleteEnabled() {
        return this.getBoolean(deleteEnabled);
    }

    public void setDeleteEnabled(boolean v) {
        this.setBoolean(deleteEnabled, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    @Override
    public BacnetServicePrimitive receiveRequest(int serviceChoice, BacnetServicePrimitive request, BBacnetAddress sourceAddress) {
        switch (serviceChoice) {
            case 10: {
                if (!(request instanceof CreateObjectRequest)) break;
                return this.processCreateObjectRequest(sourceAddress, (CreateObjectRequest)request);
            }
            case 11: {
                if (!(request instanceof DeleteObjectRequest)) break;
                return this.processDeleteObjectRequest(sourceAddress, (DeleteObjectRequest)request);
            }
        }
        return null;
    }

    private BacnetServicePrimitive processCreateObjectRequest(BBacnetAddress address, CreateObjectRequest request) {
        BBacnetObjectCreator objectCreator;
        int objectType = request.getObjectType();
        BBacnetObjectIdentifier oid = request.getObjectId();
        if (objectType == -1) {
            if (oid != null) {
                objectType = oid.getObjectType();
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("CreateObject request specifies UNKNOWN_OBJECT_TYPE and does not contain an objectId");
                }
                return BObjectHandler.error(BBacnetErrorClass.object, BBacnetErrorCode.valueOutOfRange, 0);
            }
        }
        if (!BObjectHandler.isDescriptorSupportedForType(objectType)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("CreateObject request specifies unknown objectType " + BBacnetObjectType.tag(objectType) + "; objectId: " + (Object)((Object)oid));
            }
            return BObjectHandler.error(BBacnetErrorClass.object, BBacnetErrorCode.unsupportedObjectType, 0);
        }
        if (!BObjectHandler.isObjectCreationSupportedForType(objectType)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("CreateObject request specifies unsupported objectType " + BBacnetObjectType.tag(objectType) + "; objectId: " + (Object)((Object)oid));
            }
            return BObjectHandler.error(BBacnetErrorClass.object, BBacnetErrorCode.dynamicCreationNotSupported, 0);
        }
        if (!this.getCreateEnabled()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("CreateObject request rejected because object creation is not enabled; objectId: " + (Object)((Object)oid));
            }
            return BObjectHandler.error(BBacnetErrorClass.object, BBacnetErrorCode.dynamicCreationNotSupported, 0);
        }
        if (BacnetDescriptorUtil.exportTable().get("dynamicObjects") == null) {
            BacnetDescriptorUtil.exportTable().add("dynamicObjects", (BValue)new BFolder());
        }
        if (!this.checkForObjectSpace(objectType)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("CreateObject request rejected because there is no space for objectType " + BBacnetObjectType.tag(objectType) + "; objectId: " + (Object)((Object)oid));
            }
            return BObjectHandler.error(BBacnetErrorClass.object, BBacnetErrorCode.noSpaceForObject, 0);
        }
        if (oid == null && objectType > -1) {
            oid = BacnetDescriptorUtil.nextObjectIdentifier(objectType);
        }
        if ((objectCreator = this.getCreator(oid.getObjectType())) == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("CreateObject request rejected because there is no objectCreator for objectType " + BBacnetObjectType.tag(objectType) + "; objectId: " + (Object)((Object)oid));
            }
            return BObjectHandler.error(BBacnetErrorClass.object, BBacnetErrorCode.dynamicCreationNotSupported, 0);
        }
        if (this.objectIdExists(oid)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("CreateObject request rejected because there oid " + (Object)((Object)oid) + " already exists");
            }
            return BObjectHandler.error(BBacnetErrorClass.object, BBacnetErrorCode.objectIdentifierAlreadyExists, 0);
        }
        return this.createObject(objectCreator, oid, request.getListOfInitialValues());
    }

    private BacnetServicePrimitive createObject(BBacnetObjectCreator oc, BBacnetObjectIdentifier oid, Array<PropertyValue> initialValues) {
        if (oid.getInstanceNumber() > 0x3FFFFE) {
            return new BacnetReject(6);
        }
        BIBacnetExportObject expDesc = null;
        try {
            if (oid.getObjectType() == 17) {
                expDesc = ((BScheduleCreator)oc).createObject(oid, initialValues);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Dynamic Schedule creation - Creating schedule " + expDesc.getType());
                }
            } else {
                expDesc = oc.createObject(oid);
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Exception creating object for object identifier " + (Object)((Object)oid), e);
            }
            return new BacnetReject(7);
        }
        ErrorType errorType = oc.exportObject(BacnetDescriptorUtil.exportTable(), expDesc);
        if (errorType != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Error exporting object for object identifier " + (Object)((Object)oid));
            }
            return BObjectHandler.error(errorType, 0);
        }
        if (initialValues != null) {
            for (int i = 0; i < initialValues.size(); ++i) {
                int elemNum = i + 1;
                PropertyValue pv = (PropertyValue)initialValues.get(i);
                if (!oc.checkProperties(pv.getPropertyId())) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Attempting to create object for object id " + (Object)((Object)oid) + "; initial value property " + BBacnetPropertyIdentifier.tag(pv.getPropertyId()) + " is unknown for objects of the type being created.");
                    }
                    this.getDeletor(oid.getObjectType()).deleteObject(oid, BacnetDescriptorUtil.exportTable());
                    return BObjectHandler.error(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty, elemNum);
                }
                if (!oc.isInitialValueSupported(pv.getPropertyId())) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Attempting to create object for object id " + (Object)((Object)oid) + "; initialization during the CreateObject service for property " + BBacnetPropertyIdentifier.tag(pv.getPropertyId()) + " is not supported.");
                    }
                    this.getDeletor(oid.getObjectType()).deleteObject(oid, BacnetDescriptorUtil.exportTable());
                    return BObjectHandler.error(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied, elemNum);
                }
                BBacnetErrorCode errorCode = null;
                BacnetException exception = null;
                BBacnetErrorClass errorClass = BBacnetErrorClass.object;
                try {
                    errorType = oc.writeInitialValue(expDesc, pv);
                    if (errorType != null) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Attempting to create object for object id " + (Object)((Object)oid) + "; error writing initial value for property " + BBacnetPropertyIdentifier.tag(pv.getPropertyId()) + '.');
                        }
                        this.getDeletor(oid.getObjectType()).deleteObject(oid, BacnetDescriptorUtil.exportTable());
                        return BObjectHandler.error(errorType, elemNum);
                    }
                }
                catch (AsnException ae) {
                    errorCode = BBacnetErrorCode.invalidDataType;
                    exception = ae;
                    errorClass = BBacnetErrorClass.property;
                }
                catch (BacnetException be) {
                    errorCode = BBacnetErrorCode.inconsistentParameters;
                    exception = be;
                }
                if (errorCode == null) continue;
                logger.log(Level.WARNING, "Attempting to create object for object id " + (Object)((Object)oid) + "; exception thrown while writing initial value for property " + BBacnetPropertyIdentifier.tag(pv.getPropertyId()) + '.', (Throwable)((Object)exception));
                this.getDeletor(oid.getObjectType()).deleteObject(oid, BacnetDescriptorUtil.exportTable());
                return BObjectHandler.error(errorClass, errorCode, elemNum);
            }
            oc.postProcess(expDesc);
        }
        return new CreateObjectAck(oid);
    }

    private BacnetServicePrimitive processDeleteObjectRequest(BBacnetAddress address, DeleteObjectRequest request) {
        ErrorType err = null;
        if (!this.getDeleteEnabled() || request.getObjectId().getObjectType() == 8) {
            return BObjectHandler.error(new NErrorType(1, 23));
        }
        if (!this.objectIdExists(request.getObjectId())) {
            return BObjectHandler.error(new NErrorType(1, 31));
        }
        if (this.getDeletor(request.getObjectId().getObjectType()) == null) {
            return BObjectHandler.error(new NErrorType(1, 23));
        }
        err = this.getDeletor(request.getObjectId().getObjectType()).deleteObject(request.getObjectId(), BacnetDescriptorUtil.exportTable());
        if (err != null) {
            return BObjectHandler.error(err);
        }
        return new DeleteObjectAck(request.getObjectId());
    }

    private boolean objectIdExists(BBacnetObjectIdentifier oid) {
        return BacnetDescriptorUtil.exportTable().byObjectId(oid) != null;
    }

    private BBacnetObjectCreator getCreator(int objectType) {
        BBacnetObjectCreator[] creators = (BBacnetObjectCreator[])this.getChildren(BBacnetObjectCreator.class);
        BBacnetObjectCreator boc = null;
        for (BBacnetObjectCreator oc : creators) {
            if (!oc.isObjectTypeSupported(objectType)) continue;
            boc = oc;
        }
        if (boc == null) {
            boc = this.addObjectCreator(objectType);
        }
        return boc;
    }

    private BBacnetObjectDeletor getDeletor(int objectType) {
        BBacnetObjectDeletor[] deletors = (BBacnetObjectDeletor[])this.getChildren(BBacnetObjectDeletor.class);
        BBacnetObjectDeletor bod = null;
        for (BBacnetObjectDeletor od : deletors) {
            if (!od.isObjectTypeSupported(objectType)) continue;
            bod = od;
        }
        if (bod == null) {
            bod = this.addObjectDeletor(objectType);
        }
        return bod;
    }

    private BBacnetObjectCreator addObjectCreator(int objectType) {
        BBacnetObjectCreator oc = null;
        String key = "";
        switch (objectType) {
            case 6: {
                oc = new BCalendarCreator();
                key = "CalendarCreator";
                break;
            }
            case 17: {
                oc = new BScheduleCreator();
                key = "ScheduleCreator";
                break;
            }
            case 9: {
                oc = new BEventEnrollmentCreator();
                key = "EventEnrollmentCreator";
                break;
            }
            case 20: {
                oc = new BTrendLogCreator();
                key = "TrendLogCreator";
                break;
            }
            case 15: {
                oc = new BNotificationClassCreator();
                key = "NotificationClassCreator";
            }
        }
        if (oc != null) {
            this.add(key, (BValue)oc, 5);
        }
        return oc;
    }

    private BBacnetObjectDeletor addObjectDeletor(int objectType) {
        switch (objectType) {
            case 6: {
                BCalendarDeletor cd = new BCalendarDeletor();
                this.add("CalendarDeletor", (BValue)cd, 5);
                return cd;
            }
            case 17: {
                BScheduleDeletor sd = new BScheduleDeletor();
                this.add("ScheduleDeletor", (BValue)sd, 5);
                return sd;
            }
            case 15: {
                BNotificationClassDeletor nd = new BNotificationClassDeletor();
                this.add("NotificationClassDeletor", (BValue)nd, 5);
                return nd;
            }
            case 9: {
                BEventEnrollmentDeletor ed = new BEventEnrollmentDeletor();
                this.add("EventEnrollmentDeletor", (BValue)ed, 5);
                return ed;
            }
            case 20: {
                BTrendLogDeletor td = new BTrendLogDeletor();
                this.add("TrendLogDeletor", (BValue)td, 5);
                return td;
            }
        }
        return null;
    }

    private boolean checkForObjectSpace(int objecttype) {
        boolean licenseLimit = false;
        Boolean result = true;
        return result;
    }

    private static boolean isObjectCreationSupportedForType(int objectType) {
        switch (objectType) {
            case 6: 
            case 9: 
            case 15: 
            case 17: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    private static boolean isDescriptorSupportedForType(int objectType) {
        switch (objectType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 29: 
            case 40: 
            case 45: 
            case 46: 
            case 48: {
                return true;
            }
        }
        return false;
    }

    protected static BacnetServicePrimitive error(BBacnetErrorClass errClass, BBacnetErrorCode errCode, int elementNumber) {
        return new CreateObjectError(new NErrorType(errClass.getOrdinal(), errCode.getOrdinal()), (long)elementNumber);
    }

    protected static BacnetServicePrimitive error(ErrorType errorType, int elementNumber) {
        return new CreateObjectError(new NErrorType(errorType.getErrorClass(), errorType.getErrorCode()), (long)elementNumber);
    }

    protected static BacnetServicePrimitive error(ErrorType errorType) {
        return new DeleteObjectError(new NErrorType(errorType.getErrorClass(), errorType.getErrorCode()));
    }
}

