/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server.object;

import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import com.tridium.bacnet.stack.server.object.BacObjCreatorDeletorUtil;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BBacnetObjectDeletor
extends BComponent {
    public static final Type TYPE = Sys.loadType(BBacnetObjectDeletor.class);

    public Type getType() {
        return TYPE;
    }

    public abstract boolean isObjectTypeSupported(int var1);

    public BOrd getRemoteExtensionToDelete(BIBacnetExportObject descriptor) {
        return descriptor.getObjectOrd();
    }

    public ErrorType deleteObject(BBacnetObjectIdentifier oid, BBacnetExportTable exportTable) {
        BIBacnetExportObject expObject = exportTable.byObjectId(oid);
        BOrd remoteOrd = this.getRemoteExtensionToDelete(expObject);
        BComplex descriptor = (BComplex)expObject;
        if (!this.isObjectDeletable(exportTable, descriptor)) {
            return new NErrorType(1, 23);
        }
        exportTable.get("dynamicObjects").asComponent().remove(descriptor.asComplex());
        if (remoteOrd != null && !remoteOrd.isNull()) {
            try {
                BComponent remoteExt = (BComponent)remoteOrd.get((BObject)exportTable);
                ((BComponent)remoteExt.getParent()).remove((BComplex)remoteExt);
            }
            catch (Exception e) {
                BacObjCreatorDeletorUtil.logger.info("Error while deleting Remote extension. " + e.getMessage());
            }
        }
        return null;
    }

    private boolean isObjectDeletable(BBacnetExportTable exportTable, BComplex desc) {
        try {
            return exportTable.get("dynamicObjects").asComponent().getProperty(desc.getName()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

