/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.BacnetNotificationParameters;
import com.tridium.bacnet.asn.EventNotificationParameters;
import com.tridium.bacnet.asn.NAlarmSummary;
import com.tridium.bacnet.asn.NEnrollmentSummary;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NEventSummary;
import com.tridium.bacnet.datatypes.BPriorityFilter;
import com.tridium.bacnet.enums.BAcknowledgmentFilter;
import com.tridium.bacnet.enums.BEventStateFilter;
import com.tridium.bacnet.history.BBacnetHistoryDeviceExt;
import com.tridium.bacnet.history.BBacnetHistoryImport;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.BacnetSimpleAck;
import com.tridium.bacnet.services.confirmed.AcknowledgeAlarmRequest;
import com.tridium.bacnet.services.confirmed.ConfirmedEventNotificationRequest;
import com.tridium.bacnet.services.confirmed.GetAlarmSummaryAck;
import com.tridium.bacnet.services.confirmed.GetAlarmSummaryRequest;
import com.tridium.bacnet.services.confirmed.GetEnrollmentSummaryAck;
import com.tridium.bacnet.services.confirmed.GetEnrollmentSummaryRequest;
import com.tridium.bacnet.services.confirmed.GetEventInformationAck;
import com.tridium.bacnet.services.confirmed.GetEventInformationRequest;
import com.tridium.bacnet.services.error.SimpleError;
import com.tridium.bacnet.services.unconfirmed.UnconfirmedEventNotificationRequest;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.DeviceRegistry;
import com.tridium.bacnet.stack.client.AckAlarmRequest;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import com.tridium.bacnet.stack.server.BHashedEventBuffer;
import com.tridium.bacnet.stack.server.ServiceHandler;
import com.tridium.bacnet.stack.transport.BBacnetTransportLayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetAlarmConst;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetUnconfirmedServiceChoice;
import javax.baja.bacnet.alarm.BBacnetAlarmDeviceExt;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDestination;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetRecipient;
import javax.baja.bacnet.datatypes.BBacnetRecipientProcess;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.export.BBacnetEventSource;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.BBacnetComm;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.EventNotificationListener;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.alarm.BAlarmDeviceExt;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class BEventHandler
extends BComponent
implements ServiceHandler,
BIAlarmSource,
BacnetConfirmedServiceChoice,
BacnetUnconfirmedServiceChoice,
BacnetAlarmConst,
BacnetConst {
    public static final Property silenceSupported = BEventHandler.newProperty((int)1, (boolean)false, null);
    public static final Property eventSummaryAlarmClass = BEventHandler.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassEditor")));
    public static final Property eventSummaryProcessId = BEventHandler.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)Integer.MAX_VALUE));
    public static final Property toOffnormalBuffer = BEventHandler.newProperty((int)4, (BValue)new BHashedEventBuffer(), null);
    public static final Property toFaultBuffer = BEventHandler.newProperty((int)4, (BValue)new BHashedEventBuffer(), null);
    public static final Property toNormalBuffer = BEventHandler.newProperty((int)4, (BValue)new BHashedEventBuffer(), null);
    public static final Property eventSummaries = BEventHandler.newProperty((int)4, (BValue)new BComponent(), null);
    public static final Action ackAlarm = BEventHandler.newAction((int)5, (BValue)new BAlarmRecord(), null);
    public static final Action dumpBuffers = BEventHandler.newAction((int)4, null);
    public static final Action clearBuffers = BEventHandler.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BEventHandler.class);
    private BBacnetTransportLayer transportLayer;
    private static final Logger logger = Logger.getLogger("bacnet.server");
    private ArrayList<EventNotificationListener> confirmedEventListeners = new ArrayList();
    private ArrayList<EventNotificationListener> unconfirmedEventListeners = new ArrayList();

    public boolean getSilenceSupported() {
        return this.getBoolean(silenceSupported);
    }

    public void setSilenceSupported(boolean v) {
        this.setBoolean(silenceSupported, v, null);
    }

    public String getEventSummaryAlarmClass() {
        return this.getString(eventSummaryAlarmClass);
    }

    public void setEventSummaryAlarmClass(String v) {
        this.setString(eventSummaryAlarmClass, v, null);
    }

    public int getEventSummaryProcessId() {
        return this.getInt(eventSummaryProcessId);
    }

    public void setEventSummaryProcessId(int v) {
        this.setInt(eventSummaryProcessId, v, null);
    }

    public BHashedEventBuffer getToOffnormalBuffer() {
        return (BHashedEventBuffer)this.get(toOffnormalBuffer);
    }

    public void setToOffnormalBuffer(BHashedEventBuffer v) {
        this.set(toOffnormalBuffer, (BValue)v, null);
    }

    public BHashedEventBuffer getToFaultBuffer() {
        return (BHashedEventBuffer)this.get(toFaultBuffer);
    }

    public void setToFaultBuffer(BHashedEventBuffer v) {
        this.set(toFaultBuffer, (BValue)v, null);
    }

    public BHashedEventBuffer getToNormalBuffer() {
        return (BHashedEventBuffer)this.get(toNormalBuffer);
    }

    public void setToNormalBuffer(BHashedEventBuffer v) {
        this.set(toNormalBuffer, (BValue)v, null);
    }

    public BComponent getEventSummaries() {
        return (BComponent)this.get(eventSummaries);
    }

    public void setEventSummaries(BComponent v) {
        this.set(eventSummaries, (BValue)v, null);
    }

    public BBoolean ackAlarm(BAlarmRecord ackRequest) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)ackRequest, null);
    }

    public void dumpBuffers() {
        this.invoke(dumpBuffers, null, null);
    }

    public void clearBuffers() {
        this.invoke(clearBuffers, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BEventHandler.doAckAlarm():" + ackRequest);
        }
        if (this.checkRecordByTimestamp(ackRequest)) {
            AckAlarmRequest ackReq = new AckAlarmRequest(ackRequest);
            BBacnetNetwork.bacnet().postAsync(ackReq);
            return BBoolean.TRUE;
        }
        logger.fine("Stale ack received from Alarm Service!");
        try {
            BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            ackRequest.ackAlarm();
            ackRequest.setAckState(BAckState.acked);
            as.routeAlarm(ackRequest);
        }
        catch (ServiceNotFoundException e) {
            logger.log(Level.SEVERE, "BEventHandler.doAckAlarm:Unable to find Alarm Service!", e);
        }
        return BBoolean.FALSE;
    }

    public void doDumpBuffers() {
    }

    public void doClearBuffers() {
        this.getToOffnormalBuffer().removeAll();
        this.getToFaultBuffer().removeAll();
        this.getToNormalBuffer().removeAll();
        this.getEventSummaries().removeAll();
    }

    @Override
    public BacnetServicePrimitive receiveRequest(int serviceChoice, BacnetServicePrimitive request, BBacnetAddress sourceAddress) {
        BacnetServicePrimitive response = null;
        try {
            if (request.getServiceType() == 0) {
                switch (serviceChoice) {
                    case 0: {
                        response = this.processAcknowledgeAlarmRequest((AcknowledgeAlarmRequest)request, sourceAddress);
                        break;
                    }
                    case 2: {
                        response = this.processConfirmedEventNotificationRequest((ConfirmedEventNotificationRequest)request);
                        this.routeToConfirmedListeners((ConfirmedEventNotificationRequest)request, sourceAddress);
                        break;
                    }
                    case 3: {
                        response = this.processGetAlarmSummaryRequest((GetAlarmSummaryRequest)request);
                        break;
                    }
                    case 4: {
                        response = this.processGetEnrollmentSummaryRequest((GetEnrollmentSummaryRequest)request);
                        break;
                    }
                    case 29: {
                        response = this.processGetEventInformationRequest((GetEventInformationRequest)request);
                        break;
                    }
                    default: {
                        logger.info("BEventHandler.receiveRequest:Unknown request! " + request);
                        break;
                    }
                }
            } else {
                switch (serviceChoice) {
                    case 3: {
                        this.processUnconfirmedEventNotificationRequest((UnconfirmedEventNotificationRequest)request);
                        this.routeToUnconfirmedListeners((UnconfirmedEventNotificationRequest)request, sourceAddress);
                        break;
                    }
                    default: {
                        logger.info("BEventHandler.receiveRequest:Unknown request! " + request);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Server error in event handler: " + e + " processing request " + request + " from " + sourceAddress, e);
        }
        return response;
    }

    protected BacnetServicePrimitive processAcknowledgeAlarmRequest(AcknowledgeAlarmRequest request, BBacnetAddress sourceAddress) {
        boolean logTrace = logger.isLoggable(Level.FINE);
        if (logTrace) {
            logger.fine("BEventHandler: AcknowledgeAlarmRequest received: " + request);
        }
        BLocalBacnetDevice localDevice = BBacnetNetwork.localDevice();
        ErrorType err = null;
        try {
            BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BBacnetObjectIdentifier deviceId = localDevice.getObjectId();
            BBacnetObjectIdentifier objectId = request.getEventObjectId();
            BIBacnetExportObject export = localDevice.lookupBacnetObject(objectId);
            if (export == null) {
                return new SimpleError(0, new NErrorType(1, 31));
            }
            if (!(export instanceof BBacnetEventSource)) {
                return new SimpleError(0, new NErrorType(1, 74));
            }
            BEnum stateAcked = request.getEventStateAcknowledged();
            BAlarmRecord record = this.getRecordFromEventBuffer(stateAcked.getOrdinal(), deviceId, objectId, 0L, false);
            if (logTrace) {
                logger.fine("\nstateAcked:" + stateAcked + ", ordinal=" + stateAcked.getOrdinal());
            }
            if ((err = this.validateAcknowledgement(request, record, as, sourceAddress, (BBacnetEventSource)export)) == null) {
                if (logTrace) {
                    logger.fine("\n\nacknowledgement validated (but not yet acked!) record=" + record + "\nalarmData=" + record.getAlarmData() + "\nuuid:" + record.getUuid() + "\n");
                }
                record.setUser(request.getAcknowledgementSource());
                record.setAckState(BAckState.ackPending);
                int acksReq = 0;
                BInteger acksReqFacet = (BInteger)record.getAlarmFacet("bacnetAcksRequired");
                if (acksReqFacet != null) {
                    acksReq = acksReqFacet.getInt();
                }
                if (BBacnetEventState.isOffnormal(stateAcked)) {
                    record.addAlarmFacet("offnormalAcked", (BIDataValue)BBoolean.TRUE);
                    acksReq &= 0xFFFFFFFB;
                } else if (BBacnetEventState.isFault(stateAcked)) {
                    acksReq &= 0xFFFFFFFD;
                } else if (BBacnetEventState.isNormal(stateAcked)) {
                    acksReq &= 0xFFFFFFFE;
                }
                if (logTrace) {
                    logger.fine("bacnetAcksRequired=" + acksReq);
                }
                record.addAlarmFacet("bacnetAcksRequired", (BIDataValue)BInteger.make((int)acksReq));
                record.addAlarmFacet("stateAcked", (BIDataValue)BInteger.make((int)stateAcked.getOrdinal()));
                if (acksReq == 0) {
                    if (logTrace) {
                        logger.fine("BEventHandler.processAckAlarmReq: no more acks req'd - ackAlarm(): user=" + record.getUser() + " stateAcked=" + stateAcked + "...");
                    }
                    as.ackAlarm(record);
                } else {
                    if (logTrace) {
                        logger.fine("\nBEventHandler.processAckAlarmReq: more acks req'd - routeAlarm(): user=" + record.getUser() + " stateAcked=" + stateAcked + "; adjusting ackedTransitions...");
                    }
                    BObject alarmSource = record.getSource().get(0).get((BObject)this);
                    BAlarmSourceExt ext = (BAlarmSourceExt)alarmSource;
                    int ibits = ext.getAckedTransitions().getBits();
                    ext.setAckedTransitions(BAlarmTransitionBits.make((int)(ibits |= BEventHandler.getAlarmTransitionBit(request.getEventStateAcknowledged()))));
                    try (AlarmDbConnection conn = as.getAlarmDb().getDbConnection(null);){
                        conn.update(record);
                    }
                    as.routeAlarm(record);
                }
                BAlarmRecord[] others = this.getOtherUnackeds(record);
                for (int i = 0; i < others.length; ++i) {
                    this.ackNiagara(others[i], stateAcked);
                    as.routeAlarm(others[i]);
                }
                return new BacnetSimpleAck(0);
            }
            return new SimpleError(0, err);
        }
        catch (ServiceNotFoundException e) {
            logger.log(Level.SEVERE, "BEventHandler.processAcknowledgeAlarmRequest:Unable to find Alarm Service!", e);
            return new SimpleError(0, new NErrorType(3, 0));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "BEventHandler.processAcknowledgeAlarmRequest:Exception occurred!", e);
            return new SimpleError(0, new NErrorType(3, 0));
        }
    }

    protected BacnetServicePrimitive processConfirmedEventNotificationRequest(ConfirmedEventNotificationRequest request) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BEventHandler: ConfirmedEventNotificationRequest received: " + request);
        }
        NErrorType err = null;
        try {
            err = this.processEvent(request.getEventNotificationParameters(), true);
        }
        catch (ServiceNotFoundException e) {
            logger.severe("Can't find Alarm Service!");
            err = new NErrorType(0, 25);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing BACnet Event Notification:" + e, e);
            err = new NErrorType(0, 25);
        }
        if (err == null) {
            return new BacnetSimpleAck(2);
        }
        return new SimpleError(2, err);
    }

    protected void processUnconfirmedEventNotificationRequest(UnconfirmedEventNotificationRequest request) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BEventHandler: UnconfirmedEventNotificationRequest received: " + request);
        }
        try {
            this.processEvent(request.getEventNotificationParameters(), false);
        }
        catch (ServiceNotFoundException e) {
            logger.severe("Can't find Alarm Service!");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error processing BACnet Event Notification:" + e, e);
        }
    }

    protected BacnetServicePrimitive processGetAlarmSummaryRequest(GetAlarmSummaryRequest request) {
        int ndx;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BEventHandler: GetAlarmSummaryRequest received: " + request);
        }
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        Vector<NAlarmSummary> listOfAlarmSummaries = new Vector<NAlarmSummary>();
        BBacnetObjectIdentifier[] ids = (BBacnetObjectIdentifier[])this.getEventSummaries().getChildren(BBacnetObjectIdentifier.class);
        int len = ids.length;
        for (int i = ndx = 0; i < len; ++i) {
            BEnum eventState;
            BBacnetObjectIdentifier id = ids[i];
            BBacnetEventSource src = (BBacnetEventSource)local.lookupBacnetObject(id);
            if (src == null || !src.getEventDetectionEnable()) {
                this.getEventSummaries().remove(id.toString(nameContext));
                continue;
            }
            if (src.getNotifyType() != BBacnetNotifyType.alarm || (eventState = src.getEventState()) == null || eventState.getOrdinal() == 0) continue;
            NAlarmSummary asum = new NAlarmSummary(id, eventState, src.getAckedTransitions());
            listOfAlarmSummaries.add(asum);
        }
        return new GetAlarmSummaryAck(listOfAlarmSummaries);
    }

    protected BacnetServicePrimitive processGetEnrollmentSummaryRequest(GetEnrollmentSummaryRequest request) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BEventHandler: GetEnrollmentSummaryRequest received: " + request);
        }
        BBacnetExportTable exports = (BBacnetExportTable)BBacnetNetwork.localDevice().getExportTable();
        BIBacnetExportObject[] entries = exports.getExportedObjects(BBacnetEventSource.TYPE);
        BBacnetEventSource eventSource = null;
        Vector<NEnrollmentSummary> v = new Vector<NEnrollmentSummary>();
        BAcknowledgmentFilter ackFilter = request.getAcknowledgmentFilter();
        BBacnetRecipientProcess enrollmentFilter = request.getEnrollmentFilter();
        BEventStateFilter eventStateFilter = request.getEventStateFilter();
        BEnum eventTypeFilter = request.getEventTypeFilter();
        BPriorityFilter priorityFilter = request.getPriorityFilter();
        long notificationClassFilter = request.getNotificationClassFilter();
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                eventSource = (BBacnetEventSource)entries[i];
                if (eventSource == null || !eventSource.getEventDetectionEnable() || !eventSource.isEventInitiationEnabled() || !ackFilter.filter(eventSource.getAckedTransitions())) continue;
                if (request.isEnrollmentFilter()) {
                    BBacnetNotificationClassDescriptor nc = eventSource.getNotificationClass();
                    BBacnetDestination[] recips = nc.getRecipientList();
                    boolean include = false;
                    for (int j = 0; j < recips.length; ++j) {
                        if (!recips[j].getProcessIdentifier().equals((Object)enrollmentFilter.getProcessIdentifier()) || !recips[j].getRecipient().equivalent(enrollmentFilter.getRecipient())) continue;
                        include = true;
                        break;
                    }
                    if (!include) continue;
                }
                if (request.isEventStateFilter() && !eventStateFilter.filter(eventSource.getEventState()) || request.isEventTypeFilter() && eventTypeFilter.getOrdinal() != eventSource.getEventType().getOrdinal()) continue;
                int transition = BEventHandler.getNiagaraSourceState(eventSource.getEventState().getOrdinal());
                int priority = BEventHandler.getEventPriority(transition, eventSource);
                if (request.isPriorityFilter() && !priorityFilter.filter(priority) || request.isNotificationClassFilter() && (long)eventSource.getNotificationClass().getNotificationClass() != notificationClassFilter) continue;
                v.add(new NEnrollmentSummary(eventSource.getObjectId(), eventSource.getEventType(), eventSource.getEventState(), priority, request.isNotificationClassFilter() ? (long)eventSource.getNotificationClass().getNotificationClass() : -1L));
            }
        }
        return new GetEnrollmentSummaryAck(v);
    }

    protected BacnetServicePrimitive processGetEventInformationRequest(GetEventInformationRequest request) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BEventHandler: GetEventInformationRequest received: " + request);
        }
        int maxResponseLength = request.getMaxDataLength();
        maxResponseLength -= 4;
        int lastObjectId = -1;
        BBacnetObjectIdentifier lastReceivedObjectId = request.getLastReceivedObjectId();
        if (lastReceivedObjectId != null) {
            lastObjectId = lastReceivedObjectId.hashCode();
        }
        Vector<NEventSummary> listOfEventSummaries = new Vector<NEventSummary>();
        int responseDataSize = 0;
        boolean moreEvents = false;
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier[] ids = (BBacnetObjectIdentifier[])this.getEventSummaries().getChildren(BBacnetObjectIdentifier.class);
        int len = ids.length;
        int ndx = 0;
        if (lastReceivedObjectId != null) {
            while (ndx < len && ids[ndx++].hashCode() != lastObjectId) {
            }
        }
        for (int i = ndx; i < len; ++i) {
            boolean toBeRemoved;
            BBacnetObjectIdentifier id = ids[i];
            BBacnetEventSource src = (BBacnetEventSource)local.lookupBacnetObject(id);
            boolean bl = toBeRemoved = src == null || src.getEventState() == null || !src.getEventDetectionEnable() || src.getEventState() == BBacnetEventState.normal && src.getAckedTransitions().equals((Object)BBacnetBitString.make(new boolean[]{true, true, true}));
            if (toBeRemoved) {
                this.getEventSummaries().remove(id.toString(nameContext));
                continue;
            }
            NEventSummary esum = new NEventSummary(id, src.getEventState(), src.getAckedTransitions(), src.getEventTimeStamps(), src.getNotifyType(), src.getEventEnable(), src.getEventPriorities());
            if (maxResponseLength > 0 && (responseDataSize += esum.getEncodedSize()) > maxResponseLength) {
                moreEvents = true;
                break;
            }
            listOfEventSummaries.add(esum);
        }
        return new GetEventInformationAck(listOfEventSummaries, moreEvents);
    }

    public void putRecordToEventBuffer(int eventStateOrdinal, BBacnetObjectIdentifier deviceId, BBacnetObjectIdentifier objectId, long processId, BAlarmRecord alarmRecord) {
        BString msgText = BString.make((String)alarmRecord.getFormattedAlarmDataValue("msgText", facetsContext));
        switch (eventStateOrdinal) {
            case 1: {
                alarmRecord.addAlarmFacet("toFaultMsgText", (BIDataValue)msgText);
                break;
            }
            case 0: {
                alarmRecord.addAlarmFacet("toNormalMsgText", (BIDataValue)msgText);
                break;
            }
            default: {
                alarmRecord.addAlarmFacet("toOffNormalMsgText", (BIDataValue)msgText);
            }
        }
        BHashedEventBuffer buffer = this.getEventBuffer(eventStateOrdinal);
        buffer.putRecord(deviceId, objectId, processId, alarmRecord);
    }

    public void removeAllRecordFromEventBuffer(BBacnetObjectIdentifier deviceId, BBacnetObjectIdentifier objectId, long processId) {
        BHashedEventBuffer buffer = this.getEventBuffer(1);
        buffer.removeRecord(deviceId, objectId, processId);
        buffer = this.getEventBuffer(2);
        buffer.removeRecord(deviceId, objectId, processId);
        buffer = this.getEventBuffer(0);
        buffer.removeRecord(deviceId, objectId, processId);
    }

    public BAlarmRecord getRecordFromEventBuffer(int eventStateOrdinal, BBacnetObjectIdentifier deviceId, BBacnetObjectIdentifier objectId, long processId, boolean removeFromBuffer) {
        return this.getRecordFromEventBuffer(eventStateOrdinal, deviceId, objectId, processId, null, removeFromBuffer);
    }

    public BAlarmRecord getRecordFromEventBuffer(int eventStateOrdinal, BBacnetObjectIdentifier deviceId, BBacnetObjectIdentifier objectId, long processId, BUuid uuid, boolean removeFromBuffer) {
        BHashedEventBuffer buffer = this.getEventBuffer(eventStateOrdinal);
        return buffer.getRecord(deviceId, objectId, processId, uuid, removeFromBuffer);
    }

    public boolean checkRecordByTimestamp(BAlarmRecord ackRequest) {
        BHashedEventBuffer buffer = this.getEventBuffer(ackRequest.getSourceState());
        return buffer.checkRecord(ackRequest);
    }

    public void addEventSummary(BBacnetObjectIdentifier objectId) {
        String name = objectId.toString(nameContext);
        if (this.getEventSummaries().get(name) == null) {
            this.getEventSummaries().add(name, (BValue)objectId, 1);
        }
    }

    public void removeEventSummary(BBacnetObjectIdentifier objectId) {
        try {
            this.getEventSummaries().remove(objectId.toString(nameContext));
        }
        catch (NoSuchSlotException noSuchSlotException) {
            // empty catch block
        }
    }

    public void processEventSummary(NEventSummary eventSummary, BBacnetObjectIdentifier deviceId) {
        try {
            BBacnetNetwork bacnet = BBacnetNetwork.bacnet();
            BBacnetDevice device = bacnet.doLookupDeviceById(deviceId);
            BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BBacnetObjectIdentifier objectId = eventSummary.getObjectId();
            BComponent localSource = this.findLocalAlarmSource(device, eventSummary);
            int eventStateOrdinal = eventSummary.getEventState().getOrdinal();
            BBacnetBitString ackedTransistions = eventSummary.getAcknowledgedTransitions();
            for (int i = 0; i < 3; ++i) {
                BSourceState alarmState;
                long processId = this.getProcessIdForEvent(deviceId, eventSummary);
                int transitionEventState = this.getEventStateFromTransition(i);
                BAlarmRecord dbRecord = null;
                if (transitionEventState == 0) {
                    dbRecord = this.getRecordFromEventBuffer(1, deviceId, objectId, processId, false);
                    if (dbRecord == null) {
                        dbRecord = this.getRecordFromEventBuffer(2, deviceId, objectId, processId, false);
                    }
                } else {
                    dbRecord = this.getRecordFromEventBuffer(transitionEventState, deviceId, objectId, processId, false);
                }
                if (!this.shouldBuildAlarm(eventSummary, i, dbRecord)) continue;
                BFacets alarmData = this.buildAlarmData(eventSummary, deviceId, i);
                BAlarmRecord record = null;
                if (transitionEventState == 0 && dbRecord != null && !dbRecord.isNormal()) {
                    record = dbRecord;
                    BSourceState fromState = dbRecord.getSourceState();
                    BBacnetTimeStamp time = eventSummary.getEventTimeStamps()[i];
                    record.addAlarmFacet("fromState", (BIDataValue)BString.make((String)fromState.getTag()));
                    record.addAlarmFacet("msgText", (BIDataValue)BString.make((String)"NORMAL"));
                    record.setNormalTime(time.toBAbsTime());
                } else {
                    record = new BAlarmRecord((BComponent)device.getAlarms(), device.getAlarms().getAlarmClass(), alarmData);
                }
                switch (eventStateOrdinal) {
                    case 1: {
                        alarmState = BSourceState.fault;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        alarmState = BSourceState.offnormal;
                        break;
                    }
                    default: {
                        alarmState = BSourceState.normal;
                    }
                }
                record.setSourceState(alarmState);
                BSourceState toState = alarmState;
                record.addAlarmFacet("toState", (BIDataValue)BString.make((String)toState.getTag()));
                BBacnetTimeStamp time = eventSummary.getEventTimeStamps()[i];
                record.setTimestamp(time.toBAbsTime());
                record.setPriority(eventSummary.getEventPriorities()[i]);
                if (!ackedTransistions.getBit(i)) {
                    record.addAlarmFacet("bacnetAcksRequired", (BIDataValue)BString.make((String)(toState.getTag() + "@" + time.toString(facetsContext))));
                }
                if (transitionEventState == 0 && dbRecord != null) {
                    record.addAlarmFacet("sourceName", (BIDataValue)BString.make((String)dbRecord.getSource().encodeToString()));
                } else {
                    this.addLocalSource(localSource, record);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Routing alarm from GetEventInfo:" + record);
                }
                this.putRecordToEventBuffer(eventStateOrdinal, deviceId, objectId, processId, record);
                as.routeAlarm(record);
            }
        }
        catch (ServiceNotFoundException e) {
            logger.log(Level.SEVERE, "BEventHandler.processEventSummary:Unable to find Alarm Service!", e);
        }
    }

    public void setTransportLayer(BBacnetTransportLayer transportLayer) {
        this.transportLayer = transportLayer;
    }

    @Override
    public BBacnetTransportLayer getTransportLayer() {
        return this.transportLayer;
    }

    protected NErrorType processEvent(EventNotificationParameters enp, boolean confirmed) {
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmDatabase db = as.getAlarmDb();
        BAlarmRecord record = null;
        BBacnetObjectIdentifier deviceId = enp.getInitiatingDeviceId();
        BBacnetObjectIdentifier objectId = enp.getEventObjectId();
        long processId = enp.getProcessId();
        BBacnetNetwork bacnet = BBacnetNetwork.bacnet();
        BBacnetDevice device = bacnet.doLookupDeviceById(deviceId);
        if (device == null) {
            logger.info("Bacnet alarm received from unknown device!  Ignoring...");
            return new NErrorType(1, 31);
        }
        device.getAlarms().setLastReceivedTime(BAbsTime.make());
        BControlPoint point = (BControlPoint)device.lookupBacnetObject(objectId, 85, -1, "point");
        BBacnetNotifyType notifyType = enp.getNotifyType();
        if (notifyType.getOrdinal() == 2) {
            record = this.processAckNotification(enp, device.getAlarms(), db);
        } else {
            record = this.processEventNotification(enp, device.getAlarms(), point);
            record.addAlarmFacet("confirmed", (BIDataValue)BBoolean.make((boolean)confirmed));
            this.putRecordToEventBuffer(enp.getToState().getOrdinal(), deviceId, objectId, processId, record);
        }
        if (record != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("processEvent...record:" + record + "\n data=" + record.getAlarmData());
            }
            this.addSourceAndRoute(record, point, device.getAlarms());
            this.checkForBufferReady(enp.getEventType().getOrdinal(), device, objectId);
            return null;
        }
        logger.info("Unable to generate or match alarm for routing: " + enp + "\n toState=" + enp.getToState() + ", notifyType=" + (Object)((Object)notifyType));
        return new NErrorType(5, 0);
    }

    protected BAlarmRecord processAckNotification(EventNotificationParameters params, BAlarmDeviceExt alarmDeviceExt, BAlarmDatabase db) {
        BAlarmRecord record = this.getRecordFromEventBuffer(params.getToState().getOrdinal(), params.getInitiatingDeviceId(), params.getEventObjectId(), params.getProcessId(), false);
        if (record != null) {
            this.ackNiagara(record, params.getToState());
        }
        BAlarmRecord[] otherUnacked = this.getOtherUnackeds(record);
        for (int i = 0; i < otherUnacked.length; ++i) {
            this.ackNiagara(otherUnacked[i], params.getToState());
            alarmDeviceExt.routeAlarm(otherUnacked[i]);
        }
        return record;
    }

    protected BAlarmRecord processEventNotification(EventNotificationParameters enp, BAlarmDeviceExt alarmDeviceExt, BControlPoint point) {
        BAlarmRecord record = null;
        BEnum toState = enp.getToState();
        if (BBacnetEventState.isNormal(toState)) {
            BEnum fromState = enp.getFromState();
            if (BBacnetEventState.isFault(fromState)) {
                record = this.getRecordFromEventBuffer(fromState.getOrdinal(), enp.getInitiatingDeviceId(), enp.getEventObjectId(), enp.getProcessId(), false);
            } else if (BBacnetEventState.isOffnormal(fromState)) {
                record = this.getRecordFromEventBuffer(fromState.getOrdinal(), enp.getInitiatingDeviceId(), enp.getEventObjectId(), enp.getProcessId(), false);
            }
        }
        if (record == null) {
            record = point != null ? new BAlarmRecord((BComponent)point.getProxyExt(), alarmDeviceExt.getAlarmClass(), this.buildAlarmData(enp), BUuid.make()) : new BAlarmRecord((BComponent)alarmDeviceExt, alarmDeviceExt.getAlarmClass(), this.buildAlarmData(enp), BUuid.make());
            record.setTimestamp(enp.getTimeStamp().toBAbsTime());
            record.setAckRequired(enp.getAckRequired());
        } else {
            if (BBacnetEventState.isNormal(toState)) {
                BAlarmRecord[] otherAlarms = this.getOtherNonNormals(record);
                this.updateAlarmsToNormal(otherAlarms, enp, point, alarmDeviceExt);
            }
            this.updateAlarm(record, enp);
        }
        this.setBacnetData(record, enp);
        return record;
    }

    protected long getProcessIdForEvent(BBacnetObjectIdentifier initiatingDeviceId, NEventSummary eventSummary) {
        long processId;
        block5: {
            processId = 0L;
            try {
                BBacnetAddress addr = DeviceRegistry.getDeviceAddress(initiatingDeviceId);
                int nc = AsnUtil.fromAsnUnsignedInt(this.comm().readProperty(addr, eventSummary.getObjectId(), 17));
                byte[] b = this.comm().readProperty(addr, BBacnetObjectIdentifier.make(15, nc), 102);
                AsnInputStream in = new AsnInputStream(b);
                BBacnetDestination dest = new BBacnetDestination();
                while (in.available() > 0) {
                    dest.readAsn(in);
                    BBacnetRecipient r = dest.getRecipient();
                    if (r.isAddress()) {
                        int destNet = r.getAddress().getNetworkNumber();
                        BBacnetNetworkLayer net = ((BBacnetStack)this.comm()).getNetwork();
                        BNetworkPort port = net.getPortByNetwork(destNet);
                        if (port == null) continue;
                        byte[] mac = port.getLink().getMacAddress();
                        if (!r.getAddress().equals(destNet, mac)) continue;
                        processId = dest.getProcessIdentifier().getLong();
                    } else {
                        if (!r.getDevice().equals((Object)BBacnetNetwork.localDevice().getObjectId())) continue;
                        processId = dest.getProcessIdentifier().getLong();
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block5;
                logger.log(Level.FINE, "Cannot determine processId for Event Summary:" + eventSummary + ":" + e + ";\n -- Using local processId...", e);
            }
        }
        return processId;
    }

    protected BComponent findLocalAlarmSource(BBacnetDevice device, NEventSummary eventSummary) {
        return (BControlPoint)device.lookupBacnetObject(eventSummary.getObjectId(), 85, -1, "point");
    }

    protected boolean shouldBuildAlarm(NEventSummary eventSummary, int eventTransitionIndex, BAlarmRecord dbRecord) {
        boolean enabled = eventSummary.getEventEnable().getBit(eventTransitionIndex);
        boolean acked = eventSummary.getAcknowledgedTransitions().getBit(eventTransitionIndex);
        if (!enabled || acked) {
            return false;
        }
        BBacnetTimeStamp esumTS = eventSummary.getEventTimeStamps()[eventTransitionIndex];
        if (this.isNull(esumTS)) {
            return false;
        }
        if (dbRecord == null) {
            return true;
        }
        BAbsTime recordTS = dbRecord.getTimestamp();
        if (eventTransitionIndex == 2) {
            recordTS = dbRecord.getNormalTime();
        }
        if (recordTS.equals((Object)BAbsTime.DEFAULT)) {
            return true;
        }
        return esumTS.toBAbsTime().isAfter(recordTS);
    }

    private boolean isNull(BBacnetTimeStamp ts) {
        switch (ts.getChoice()) {
            case 0: {
                return ts.getTime().isAnyUnspecified();
            }
            case 2: {
                return ts.getDateTime().isAnyUnspecified();
            }
        }
        return false;
    }

    private int getEventStateFromTransition(int eventTransition) {
        switch (eventTransition) {
            case 2: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    protected void addLocalSource(BComponent localSource, BAlarmRecord record) {
        if (localSource != null) {
            record.addAlarmFacet("sourceName", (BIDataValue)BString.make((String)localSource.getName()));
        }
    }

    protected final ErrorType validateAcknowledgement(AcknowledgeAlarmRequest ack, BAlarmRecord rec, BAlarmService as, BBacnetAddress sourceAddress, BBacnetEventSource export) {
        BEnum stateAckedEn = ack.getEventStateAcknowledged();
        int stateAcked = stateAckedEn.getOrdinal();
        if (rec == null) {
            return new NErrorType(5, 73);
        }
        if (BBacnetEventState.isOffnormal(stateAckedEn) && stateAcked != 2) {
            int offnormalToState = 2;
            BInteger offTof = (BInteger)rec.getAlarmFacet("offnormalToState");
            if (offTof != null) {
                offnormalToState = offTof.getInt();
            }
            if (stateAcked != offnormalToState) {
                return new NErrorType(5, 73);
            }
        }
        if (!BEventHandler.timesMatch(ack.getTimeStamp(), BEventHandler.getTimestamp(rec, stateAckedEn))) {
            return new NErrorType(5, 14);
        }
        return null;
    }

    protected static final BAbsTime getTimestamp(BAlarmRecord rec, BEnum stateAcked) {
        if (BBacnetEventState.isNormal(stateAcked)) {
            return rec.getNormalTime();
        }
        return rec.getTimestamp();
    }

    protected static final boolean timesMatch(BBacnetTimeStamp ts, BAbsTime t) {
        long m2;
        if (ts.getChoice() != 2) {
            return false;
        }
        BAbsTime tst = ts.toBAbsTime();
        int scale = 10;
        long m1 = tst.getMillis() / (long)scale;
        return m1 == (m2 = t.getMillis() / (long)scale);
    }

    protected void checkForBufferReady(int eventType, BBacnetDevice device, BBacnetObjectIdentifier objectId) {
        BBacnetHistoryImport[] pts;
        if (eventType == 10 && (pts = ((BBacnetHistoryDeviceExt)device.getTrendLogs()).findImportDescriptors(objectId)) != null) {
            for (int j = 0; j < pts.length; ++j) {
                pts[j].setBufferReady(true);
                pts[j].execute();
                pts[j].setBufferReady(false);
            }
        }
    }

    protected void updateAlarm(BAlarmRecord record, EventNotificationParameters enp) {
        String tsString = enp.getTimeStamp().toString(facetsContext);
        BEnum toState = enp.getToState();
        BEnum fromState = enp.getFromState();
        record.addAlarmFacet("toState", (BIDataValue)BString.make((String)toState.getTag()));
        record.addAlarmFacet("fromState", (BIDataValue)BString.make((String)fromState.getTag()));
        record.addAlarmFacet("BacnetTimestamp", (BIDataValue)BString.make((String)tsString));
        String s = enp.getMessageText();
        if (s != null && s.length() > 0) {
            record.addAlarmFacet("msgText", (BIDataValue)BString.make((String)s));
        }
        if (enp.getAckRequired()) {
            BString acksReq = (BString)record.getAlarmData().getFacet("bacnetAcksRequired");
            if (acksReq != null) {
                String acksReqStr = acksReq.getString();
                StringTokenizer st = new StringTokenizer(acksReqStr, ";");
                StringBuilder newAcksReqStr = new StringBuilder();
                boolean found = false;
                while (st.hasMoreTokens()) {
                    String state = st.nextToken();
                    if (state.startsWith(toState.getTag())) {
                        state = state.substring(0, state.indexOf("@") + 1) + tsString;
                        found = true;
                    }
                    newAcksReqStr.append(state).append(';');
                }
                acksReq = !found ? BString.make((String)newAcksReqStr.append(toState.getTag()).append('@').append(tsString).toString()) : BString.make((String)newAcksReqStr.substring(0, newAcksReqStr.length() - 1));
            } else {
                acksReq = BString.make((String)(toState.getTag() + "@" + tsString));
            }
            record.addAlarmFacet("bacnetAcksRequired", (BIDataValue)acksReq);
        } else if (enp.getToState() != BBacnetEventState.normal || record.getAckState() != BAckState.unacked) {
            record.setAckRequired(false);
        }
    }

    protected void setBacnetData(BAlarmRecord record, EventNotificationParameters enp) {
        BEnum toState = enp.getToState();
        switch (toState.getOrdinal()) {
            case 1: {
                record.setSourceState(BSourceState.fault);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                record.setSourceState(BSourceState.offnormal);
                break;
            }
            default: {
                record.setNormalTime(enp.getTimeStamp().toBAbsTime());
                record.setSourceState(BSourceState.normal);
            }
        }
        record.setPriority(enp.getPriority());
        if (enp.getAckRequired()) {
            record.setAckState(BAckState.unacked);
        }
    }

    private void ackNiagara(BAlarmRecord record, BEnum toState) {
        record.ackAlarm();
        record.setAckState(BAckState.acked);
        BObject acksReqFacet = record.getAlarmData().getFacet("bacnetAcksRequired");
        if (acksReqFacet == null) {
            return;
        }
        if (acksReqFacet instanceof BString) {
            String acksReq = ((BString)acksReqFacet).getString();
            int start = acksReq.indexOf(toState.getTag());
            if (start >= 0) {
                int end = acksReq.indexOf(";", start);
                if (end < 0) {
                    end = acksReq.length();
                }
                if ((acksReq = new StringBuilder(acksReq).delete(start, end).toString()).startsWith(";")) {
                    acksReq = acksReq.substring(1);
                }
                record.addAlarmFacet("bacnetAcksRequired", (BIDataValue)BString.make((String)acksReq));
            }
        } else if (acksReqFacet instanceof BInteger) {
            int acksReq = ((BInteger)acksReqFacet).getInt();
            if (BBacnetEventState.isOffnormal(toState)) {
                acksReq &= 0xFFFFFFFB;
            }
            if (BBacnetEventState.isFault(toState)) {
                acksReq &= 0xFFFFFFFD;
            }
            if (BBacnetEventState.isNormal(toState)) {
                acksReq &= 0xFFFFFFFE;
            }
            record.addAlarmFacet("bacnetAcksRequired", (BIDataValue)BInteger.make((int)acksReq));
        }
    }

    private BBacnetComm comm() {
        return BBacnetNetwork.bacnet().getBacnetComm();
    }

    static void dumpAlarm(BAlarmRecord r, boolean showFacets) {
        if (r == null) {
            return;
        }
        System.out.println("\n" + r);
        if (showFacets) {
            System.out.println("      Facets:" + r.getAlarmData());
        }
    }

    protected static int getAlarmTransitionBit(BEnum eventStateAcknowledged) {
        switch (eventStateAcknowledged.getOrdinal()) {
            case 0: {
                return 4;
            }
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    private BAlarmRecord[] getOtherUnackeds(BAlarmRecord record) {
        Array a;
        block27: {
            a = new Array(BAlarmRecord.class);
            try {
                BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                BAlarmDatabase alarmDb = as.getAlarmDb();
                BObject source = record.getSource().get(0).get((BObject)this);
                if (source instanceof BBacnetAlarmDeviceExt) break block27;
                try (AlarmDbConnection conn = alarmDb.getDbConnection(null);
                     Cursor c = conn.getAlarmsForSource(record.getSource());){
                    BUuid uuid = record.getUuid();
                    while (c.next()) {
                        BAlarmRecord rec = (BAlarmRecord)((BAlarmRecord)c.get()).asComplex().newCopy();
                        if (uuid.equals((Object)rec.getUuid()) || rec.getAckState() == BAckState.acked || !rec.getAlarmTransition().equals((Object)record.getAlarmTransition())) continue;
                        a.add((Object)rec);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred in getOtherUnackeds", e);
            }
        }
        return (BAlarmRecord[])a.trim();
    }

    private BAlarmRecord[] getOtherNonNormals(BAlarmRecord record) {
        Array a = new Array(BAlarmRecord.class);
        try {
            BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmDatabase alarmDb = as.getAlarmDb();
            try (AlarmDbConnection conn = alarmDb.getDbConnection(null);
                 Cursor c = conn.getAlarmsForSource(record.getSource());){
                BUuid uuid = record.getUuid();
                while (c.next()) {
                    BAlarmRecord rec = (BAlarmRecord)((BAlarmRecord)c.get()).asComplex().newCopy();
                    if (uuid.equals((Object)rec.getUuid()) || rec.isNormal()) continue;
                    a.add((Object)rec);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred in getOtherNonNormals", e);
        }
        return (BAlarmRecord[])a.trim();
    }

    private void updateAlarmsToNormal(BAlarmRecord[] records, EventNotificationParameters enp, BControlPoint point, BAlarmDeviceExt alarmDeviceExt) {
        for (int i = 0; i < records.length; ++i) {
            this.updateAlarm(records[i], enp);
            this.setBacnetData(records[i], enp);
            this.addSourceAndRoute(records[i], point, alarmDeviceExt);
        }
    }

    private void addSourceAndRoute(BAlarmRecord record, BControlPoint point, BAlarmDeviceExt alarmDeviceExt) {
        if (point != null) {
            record.addAlarmFacet("sourceName", (BIDataValue)BString.make((String)point.getName()));
        }
        alarmDeviceExt.routeAlarm(record);
    }

    protected static final int getNiagaraSourceState(int toState) {
        switch (toState) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    protected static final int getEventPriority(int transition, BBacnetEventSource eventSource) {
        int[] eventPriorities = eventSource.getEventPriorities();
        if (transition == 0) {
            return eventPriorities[2];
        }
        if (transition == 2) {
            return eventPriorities[1];
        }
        return eventPriorities[0];
    }

    private BHashedEventBuffer getEventBuffer(int eventStateOrdinal) {
        switch (eventStateOrdinal) {
            case 1: {
                return this.getToFaultBuffer();
            }
            case 0: {
                return this.getToNormalBuffer();
            }
        }
        return this.getToOffnormalBuffer();
    }

    private BHashedEventBuffer getEventBuffer(BSourceState sourceState) {
        switch (sourceState.getOrdinal()) {
            case 1: {
                return this.getToOffnormalBuffer();
            }
            case 2: {
                return this.getToFaultBuffer();
            }
            case 0: {
                return this.getToNormalBuffer();
            }
        }
        logger.severe("Unknown source state! " + sourceState);
        throw new IllegalArgumentException("Invalid source state:" + sourceState);
    }

    private BFacets buildAlarmData(EventNotificationParameters enp) {
        BacnetNotificationParameters eventValues;
        BEnum fromState;
        String s;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processId", BString.make((String)Long.toString(enp.getProcessId())));
        map.put("deviceId", BString.make((String)enp.getInitiatingDeviceId().toString(facetsContext)));
        map.put("objectId", BString.make((String)enp.getEventObjectId().toString(facetsContext)));
        map.put("NC", BString.make((String)Long.toString(enp.getNotificationClass())));
        map.put("eventType", BString.make((String)enp.getEventType().getTag()));
        map.put("notifyType", BString.make((String)enp.getNotifyType().getTag()));
        map.put("toState", BString.make((String)enp.getToState().getTag()));
        map.put("BacnetTimestamp", BString.make((String)enp.getTimeStamp().toString(facetsContext)));
        map.put("priority", BInteger.make((int)enp.getPriority()));
        if (enp.getAckRequired()) {
            map.put("bacnetAcksRequired", BString.make((String)(enp.getToState().getTag() + "@" + enp.getTimeStamp().toString(facetsContext))));
        }
        if ((s = enp.getMessageText()) != null && s.length() > 0) {
            map.put("msgText", BString.make((String)s));
        }
        if ((fromState = enp.getFromState()) != null) {
            map.put("fromState", BString.make((String)fromState.getTag()));
        }
        if ((eventValues = enp.getEventValues()) != null) {
            eventValues.addAlarmData(map);
        }
        return BFacets.make(map);
    }

    private BFacets buildAlarmData(NEventSummary esum, BBacnetObjectIdentifier deviceId, int transition) {
        HashMap<String, BString> map = new HashMap<String, BString>();
        map.put("processId", BString.make((String)String.valueOf(this.getEventSummaryProcessId())));
        map.put("deviceId", BString.make((String)deviceId.toString(facetsContext)));
        map.put("objectId", BString.make((String)esum.getObjectId().toString(facetsContext)));
        map.put("toState", BString.make((String)esum.getEventState().getTag()));
        map.put("BacnetTimestamp", BString.make((String)esum.getEventTimeStamps()[transition].toString(facetsContext)));
        map.put("notifyType", BString.make((String)esum.getNotifyType().getTag()));
        map.put("ackedTransitions", BString.make((String)esum.getAcknowledgedTransitions().toString(BacnetBitStringUtil.BacnetEventTransitionBits)));
        BBacnetTimeStamp[] eventTimeStamps = esum.getEventTimeStamps();
        map.put("eventTimeStamps", BString.make((String)(eventTimeStamps[0].toString(facetsContext) + "," + eventTimeStamps[1].toString(facetsContext) + "," + eventTimeStamps[2].toString(facetsContext))));
        map.put("eventEnable", BString.make((String)esum.getEventEnable().toString(BacnetBitStringUtil.BacnetEventTransitionBits)));
        int[] eventPriorities = esum.getEventPriorities();
        map.put("eventPriorities", BString.make((String)("" + eventPriorities[0] + "," + eventPriorities[1] + "," + eventPriorities[2])));
        return BFacets.make(map);
    }

    void addListener(EventNotificationListener listener, int serviceIndex) {
        switch (serviceIndex) {
            case 2: {
                this.confirmedEventListeners.add(listener);
                break;
            }
            case 29: {
                this.unconfirmedEventListeners.add(listener);
                break;
            }
        }
    }

    void removeListener(EventNotificationListener listener, int serviceIndex) {
        try {
            switch (serviceIndex) {
                case 2: {
                    this.confirmedEventListeners.remove(listener);
                    break;
                }
                case 29: {
                    this.unconfirmedEventListeners.remove(listener);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void routeToConfirmedListeners(ConfirmedEventNotificationRequest request, BBacnetAddress sourceAddress) {
        int len = this.confirmedEventListeners.size();
        if (len == 0) {
            return;
        }
        EventNotificationParameters enp = request.getEventNotificationParameters();
        for (int i = 0; i < len; ++i) {
            this.confirmedEventListeners.get(i).receiveConfirmedEventNotification(sourceAddress, enp.getProcessId(), enp.getInitiatingDeviceId(), enp.getEventObjectId(), enp.getTimeStamp(), enp.getNotificationClass(), enp.getPriority(), enp.getEventType(), enp.getMessageText(), enp.getNotifyType(), enp.getAckRequired(), enp.getFromState(), enp.getToState(), enp.getRawEventValues(), enp.getEncoding());
        }
    }

    private void routeToUnconfirmedListeners(UnconfirmedEventNotificationRequest request, BBacnetAddress sourceAddress) {
        int len = this.unconfirmedEventListeners.size();
        if (len == 0) {
            return;
        }
        EventNotificationParameters enp = request.getEventNotificationParameters();
        for (int i = 0; i < len; ++i) {
            this.unconfirmedEventListeners.get(i).receiveUnconfirmedEventNotification(sourceAddress, enp.getProcessId(), enp.getInitiatingDeviceId(), enp.getEventObjectId(), enp.getTimeStamp(), enp.getNotificationClass(), enp.getPriority(), enp.getEventType(), enp.getMessageText(), enp.getNotifyType(), enp.getAckRequired(), enp.getFromState(), enp.getToState(), enp.getRawEventValues(), enp.getEncoding());
        }
    }
}

