/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.BacnetQuery;
import com.tridium.bacnet.datatypes.BNextInstArgs;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.server.BIBacnetExportFolder;
import com.tridium.util.ComponentTreeCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BOutOfServiceExt;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetExportTable
extends BComponent
implements BIBacnetExportFolder {
    public static final Action getObjectOrdById = BBacnetExportTable.newAction((int)4, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Action getNextInst = BBacnetExportTable.newAction((int)4, (BValue)new BNextInstArgs(), null);
    public static final Action reorderOutOfServiceExt = BBacnetExportTable.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BBacnetExportTable.class);
    private static final Logger logger = Logger.getLogger("bacnet.server");
    ServerObjectComparator comparator = new ServerObjectComparator();
    private final ConcurrentHashMap<BBacnetObjectIdentifier, BIBacnetExportObject> exportsByObjectId = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, BIBacnetExportObject> exportsByObjectName = new ConcurrentHashMap();
    private final ArrayList<BBacnetObjectIdentifier> objectList = new ArrayList();
    private final Object OBJECTS_BY_ORD_MONITOR = new Object();
    private final HashSet<BBacnetObjectIdentifier> objectsIdExportedByOrd = new HashSet();
    private final HashMap<BOrd, BBacnetObjectIdentifier> objectIdsByOrd = new HashMap();

    public BOrd getObjectOrdById(BBacnetObjectIdentifier objectId) {
        return (BOrd)this.invoke(getObjectOrdById, (BValue)objectId, null);
    }

    public BInteger getNextInst(BNextInstArgs arg) {
        return (BInteger)this.invoke(getNextInst, (BValue)arg, null);
    }

    public void reorderOutOfServiceExt() {
        this.invoke(reorderOutOfServiceExt, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BOrd doGetObjectOrdById(BBacnetObjectIdentifier objectId) {
        BIBacnetExportObject e = this.byObjectId(objectId);
        if (e == null) {
            return BOrd.DEFAULT;
        }
        return ((BComponent)e).getOrdInSpace();
    }

    public void doReorderOutOfServiceExt() {
        BComponent networkComp;
        BComponent parent = this.getParent().asComponent();
        if (parent != null && parent instanceof BLocalBacnetDevice && (networkComp = parent.getParent().asComponent()) != null && networkComp instanceof BBacnetNetwork) {
            BBacnetNetwork network = (BBacnetNetwork)networkComp;
            network.getWorker().post(new Runnable(){

                @Override
                public void run() {
                    SlotCursor sc = BBacnetExportTable.this.getSlots();
                    while (sc.next(BBacnetPointDescriptor.class)) {
                        BValue value = sc.get();
                        if (!(value instanceof BBacnetPointDescriptor)) continue;
                        BBacnetPointDescriptor pd = (BBacnetPointDescriptor)value;
                        BBacnetExportTable.this.reorderOutOfServiceExt(pd);
                    }
                }
            });
        }
    }

    private void reorderOutOfServiceExt(BBacnetPointDescriptor export) {
        Property[] props;
        BControlPoint point = export.getPoint();
        if (point != null && (props = point.getDynamicPropertiesArray()) != null) {
            for (int i = 0; i < props.length; ++i) {
                if (!props[i].getType().equals(BOutOfServiceExt.TYPE)) continue;
                point.reorderToTop(props[i]);
                break;
            }
        }
    }

    public String toString(Context cx) {
        return "ExportTable:" + this.getSize();
    }

    @Override
    public BBacnetExportTable getExports() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String export(BIBacnetExportObject object) {
        BIBacnetExportObject dup;
        BBacnetObjectIdentifier objectId = object.getObjectId();
        String objectName = object.getObjectName();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("export:" + object + " id=" + (Object)((Object)objectId) + " name=" + objectName + " ord=" + object.getObjectOrd());
        }
        if ((dup = this.exportsByObjectId.get((Object)objectId)) != null && dup != object) {
            return "Duplicate Object ID";
        }
        dup = this.exportsByObjectName.get(objectName);
        if (dup != null && dup != object) {
            return "Duplicate Object Name";
        }
        if (dup == null) {
            this.exportsByObjectId.put(objectId, object);
            this.exportsByObjectName.put(objectName, object);
            this.objectList.add(objectId);
            Object object2 = this.OBJECTS_BY_ORD_MONITOR;
            synchronized (object2) {
                if (this.objectsIdExportedByOrd.contains((Object)objectId)) {
                    this.objectIdsByOrd.values().remove((Object)objectId);
                }
                this.objectsIdExportedByOrd.add(objectId);
                this.objectIdsByOrd.put(object.getObjectOrd(), objectId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportByOrd(BIBacnetExportObject object) {
        BBacnetObjectIdentifier objectId = object.getObjectId();
        if (objectId != null) {
            Object object2 = this.OBJECTS_BY_ORD_MONITOR;
            synchronized (object2) {
                if (this.objectsIdExportedByOrd.contains((Object)objectId)) {
                    this.objectIdsByOrd.values().remove((Object)objectId);
                }
                this.objectsIdExportedByOrd.add(objectId);
                this.objectIdsByOrd.put(object.getObjectOrd(), objectId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unexport(BBacnetObjectIdentifier objectId, String objectName, BIBacnetExportObject object) {
        BIBacnetExportObject idDup = this.exportsByObjectId.get((Object)objectId);
        BIBacnetExportObject nameDup = this.exportsByObjectName.get(objectName);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("unexport:" + object + " id=" + (Object)((Object)objectId) + " name=" + objectName + " ord=" + object.getObjectOrd() + "\n  idDup=" + idDup + "  nameDup=" + nameDup);
        }
        if (idDup == object) {
            this.exportsByObjectId.remove((Object)objectId);
            this.objectList.remove((Object)objectId);
        }
        if (nameDup == object) {
            this.exportsByObjectName.remove(objectName);
        }
        Object object2 = this.OBJECTS_BY_ORD_MONITOR;
        synchronized (object2) {
            if (this.objectsIdExportedByOrd.contains((Object)objectId)) {
                this.objectsIdExportedByOrd.remove((Object)objectId);
                this.objectIdsByOrd.values().remove((Object)objectId);
            }
        }
        ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getServer().getEventHandler().removeEventSummary(objectId);
    }

    public BIBacnetExportObject byObjectId(BBacnetObjectIdentifier objectId) {
        BIBacnetExportObject e = this.exportsByObjectId.get((Object)objectId);
        if (e == null) {
            return null;
        }
        return e.isFatalFault() ? null : e;
    }

    public BIBacnetExportObject byObjectName(String objectName) {
        BIBacnetExportObject e = this.exportsByObjectName.get(objectName);
        if (e == null) {
            return null;
        }
        return e.isFatalFault() ? null : e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BBacnetObjectIdentifier byObjectOrd(BOrd ord) {
        if (ord == null || ord.equals((Object)BOrd.NULL)) {
            return null;
        }
        BOrd objectOrd = ord.relativizeToSession();
        OrdQuery[] oqs = objectOrd.parse();
        String scheme = oqs[0].getScheme();
        if (scheme.equals("station")) {
            objectOrd = BOrd.make((OrdQuery[])oqs, (int)1, (int)oqs.length);
        } else if (scheme.equals("bac")) {
            try {
                BBacnetObjectIdentifier id = (BBacnetObjectIdentifier)BBacnetObjectIdentifier.DEFAULT.decodeFromString(((BacnetQuery)oqs[0]).getObject());
                return id;
            }
            catch (Exception e) {
                logger.severe("Error decoding BACnet Ord:" + objectOrd + ": oq=" + oqs[0]);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Stack Trace: ", e);
                }
                return null;
            }
        }
        BBacnetObjectIdentifier objectId = null;
        Object object = this.OBJECTS_BY_ORD_MONITOR;
        synchronized (object) {
            objectId = this.objectIdsByOrd.get(objectOrd);
            if (objectId == null && scheme.equals("slot")) {
                BOrd handleOrd = ord.resolve((BObject)Sys.getStation()).get().asComponent().getHandleOrd();
                objectId = this.objectIdsByOrd.get(handleOrd);
            }
            if (objectId == null && scheme.equals("h")) {
                BOrd slotPathOrd = ord.resolve((BObject)Sys.getStation()).get().asComponent().getSlotPathOrd();
                objectId = this.objectIdsByOrd.get(slotPathOrd);
            }
        }
        return objectId;
    }

    public void writeObjectIds(AsnOutput out) {
        Iterator<BBacnetObjectIdentifier> ids = this.objectList.iterator();
        while (ids.hasNext()) {
            out.writeObjectIdentifier(ids.next());
        }
    }

    public BBacnetObjectIdentifier[] getObjectIds() {
        return this.objectList.toArray(new BBacnetObjectIdentifier[0]);
    }

    public BBacnetObjectIdentifier getEntry(int index) {
        return this.objectList.get(index);
    }

    public int getSize() {
        return this.objectList.size();
    }

    public BIBacnetExportObject[] getExportedObjects(Type t) {
        if (!t.is(BIBacnetExportObject.TYPE)) {
            return null;
        }
        Class c = t.getTypeClass();
        Array ret = new Array(BIBacnetExportObject.class);
        Enumeration<BIBacnetExportObject> e = this.exportsByObjectId.elements();
        while (e.hasMoreElements()) {
            BIBacnetExportObject o = e.nextElement();
            if (!c.isInstance(o) || o.isFatalFault()) continue;
            ret.add((Object)o);
        }
        return (BIBacnetExportObject[])ret.trim();
    }

    public BInteger doGetNextInst(BNextInstArgs arg) {
        return BInteger.make((int)this.getNextInstance(arg.getObjectType(), arg.getSiblings().getOrdinals()));
    }

    public int getNextInstance(int objectType) {
        return this.getNextInstance(objectType, new int[0]);
    }

    public int getNextInstance(int objectType, int[] siblings) {
        ComponentTreeCursor c = new ComponentTreeCursor((BComponent)this, null);
        int count = 0;
        while (c.next(BIBacnetExportObject.class)) {
            if (((BIBacnetExportObject)c.get()).getObjectId().getObjectType() != objectType) continue;
            ++count;
        }
        int[] list = new int[siblings.length + count];
        System.arraycopy(siblings, 0, list, 0, siblings.length);
        c.reset();
        count = siblings.length;
        while (c.next(BIBacnetExportObject.class)) {
            BIBacnetExportObject obj = (BIBacnetExportObject)c.get();
            if (obj.getObjectId().getObjectType() != objectType) continue;
            list[count++] = obj.getObjectId().getInstanceNumber();
        }
        Arrays.sort(list);
        int next = 0;
        for (int i = 0; i < list.length; ++i) {
            if (list[i] > next) {
                return next;
            }
            if (list[i] != next) continue;
            ++next;
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetExportTable", 2);
        out.prop((Object)"Exports By Object Id", (Object)"");
        Enumeration<BBacnetObjectIdentifier> ebboi = this.exportsByObjectId.keys();
        while (ebboi.hasMoreElements()) {
            BBacnetObjectIdentifier id = ebboi.nextElement();
            out.prop((Object)("  " + (Object)((Object)id)), (Object)this.exportsByObjectId.get((Object)id));
        }
        out.prop((Object)"Exports By Object Name", (Object)"");
        Enumeration<String> es = this.exportsByObjectName.keys();
        while (es.hasMoreElements()) {
            String n = es.nextElement();
            out.prop((Object)("  " + n), (Object)this.exportsByObjectName.get(n));
        }
        out.prop((Object)"ObjectList", (Object)"[] is external index");
        int len = this.objectList.size();
        for (int i = 0; i < len; ++i) {
            out.prop((Object)("  " + i + " [" + (i + 2) + "]"), (Object)this.objectList.get(i));
        }
        out.prop((Object)"ObjectIDs By Object Ord", (Object)"");
        Object object = this.OBJECTS_BY_ORD_MONITOR;
        synchronized (object) {
            for (BOrd o : this.objectIdsByOrd.keySet()) {
                out.prop((Object)("  " + o), (Object)this.objectIdsByOrd.get(o));
            }
        }
        out.endProps();
    }

    static class ServerObjectComparator
    implements Comparator<Object> {
        ServerObjectComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            BIBacnetExportObject obj1 = (BIBacnetExportObject)o1;
            BIBacnetExportObject obj2 = (BIBacnetExportObject)o2;
            long id1 = obj1.getObjectId().hashCode();
            long id2 = obj2.getObjectId().hashCode();
            return (int)(id1 - id2);
        }
    }
}

