/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack;

import java.io.ByteArrayInputStream;

public class BacnetInputStream
extends ByteArrayInputStream {
    public static final int STREAM_POOL_SIZE = 20;
    private boolean freeBuf = false;
    private static int cnt = 0;
    public BacnetInputStream next = null;
    private static BacnetInputStream[] pool = new BacnetInputStream[20];

    private BacnetInputStream() {
        super(new byte[0]);
    }

    public BacnetInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
    }

    public void setBuffer(byte[] buffer) {
        this.buf = buffer;
        this.mark = 0;
        this.pos = 0;
        this.count = this.buf.length;
    }

    @Override
    public int read(byte[] array) {
        return this.read(array, 0, array.length);
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int newPos) {
        this.pos = this.mark = newPos;
    }

    public BacnetInputStream copy() {
        byte[] clone = (byte[])this.buf.clone();
        return new BacnetInputStream(clone, 0, clone.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BacnetInputStream make() {
        BacnetInputStream[] bacnetInputStreamArray = pool;
        synchronized (pool) {
            BacnetInputStream strm = cnt > 0 && cnt <= 20 ? pool[--cnt] : new BacnetInputStream();
            strm.freeBuf = false;
            // ** MonitorExit[var1] (shouldn't be in output)
            return strm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BacnetInputStream make(byte[] buf, int offset, int length) {
        BacnetInputStream[] bacnetInputStreamArray = pool;
        synchronized (pool) {
            BacnetInputStream strm;
            if (cnt > 0 && cnt <= 20) {
                strm = pool[--cnt];
                strm.pos = offset;
                strm.mark = offset;
                strm.buf = buf;
                strm.count = length;
            } else {
                strm = new BacnetInputStream(buf, offset, length);
            }
            strm.freeBuf = false;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return strm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        BacnetInputStream[] bacnetInputStreamArray = pool;
        synchronized (pool) {
            BacnetInputStream strm = this;
            while (strm != null) {
                if (strm.freeBuf) continue;
                if (cnt < pool.length) {
                    BacnetInputStream.pool[BacnetInputStream.cnt++] = strm;
                }
                strm.freeBuf = true;
                strm = strm.next;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

