/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.schedule;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BBacnetScheduleTypeChangeJob;
import com.tridium.bacnet.schedule.BBacnetChangeTypeParm;
import com.tridium.bacnet.schedule.BBacnetScheduleDeviceExt;
import com.tridium.bacnet.schedule.ScheduleSupport0;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.driver.schedule.BScheduleDeviceExt;
import javax.baja.driver.schedule.BScheduleExport;
import javax.baja.driver.util.BDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.schedule.BCustomSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

public class BBacnetScheduleExport
extends BScheduleExport {
    public static final Property supervisorId = BBacnetScheduleExport.newProperty((int)5, (String)"", null);
    public static final Property subordinateVersion = BBacnetScheduleExport.newProperty((int)5, (BValue)BAbsTime.NULL, null);
    private static final BEnumRange ENUM_DATA_TYPE_RANGE = BEnumRange.make((String[])new String[]{AsnUtil.getAsnTypeName(2), AsnUtil.getAsnTypeName(9), AsnUtil.getAsnTypeName(3)});
    public static final Property supervisorOrd = BBacnetScheduleExport.newProperty((int)0, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"targetType", (String)"schedule:AbstractSchedule"));
    public static final Property objectId = BBacnetScheduleExport.newProperty((int)0, (BValue)BBacnetObjectIdentifier.make(17), (BFacets)ScheduleSupport0.SCHEDULE_CALENDAR_OBJECT_ID_FACETS);
    public static final Property dataType = BBacnetScheduleExport.newProperty((int)1, (String)"", null);
    public static final Property priorityForWriting = BBacnetScheduleExport.newProperty((int)0, (int)16, (BFacets)BFacets.makeInt((int)1, (int)16));
    public static final Property skipWrites = BBacnetScheduleExport.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Property writeEnumAs = BBacnetScheduleExport.newProperty((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)ENUM_DATA_TYPE_RANGE), null);
    public static final Property outOfService = BBacnetScheduleExport.newProperty((int)0, (boolean)false, null);
    public static final Action readFromDevice = BBacnetScheduleExport.newAction((int)16, null);
    public static final Action readChangeTypeParams = BBacnetScheduleExport.newAction((int)4, null);
    public static final Action changeType = BBacnetScheduleExport.newAction((int)4, (BValue)new BBacnetChangeTypeParm(), null);
    public static final Type TYPE = Sys.loadType(BBacnetScheduleExport.class);
    private int asnType = -1;
    BEnum writeProperty = null;
    private static final Lexicon lex = Lexicon.make((String)"bacnet");
    private static final Logger logger = Logger.getLogger("bacnet.schedule");

    public BOrd getSupervisorOrd() {
        return (BOrd)this.get(supervisorOrd);
    }

    public void setSupervisorOrd(BOrd v) {
        this.set(supervisorOrd, (BValue)v, null);
    }

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    public String getDataType() {
        return this.getString(dataType);
    }

    public void setDataType(String v) {
        this.setString(dataType, v, null);
    }

    public int getPriorityForWriting() {
        return this.getInt(priorityForWriting);
    }

    public void setPriorityForWriting(int v) {
        this.setInt(priorityForWriting, v, null);
    }

    public BFacets getSkipWrites() {
        return (BFacets)this.get(skipWrites);
    }

    public void setSkipWrites(BFacets v) {
        this.set(skipWrites, (BValue)v, null);
    }

    public BEnum getWriteEnumAs() {
        return (BEnum)this.get(writeEnumAs);
    }

    public void setWriteEnumAs(BEnum v) {
        this.set(writeEnumAs, (BValue)v, null);
    }

    public boolean getOutOfService() {
        return this.getBoolean(outOfService);
    }

    public void setOutOfService(boolean v) {
        this.setBoolean(outOfService, v, null);
    }

    public void readFromDevice() {
        this.invoke(readFromDevice, null, null);
    }

    public BBacnetChangeTypeParm readChangeTypeParams() {
        return (BBacnetChangeTypeParm)this.invoke(readChangeTypeParams, null, null);
    }

    public BOrd changeType(BBacnetChangeTypeParm param) {
        return (BOrd)this.invoke(changeType, (BValue)param, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBacnetScheduleExport() {
    }

    public BBacnetScheduleExport(String sid) {
        this.setSupervisorId(sid);
    }

    public void started() throws Exception {
        super.started();
        this.setAsnType();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (p.equals(supervisorOrd)) {
            this.setSupervisorId(this.getSupervisorOrd().toString());
            this.setDataType("");
        }
        if (p.equals(dataType)) {
            this.setAsnType();
        }
    }

    public String toString(Context cx) {
        return "BacnetScheduleExport_" + this.getObjectId().toString(cx);
    }

    public BAbstractSchedule getSupervisor() {
        BAbstractSchedule sch = null;
        try {
            sch = (BAbstractSchedule)this.getSupervisorOrd().resolve((BObject)this).get();
        }
        catch (Exception x) {
            throw new BajaRuntimeException(this.getSupervisorId(), (Throwable)x);
        }
        if (sch == null) {
            throw new IllegalArgumentException("Cannot resolve: " + this.getSupervisorId());
        }
        return sch;
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action == BDescriptor.execute) {
            if (this.isDisabled()) {
                return null;
            }
            if (this.getState() != BDescriptorState.idle) {
                return null;
            }
            if (this.getSupervisorOrd().equals((Object)BOrd.DEFAULT)) {
                return null;
            }
            if (objectId.isEquivalentToDefaultValue((BValue)this.getObjectId())) {
                return null;
            }
            if (BScheduleDeviceExt.getVersionOf((BAbstractSchedule)this.getSupervisor()).equals((Object)this.getSubordinateVersion())) {
                return null;
            }
            this.setLastAttempt(Clock.time());
            this.setState(BDescriptorState.pending);
            try {
                return this.postExecute(action, arg, cx);
            }
            catch (Exception e) {
                this.executeFail(e);
                return null;
            }
        }
        if (action == readFromDevice) {
            return BBacnetNetwork.bacnet().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return super.post(action, arg, cx);
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        return BBacnetNetwork.bacnet().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
    }

    public void doExecute() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BBacnetScheduleExport.doExecute on " + (Object)((Object)this));
        }
        BBacnetScheduleDeviceExt deviceExt = (BBacnetScheduleDeviceExt)this.getDeviceExt();
        this.executeInProgress();
        try {
            this.validateSchedule();
            deviceExt.writeRemote(this);
            this.setSubordinateVersion(BAbsTime.now());
            this.executeOk();
            this.getDevice().pingOk();
        }
        catch (BacnetException e1) {
            logger.log(Level.WARNING, "BacnetException writing supervisor schedule data for " + this.getSupervisor().getName() + " to " + (Object)((Object)this.getObjectId()) + " in " + this.getDevice() + ": " + (Object)((Object)e1), (Throwable)((Object)e1));
            this.executeFail((this.writeProperty != null ? this.writeProperty.getTag() : "null") + "::" + e1.toString());
        }
        catch (Exception e2) {
            logger.log(Level.WARNING, "Exception writing supervisor schedule data for " + this.getSupervisor().getName() + " to " + (Object)((Object)this.getObjectId()) + " in " + this.getDevice() + ": " + e2, e2);
            this.executeFail(e2);
        }
        finally {
            this.setState(BDescriptorState.idle);
        }
    }

    public void doReadFromDevice() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BBacnetScheduleExport.doReadFromDevice on " + (Object)((Object)this));
        }
        try {
            this.getSupervisor();
        }
        catch (Exception e) {
            this.executeFail(e);
        }
        BBacnetScheduleDeviceExt deviceExt = (BBacnetScheduleDeviceExt)this.getDeviceExt();
        try {
            BAbstractSchedule ret = deviceExt.readRemote(this);
            if (ret != null) {
                this.importRemoteSubordinate((BControlSchedule)ret);
            }
            this.getDevice().pingOk();
        }
        catch (BacnetException e1) {
            logger.log(Level.SEVERE, "BacnetException reading remote subordinate schedule data for " + this.getSupervisor().getName() + " from " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e1), (Throwable)((Object)e1));
            this.executeFail((Throwable)((Object)e1));
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Exception reading remote subordinate schedule data for " + this.getSupervisor().getName() + " from " + (Object)((Object)this.getObjectId()) + ": " + e2, e2);
            this.executeFail(e2);
        }
    }

    public BOrd doChangeType(BBacnetChangeTypeParm param) {
        return new BBacnetScheduleTypeChangeJob(BBacnetNetwork.bacnet(), this, param).submit(null);
    }

    private void setAsnType() {
        if (this.getDataType() == "" || this.getDataType().equals(lex.getText("asn.unknown"))) {
            this.setDataTypeFromSupervisor();
        }
        this.asnType = AsnUtil.getAsnType(this.getDataType());
    }

    private void setDataTypeFromSupervisor() {
        try {
            Type t = this.getSupervisor().getType();
            if (t.is(BBooleanSchedule.TYPE)) {
                this.setDataType(AsnUtil.getAsnTypeName(1));
                this.setFlags((Slot)writeEnumAs, this.getFlags((Slot)writeEnumAs) | 4);
            } else if (t.is(BNumericSchedule.TYPE)) {
                this.setDataType(AsnUtil.getAsnTypeName(4));
                this.setFlags((Slot)writeEnumAs, this.getFlags((Slot)writeEnumAs) | 4);
            } else if (t.is(BEnumSchedule.TYPE)) {
                this.setDataType(AsnUtil.getAsnTypeName(2));
                this.setFlags((Slot)writeEnumAs, this.getFlags((Slot)writeEnumAs) & 0xFFFFFFFB);
            } else {
                this.setDataType(AsnUtil.getAsnTypeName(7));
                this.setFlags((Slot)writeEnumAs, this.getFlags((Slot)writeEnumAs) | 4);
            }
        }
        catch (Exception e) {
            logger.info("Cannot determine ASN type for schedule export " + (Object)((Object)this) + ":invalid supervisor ord [" + this.getSupervisorOrd() + "]");
        }
    }

    public int getAsnType() {
        Type t = this.getSupervisor().getType();
        if (t.is(BEnumSchedule.TYPE)) {
            switch (this.getWriteEnumAs().getOrdinal()) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 9;
                }
                case 2: {
                    return 3;
                }
            }
        }
        return this.asnType;
    }

    public void importRemoteSubordinate(BControlSchedule remoteSubordinate) {
        BControlSchedule localSupervisor = (BControlSchedule)this.getSupervisor();
        if (!localSupervisor.getClass().equals(remoteSubordinate.getClass())) {
            throw new IllegalStateException("Incompatible Schedules: Import [" + remoteSubordinate.getClass().getName() + "] != " + localSupervisor.toPathString() + " [" + localSupervisor.getClass().getName() + "]");
        }
        boolean cleanup = localSupervisor.getCleanupExpiredEvents();
        remoteSubordinate.setCleanupExpiredEvents(cleanup);
        BFacets existingFacets = localSupervisor.getFacets();
        BBacnetScheduleExport.copyOver((BAbstractSchedule)remoteSubordinate, (BAbstractSchedule)localSupervisor);
        localSupervisor.setFacets(existingFacets);
    }

    protected static void copyOver(BAbstractSchedule source, BAbstractSchedule target) {
        target.copyFrom(source, null);
        target.set("lastModified", (BValue)BScheduleDeviceExt.getVersionOf((BAbstractSchedule)source));
    }

    protected void validateSchedule() {
        BAbstractSchedule as = this.getSupervisor();
        if (as instanceof BWeeklySchedule) {
            BWeeklySchedule ws = (BWeeklySchedule)as;
            BDailySchedule[] kids = ws.getSpecialEventsChildren();
            for (int i = 0; i < kids.length; ++i) {
                BDailySchedule daily = kids[i];
                if (daily.getDays() instanceof BCustomSchedule) {
                    throw new IllegalStateException("Cannot send CustomSchedule Special Events to BACnet");
                }
                BDaySchedule day = daily.getDay();
                SlotCursor sc = day.getProperties();
                while (sc.next(BTimeSchedule.class)) {
                    BTimeSchedule ts = (BTimeSchedule)sc.get();
                    if (!ts.getEffectiveValue().getStatus().isNull()) continue;
                    throw new IllegalStateException("Cannot write NULL-valued TimeSchedules to BACnet");
                }
            }
        }
    }

    public BBacnetChangeTypeParm doReadChangeTypeParams() {
        BBacnetScheduleDeviceExt deviceExt = (BBacnetScheduleDeviceExt)this.getDeviceExt();
        BBacnetDevice dev = deviceExt.device();
        BBacnetChangeTypeParm ctp = new BBacnetChangeTypeParm();
        ctp.setDataType(this.getDataType());
        ctp.setSupervisorOrd(this.getSupervisorOrd());
        try {
            BBacnetAddress adr = dev.getAddress();
            BBacnetObjectIdentifier oid = this.getObjectId();
            BBacnetClientLayer cl = deviceExt.client();
            AsnInputStream asnIn = new AsnInputStream();
            byte[] encodedValue = cl.readProperty(adr, oid, 174);
            asnIn.setBuffer(encodedValue);
            ctp.getScheduleDefault().readAsn(asnIn);
            encodedValue = cl.readProperty(adr, oid, 54);
            asnIn.setBuffer(encodedValue);
            ctp.getListOfObjectPropertyRefs().readAsn(asnIn);
            try {
                encodedValue = cl.readProperty(adr, oid, 123);
                asnIn.setBuffer(encodedValue);
                ctp.getWeeklySchedule().readAsn(asnIn);
                ctp.setHasWeeklySchedule(true);
            }
            catch (ErrorException e) {
                ctp.setHasWeeklySchedule(false);
            }
            try {
                encodedValue = cl.readProperty(adr, oid, 38);
                asnIn.setBuffer(encodedValue);
                ctp.getExceptionSchedule().readAsn(asnIn);
                ctp.setHasExceptionSchedule(true);
            }
            catch (ErrorException e) {
                ctp.setHasExceptionSchedule(false);
            }
            return ctp;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "doReadChangeTypeParams failed with exception", e);
            return null;
        }
    }
}

