/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.job;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.history.BBacnetHistoryDeviceExt;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import com.tridium.bacnet.job.BBacnetDiscoverJob;
import com.tridium.bacnet.job.BDiscoveryLog;
import java.util.logging.Level;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.driver.BDeviceExt;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class BBacnetDiscoverTrendLogsJob
extends BBacnetDiscoverJob {
    public static final Type TYPE = Sys.loadType(BBacnetDiscoverTrendLogsJob.class);
    private static final Lexicon lex = Lexicon.make((String)"bacnet");
    private static final String HISTORY_TYPE_UNKNOWN = lex.getText("historyType.unknown");

    @Override
    public Type getType() {
        return TYPE;
    }

    public BBacnetDiscoverTrendLogsJob() {
    }

    public BBacnetDiscoverTrendLogsJob(BBacnetHistoryDeviceExt deviceExt) {
        super((BDeviceExt)deviceExt);
    }

    @Override
    protected boolean doForId(BBacnetObjectIdentifier objectId) {
        return objectId.getObjectType() == 20 || objectId.getObjectType() == 27;
    }

    @Override
    int[] getDiscoveryPropIds(BBacnetObjectIdentifier objectId) {
        return new int[]{132, 28};
    }

    @Override
    void addDiscoveryChild(BBacnetDiscoverJob.IdVals iv) {
        String ht = this.findHistoryType(iv);
        BDiscoveryLog dl = new BDiscoveryLog(iv.name, iv.id, ht);
        BBacnetDiscoverJob.PropVal desc = iv.get(28);
        if (desc != null) {
            dl.setDescription(desc.toString());
        }
        this.add(null, (BValue)dl);
    }

    private String findHistoryType(BBacnetDiscoverJob.IdVals iv) {
        String ht = null;
        try {
            BTypeSpec recType;
            BBacnetDiscoverJob.PropVal ldop = iv.get(132);
            if (ldop != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("findHistoryType: ldop=" + ldop.dbg());
                }
                if (!ldop.err) {
                    ht = BBacnetDiscoverTrendLogsJob.getHistoryType((BBacnetDeviceObjectPropertyReference)ldop.val);
                }
            }
            if (ht == null && iv.id != null && (recType = BacnetTrendLogUtil.findHistoryTypeByRecords(this.device, iv.id)) != null) {
                String historyType = recType.getTypeName();
                ht = historyType.substring(6, historyType.length() - 11);
            }
            if (ht == null && ldop != null) {
                ht = this.guessHistoryTypeByAsn((BBacnetDeviceObjectPropertyReference)ldop.val);
            }
        }
        catch (Exception e) {
            this.log().message("Unable to determine history type for history " + iv);
            ht = HISTORY_TYPE_UNKNOWN;
        }
        return ht;
    }

    private static String getHistoryType(BBacnetDeviceObjectPropertyReference dop) {
        int objectType = dop.getObjectId().getObjectType();
        int propertyId = dop.getPropertyId();
        if (dop.getObjectId().getInstanceNumber() == 0x3FFFFF) {
            return null;
        }
        switch (objectType) {
            case 0: 
            case 1: 
            case 2: {
                switch (propertyId) {
                    case 85: {
                        return "Numeric";
                    }
                }
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                switch (propertyId) {
                    case 85: {
                        return "Boolean";
                    }
                }
                break;
            }
            case 13: 
            case 14: 
            case 19: {
                switch (propertyId) {
                    case 85: {
                        return "Enum";
                    }
                }
            }
        }
        return null;
    }

    private String guessHistoryTypeByAsn(BBacnetDeviceObjectPropertyReference dop) {
        int propertyId;
        int objectType = dop.getObjectId().getObjectType();
        PropertyInfo pi = this.device.getPropertyInfo(objectType, propertyId = dop.getPropertyId());
        if (pi != null) {
            int asnType = pi.getAsnType();
            if (asnType == -2) {
                if (dop.getPropertyArrayIndex() == -1) {
                    return "String";
                }
                String typespec = pi.getType();
                Type t = BTypeSpec.make((String)typespec).getResolvedType();
                asnType = AsnUtil.getAsnType(t);
            }
            return BBacnetDiscoverTrendLogsJob.asnTypeToHistoryRecordType(asnType);
        }
        return "String";
    }

    private static String asnTypeToHistoryRecordType(int asnType) {
        switch (asnType) {
            case 0: {
                return null;
            }
            case 1: {
                return "Boolean";
            }
            case 2: {
                return "Enum";
            }
            case 3: {
                return "Enum";
            }
            case 4: {
                return "Numeric";
            }
            case 5: {
                return "Numeric";
            }
            case 6: {
                return "String";
            }
            case 7: {
                return "String";
            }
            case 8: {
                return "String";
            }
            case 9: {
                return "Enum";
            }
            case 10: {
                return "String";
            }
            case 11: {
                return "String";
            }
            case 12: {
                return "String";
            }
        }
        return "String";
    }
}

