/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.history;

import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.datatypes.BTrendEvent;
import com.tridium.bacnet.history.BBacnetBooleanTrendRecord;
import com.tridium.bacnet.history.BBacnetEnumTrendRecord;
import com.tridium.bacnet.history.BBacnetNumericTrendRecord;
import com.tridium.bacnet.history.BBacnetTrendLogAlarmSourceExt;
import com.tridium.bacnet.history.BBacnetTrendRecord;
import com.tridium.bacnet.history.BIBacnetTrendLogExt;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.stack.BBacnetStack;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetLogRecord;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BBacnetTrendLogDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BOutOfServiceExt;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.collection.TableCursor;
import javax.baja.control.BPointExtension;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BTrendFlags;
import javax.baja.history.BTrendRecord;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BacnetTrendLogUtil
implements BacnetConst {
    protected static AsnOutputStream asnOut = new AsnOutputStream();
    private static final Logger logger = Logger.getLogger("bacnet.history");
    public static long MAX_SEQ_NUM = 0xFFFFFFFFL;
    private static final RangeData EMPTY_RESULT = new ReadLogResult(0L, -1L, new byte[0], false, false, false);

    public static void initHistoryExt(BHistoryExt ext) throws Exception {
        BLocalBacnetDevice localDevice = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier objectId = localDevice.lookupBacnetObjectId(ext.getHandleOrd());
        if (objectId == null) {
            BBacnetTrendLogDescriptor descriptor = new BBacnetTrendLogDescriptor();
            int nextInstanceNum = localDevice.getNextInstance(20);
            objectId = BBacnetObjectIdentifier.make(20, nextInstanceNum);
            descriptor.setObjectId(objectId);
            descriptor.setObjectName(SlotPath.unescape((String)ext.getHistoryName().format((Object)ext)));
            descriptor.setObjectOrd(ext.getHandleOrd(), null);
            String exportName = objectId.toString(BacnetConst.nameContext);
            localDevice.getExportTable().add(exportName, (BValue)descriptor);
        }
    }

    public static final long incrementSequenceNumber(long currentSeqNum) {
        if (currentSeqNum < 0L) {
            return 1L;
        }
        if (++currentSeqNum > MAX_SEQ_NUM) {
            currentSeqNum = 1L;
        }
        return currentSeqNum;
    }

    public static BOutOfServiceExt getOosExt(BHistoryExt hext) {
        BPointExtension[] pexts = hext.getParentPoint().getExtensions();
        for (int i = 0; i < pexts.length; ++i) {
            if (!(pexts[i] instanceof BOutOfServiceExt)) continue;
            return (BOutOfServiceExt)pexts[i];
        }
        return null;
    }

    public static BIHistory getHistory(BIBacnetTrendLogExt ext) {
        BIHistory history = ext.getHistory();
        if (history == null) {
            try (HistorySpaceConnection conn = BacnetTrendLogUtil.getHistoryDbConnection(null);){
                history = BacnetTrendLogUtil.getHistory(conn, ext);
            }
        }
        return history;
    }

    protected static BIHistory getHistory(HistorySpaceConnection conn, BIBacnetTrendLogExt ext) {
        BHistoryConfig config;
        BHistoryId id;
        BIHistory history = ext.getHistory();
        if (history == null && conn.exists(id = (config = ext.getHistoryConfig()).getId())) {
            history = conn.getHistory(id);
        }
        return history;
    }

    protected static HistorySpaceConnection getHistoryDbConnection(Context cx) {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        return db.getConnection(null);
    }

    public static BTypeSpec findHistoryTypeByRecords(BBacnetDevice device, BBacnetObjectIdentifier objectId) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("findHistoryTypeByRecords for " + (Object)((Object)objectId));
        }
        BBacnetLogRecord v = new BBacnetLogRecord();
        BTypeSpec recType = null;
        long itemCount = 1L;
        int position = 1;
        while (recType == null && itemCount > 0L) {
            ReadRangeAck ack = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient().readRange(device.getAddress(), objectId, 131, -1, 3, position++, null, 1);
            itemCount = ack.getItemCount();
            if (itemCount <= 0L) continue;
            try {
                AsnUtil.fromAsn(ack.getItemData(), (BValue)v);
                recType = v.getNiagaraRecordType();
            }
            catch (AsnException e) {
                logger.info("Unable to convert ASN-encoded BACnetLogRecord (" + ByteArrayUtil.toHexString((byte[])ack.getItemData()) + ") for object " + (Object)((Object)objectId));
            }
        }
        return recType;
    }

    public static long getMaxRecords(BIBacnetTrendLogExt tlog) {
        BHistoryConfig config = tlog.getHistoryConfig();
        long maxRecords = 0xFFFFFFFFL;
        if (config.getCapacity().isByRecordCount()) {
            maxRecords = config.getCapacity().getMaxRecords();
        } else if (config.getCapacity().isByStorageSize()) {
            long maxBytes = config.getCapacity().getMaxStorage();
            int bytesPerRecord = 1;
            try {
                bytesPerRecord = config.getRecordSize();
            }
            catch (Exception e) {
                logger.info("Unable to determine bytes per record for BacnetTrendLogExt " + tlog);
            }
            maxRecords = maxBytes / (long)bytesPerRecord;
        }
        return maxRecords;
    }

    public static BBacnetTrendLogAlarmSourceExt getAlarmExt(BIBacnetTrendLogExt ext) {
        if (ext == null) {
            return null;
        }
        SlotCursor c = ((BComplex)ext).getProperties();
        if (c.next(BBacnetTrendLogAlarmSourceExt.class)) {
            return (BBacnetTrendLogAlarmSourceExt)c.get();
        }
        return null;
    }

    public static BBacnetNotificationClassDescriptor getNotificationClass(BIBacnetTrendLogExt ext) {
        BBacnetTrendLogAlarmSourceExt almExt = BacnetTrendLogUtil.getAlarmExt(ext);
        if (almExt == null) {
            return null;
        }
        try {
            BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmClass ac = as.lookupAlarmClass(almExt.getAlarmClass());
            BBacnetObjectIdentifier objectId = BBacnetNetwork.localDevice().lookupBacnetObjectId(ac.getHandleOrd());
            if (objectId != null) {
                return (BBacnetNotificationClassDescriptor)BBacnetNetwork.localDevice().lookupBacnetObject(objectId);
            }
        }
        catch (ServiceNotFoundException e) {
            logger.log(Level.INFO, "getNotificationClass on " + ext + ":Unable to find alarm service!", e);
        }
        return null;
    }

    static NErrorType getFailureError(BIBacnetTrendLogExt ext) {
        ErrorType extError;
        SlotCursor c = ((BComplex)ext).getParent().getProperties();
        if (c.next(BBacnetProxyExt.class) && (extError = ((BBacnetProxyExt)c.get()).getLastReadError()) != null) {
            return new NErrorType(extError.getErrorClass(), extError.getErrorCode());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeEvent(BIBacnetTrendLogExt ext, BAbsTime timestamp, BStatus status, long sequenceNumber, BTrendEvent event) throws IOException {
        BHistoryExt hext = (BHistoryExt)ext;
        BBacnetTrendRecord rec = ext.getRecord();
        BTrendFlags tf = rec.getTrendFlags();
        BBacnetTrendLogAlarmSourceExt almExt = BacnetTrendLogUtil.getAlarmExt(ext);
        try (HistorySpaceConnection conn = BacnetTrendLogUtil.getHistoryDbConnection(null);){
            BIHistory history = BacnetTrendLogUtil.getHistory(conn, ext);
            if (history == null || conn.getRecordCount(history) == 0) {
                if (event.isLogStatus()) {
                    BBacnetBitString logStatus = event.getLogStatus();
                    BTrendEvent trendEvent = BTrendEvent.makeLogStatus(BBacnetBitString.make(logStatus, 1, true));
                    rec.set(timestamp, status, sequenceNumber, trendEvent, tf.set(4, true));
                    if (trendEvent.isLogDisabled()) {
                        BacnetTrendLogUtil.extAppend(ext, rec);
                    } else {
                        BacnetTrendLogUtil.appendRecord(ext, rec);
                    }
                } else {
                    BTrendEvent evt = ext.getEnabled() ? BTrendEvent.LOG_STATUS_ENABLED_BUFFER_PURGED : BTrendEvent.LOG_STATUS_DISABLED_BUFFER_PURGED;
                    BAbsTime timestampMinusOne = timestamp.subtract(BRelTime.make((long)1L));
                    rec.set(timestampMinusOne, status, sequenceNumber, evt, tf.set(4, true));
                    if (evt.isLogDisabled()) {
                        BacnetTrendLogUtil.extAppend(ext, rec);
                    } else {
                        BacnetTrendLogUtil.appendRecord(ext, rec);
                    }
                    if (!hext.getStatus().isFault()) {
                        ext.setTotalRecordCount(sequenceNumber);
                        if (almExt != null) {
                            almExt.incrementRecordsSinceNotification();
                        }
                    }
                    sequenceNumber = BacnetTrendLogUtil.incrementSequenceNumber(sequenceNumber);
                    rec.set(timestamp, status, sequenceNumber, event, tf.set(4, true));
                    BacnetTrendLogUtil.appendRecord(ext, rec);
                }
            } else {
                rec.set(timestamp, status, sequenceNumber, event, tf.set(4, true));
                if (event.isLogDisabled() || event.isTimeChange()) {
                    BacnetTrendLogUtil.extAppend(ext, rec);
                } else {
                    BacnetTrendLogUtil.appendRecord(ext, rec);
                }
            }
            if (!hext.getStatus().isFault()) {
                ext.setTotalRecordCount(sequenceNumber);
                if (almExt != null) {
                    almExt.incrementRecordsSinceNotification();
                }
                BacnetTrendLogUtil.checkForBufferFull(ext);
            }
        }
        finally {
            rec.setTrendFlags(tf);
        }
    }

    public static void writeRecord(BIBacnetTrendLogExt ext, BAbsTime timestamp, BStatusValue out) throws IOException {
        if (!ext.getEnabled()) {
            return;
        }
        BHistoryExt hext = (BHistoryExt)ext;
        BBacnetTrendRecord rec = ext.getRecord();
        BTrendFlags tf = rec.getTrendFlags();
        BBacnetTrendLogAlarmSourceExt almExt = BacnetTrendLogUtil.getAlarmExt(ext);
        long sequenceNumber = BacnetTrendLogUtil.incrementSequenceNumber(ext.getTotalRecordCount());
        boolean bufferPurged = false;
        try (HistorySpaceConnection conn = BacnetTrendLogUtil.getHistoryDbConnection(null);){
            BIHistory history = BacnetTrendLogUtil.getHistory(conn, ext);
            if (history == null || conn.getRecordCount(history) == 0) {
                bufferPurged = true;
            }
        }
        catch (HistoryException e) {
            bufferPurged = true;
        }
        if (bufferPurged) {
            BAbsTime timestampMinusOne = timestamp.subtract(BRelTime.make((long)1L));
            BacnetTrendLogUtil.appendRecord(ext, rec.set(timestampMinusOne, out.getStatus(), sequenceNumber, BTrendEvent.LOG_STATUS_ENABLED_BUFFER_PURGED, tf.set(4, true)));
            if (!hext.getStatus().isFault()) {
                ext.setTotalRecordCount(sequenceNumber);
                if (almExt != null) {
                    almExt.incrementRecordsSinceNotification();
                }
            }
        }
        BTrendEvent event = BTrendEvent.DEFAULT;
        NErrorType errorFound = BacnetTrendLogUtil.getFailureError(ext);
        if (errorFound != null) {
            event = BTrendEvent.makeFailure(errorFound);
            rec.setTrendFlags(tf.set(4, true));
        }
        sequenceNumber = BacnetTrendLogUtil.incrementSequenceNumber(ext.getTotalRecordCount());
        rec.set(timestamp, out, sequenceNumber, event, BTrendFlags.DEFAULT);
        BacnetTrendLogUtil.appendRecord(ext, rec);
        if (!hext.getStatus().isFault() && almExt != null) {
            almExt.incrementRecordsSinceNotification();
        }
        ext.setTotalRecordCount(sequenceNumber);
        BacnetTrendLogUtil.checkForBufferFull(ext);
    }

    private static void checkForBufferFull(BIBacnetTrendLogExt ext) {
        long bufferSize = BacnetTrendLogUtil.getMaxRecords(ext);
        try (HistorySpaceConnection conn = BacnetTrendLogUtil.getHistoryDbConnection(null);){
            BIHistory history = BacnetTrendLogUtil.getHistory(conn, ext);
            if (history == null) {
                return;
            }
            int recordCount = conn.getRecordCount(history);
            if ((long)recordCount == bufferSize - 1L && ext.getHistoryConfig().getFullPolicy() == BFullPolicy.stop) {
                ((BHistoryExt)ext).setEnabled(false);
            }
        }
    }

    private static void appendRecord(BIBacnetTrendLogExt ext, BTrendRecord rec) throws IOException {
        try (HistorySpaceConnection conn = BacnetTrendLogUtil.getHistoryDbConnection(null);){
            BIHistory history = BacnetTrendLogUtil.getHistory(conn, ext);
            TableCursor c = conn.timeQuery(history, conn.getLastTimestamp(history), conn.getLastTimestamp(history)).cursor();
            c.next();
            BBacnetTrendRecord lastRecord = (BBacnetTrendRecord)((Object)c.get());
            if (lastRecord.getLogEvent().equals((Object)BTrendEvent.DEFAULT)) {
                ext.append(rec);
            } else {
                BacnetTrendLogUtil.extAppend(ext, rec);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extAppend(BIBacnetTrendLogExt ext, BTrendRecord record) {
        block20: {
            BHistoryExt historyExt = (BHistoryExt)ext;
            try (HistorySpaceConnection conn = BacnetTrendLogUtil.getHistoryDbConnection(null);){
                BIHistory history = BacnetTrendLogUtil.getHistory(conn, ext);
                if (!historyExt.isRunning() || !Sys.atSteadyState()) break block20;
                try {
                    BIBacnetTrendLogExt bIBacnetTrendLogExt = ext;
                    synchronized (bIBacnetTrendLogExt) {
                        if (history != null) {
                            conn.append(history, (BIHistoryRecordSet)record);
                        }
                    }
                    if (history != null) {
                        historyExt.updateStatus();
                    }
                }
                catch (HistoryNotFoundException ex) {
                    logger.info("Unable to append record to history: record=" + record + " history=" + ext);
                }
                catch (Exception ex) {
                    logger.info("Unable to append record to history: record=" + record + " history=" + ext);
                }
            }
        }
    }

    private static int getLogDatumType(BBacnetTrendRecord r, Integer pointAsnType) {
        switch (r.getLogDatumType()) {
            case 0: 
            case 6: 
            case 8: 
            case 9: {
                return r.getLogDatumType();
            }
        }
        if (pointAsnType == null) {
            return r.getLogDatumType();
        }
        switch (pointAsnType) {
            case 0: {
                return 7;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 6;
            }
            case 9: {
                return 3;
            }
            case -2: {
                if (r instanceof BBacnetBooleanTrendRecord) {
                    return 3;
                }
                if (r instanceof BBacnetEnumTrendRecord) {
                    return 4;
                }
                if (r instanceof BBacnetNumericTrendRecord) {
                    return 2;
                }
                return r.getLogDatumType();
            }
        }
        return 10;
    }

    public static RangeData readRangeAll(BIBacnetTrendLogExt ext, int maxSize, Integer pointAsnType) {
        try (HistorySpaceConnection conn = BacnetTrendLogUtil.getHistoryDbConnection(null);){
            BIHistory dataHistory = BacnetTrendLogUtil.getHistory(conn, ext);
            if (dataHistory == null || conn.getRecordCount(dataHistory) == 0) {
                RangeData rangeData = EMPTY_RESULT;
                return rangeData;
            }
            BAbsTime firstTimestamp = conn.getFirstTimestamp(dataHistory);
            TableCursor data = conn.timeQuery(dataHistory, firstTimestamp, firstTimestamp).cursor();
            long firstPossibleSeqNum = 1L;
            int recordCount = conn.getRecordCount(dataHistory);
            if (data.next()) {
                firstPossibleSeqNum = ((BBacnetTrendRecord)((Object)data.get())).getSequenceNumber();
            }
            RangeData rangeData = BacnetTrendLogUtil.readRangeBySequence(ext, firstPossibleSeqNum, recordCount, maxSize, pointAsnType);
            return rangeData;
        }
    }

    public static RangeData readRangeByPosition(BIBacnetTrendLogExt ext, long position, int count, int maxSize, Integer pointAsnType) {
        try (HistorySpaceConnection conn = BacnetTrendLogUtil.getHistoryDbConnection(null);){
            BIHistory dataHistory = BacnetTrendLogUtil.getHistory(conn, ext);
            if (dataHistory == null || conn.getRecordCount(dataHistory) == 0) {
                RangeData rangeData = EMPTY_RESULT;
                return rangeData;
            }
            long recordCount = conn.getRecordCount(dataHistory);
            long lastUsedSeqNum = ext.getTotalRecordCount();
            long firstUsedSeqNum = lastUsedSeqNum - recordCount + 1L;
            if (firstUsedSeqNum < 1L) {
                firstUsedSeqNum = MAX_SEQ_NUM + firstUsedSeqNum;
            }
            long seqNumAtPosition = firstUsedSeqNum + position - 1L;
            RangeData rangeData = BacnetTrendLogUtil.readRangeBySequence(ext, seqNumAtPosition, count, maxSize, pointAsnType);
            return rangeData;
        }
    }

    public static RangeData readRangeByTime(BIBacnetTrendLogExt ext, BBacnetDateTime refTime, int count, int maxSize, Integer pointAsnType) {
        try (HistorySpaceConnection conn = BacnetTrendLogUtil.getHistoryDbConnection(null);){
            BIHistory dataHistory = BacnetTrendLogUtil.getHistory(conn, ext);
            if (dataHistory == null || conn.getRecordCount(dataHistory) == 0) {
                RangeData rangeData = EMPTY_RESULT;
                return rangeData;
            }
            BAbsTime referenceTime = refTime.toBAbsTime();
            TableCursor data = null;
            long seqNum = 1L;
            if (count >= 0) {
                Object recTime;
                data = conn.timeQuery(dataHistory, referenceTime, null).cursor();
                BAbsTime firstDataTimestamp = null;
                while (data.next()) {
                    recTime = new BBacnetDateTime(((BHistoryRecord)data.get()).getTimestamp());
                    if (((BBacnetDateTime)recTime).toBAbsTime().equals((Object)referenceTime)) continue;
                    firstDataTimestamp = ((BHistoryRecord)data.get()).getTimestamp();
                    break;
                }
                if (firstDataTimestamp == null) {
                    recTime = EMPTY_RESULT;
                    return recTime;
                }
                seqNum = ((BBacnetTrendRecord)((Object)data.get())).getSequenceNumber();
            } else {
                data = conn.timeQuery(dataHistory, null, referenceTime).cursor();
                BAbsTime lastDataTimestamp = null;
                BBacnetTrendRecord lastDataRecord = null;
                while (data.next()) {
                    BBacnetDateTime recTime = new BBacnetDateTime(((BHistoryRecord)data.get()).getTimestamp());
                    if (recTime.toBAbsTime().equals((Object)referenceTime)) continue;
                    lastDataRecord = (BBacnetTrendRecord)((Object)data.get());
                }
                if (lastDataRecord == null) {
                    RangeData rangeData = EMPTY_RESULT;
                    return rangeData;
                }
                lastDataTimestamp = lastDataRecord.getTimestamp();
                if (lastDataTimestamp != null) {
                    seqNum = lastDataRecord.getSequenceNumber();
                }
            }
            RangeData rangeData = BacnetTrendLogUtil.readRangeBySequence(ext, seqNum, count, maxSize, pointAsnType);
            return rangeData;
        }
    }

    public static RangeData readRangeBySequence(BIBacnetTrendLogExt ext, long refSeqNum, int count, int maxSize, Integer pointAsnType) {
        if (count == 0) {
            return EMPTY_RESULT;
        }
        try (HistorySpaceConnection conn = BacnetTrendLogUtil.getHistoryDbConnection(null);){
            BIHistory dataHistory = BacnetTrendLogUtil.getHistory(conn, ext);
            if (dataHistory == null || conn.getRecordCount(dataHistory) == 0) {
                RangeData rangeData = EMPTY_RESULT;
                return rangeData;
            }
            int itemCount = 0;
            boolean inclFirst = false;
            boolean inclLast = false;
            boolean moreItems = false;
            long beginSeqNum = 0L;
            if (count > 0) {
                Object tmp;
                beginSeqNum = refSeqNum;
                Cursor data = conn.scan(dataHistory);
                data.next();
                BBacnetTrendRecord firstRec = (BBacnetTrendRecord)((Object)data.get());
                long firstRecSeqNum = firstRec.getSequenceNumber();
                if (firstRecSeqNum > refSeqNum + (long)count) {
                    RangeData rangeData = EMPTY_RESULT;
                    return rangeData;
                }
                long seqNum = BacnetTrendLogUtil.findBeginRecord((Cursor<BHistoryRecord>)data, beginSeqNum);
                if (seqNum == firstRecSeqNum) {
                    inclFirst = true;
                }
                if (seqNum < 0L) {
                    RangeData rangeData = EMPTY_RESULT;
                    return rangeData;
                }
                BBacnetTrendRecord rec = (BBacnetTrendRecord)((Object)data.get());
                long firstSeqNum = seqNum;
                AsnOutputStream out = new AsnOutputStream();
                do {
                    tmp = new AsnOutputStream();
                    try {
                        out.writeTo((OutputStream)tmp);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error writing to temp ASN output stream");
                    }
                    int logDatumType = BacnetTrendLogUtil.getLogDatumType(rec, pointAsnType);
                    BBacnetLogRecord.writeLogRecord(rec.getTimestamp(), (BSimple)(rec.getStatus().isNull() ? BBacnetNull.DEFAULT : rec.get(rec.getValueProperty())), logDatumType, rec.getStatus(), rec.getLogEvent().getLong(), (AsnOutput)out);
                    if (maxSize > 0 && out.size() > maxSize) {
                        out = tmp;
                        moreItems = true;
                        break;
                    }
                    ++itemCount;
                    if (!data.next()) {
                        inclLast = true;
                        break;
                    }
                    rec = (BBacnetTrendRecord)((Object)data.get());
                    seqNum = rec.getSequenceNumber();
                } while (itemCount < count);
                tmp = new ReadLogResult(itemCount, firstSeqNum, out.toByteArray(), inclFirst, inclLast, moreItems);
                return tmp;
            }
            beginSeqNum = refSeqNum + (long)count + 1L;
            Cursor data = conn.scan(dataHistory);
            data.next();
            BBacnetTrendRecord firstRec = (BBacnetTrendRecord)((Object)data.get());
            long firstRecSeqNum = firstRec.getSequenceNumber();
            if (firstRecSeqNum > refSeqNum) {
                RangeData seqNum = EMPTY_RESULT;
                return seqNum;
            }
            long seqNum = BacnetTrendLogUtil.findBeginRecord((Cursor<BHistoryRecord>)data, beginSeqNum);
            if (seqNum == firstRecSeqNum) {
                inclFirst = true;
            }
            if (seqNum < 0L) {
                RangeData rec = EMPTY_RESULT;
                return rec;
            }
            BBacnetTrendRecord rec = (BBacnetTrendRecord)((Object)data.get());
            AsnOutputStream out = new AsnOutputStream();
            Array a = new Array(EncodedRecord.class);
            int totalSize = 0;
            count = Math.abs(count);
            do {
                int recSize = BacnetTrendLogUtil.getEncodedRecordSize(rec, pointAsnType);
                a.add((Object)new EncodedRecord(rec, recSize));
                ++itemCount;
                boolean end = false;
                if (maxSize > 0 && (totalSize += recSize) > maxSize) {
                    moreItems = true;
                    if (itemCount > 0) {
                        a.remove(itemCount - 1);
                        --itemCount;
                    }
                    end = true;
                }
                if (end) break;
                if (!data.next()) {
                    inclLast = true;
                    break;
                }
                rec = (BBacnetTrendRecord)((Object)data.get());
                seqNum = rec.getSequenceNumber();
            } while (itemCount < count);
            out.reset();
            long firstSeqNum = ((EncodedRecord)a.get((int)0)).rec.getSequenceNumber();
            for (int i = 0; i < a.size(); ++i) {
                BBacnetTrendRecord r = ((EncodedRecord)a.get((int)i)).rec;
                int logDatumType = BacnetTrendLogUtil.getLogDatumType(r, pointAsnType);
                BBacnetLogRecord.writeLogRecord(r.getTimestamp(), (BSimple)(r.getStatus().isNull() ? BBacnetNull.DEFAULT : r.get(r.getValueProperty())), logDatumType, r.getStatus(), r.getLogEvent().getLong(), (AsnOutput)out);
            }
            ReadLogResult readLogResult = new ReadLogResult(itemCount, firstSeqNum, out.toByteArray(), inclFirst, inclLast, moreItems);
            return readLogResult;
        }
    }

    private static long findBeginRecord(Cursor<BHistoryRecord> c, long begin) {
        BBacnetTrendRecord r = (BBacnetTrendRecord)((Object)c.get());
        long seqnum = r.getSequenceNumber();
        while (seqnum < begin) {
            if (c.next()) {
                r = (BBacnetTrendRecord)((Object)c.get());
                seqnum = r.getSequenceNumber();
                continue;
            }
            return -1L;
        }
        return seqnum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getEncodedRecordSize(BBacnetTrendRecord rec, Integer pointAsnType) {
        AsnOutputStream asnOutputStream = asnOut;
        synchronized (asnOutputStream) {
            asnOut.reset();
            int logDatumType = BacnetTrendLogUtil.getLogDatumType(rec, pointAsnType);
            BBacnetLogRecord.writeLogRecord(rec.getTimestamp(), (BSimple)(rec.getStatus().isNull() ? BBacnetNull.DEFAULT : rec.get(rec.getValueProperty())), logDatumType, rec.getStatus(), rec.getLogEvent().getLong(), (AsnOutput)asnOut);
            return asnOut.size();
        }
    }

    static class ReadLogResult
    implements RangeData {
        long itemCount;
        long firstSequenceNumber;
        byte[] itemData;
        boolean includeFirst;
        boolean includeLast;
        boolean moreItems;

        ReadLogResult(long ic, long fsn, byte[] id, boolean inclFirst, boolean inclLast, boolean more) {
            this.itemCount = ic;
            this.firstSequenceNumber = fsn;
            this.itemData = id;
            this.includeFirst = inclFirst;
            this.includeLast = inclLast;
            this.moreItems = more;
        }

        @Override
        public BBacnetBitString getResultFlags() {
            return BBacnetBitString.make(new boolean[]{this.includeFirst, this.includeLast, this.moreItems});
        }

        @Override
        public boolean includesFirstItem() {
            return this.includeFirst;
        }

        @Override
        public boolean includesLastItem() {
            return this.includeLast;
        }

        @Override
        public boolean isMoreItems() {
            return this.moreItems;
        }

        @Override
        public long getItemCount() {
            return this.itemCount;
        }

        @Override
        public long getFirstSequenceNumber() {
            return this.firstSequenceNumber;
        }

        @Override
        public byte[] getItemData() {
            return this.itemData;
        }

        @Override
        public ErrorType getError() {
            return null;
        }

        @Override
        public int getErrorClass() {
            return -1;
        }

        @Override
        public int getErrorCode() {
            return -1;
        }

        @Override
        public boolean isError() {
            return false;
        }

        @Override
        public int getPropertyId() {
            return 131;
        }

        @Override
        public int getPropertyArrayIndex() {
            return -1;
        }

        @Override
        public void writeAsn(AsnOutput out) {
        }

        @Override
        public void readAsn(AsnInput in) {
        }
    }

    static class EncodedRecord {
        BBacnetTrendRecord rec;
        int size;

        EncodedRecord(BBacnetTrendRecord r, int sz) {
            this.rec = (BBacnetTrendRecord)r.newCopy();
            this.size = sz;
        }
    }
}

