/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.history;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.history.BIBacnetTrendLogExt;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.alarm.ext.BAlarmTimestamps;
import javax.baja.alarm.ext.BIAlarmMessages;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetAlarmConst;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.control.BControlPoint;
import javax.baja.control.BPointExtension;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BUuid;

public class BBacnetTrendLogAlarmSourceExt
extends BPointExtension
implements BIAlarmSource,
BIAlarmMessages,
BacnetAlarmConst {
    public static final Property notificationThreshold = BBacnetTrendLogAlarmSourceExt.newProperty((int)0, (BValue)BLong.make((long)10L), null);
    public static final Property recordsSinceNotification = BBacnetTrendLogAlarmSourceExt.newProperty((int)3, (BValue)BLong.make((long)0L), null);
    public static final Property lastNotifyRecord = BBacnetTrendLogAlarmSourceExt.newProperty((int)3, (BValue)BLong.make((long)0L), null);
    public static final Property alarmInhibit = BBacnetTrendLogAlarmSourceExt.newProperty((int)0, (BValue)new BStatusBoolean(false), null);
    public static final Property alarmState = BBacnetTrendLogAlarmSourceExt.newProperty((int)3, (BValue)BAlarmState.normal, null);
    public static final Property alarmEnable = BBacnetTrendLogAlarmSourceExt.newProperty((int)0, (BValue)BAlarmTransitionBits.make((int)4), null);
    public static final Property ackedTransitions = BBacnetTrendLogAlarmSourceExt.newProperty((int)3, (BValue)BAlarmTransitionBits.ALL, null);
    public static final Property notifyType = BBacnetTrendLogAlarmSourceExt.newProperty((int)0, (BValue)BBacnetNotifyType.alarm, (BFacets)BacUtil.makeBacnetNotifyTypeFacets());
    public static final Property toOffnormalTimes = BBacnetTrendLogAlarmSourceExt.newProperty((int)3, (BValue)new BAlarmTimestamps(), null);
    public static final Property toFaultTimes = BBacnetTrendLogAlarmSourceExt.newProperty((int)3, (BValue)new BAlarmTimestamps(), null);
    public static final Property toNormalTimes = BBacnetTrendLogAlarmSourceExt.newProperty((int)3, (BValue)new BAlarmTimestamps(), null);
    public static final Property toNormalText = BBacnetTrendLogAlarmSourceExt.newProperty((int)0, (BValue)BFormat.make((String)"BUFFER_READY"), null);
    public static final Property hyperlinkOrd = BBacnetTrendLogAlarmSourceExt.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"ordRelativize", (boolean)false));
    public static final Property alarmClass = BBacnetTrendLogAlarmSourceExt.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassEditor")));
    public static final Action ackAlarm = BBacnetTrendLogAlarmSourceExt.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BBacnetTrendLogAlarmSourceExt.class);
    private static final Context millis = BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
    private static Logger logger = Logger.getLogger("bacnet.server");

    public long getNotificationThreshold() {
        return this.getLong(notificationThreshold);
    }

    public void setNotificationThreshold(long v) {
        this.setLong(notificationThreshold, v, null);
    }

    public long getRecordsSinceNotification() {
        return this.getLong(recordsSinceNotification);
    }

    public void setRecordsSinceNotification(long v) {
        this.setLong(recordsSinceNotification, v, null);
    }

    public long getLastNotifyRecord() {
        return this.getLong(lastNotifyRecord);
    }

    public void setLastNotifyRecord(long v) {
        this.setLong(lastNotifyRecord, v, null);
    }

    public BStatusBoolean getAlarmInhibit() {
        return (BStatusBoolean)this.get(alarmInhibit);
    }

    public void setAlarmInhibit(BStatusBoolean v) {
        this.set(alarmInhibit, (BValue)v, null);
    }

    public BAlarmState getAlarmState() {
        return (BAlarmState)this.get(alarmState);
    }

    public void setAlarmState(BAlarmState v) {
        this.set(alarmState, (BValue)v, null);
    }

    public BAlarmTransitionBits getAlarmEnable() {
        return (BAlarmTransitionBits)this.get(alarmEnable);
    }

    public void setAlarmEnable(BAlarmTransitionBits v) {
        this.set(alarmEnable, (BValue)v, null);
    }

    public BAlarmTransitionBits getAckedTransitions() {
        return (BAlarmTransitionBits)this.get(ackedTransitions);
    }

    public void setAckedTransitions(BAlarmTransitionBits v) {
        this.set(ackedTransitions, (BValue)v, null);
    }

    public BBacnetNotifyType getNotifyType() {
        return (BBacnetNotifyType)this.get(notifyType);
    }

    public void setNotifyType(BBacnetNotifyType v) {
        this.set(notifyType, (BValue)v, null);
    }

    public BAlarmTimestamps getToOffnormalTimes() {
        return (BAlarmTimestamps)this.get(toOffnormalTimes);
    }

    public void setToOffnormalTimes(BAlarmTimestamps v) {
        this.set(toOffnormalTimes, (BValue)v, null);
    }

    public BAlarmTimestamps getToFaultTimes() {
        return (BAlarmTimestamps)this.get(toFaultTimes);
    }

    public void setToFaultTimes(BAlarmTimestamps v) {
        this.set(toFaultTimes, (BValue)v, null);
    }

    public BAlarmTimestamps getToNormalTimes() {
        return (BAlarmTimestamps)this.get(toNormalTimes);
    }

    public void setToNormalTimes(BAlarmTimestamps v) {
        this.set(toNormalTimes, (BValue)v, null);
    }

    public BFormat getToNormalText() {
        return (BFormat)this.get(toNormalText);
    }

    public void setToNormalText(BFormat v) {
        this.set(toNormalText, (BValue)v, null);
    }

    public BOrd getHyperlinkOrd() {
        return (BOrd)this.get(hyperlinkOrd);
    }

    public void setHyperlinkOrd(BOrd v) {
        this.set(hyperlinkOrd, (BValue)v, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    public BBoolean ackAlarm(BAlarmRecord ackRequest) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)ackRequest, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setLastNotifyRecord(this.getTrendLogExt().getTotalRecordCount());
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BIBacnetTrendLogExt;
    }

    protected boolean isSiblingLegal(BComponent sibling) {
        return true;
    }

    protected BIBacnetTrendLogExt getTrendLogExt() {
        return (BIBacnetTrendLogExt)this.getParent();
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        Property alarmTimesProp;
        if (!this.isRunning()) {
            return BBoolean.make((boolean)false);
        }
        ackRequest.setAckTime(BAbsTime.make());
        boolean validAck = false;
        ackRequest.setAckState(BAckState.acked);
        ackRequest.setAckRequired(false);
        BSourceState transition = ackRequest.getSourceState();
        if (transition == BSourceState.normal) {
            alarmTimesProp = toNormalTimes;
        } else if (transition == BSourceState.offnormal) {
            alarmTimesProp = toOffnormalTimes;
        } else if (transition == BSourceState.fault) {
            alarmTimesProp = toFaultTimes;
        } else {
            throw new IllegalStateException();
        }
        BAlarmTimestamps timestamps = (BAlarmTimestamps)this.get(alarmTimesProp);
        BAbsTime alarmTime = timestamps.getAlarmTime();
        if (alarmTime.equals((Object)ackRequest.getTimestamp())) {
            timestamps.setAckTime(ackRequest.getAckTime());
            timestamps.setCount(0);
            BAlarmTransitionBits ackedTrans = this.getAckedTransitions();
            if (transition == BSourceState.offnormal) {
                this.setAckedTransitions(BAlarmTransitionBits.make((BAlarmTransitionBits)ackedTrans, (BAlarmTransitionBits)BAlarmTransitionBits.toOffnormal, (boolean)true));
            } else if (transition == BSourceState.fault) {
                this.setAckedTransitions(BAlarmTransitionBits.make((BAlarmTransitionBits)ackedTrans, (BAlarmTransitionBits)BAlarmTransitionBits.toFault, (boolean)true));
            } else if (transition == BSourceState.normal) {
                this.setAckedTransitions(BAlarmTransitionBits.make((BAlarmTransitionBits)ackedTrans, (BAlarmTransitionBits)BAlarmTransitionBits.toNormal, (boolean)true));
            } else if (transition == BSourceState.alert) {
                this.setAckedTransitions(BAlarmTransitionBits.make((BAlarmTransitionBits)ackedTrans, (BAlarmTransitionBits)BAlarmTransitionBits.toAlert, (boolean)true));
            }
            validAck = true;
        } else {
            logger.info("Ack timestamp does not match: stale ack! " + alarmTime.toString(millis) + " != " + ackRequest.getTimestamp().toString(millis));
            ackRequest.addAlarmFacet("staleAck", (BIDataValue)BBoolean.TRUE);
        }
        try {
            BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            as.routeAlarm(ackRequest);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to route alarm to alarm service", e);
        }
        return BBoolean.make((boolean)validAck);
    }

    public void incrementRecordsSinceNotification() {
        this.setRecordsSinceNotification(this.getRecordsSinceNotification() + 1L);
    }

    public void onExecute(BStatusValue out, Context cx) {
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if ((p.equals(notificationThreshold) || p.equals(recordsSinceNotification)) && !(cx instanceof SkipCheckBufferContext)) {
            this.checkBufferReady(this.getTrendLogExt().getTotalRecordCount());
        }
    }

    public void updateParameters(long notificationThreshold, long previousCount, Context cx) {
        SkipCheckBufferContext skipCheckBuffer = new SkipCheckBufferContext(cx);
        this.setLong(BBacnetTrendLogAlarmSourceExt.notificationThreshold, notificationThreshold, (Context)skipCheckBuffer);
        long oldPreviousCount = this.getLastNotifyRecord();
        long recordsSince = this.getRecordsSinceNotification() + oldPreviousCount - previousCount;
        this.setLong(recordsSinceNotification, recordsSince, (Context)skipCheckBuffer);
        this.setLong(lastNotifyRecord, previousCount, (Context)skipCheckBuffer);
        this.checkBufferReady(this.getTrendLogExt().getTotalRecordCount());
    }

    public void checkBufferReady(long currentSeqNum) {
        boolean successful;
        if (this.getAlarmInhibit().getBoolean()) {
            return;
        }
        if (this.getRecordsSinceNotification() > this.getNotificationThreshold() && (successful = this.initiateBufferReadyEvent(currentSeqNum, this.getLastNotifyRecord()))) {
            this.setRecordsSinceNotification(1L);
            this.setLastNotifyRecord(currentSeqNum);
        }
    }

    private boolean initiateBufferReadyEvent(long currentNotification, long previousNotification) {
        if (!this.getAlarmEnable().includes(BSourceState.normal)) {
            return true;
        }
        HashMap<String, BString> map = new HashMap<String, BString>();
        String msgText = "";
        BOrd ord = BOrd.NULL;
        msgText = this.getToNormalText().getFormat();
        ord = this.getHyperlinkOrd();
        Property alarmTimesProp = toNormalTimes;
        try {
            BBacnetObjectIdentifier objectId = BBacnetNetwork.localDevice().lookupBacnetObjectId(((BComponent)this.getTrendLogExt()).getHandleOrd());
            if (objectId == null) {
                BControlPoint parentPoint;
                BComplex parent = ((BComponent)this.getTrendLogExt()).getParent();
                BControlPoint bControlPoint = parentPoint = parent instanceof BControlPoint ? (BControlPoint)parent : null;
                if (parentPoint != null) {
                    objectId = BBacnetNetwork.localDevice().lookupBacnetObjectId(parentPoint.getHandleOrd());
                }
                if (objectId == null) {
                    logger.severe("Could not send the alarm as the object is not exported as a BACnet object.");
                    return false;
                }
            }
            BBacnetDeviceObjectPropertyReference opr = new BBacnetDeviceObjectPropertyReference(objectId, 131);
            map.put("presentValue", BString.make((String)opr.encodeToString()));
            map.put("fromState", BString.make((String)this.getAlarmState().getTag()));
            map.put("toState", BString.make((String)BAlarmState.normal.getTag()));
            map.put("msgText", BString.make((String)msgText));
            map.put("hyperlinkOrd", BString.make((String)ord.toString()));
            map.put("notifyType", BString.make((String)this.getNotifyType().getTag()));
            map.put("previousNotification", BString.make((String)String.valueOf(previousNotification)));
            map.put("currentNotification", BString.make((String)String.valueOf(currentNotification)));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Buffer-Ready toNormal Transition Failed - Could not build alarm record facets.", e);
            return false;
        }
        try {
            BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmClass ac = as.lookupAlarmClass(this.getAlarmClass());
            BAlarmRecord alarm = new BAlarmRecord((BComponent)this, this.getAlarmClass(), BFacets.make(map), BUuid.make());
            alarm.setSourceState(BSourceState.normal);
            boolean ackRequired = ac.getAckRequired().includes(BSourceState.normal);
            alarm.setAckRequired(ackRequired);
            if (ackRequired) {
                BAlarmTransitionBits ackedTrans = this.getAckedTransitions();
                this.setAckedTransitions(BAlarmTransitionBits.make((BAlarmTransitionBits)ackedTrans, (BAlarmTransitionBits)BAlarmTransitionBits.toNormal, (boolean)false));
            }
            BAlarmTimestamps alarmTimes = (BAlarmTimestamps)this.get(alarmTimesProp);
            BAbsTime timestamp = alarm.getTimestamp();
            alarmTimes.setAlarmTime(timestamp);
            alarmTimes.setNormalTime(timestamp);
            alarm.setNormalTime(timestamp);
            alarmTimes.setAckTime(BAbsTime.DEFAULT);
            alarmTimes.setCount(alarmTimes.getCount() + 1);
            as.routeAlarm(alarm);
        }
        catch (ServiceNotFoundException e) {
            logger.severe("Buffer-Ready toNormal Transition Failed - AlarmService not found.");
            return false;
        }
        return true;
    }

    public BFormat getToFaultText() {
        return BFormat.DEFAULT;
    }

    public BFormat getToOffnormalText() {
        return BFormat.DEFAULT;
    }

    private static class SkipCheckBufferContext
    extends BasicContext {
        public SkipCheckBufferContext(Context base) {
            super(base);
        }
    }
}

