/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.history;

import com.tridium.bacnet.datatypes.BTrendEvent;
import com.tridium.bacnet.history.BBacnetActivePeriod;
import com.tridium.bacnet.history.BBacnetBooleanTrendRecord;
import com.tridium.bacnet.history.BBacnetTrendRecord;
import com.tridium.bacnet.history.BIBacnetTrendLogExt;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.history.ext.BBooleanIntervalHistoryExt;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetBooleanIntervalTrendLogExt
extends BBooleanIntervalHistoryExt
implements BIBacnetTrendLogExt {
    public static final Property totalRecordCount = BBacnetBooleanIntervalTrendLogExt.newProperty((int)1, (BValue)BLong.make((long)0L), null);
    public static final Action startLogging = BBacnetBooleanIntervalTrendLogExt.newAction((int)0, null);
    public static final Action stopLogging = BBacnetBooleanIntervalTrendLogExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BBacnetBooleanIntervalTrendLogExt.class);
    private BBacnetBooleanTrendRecord rec;
    private boolean trigger = false;
    private static final Logger logger = Logger.getLogger("bacnet.server");
    private Object SEQUENCE_LOCK = new Object();

    @Override
    public long getTotalRecordCount() {
        return this.getLong(totalRecordCount);
    }

    @Override
    public void setTotalRecordCount(long v) {
        this.setLong(totalRecordCount, v, null);
    }

    public void startLogging() {
        this.invoke(startLogging, null, null);
    }

    public void stopLogging() {
        this.invoke(stopLogging, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.rec = new BBacnetBooleanTrendRecord();
        if (!(this.getActivePeriod() instanceof BBacnetActivePeriod)) {
            this.setActivePeriod(new BBacnetActivePeriod());
        }
        if (Sys.atSteadyState() && this.initHistoryExt()) {
            BacnetTrendLogUtil.initHistoryExt((BHistoryExt)this);
        }
    }

    protected boolean initHistoryExt() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atSteadyState() {
        block9: {
            if (this.isRunning()) {
                try {
                    BAbsTime timestamp = BAbsTime.make();
                    if (!this.getActivePeriod().isActive(timestamp) || !this.getEnabled()) break block9;
                    Object object = this.SEQUENCE_LOCK;
                    synchronized (object) {
                        this.trigger = true;
                        long sequenceNumber = BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount());
                        BTrendEvent event = BTrendEvent.LOG_STATUS_ENABLED;
                        BStatus status = BStatus.DEFAULT;
                        BacnetTrendLogUtil.writeEvent(this, timestamp, status, sequenceNumber, event);
                    }
                    BacnetTrendLogUtil.initHistoryExt((BHistoryExt)this);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error storing log status enabled event", e);
                }
                finally {
                    this.trigger = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(enabled)) {
            if (!this.isParentLegal(this.getParent().asComponent())) {
                log.severe("Tried to enable BacnetTrendLogExt inside an illegal parent!?");
                this.setEnabled(false);
            } else {
                try {
                    Object object = this.SEQUENCE_LOCK;
                    synchronized (object) {
                        this.trigger = true;
                        BAbsTime timestamp = BAbsTime.make();
                        if (this.getEnabled()) {
                            BacnetTrendLogUtil.writeEvent(this, timestamp, this.getStatus(), BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount()), BTrendEvent.LOG_STATUS_ENABLED);
                        } else {
                            BacnetTrendLogUtil.writeEvent(this, timestamp, this.getStatus(), BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount()), BTrendEvent.LOG_STATUS_DISABLED);
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error storing event", e);
                }
                finally {
                    this.trigger = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clockChanged(BRelTime shift) throws Exception {
        if (!this.getEnabled()) {
            return;
        }
        try {
            Object object = this.SEQUENCE_LOCK;
            synchronized (object) {
                this.trigger = true;
                long sequenceNumber = BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount());
                BAbsTime timestamp = BAbsTime.now();
                BTrendEvent event = BTrendEvent.makeTimeChange(shift.getSeconds());
                BStatus status = this.getStatus();
                BacnetTrendLogUtil.writeEvent(this, timestamp, status, sequenceNumber, event);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error storing event", e);
        }
        finally {
            this.trigger = false;
        }
    }

    public void doStartLogging() {
        this.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStopLogging() {
        try {
            Object object = this.SEQUENCE_LOCK;
            synchronized (object) {
                this.trigger = true;
                BAbsTime timestamp = BAbsTime.make();
                BacnetTrendLogUtil.writeEvent(this, timestamp, BStatus.DEFAULT, BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount()), BTrendEvent.LOG_STATUS_DISABLED);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error storing event", e);
        }
        finally {
            this.trigger = false;
            this.setEnabled(false);
        }
    }

    public Type getRecordType() {
        return BBacnetBooleanTrendRecord.TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRecord(BAbsTime timestamp, BStatusValue out) throws IOException {
        Object object = this.SEQUENCE_LOCK;
        synchronized (object) {
            BacnetTrendLogUtil.writeRecord(this, timestamp, out);
        }
    }

    @Override
    public BBacnetTrendRecord getRecord() {
        return this.rec;
    }

    @Override
    public ErrorType setLogInterval(long logInterval, Context cx) {
        this.set(interval, (BValue)BRelTime.make((long)logInterval), cx);
        return null;
    }

    @Override
    public boolean getTrigger() {
        return this.trigger;
    }
}

