/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.enums;

import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BAcknowledgmentFilter
extends BFrozenEnum {
    public static final int ALL = 0;
    public static final int ACKED = 1;
    public static final int NOT_ACKED = 2;
    public static final BAcknowledgmentFilter all = new BAcknowledgmentFilter(0);
    public static final BAcknowledgmentFilter acked = new BAcknowledgmentFilter(1);
    public static final BAcknowledgmentFilter notAcked = new BAcknowledgmentFilter(2);
    public static final Type TYPE = Sys.loadType(BAcknowledgmentFilter.class);
    public static final BAcknowledgmentFilter DEFAULT = all;
    private static final BBacnetBitString ACKED_BITS = BBacnetBitString.make(new boolean[]{true, true, true});

    public Type getType() {
        return TYPE;
    }

    public static BAcknowledgmentFilter make(int ordinal) {
        return (BAcknowledgmentFilter)all.getRange().get(ordinal, false);
    }

    public static BAcknowledgmentFilter make(String tag) {
        return (BAcknowledgmentFilter)all.getRange().get(tag);
    }

    private BAcknowledgmentFilter(int ordinal) {
        super(ordinal);
    }

    public boolean filter(BBacnetBitString ackedTransitions) {
        if (ackedTransitions == null) {
            return false;
        }
        switch (this.getOrdinal()) {
            case 0: {
                return true;
            }
            case 1: {
                return ACKED_BITS.equals((Object)ackedTransitions);
            }
            case 2: {
                for (int i = 0; i < 3; ++i) {
                    if (ackedTransitions.getBit(i)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalStateException();
    }
}

