/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.datatypes;

import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.server.BEventHandler;
import com.tridium.bacnet.util.BacnetAlarmRecipientUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.export.BBacnetEventSource;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BEventSaver
extends BAlarmRecipient {
    public static final Type TYPE = Sys.loadType(BEventSaver.class);
    private static final Logger logger = Logger.getLogger("bacnet.server");

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BBacnetNotificationClassDescriptor;
    }

    public void handleAlarm(BAlarmRecord rec) {
        block33: {
            BLocalBacnetDevice local = BBacnetNetwork.localDevice();
            BBacnetEventSource evtSrc = null;
            boolean traceOn = logger.isLoggable(Level.FINE);
            try {
                BObject src;
                BBacnetObjectIdentifier id;
                if (traceOn) {
                    logger.fine("handleAlarm on " + SlotPath.unescape((String)this.getName()) + ":" + rec + "\n alarmData=" + rec.getAlarmData() + "\n uuid=" + rec.getUuid());
                }
                if ((id = BacnetAlarmRecipientUtil.getEventObjectId(src = rec.getSource().get(0).get((BObject)this))) == null) {
                    if (traceOn) {
                        logger.fine("event not saved: object not exported to BACnet");
                    }
                    return;
                }
                BSourceState srcSt = rec.getSourceState();
                if (srcSt == BSourceState.alert) {
                    if (traceOn) {
                        logger.fine("event not saved: alert");
                    }
                    return;
                }
                try {
                    evtSrc = (BBacnetEventSource)local.lookupBacnetObject(id);
                }
                catch (ClassCastException e) {
                    if (traceOn) {
                        logger.fine("event not saved: object not a BacnetEventSource");
                    }
                    return;
                }
                if (evtSrc == null) {
                    if (traceOn) {
                        logger.fine("event not saved: event object not exported");
                    }
                    return;
                }
                BBacnetNotificationClassDescriptor nc = evtSrc.getNotificationClass();
                if (nc == null) {
                    if (traceOn) {
                        logger.fine("event not saved: alarm class not exported to BACnet");
                    }
                    return;
                }
                BEventHandler eh = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getServer().getEventHandler();
                if (!evtSrc.getEventDetectionEnable()) {
                    if (traceOn) {
                        logger.fine("Event detection enable is false. Do not add the events in event buffers for " + (Object)((Object)local.getObjectId()) + " " + (Object)((Object)id));
                    }
                    return;
                }
                if (rec.getSourceState() != BSourceState.normal || rec.getAckState() != BAckState.acked) {
                    BBacnetEventState eventState = BBacnetEventState.make(rec.getSourceState());
                    if (traceOn) {
                        logger.fine("Save record to " + eventState + " buffer: " + (Object)((Object)local.getObjectId()) + " " + (Object)((Object)id) + " " + 0L);
                    }
                    eh.addEventSummary(id);
                    eh.putRecordToEventBuffer(eventState.getOrdinal(), local.getObjectId(), id, 0L, rec);
                    BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                    try (AlarmDbConnection conn = as.getAlarmDb().getDbConnection(null);){
                        conn.update(rec);
                        break block33;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "BEventHandler.putRecordToEventBuffer:Unable to update Alarm record", e);
                    }
                    break block33;
                }
                eh.removeEventSummary(id);
                if (traceOn) {
                    logger.fine("Remove record from outstanding events: " + (Object)((Object)local.getObjectId()) + " " + (Object)((Object)id) + " " + 0L);
                }
            }
            catch (Exception e) {
                if (!traceOn) break block33;
                logger.fine("Exception in BEventSaver.handleAlarm() [" + this.getName() + "]");
            }
        }
    }

    public boolean accept(BAlarmRecord rec) {
        return true;
    }
}

