/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet;

import com.tridium.bacnet.asn.NBacnetPropertyReference;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class ObjectTypeList {
    private static ObjectTypeList INSTANCE = null;
    private static ArrayList<NBacnetPropertyReference> BASIC_PROP_LIST = new ArrayList();
    private static Log logger = Log.getLog((String)"bacnet");
    private static int[] BASIC_PROPS;
    private IntHashMap objectMap = new IntHashMap(25);
    private IntHashMap reqPropsMap = new IntHashMap(25);

    private ObjectTypeList(BOrd ord) {
        this.load(ord);
    }

    public static ObjectTypeList make(BOrd ord) {
        return new ObjectTypeList(ord);
    }

    private void load(BOrd ord) {
        try {
            if (ord == null || ord.equals((Object)BOrd.NULL)) {
                return;
            }
            if (logger.isTraceOn()) {
                logger.trace("Loading object type info from " + ord);
            }
            BIFile file = (BIFile)ord.resolve().get();
            XElem root = XParser.make((InputStream)file.getInputStream()).parse();
            XElem[] types = root.elems("object");
            for (int i = 0; i < types.length; ++i) {
                IntHashMap byPropId = new IntHashMap();
                ArrayList<Integer> reqProps = new ArrayList<Integer>();
                int pr = types[i].geti("pr", 0);
                int type = types[i].geti("t");
                XElem[] props = types[i].elems("property");
                for (int j = 0; j < props.length; ++j) {
                    int propId = props[j].geti("i");
                    PropertyInfo info = new PropertyInfo(props[j], pr);
                    byPropId.put(propId, (Object)info);
                    boolean required = props[j].getb("r", false);
                    if (!required) continue;
                    reqProps.add(new Integer(propId));
                }
                int[] reqPropsArr = new int[reqProps.size()];
                for (int j = 0; j < reqPropsArr.length; ++j) {
                    reqPropsArr[j] = (Integer)reqProps.get(j);
                }
                this.objectMap.put(type, (Object)byPropId);
                this.reqPropsMap.put(type, (Object)reqPropsArr);
            }
        }
        catch (Exception e) {
            logger.warning("Unable to load Bacnet Object Types from " + ord + ":" + e);
            throw new BajaRuntimeException("Error loading object types!", (Throwable)e);
        }
    }

    public PropertyInfo getPropertyInfo(int objectType, int propertyId) {
        IntHashMap map = (IntHashMap)this.objectMap.get(objectType);
        if (map == null) {
            return null;
        }
        return (PropertyInfo)map.get(propertyId);
    }

    public boolean isObjectTypeKnown(int objectType) {
        return this.objectMap.get(objectType) != null;
    }

    public int[] getPossibleProperties(BBacnetObjectIdentifier objectId) {
        return this.getPossibleProperties(objectId, -1);
    }

    public int[] getPossibleProperties(BBacnetObjectIdentifier objectId, int revision) {
        if (objectId == null) {
            return BASIC_PROPS;
        }
        IntHashMap propsMap = (IntHashMap)this.objectMap.get(objectId.getObjectType());
        if (propsMap == null) {
            return BASIC_PROPS;
        }
        int[] props = new int[propsMap.size()];
        IntHashMap.Iterator it = propsMap.iterator();
        int ndx = 0;
        while (it.hasNext()) {
            PropertyInfo propInfo = (PropertyInfo)it.next();
            if (revision != -1 && revision < propInfo.getPr()) continue;
            props[ndx++] = it.key();
        }
        return Arrays.copyOf(props, ndx);
    }

    public int[] getRequiredProperties(BBacnetObjectIdentifier objectId) {
        if (objectId == null) {
            return BASIC_PROPS;
        }
        int[] props = (int[])this.reqPropsMap.get(objectId.getObjectType());
        return props != null ? props : BASIC_PROPS;
    }

    public String toString() {
        return "ObjectTypeList:size=" + this.size();
    }

    public static ObjectTypeList getInstance() {
        return INSTANCE;
    }

    private int size() {
        return this.objectMap.size();
    }

    public IntHashMap getPropertiesForObjectId(BBacnetObjectIdentifier objectId) {
        return (IntHashMap)this.objectMap.get(objectId.getObjectType());
    }

    static {
        AccessController.doPrivileged(() -> {
            try {
                INSTANCE = new ObjectTypeList(BOrd.make((String)"file:!defaults/bacnetObjectTypes.xml"));
            }
            catch (Exception e) {
                try {
                    INSTANCE = new ObjectTypeList(BOrd.make((String)"module://bacnet/com/tridium/bacnet/objectTypes.xml"));
                }
                catch (Exception e2) {
                    System.err.println("Cannot load BACnet object type data from XML file!");
                }
            }
            return null;
        });
        BASIC_PROP_LIST.add(new NBacnetPropertyReference(75));
        BASIC_PROP_LIST.add(new NBacnetPropertyReference(77));
        BASIC_PROP_LIST.add(new NBacnetPropertyReference(79));
        BASIC_PROPS = new int[]{75, 77, 79};
    }
}

