/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platLon;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platLon.BLonPlatformService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.AccessController;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BajaException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BLonPlatformServiceQnx
extends BLonPlatformService {
    public static final Type TYPE = Sys.loadType(BLonPlatformServiceQnx.class);
    private static final int MAX_HANDLE = 3;
    private static int nextHandle = 0;
    private FileInputStream[] in = new FileInputStream[4];
    private FileOutputStream[] out = new FileOutputStream[4];
    private String[] devNames = new String[4];

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx);
    }

    @Override
    public int driverInit(String deviceName) throws Exception {
        int handle = -1;
        for (int i = 0; i < this.devNames.length; ++i) {
            if (this.devNames[i] == null || this.devNames[i].length() == 0) {
                handle = i;
                this.devNames[i] = deviceName;
                break;
            }
            if (!this.devNames[i].equals(deviceName)) continue;
            return i;
        }
        if (handle == -1) {
            throw new BajaException("All available LON ports in use.");
        }
        File driver = new File("/dev/" + TextUtil.toLowerCase((String)deviceName));
        int driverHandler = handle;
        AccessController.doPrivileged(() -> {
            this.in[driverHandler] = new FileInputStream(driver);
            this.out[driverHandler] = new FileOutputStream(driver);
            return null;
        });
        return driverHandler;
    }

    @Override
    public void write(int handle, byte[] netBytes, int msgLen) throws Exception {
        this.out[handle].write(netBytes, 0, msgLen);
    }

    @Override
    public boolean read(int handle, byte[] buf) throws Exception {
        int bytesRead = this.in[handle].read(buf);
        return bytesRead != -1;
    }
}

