/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import javax.baja.gx.BInsets;
import javax.baja.gx.Point;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextField;
import javax.baja.ui.event.BMouseEvent;

public class BToolTipTextField
extends BTextField {
    public static final Property toolTip = BToolTipTextField.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BToolTipTextField.class);
    private static TextFieldToolTip window = new TextFieldToolTip(new Frame());
    private static Font font = new Font(Theme.textEditor().getFont().getName(), 0, (int)Theme.textEditor().getFont().getSize());

    public String getToolTip() {
        return this.getString(toolTip);
    }

    public void setToolTip(String v) {
        this.setString(toolTip, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BToolTipTextField() {
    }

    public BToolTipTextField(String text) {
        super(text);
    }

    public BToolTipTextField(String text, int visibleColumns) {
        super(text, visibleColumns);
    }

    public BToolTipTextField(String text, int visibleColumns, boolean editable) {
        super(text, visibleColumns, editable);
    }

    public void mouseHover(BMouseEvent event) {
        boolean showIt;
        super.mouseHover(event);
        String toDisplay = this.getToolTip();
        if (toDisplay.trim().length() == 0) {
            toDisplay = this.getText();
            BInsets insets = this.getInsets();
            double displayableWidth = this.getWidth() - insets.left() - insets.right();
            showIt = displayableWidth < (double)BToolTipTextField.getToolTipTextWidth(toDisplay);
        } else {
            showIt = true;
        }
        if (showIt) {
            Point pt = this.translateToScreen(new Point(0.0, 16.0));
            BToolTipTextField.openTextFieldToolTip((int)pt.x, (int)pt.y, toDisplay);
        }
    }

    public void mouseExited(BMouseEvent event) {
        super.mouseExited(event);
        BToolTipTextField.closeTextFieldToolTip();
    }

    public static void openTextFieldToolTip(int x, int y, String msg) {
        window.setLocation(x, y);
        BToolTipTextField.window.setText(msg);
        window.checkLocation();
        window.pack();
        window.setVisible(true);
    }

    public static void closeTextFieldToolTip() {
        window.setVisible(false);
    }

    public static int getToolTipTextWidth(String msg) {
        return window.getFontMetrics(font).stringWidth(msg);
    }

    public static class TextFieldToolTip
    extends Window {
        private String text;
        private int delta;
        private Color foreground;
        private Color background;

        private TextFieldToolTip(Frame frame) {
            super(frame);
            this.setLayout(null);
            this.foreground = Color.black;
            this.background = Color.white;
        }

        private void setText(String msg) {
            this.text = msg;
            FontMetrics fm = window.getFontMetrics(font);
            this.delta = fm.getHeight();
            int w = fm.stringWidth(this.text) + 8;
            int h = this.delta + 4;
            this.setSize(w, h);
        }

        public void checkLocation() {
            GraphicsDevice device;
            int x = this.getLocation().x;
            int y = this.getLocation().y;
            int w = this.getSize().width;
            int h = this.getSize().height;
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] devices = env.getScreenDevices();
            Rectangle currentDimensions = null;
            GraphicsDevice[] graphicsDeviceArray = devices;
            int n = graphicsDeviceArray.length;
            for (int i = 0; i < n && !(currentDimensions = (device = graphicsDeviceArray[i]).getDefaultConfiguration().getBounds()).contains(this.getLocation()); ++i) {
            }
            if (currentDimensions != null) {
                int y_difference;
                int x_difference = this.getLocation().x + w + 5 - (currentDimensions.x + currentDimensions.width);
                if (x_difference > 0) {
                    x -= x_difference;
                }
                if ((y_difference = this.getLocation().y + h + 5 - (currentDimensions.y + currentDimensions.height)) > 0) {
                    y -= y_difference;
                    y -= h * 2;
                }
            }
            this.setLocation(x, y);
        }

        @Override
        public void paint(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            g.setColor(this.foreground);
            g.fillRect(0, 0, w, h);
            g.setColor(this.background);
            g.fillRect(1, 1, w - 2, h - 2);
            g.setColor(this.foreground);
            g.setFont(font);
            g.drawString(this.text, 4, this.delta);
        }
    }
}

