/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.platform.ui.util.BTextOutputPane;
import com.tridium.util.ThrowableUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidgetShell;
import javax.baja.util.Lexicon;

public abstract class BInputStreamPane
extends BTextOutputPane {
    public static final Type TYPE = Sys.loadType(BInputStreamPane.class);
    public static final int BUFFER_TIME_MAX = 3000;
    protected static final Lexicon lex = Lexicon.make((String)"platform");
    protected int bufferTime = 3000;
    protected OutputWatcher watcher = null;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BInputStreamPane() {
        this(20, 80);
    }

    protected BInputStreamPane(int rows, int cols) {
        super(rows, cols);
        this.setUseAutoScroll(true);
    }

    protected abstract InputStream getInputStream();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        InputStream stream = this.getInputStream();
        BInputStreamPane bInputStreamPane = this;
        synchronized (bInputStreamPane) {
            if (stream != null) {
                this.stopUpdates();
                this.startUpdates(new OutputWatcher(stream));
            }
        }
    }

    public void setBufferTime(int value) {
        this.bufferTime = value;
    }

    public int getBufferTime() {
        return this.bufferTime;
    }

    protected synchronized void startUpdates(OutputWatcher value) {
        this.watcher = value;
        this.watcher.start();
    }

    public synchronized void stopUpdates() {
        if (this.watcher != null) {
            this.watcher.stopWatcher();
            this.watcher = null;
        }
    }

    public void clearValue() {
        this.stopUpdates();
        this.clear();
    }

    public synchronized void clearText() throws Exception {
        if (this.watcher == null) {
            this.clear();
        } else {
            this.watcher.clearOutput();
        }
    }

    public void deactivated() {
        this.stopUpdates();
    }

    @Override
    public void stopped() throws Exception {
        super.stopped();
        this.stopUpdates();
    }

    public class OutputWatcher
    extends Thread {
        private final InputStream in;
        private boolean stopped;
        private boolean clearBuffer;
        private static final String clearSync = "sync";
        private BWidgetShell shell;

        public OutputWatcher(InputStream pIn) {
            super("InputStreamPane:OutputWatcher");
            this.stopped = true;
            this.clearBuffer = false;
            this.in = pIn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            boolean busyShowing = true;
            this.stopped = false;
            byte[] buf = new byte[8192];
            StringBuffer pendingDisplay = new StringBuffer();
            long startTicks = Clock.ticks();
            BInputStreamPane.this.setText("");
            try {
                this.shell = BInputStreamPane.this.getShell();
                if (this.shell != null) {
                    this.shell.enterBusy();
                }
                while (!this.stopped) {
                    int numRead;
                    long lastRead;
                    block26: {
                        String string = clearSync;
                        // MONITORENTER : "sync"
                        this.clearBuffer = false;
                        // MONITOREXIT : string
                        try {
                            lastRead = Clock.ticks();
                            numRead = this.in.read(buf, 0, 8192);
                            if (!busyShowing) break block26;
                            if (this.shell != null) {
                                this.shell.exitBusy();
                            }
                            busyShowing = false;
                        }
                        catch (NullPointerException npe) {
                            if (!busyShowing) throw new IOException();
                            if (this.shell != null) {
                                this.shell.exitBusy();
                            }
                            busyShowing = false;
                            throw new IOException();
                        }
                        catch (InterruptedIOException ignored) {
                            if (pendingDisplay.length() > 0) {
                                BInputStreamPane.this.append(pendingDisplay.toString());
                                pendingDisplay = new StringBuffer();
                            }
                            if (!busyShowing) continue;
                            if (this.shell != null) {
                                this.shell.exitBusy();
                            }
                            busyShowing = false;
                            continue;
                        }
                    }
                    String ignored = clearSync;
                    // MONITORENTER : "sync"
                    if (this.clearBuffer) {
                        numRead = 0;
                        this.clearBuffer = false;
                    }
                    // MONITOREXIT : ignored
                    if (this.stopped) continue;
                    if (numRead >= 0) {
                        if (lastRead - startTicks > (long)BInputStreamPane.this.bufferTime) {
                            if (pendingDisplay.length() > 0) {
                                BInputStreamPane.this.append(pendingDisplay.toString());
                                pendingDisplay = new StringBuffer();
                            }
                            BInputStreamPane.this.append(new String(buf, 0, numRead, StandardCharsets.UTF_8));
                            continue;
                        }
                        pendingDisplay.append(new String(buf, 0, numRead, StandardCharsets.UTF_8));
                        continue;
                    }
                    if (pendingDisplay.length() > 0) {
                        BInputStreamPane.this.append(pendingDisplay.toString());
                        pendingDisplay = new StringBuffer();
                    }
                    this.stopWatcher(false);
                }
                return;
            }
            catch (EOFException eof) {
                BInputStreamPane.this.append(pendingDisplay.toString());
                String message = "\n" + lex.getText("InputStreamPane.eof");
                BInputStreamPane.this.append(message.getBytes(), 0, message.length());
                return;
            }
            catch (IOException ioe) {
                BInputStreamPane.this.append(pendingDisplay.toString());
                if (this.stopped) return;
                String message = "\n" + lex.getText("InputStreamPane.ioe", new Object[]{ThrowableUtil.dumpToString((Throwable)ioe)});
                BInputStreamPane.this.append(message.getBytes(), 0, message.length());
                System.err.println("Error occurred reading output: ");
                ioe.printStackTrace(System.err);
                return;
            }
            finally {
                if (busyShowing && this.shell != null) {
                    this.shell.exitBusy();
                }
                this.stopWatcher(false);
            }
        }

        public void stopWatcher() {
            this.stopWatcher(true);
        }

        public void stopWatcher(boolean waitForNotify) {
            if (this.stopped) {
                return;
            }
            this.clearBuffer = false;
            this.stopped = true;
            new Thread(() -> {
                try {
                    this.in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }).start();
            if (waitForNotify) {
                try {
                    this.join();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearOutput() {
            String string = clearSync;
            synchronized (clearSync) {
                BInputStreamPane.this.clear();
                this.clearBuffer = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

