/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.platform.ui.util.BBox;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.LexiconText;

public class BIndentPane
extends BGridPane {
    public static final Type TYPE = Sys.loadType(BIndentPane.class);
    private BIndentPane contentPane;
    private int indentWidth;
    public static int DEFAULT_WIDTH = 6;

    public Type getType() {
        return TYPE;
    }

    public BIndentPane() {
        this(DEFAULT_WIDTH);
    }

    private BIndentPane(int indentWidth) {
        super(1);
        this.setValign(BValign.top);
        this.setHalign(BHalign.left);
        this.contentPane = this;
        this.indentWidth = indentWidth;
    }

    public void setIndentWidth(int value) {
        this.indentWidth = value;
        if (this.contentPane != this) {
            this.contentPane.setIndentWidth(value);
        }
    }

    public int getIndentWidth() {
        return this.indentWidth;
    }

    public void indent(int nLevels) {
        if (nLevels < 0) {
            this.unindent(-1 * nLevels);
        } else {
            for (int i = 0; i < nLevels; ++i) {
                this.indent();
            }
        }
    }

    public void indent() {
        if (this.contentPane == this) {
            BGridPane indentGrid = new BGridPane(2);
            indentGrid.setValign(BValign.top);
            indentGrid.setHalign(BHalign.left);
            indentGrid.add("box", (BValue)new BBox(this.indentWidth, 0.0));
            this.contentPane = new BIndentPane(this.getIndentWidth());
            indentGrid.add("content", (BValue)this.contentPane);
            super.add(null, (BValue)indentGrid);
        } else {
            this.contentPane.indent();
        }
    }

    public void unindentAll() {
        this.contentPane = this;
    }

    public void unindent(int nLevels) {
        if (nLevels < 0) {
            this.indent(-1 * nLevels);
        } else {
            for (int i = 0; i < nLevels; ++i) {
                this.unindent();
            }
        }
    }

    public boolean unindent() {
        if (this.contentPane == this) {
            return false;
        }
        if (!this.contentPane.unindent()) {
            this.contentPane = this;
        }
        return true;
    }

    public void add(BWidget widget) {
        if (this.contentPane == this) {
            super.add(null, (BValue)widget);
        } else {
            this.contentPane.add(widget);
        }
    }

    public void add(String text) {
        this.add((BWidget)new BLabel(text, BHalign.left));
    }

    public void add(LexiconText text) {
        this.add((BWidget)new BLabel(text.getText(null), BHalign.left));
    }

    public void add(LexiconText text, Context cx) {
        this.add((BWidget)new BLabel(text.getText(cx), BHalign.left));
    }

    public void add(LexiconText text, Object[] args) {
        this.add((BWidget)new BLabel(text.getText(null, args), BHalign.left));
    }

    public void add(LexiconText text, Object[] args, Context cx) {
        this.add((BWidget)new BLabel(text.getText(cx, args), BHalign.left));
    }

    public void clear() {
        this.removeAll();
        this.unindentAll();
    }
}

