/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.BFileChooserListView;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.IFilePathFilter;
import com.tridium.ui.file.BTreeView;
import com.tridium.ui.file.FileChooserModel;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nav.BINavNode;
import javax.baja.space.BSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;

public class BFileChooserDialog
extends BEdgePane {
    public static final Type TYPE = Sys.loadType(BFileChooserDialog.class);
    private BCommandDialog dialog = null;
    private FileChooserModel model;
    private BFileChooserListView listView;
    private BTreeView treeView;
    private IFilePathFilter selectionPathFilter;
    private IFileFilter selectionFileFilter;
    private BLabel currentDirectoryLabel;
    private BTextField fileNameTextField;
    private static Lexicon lex = null;

    public Type getType() {
        return TYPE;
    }

    private BFileChooserDialog(BImage icon, String title, String message, BIFile initialDir, IFileFilter displayFilter, IFileFilter selectionFileFilter, IFilePathFilter selectionPathFilter, BFileChooserListView.ListModel listModel, boolean selectMulti, boolean showTextField, String defTextFieldContents) {
        this.model = initialDir == null ? new FileChooserModel((BSpace)BFileSystem.INSTANCE) : new FileChooserModel((BSpace)initialDir.getFileSpace());
        this.model.setFilter(displayFilter);
        this.model.setSupport((FileChooserModel.Support)new FileBrowserSupport());
        this.listView = new BFileChooserListView(this.model);
        if (listModel == null) {
            this.listView.setDetailsView();
        } else {
            this.listView.setView(listModel, true);
        }
        this.listView.setMultipleSelection(selectMulti);
        this.treeView = new BTreeView(this.model);
        this.treeView.setController((TreeController)new Controller());
        this.selectionPathFilter = selectionPathFilter == null ? new IFilePathFilter(){

            @Override
            public boolean accept(FilePath p) {
                return true;
            }
        } : selectionPathFilter;
        this.selectionFileFilter = selectionFileFilter == null ? new IFileFilter(){

            public boolean accept(BIFile f) {
                return true;
            }

            public String getDescription(Context c) {
                return "";
            }
        } : selectionFileFilter;
        BSplitPane split = new BSplitPane();
        split.setDividerPosition(33.0);
        split.setWidget1((BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)this.treeView), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        BFlowPane toolFlow = new BFlowPane(BHalign.left);
        this.currentDirectoryLabel = new BLabel();
        toolFlow.add(null, (BValue)this.currentDirectoryLabel);
        BToolBar tools = new BToolBar();
        tools.add(null, (BValue)new BSeparator());
        tools.add(null, (Command)new HomeCommand());
        tools.add(null, (Command)new UpLevelCommand());
        toolFlow.add(null, (BValue)tools);
        BEdgePane fileNamePane = null;
        this.fileNameTextField = new BTextField("", 32);
        this.fileNameTextField.setModel(new TextModel(){

            protected void textModified() {
                BFileChooserDialog.this.checkDialogButtonState();
            }
        });
        if (showTextField) {
            fileNamePane = new BEdgePane(null, null, (BWidget)new BBorderPane((BWidget)new BLabel(this.getLexicon().getText("FileChooserDialog.fileName")), BInsets.make((double)4.0, (double)4.0, (double)0.0, (double)0.0)), null, (BWidget)new BBorderPane((BWidget)this.fileNameTextField, BInsets.make((double)4.0, (double)0.0, (double)0.0, (double)0.0)));
        }
        split.setWidget2((BWidget)new BEdgePane((BWidget)toolFlow, fileNamePane, null, null, (BWidget)new BBorderPane((BWidget)this.listView, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0))));
        this.setTop((BWidget)new BWizardHeader(icon, title, message == null ? "" : message));
        BConstrainedPane pane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)split, 6.0, 4.0, 4.0, 4.0));
        pane.setFixedSize(550.0, 330.0);
        this.setCenter((BWidget)pane);
        if (initialDir != null && initialDir.isDirectory()) {
            this.model.setDirectory((BINavNode)initialDir);
            this.treeView.scrollToVisible((BINavNode)initialDir);
            this.currentDirectoryLabel.setImage(BImage.make((BIcon)initialDir.getNavIcon()));
            this.currentDirectoryLabel.setText(initialDir.getNavDisplayName(null));
        }
        if (defTextFieldContents != null) {
            this.fileNameTextField.setText(defTextFieldContents);
        }
    }

    public static BIFile[] chooseFiles(BWidget owner, BImage dlgIcon, String dlgTitle, String dlgMessage, BIFile initialDir, IFileFilter displayFilter, IFileFilter selectionFileFilter) {
        return BFileChooserDialog.chooseFiles(owner, dlgIcon, dlgTitle, dlgMessage, initialDir, displayFilter, selectionFileFilter, null);
    }

    public static BIFile[] chooseFiles(BWidget owner, BImage dlgIcon, String dlgTitle, String dlgMessage, BIFile initialDir, IFileFilter displayFilter, IFileFilter selectionFileFilter, BFileChooserListView.ListModel listModel) {
        BFileChooserDialog content = new BFileChooserDialog(dlgIcon, dlgTitle, dlgMessage, initialDir, displayFilter, selectionFileFilter, null, listModel, true, false, null);
        if (1 == BCommandDialog.open(owner, dlgTitle, (Object)content, 3)) {
            return content.getSelectedFiles();
        }
        return new BIFile[0];
    }

    public static BIFile chooseFile(BWidget owner, BImage dlgIcon, String dlgTitle, String dlgMessage, BIFile initialDir, IFileFilter displayFilter, IFileFilter selectionFileFilter) {
        return BFileChooserDialog.chooseFile(owner, dlgIcon, dlgTitle, dlgMessage, initialDir, displayFilter, selectionFileFilter, null);
    }

    public static BIFile chooseFile(BWidget owner, BImage dlgIcon, String dlgTitle, String dlgMessage, BIFile initialDir, IFileFilter displayFilter, IFileFilter selectionFileFilter, BFileChooserListView.ListModel listModel) {
        BFileChooserDialog content = new BFileChooserDialog(dlgIcon, dlgTitle, dlgMessage, initialDir, displayFilter, selectionFileFilter, null, listModel, false, false, null);
        if (1 == BCommandDialog.open(owner, dlgTitle, (Object)content, 3)) {
            return content.getSelectedFile();
        }
        return null;
    }

    public static FilePath chooseFilePath(BWidget owner, BImage dlgIcon, String dlgTitle, String dlgMessage, BIFile initialDir, IFileFilter displayFilter, IFilePathFilter selectionPathFilter, BFileChooserListView.ListModel listModel, String defFileName) {
        BFileChooserDialog content = new BFileChooserDialog(dlgIcon, dlgTitle, dlgMessage, initialDir, displayFilter, null, selectionPathFilter, listModel, false, true, defFileName);
        if (1 == BCommandDialog.open(owner, dlgTitle, (Object)content, 3)) {
            return content.getSelectedFilePath();
        }
        return null;
    }

    public static BIFile[] chooseFiles(BWidget owner, String dlgMessage) {
        return BFileChooserDialog.chooseFiles(owner, BImage.make((String)BFileChooserDialog.lex().getText("FileChooserDialog.file.icon")), BFileChooserDialog.lex().getText("FileChooserDialog.files.title"), dlgMessage, null, IFileFilter.all, new IFileFilter(){

            public boolean accept(BIFile file) {
                return !(file instanceof BIDirectory);
            }

            public String getDescription(Context cx) {
                return "TODO";
            }
        }, null);
    }

    public static BIFile chooseFile(BWidget owner, String dlgMessage) {
        return BFileChooserDialog.chooseFile(owner, BImage.make((String)BFileChooserDialog.lex().getText("FileChooserDialog.file.icon")), BFileChooserDialog.lex().getText("FileChooserDialog.file.title"), dlgMessage, null, IFileFilter.all, new IFileFilter(){

            public boolean accept(BIFile file) {
                return !(file instanceof BIDirectory);
            }

            public String getDescription(Context cx) {
                return "TODO";
            }
        }, null);
    }

    public static FilePath chooseFilePath(BWidget owner, String dlgMessage) {
        return BFileChooserDialog.chooseFilePath(owner, BImage.make((String)BFileChooserDialog.lex().getText("FileChooserDialog.file.icon")), BFileChooserDialog.lex().getText("FileChooserDialog.file.title"), dlgMessage, null, IFileFilter.all, null, null, null);
    }

    public static BIFile[] chooseDirectories(BWidget owner, String dlgMessage) {
        return BFileChooserDialog.chooseFiles(owner, BImage.make((String)BFileChooserDialog.lex().getText("FileChooserDialog.dir.icon")), BFileChooserDialog.lex().getText("FileChooserDialog.dirs.title"), dlgMessage, null, IFileFilter.directory, null, null);
    }

    public static BIFile chooseDirectory(BWidget owner, String dlgMessage) {
        return BFileChooserDialog.chooseFile(owner, BImage.make((String)BFileChooserDialog.lex().getText("FileChooserDialog.dir.icon")), BFileChooserDialog.lex().getText("FileChooserDialog.dir.title"), dlgMessage, null, IFileFilter.directory, null, null);
    }

    public void setDialog(BCommandDialog value) {
        this.dialog = value;
        this.checkDialogButtonState();
    }

    public BCommandDialog getDialog() {
        if (this.dialog == null) {
            for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof BCommandDialog)) continue;
                this.dialog = (BCommandDialog)parent;
                break;
            }
        }
        return this.dialog;
    }

    public BIFile[] getSelectedFiles() {
        return this.model.getSelectedFiles();
    }

    public FilePath getSelectedFilePath() {
        return ((BIFile)this.model.getDirectory()).getFilePath().merge(this.fileNameTextField.getText());
    }

    public BIFile getSelectedFile() {
        BIFile[] selection = this.getSelectedFiles();
        return selection.length == 0 ? null : selection[0];
    }

    public void started() {
        this.checkDialogButtonState();
    }

    protected void checkDialogButtonState() {
        Command c;
        if (this.getDialog() != null && (c = this.getDialog().getButtonCommand(1)) != null) {
            c.setEnabled(this.fileNameTextField.getText().trim().length() > 0 && this.model.getDirectory() != null && this.model.getDirectory() instanceof BDirectory && this.selectionPathFilter.accept(((BDirectory)this.model.getDirectory()).getFilePath().merge(this.fileNameTextField.getText().trim())));
        }
    }

    private static Lexicon lex() {
        if (lex == null) {
            lex = TYPE.getModule().getLexicon();
        }
        return lex;
    }

    class Controller
    extends TreeController {
        Controller() {
        }

        protected void mouseSelection(TreeNode target, BMouseEvent evt) {
            super.mouseSelection(target, evt);
            BFileChooserDialog.this.listView.getSelection().deselectAll();
        }

        protected void doSelectAction(TreeNode target, double x, double y) {
            BINavNode navNode = BFileChooserDialog.this.treeView.getFileForNode(target);
            if (navNode != null) {
                BFileChooserDialog.this.model.setDirectory(navNode);
            }
        }
    }

    class HomeCommand
    extends Command {
        public HomeCommand() {
            super((BWidget)BFileChooserDialog.this, TYPE.getModule(), "FileChooserDialog.home");
        }

        public CommandArtifact doInvoke() {
            try {
                BDirectory dir = BFileSystem.INSTANCE.getSysHome();
                BFileChooserDialog.this.model.setDirectory((BINavNode)dir);
            }
            catch (Throwable t) {
                CommandUtil.error(this, t);
            }
            return null;
        }
    }

    class UpLevelCommand
    extends Command {
        public UpLevelCommand() {
            super((BWidget)BFileChooserDialog.this, TYPE.getModule(), "FileChooserDialog.upLevel");
        }

        public CommandArtifact doInvoke() {
            try {
                BFileChooserDialog.this.model.moveUpDirectory();
            }
            catch (Throwable t) {
                CommandUtil.error(this, t);
            }
            return null;
        }
    }

    class FileBrowserSupport
    extends FileChooserModel.Support {
        FileBrowserSupport() {
        }

        public void pathModified() {
            BFileChooserDialog.this.listView.populateChildren();
            BFileChooserDialog.this.listView.relayout();
            BIFile dir = (BIFile)BFileChooserDialog.this.model.getDirectory();
            if (dir != null) {
                BFileChooserDialog.this.treeView.scrollToVisible((BINavNode)dir);
                BFileChooserDialog.this.currentDirectoryLabel.setImage(BImage.make((BIcon)dir.getNavIcon()));
                BFileChooserDialog.this.currentDirectoryLabel.setText(dir.getNavDisplayName(null));
                BFileChooserDialog.this.currentDirectoryLabel.relayout();
            }
            BFileChooserDialog.this.checkDialogButtonState();
        }

        public void selectionModified() {
            BIFile[] selectedFiles = BFileChooserDialog.this.model.getSelectedFiles();
            if (selectedFiles.length == 0) {
                return;
            }
            BFileChooserDialog.this.treeView.getSelection().deselectAll();
            for (int i = 0; i < selectedFiles.length; ++i) {
                if (BFileChooserDialog.this.selectionPathFilter.accept(selectedFiles[i].getFilePath()) && BFileChooserDialog.this.selectionFileFilter.accept(selectedFiles[i])) continue;
                return;
            }
            BFileChooserDialog.this.fileNameTextField.setText(selectedFiles[0].getFileName());
        }

        public void chooseSelectedFiles() {
        }
    }
}

