/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.tcpip;

import com.tridium.platform.ui.tcpip.BIpHostFE;
import com.tridium.platform.ui.util.CommandUtil;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraAction(name="handleFocusChange", parameterType="BFocusEvent", defaultValue="new BFocusEvent()", flags=4)
public class BIpHostVectorFE
extends BWbFieldEditor {
    public static final Action handleFocusChange = BIpHostVectorFE.newAction((int)4, (BValue)new BFocusEvent(), null);
    public static final Type TYPE = Sys.loadType(BIpHostVectorFE.class);
    private boolean isIpv6 = false;
    private BGridPane contentPane;
    private BWbFieldEditor focusedEditor = null;
    private Command addCommand;
    private Command deleteCommand;
    private Command upCommand;
    private Command downCommand;
    private int maxHosts = 2;
    public static final String MAX_HOSTS = "maxHosts";

    public void handleFocusChange(BFocusEvent parameter) {
        this.invoke(handleFocusChange, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIpHostVectorFE() {
        this(false);
    }

    public BIpHostVectorFE(boolean isIpv6Vector) {
        this.isIpv6 = isIpv6Vector;
        BFlowPane toolbarPane = new BFlowPane(BHalign.center);
        BToolBar toolbar = new BToolBar();
        toolbarPane.add(null, (BValue)toolbar, null);
        this.addCommand = new AddCommand();
        BButton button = new BButton(this.addCommand);
        toolbar.add("add", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.toolBar);
        this.deleteCommand = new DeleteCommand();
        button = new BButton(this.deleteCommand);
        toolbar.add("delete", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.toolBar);
        this.upCommand = new UpCommand();
        button = new BButton(this.upCommand);
        toolbar.add("up", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.toolBar);
        this.downCommand = new DownCommand();
        button = new BButton(this.downCommand);
        toolbar.add("down", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.toolBar);
        BGridPane outerGrid = new BGridPane(1);
        this.contentPane = new BGridPane(1);
        outerGrid.add(null, (BValue)this.contentPane);
        outerGrid.add(null, (BValue)toolbarPane);
        outerGrid.setHalign(BHalign.left);
        outerGrid.setColumnAlign(BHalign.center);
        this.setContent((BWidget)outerGrid);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        try {
            this.maxHosts = cx == null ? 2 : cx.getFacets().geti(MAX_HOSTS, 2);
            BVector vector = (BVector)value;
            this.contentPane.removeAll();
            SlotCursor c = vector.loadSlots().getProperties();
            while (c.next(BString.class)) {
                this.addElement(c.get());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BVector vector = (BVector)value;
        vector.lease();
        vector.removeAll();
        if (vector.getSlotCount() > 0) {
            throw new Exception("Failed to remove DNS slots");
        }
        for (BWidget child : this.contentPane.getChildWidgets()) {
            BString fieldValue = (BString)((BWbFieldEditor)child).saveValue(cx);
            if (fieldValue.toString().trim().length() == 0) {
                throw new LocalizableRuntimeException("platform", "IpHostVectorFE.emptyDnsHost");
            }
            String propName = SlotPath.escape((String)fieldValue.toString());
            if (vector.getProperty(propName) != null) {
                throw new LocalizableRuntimeException("platform", "IpHostVectorFE.duplicate", new Object[]{fieldValue});
            }
            vector.add(propName, (BValue)fieldValue, 1, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platform:IpHostFE")), null);
        }
        if (vector.getSlotCount() != this.contentPane.getChildWidgets().length) {
            throw new Exception("Failed to add DNS slots");
        }
        return vector;
    }

    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.deleteCommand.setEnabled(isEnabled && this.focusedEditor != null);
        BWidget[] children = this.contentPane.getChildWidgets();
        this.addCommand.setEnabled(isEnabled && children.length < this.maxHosts);
        for (BWidget child : children) {
            child.setEnabled(isEnabled);
        }
    }

    protected void doSetReadonly(boolean readonly) {
        BWidget[] children;
        this.setEnabled(!readonly);
        for (BWidget child : children = this.contentPane.getChildWidgets()) {
            ((BWbFieldEditor)child).setReadonly(readonly);
        }
    }

    public void addElements(BValue[] values) {
        for (BValue value : values) {
            this.addElement(value);
        }
    }

    public void addElement(BValue value) {
        BIpHostFE editor = new BIpHostFE(this.isIpv6);
        editor.loadValue((BObject)value);
        this.contentPane.add(null, (BValue)editor, 0);
        editor.setEnabled(this.isEnabled());
        this.getContent().relayout();
        this.getContent().computePreferredSize();
        this.linkTo(null, (BComponent)editor, (Slot)BWbFieldEditor.focusEvent, (Slot)handleFocusChange);
        this.linkTo(null, (BComponent)editor, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified);
        this.setModified();
        this.setEnabled(this.isEnabled());
    }

    public void doHandleFocusChange(BFocusEvent evt) {
        try {
            if (!this.isEnabled()) {
                return;
            }
            if (evt.getId() == 1005) {
                if (this.focusedEditor == evt.getWidget()) {
                    this.focusedEditor = null;
                }
            } else if (evt.getId() == 1004) {
                this.focusedEditor = (BWbFieldEditor)evt.getWidget();
            }
            this.setArrowCommandEnabledStates();
            this.deleteCommand.setEnabled(this.focusedEditor != null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Property[] getDynamicPropertiesArray(BObject obj, boolean autoLoad) {
        if (autoLoad) {
            obj.asComplex().loadSlots();
        }
        Property[] allProps = obj.asComplex().getPropertiesArray();
        for (int i = 0; i < allProps.length; ++i) {
            if (allProps[i].isFrozen()) continue;
            Property[] result = new Property[allProps.length - i];
            System.arraycopy(allProps, i, result, 0, result.length);
            return result;
        }
        return new Property[0];
    }

    private void setArrowCommandEnabledStates() {
        BWidget[] children = this.contentPane.getChildWidgets();
        if (children.length > 1 && this.focusedEditor != null) {
            this.upCommand.setEnabled(children[0] != this.focusedEditor);
            this.downCommand.setEnabled(children[children.length - 1] != this.focusedEditor);
        } else {
            this.upCommand.setEnabled(false);
            this.downCommand.setEnabled(false);
        }
    }

    private class DownCommand
    extends Command {
        public DownCommand() {
            super((BWidget)BIpHostVectorFE.this, "", BImage.make((BIcon)BIcon.std((String)"arrowDown.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                Property[] props = BIpHostVectorFE.getDynamicPropertiesArray((BObject)BIpHostVectorFE.this.contentPane, true);
                for (int i = 0; i < props.length; ++i) {
                    if (BIpHostVectorFE.this.focusedEditor != BIpHostVectorFE.this.contentPane.get(props[i])) continue;
                    Property temp = props[i];
                    props[i] = props[i + 1];
                    props[i + 1] = temp;
                    BIpHostVectorFE.this.contentPane.reorder(props);
                    BIpHostVectorFE.this.setModified();
                    BIpHostVectorFE.this.setArrowCommandEnabledStates();
                    return null;
                }
            }
            catch (Throwable t) {
                CommandUtil.error(this, t);
            }
            return null;
        }
    }

    private class UpCommand
    extends Command {
        public UpCommand() {
            super((BWidget)BIpHostVectorFE.this, "", BImage.make((BIcon)BIcon.std((String)"arrowUp.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                Property[] props = BIpHostVectorFE.getDynamicPropertiesArray((BObject)BIpHostVectorFE.this.contentPane, true);
                for (int i = 0; i < props.length; ++i) {
                    if (BIpHostVectorFE.this.focusedEditor != BIpHostVectorFE.this.contentPane.get(props[i])) continue;
                    Property temp = props[i];
                    props[i] = props[i - 1];
                    props[i - 1] = temp;
                    BIpHostVectorFE.this.contentPane.reorder(props);
                    BIpHostVectorFE.this.setModified();
                    BIpHostVectorFE.this.setArrowCommandEnabledStates();
                    return null;
                }
            }
            catch (Throwable t) {
                CommandUtil.error(this, t);
            }
            return null;
        }
    }

    private class AddCommand
    extends Command {
        public AddCommand() {
            super((BWidget)BIpHostVectorFE.this, "", BImage.make((BIcon)BIcon.std((String)"add.png")), null, "");
        }

        public CommandArtifact doInvoke() {
            BIpHostVectorFE.this.addElement((BValue)BString.DEFAULT);
            BIpHostVectorFE.this.setArrowCommandEnabledStates();
            this.setEnabled(BIpHostVectorFE.this.contentPane.getChildWidgets().length < BIpHostVectorFE.this.maxHosts);
            return null;
        }
    }

    private class DeleteCommand
    extends Command {
        public DeleteCommand() {
            super((BWidget)BIpHostVectorFE.this, "", BImage.make((BIcon)BIcon.std((String)"delete.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            if (BIpHostVectorFE.this.focusedEditor == null) {
                return null;
            }
            try {
                SlotCursor c = BIpHostVectorFE.this.contentPane.loadSlots().getProperties();
                while (c.next(BWbFieldEditor.class)) {
                    if (c.get() != BIpHostVectorFE.this.focusedEditor) continue;
                    BIpHostVectorFE.this.contentPane.remove(c.property());
                    BIpHostVectorFE.this.focusedEditor = null;
                    BIpHostVectorFE.this.deleteCommand.setEnabled(false);
                    BIpHostVectorFE.this.addCommand.setEnabled(true);
                    BIpHostVectorFE.this.setModified();
                    BIpHostVectorFE.this.setArrowCommandEnabledStates();
                    BIpHostVectorFE.this.relayout();
                    return null;
                }
            }
            catch (Throwable t) {
                CommandUtil.error(this, t);
            }
            return null;
        }
    }
}

