/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.ntp;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.ntp.BNtpServer;
import com.tridium.platform.ui.util.BCoordinatedGridPane;
import com.tridium.ui.util.LabelUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.util.LexiconText;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BNtpServerFE
extends BWbFieldEditor {
    public static final Action propagateFocusEvent = BNtpServerFE.newAction((int)4, (BValue)new BFocusEvent(), null);
    public static final Action propagateKeyEvent = BNtpServerFE.newAction((int)4, (BValue)new BKeyEvent(), null);
    public static final Action propagateMouseEvent = BNtpServerFE.newAction((int)4, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType(BNtpServerFE.class);
    boolean readonlyInitialized = false;
    protected BCoordinatedGridPane grid = new BCoordinatedGridPane(1);
    protected BTextField addressFe;

    public void propagateFocusEvent(BFocusEvent arg) {
        this.invoke(propagateFocusEvent, (BValue)arg, null);
    }

    public void propagateKeyEvent(BKeyEvent arg) {
        this.invoke(propagateKeyEvent, (BValue)arg, null);
    }

    public void propagateMouseEvent(BMouseEvent arg) {
        this.invoke(propagateMouseEvent, (BValue)arg, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNtpServerFE() {
        this.grid.setHalign(BHalign.left);
        this.grid.setColumnAlign(BHalign.center);
        this.addressFe = new BTextField("", 32);
        this.grid.add(null, (BValue)this.addressFe);
        this.linkTo((BComponent)this.addressFe, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo((BComponent)this.addressFe, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.linkTo((BComponent)this.addressFe, (Slot)BTextField.focusEvent, (Slot)propagateFocusEvent);
        this.linkTo((BComponent)this.addressFe, (Slot)BTextField.keyEvent, (Slot)propagateKeyEvent);
        this.linkTo((BComponent)this.addressFe, (Slot)BTextField.mouseEvent, (Slot)propagateMouseEvent);
        this.setContent((BWidget)this.grid);
    }

    public void doValidate(Context cx) throws Exception {
        String host = this.addressFe.getText();
        if (host.trim().length() == 0) {
            throw new LocalizableRuntimeException("platform", "NtpServerFE.nullAddress");
        }
        if (!(IPAddressUtil.isNumericAddr((String)host) || IPAddressUtil.isNumericAddr((String)IPAddressUtil.removeScopeSpec((String)host)) || IPAddressUtil.isHostname((String)host))) {
            throw new LocalizableRuntimeException("platform", "NtpServerFE.invalidHost", new Object[]{host});
        }
    }

    public String getServerPropertyName(Context cx) throws Exception {
        return ((BNtpServer)this.getCurrentValue()).getPropertyName(this.addressFe.getText());
    }

    public BWidget makeHeader() {
        BCoordinatedGridPane header = new BCoordinatedGridPane(1);
        header.setHalign(BHalign.left);
        header.setColumnAlign(BHalign.center);
        header.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"NtpPlatformService.address.label"), (boolean)true));
        return header;
    }

    public void useHeader(BWidget header) {
        if (header != null) {
            this.grid.setMaster((BCoordinatedGridPane)header);
        }
    }

    public void doPropagateFocusEvent(BFocusEvent evt) {
        this.fireFocusEvent(new BFocusEvent(evt.getId(), (BWidget)this, evt.isTemporary()));
    }

    public void doPropagateKeyEvent(BKeyEvent evt) {
        this.fireKeyEvent(new BKeyEvent(evt.getId(), (BWidget)this, evt.getModifiers(), evt.getKeyCode(), evt.getKeyChar()));
    }

    public void doPropagateMouseEvent(BMouseEvent evt) {
        if (evt instanceof BMouseWheelEvent) {
            this.fireMouseEvent((BMouseEvent)new BMouseWheelEvent(evt.getId(), (BWidget)this, evt.getModifiers(), evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger(), ((BMouseWheelEvent)evt).getWheelRotation()));
        } else {
            this.fireMouseEvent(new BMouseEvent(evt.getId(), (BWidget)this, evt.getModifiers(), evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger()));
        }
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BComplex parent;
        BNtpServer server = (BNtpServer)value;
        if (!this.readonlyInitialized && (parent = server.getParent()) != null) {
            this.setReadonly((parent.loadSlots().getFlags((Slot)server.getPropertyInParent()) & 1) > 0);
        }
        this.addressFe.setText(server.getAddress());
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BNtpServer server = (BNtpServer)value;
        server.setAddress(this.addressFe.getText());
        return server;
    }

    protected void doSetReadonly(boolean readonly) {
        this.readonlyInitialized = true;
        this.addressFe.setEditable(!readonly);
    }
}

