/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.license;

import com.tridium.file.types.text.BLicenseFile;
import com.tridium.platform.license.BEnvLicenseSummary;
import com.tridium.platform.license.BLicenseArchiveFile;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.ExtPathFilter;
import com.tridium.platform.ui.util.FavoriteDirectory;
import com.tridium.platform.ui.util.IFilePathFilter;
import com.tridium.sys.license.dom.CertificateDatabase;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.sys.license.dom.VendorLicense;
import com.tridium.util.ArrayUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.space.Mark;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class BWorkbenchLicenseTree
extends BTree {
    public static final Action handleSelectionModified = BWorkbenchLicenseTree.newAction((int)0, null);
    public static final Topic valueUpdated = BWorkbenchLicenseTree.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BWorkbenchLicenseTree.class);
    private static final BIcon HOST_ICON = BIcon.std((String)"host.png");
    private static final BIcon LICENSE_ICON = BIcon.std((String)"file.png");
    private static final IFileFilter LAR_FILTER = new ExtFileFilter("TODO", "lar");
    private static final IFilePathFilter LAR_PATH_FILTER = new ExtPathFilter("lar");
    private static final IFileFilter LICENSE_FILTER = new ExtFileFilter("TODO", "license,lar");
    private static final Lexicon LEX = Lexicon.make((String)"platform");
    private Command importFile = new ImportFile();
    private Command exportFile = new ExportFile();
    private Command delete = new Delete();
    private SyncOnline syncOnline = new SyncOnline();

    public void handleSelectionModified() {
        this.invoke(handleSelectionModified, null, null);
    }

    public void fireValueUpdated(BValue event) {
        this.fire(valueUpdated, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BWorkbenchLicenseTree() {
        this.setModel(new Model());
        this.setMultipleSelection(true);
        this.linkTo(null, (BComponent)this, (Slot)BTree.selectionModified, (Slot)handleSelectionModified);
    }

    public String getDetailsText() throws Exception {
        TreeNode[] selected = this.getSelection().getNodes();
        if (selected.length == 1 && selected[0] instanceof LicenseNode) {
            return ((LicenseNode)selected[0]).getContents();
        }
        return "";
    }

    public void importLicenseArchive(BLicenseArchiveFile file, Context cx) throws Exception {
        LicenseDatabase.LOCAL_INSTANCE.importFile((BIFile)file);
        this.load(cx);
        BDialog.message((BWidget)this, (Object)LEX.getText("WorkbenchLicenseTree.importFile.success"));
    }

    public void load(Context cx) throws Exception {
        ((Model)this.getModel()).load(cx);
    }

    public void reload() throws Exception {
        ((Model)this.getModel()).reload();
    }

    public Command[] getCommands() {
        if (PortalLicenseUtil.requestLicensesOnline()) {
            return new Command[]{this.importFile, this.exportFile, this.delete, this.syncOnline};
        }
        return new Command[]{this.importFile, this.exportFile, this.delete};
    }

    public int dragOver(TransferContext cx) {
        if (cx.isCopy() && cx.getEnvelope().supports(TransferFormat.mark)) {
            Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
            for (BObject value : mark.getValues()) {
                if (!(value instanceof BLicenseFile) && !(value instanceof BLicenseArchiveFile)) continue;
                return 16;
            }
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext cx) throws Exception {
        if (cx.isCopy() && cx.getEnvelope().supports(TransferFormat.mark)) {
            Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
            boolean anyImported = false;
            for (BObject value : mark.getValues()) {
                if (!(value instanceof BLicenseFile) && !(value instanceof BLicenseArchiveFile)) continue;
                LicenseDatabase.LOCAL_INSTANCE.importFile((BIFile)value);
                anyImported = true;
            }
            if (anyImported) {
                this.load((Context)cx);
                BDialog.message((BWidget)this, (Object)LEX.getText("WorkbenchLicenseTree.importFile.success"));
            }
        }
        return null;
    }

    public void doHandleSelectionModified() {
        TreeNode[] selected = this.getSelection().getNodes();
        this.delete.setEnabled(selected.length > 0);
        this.fireValueUpdated(null);
    }

    private String[] getSelectedHostIds() {
        HashSet<String> hostIdSet = new HashSet<String>();
        for (TreeNode aSelected : this.getSelection().getNodes()) {
            if (aSelected instanceof HostNode) {
                hostIdSet.add(((HostNode)aSelected).getHostId());
                continue;
            }
            hostIdSet.add(((LicenseNode)aSelected).getHostId());
        }
        String[] result = new String[hostIdSet.size()];
        hostIdSet.toArray(result);
        return result;
    }

    private class SyncOnline
    extends AsyncCommand {
        public boolean canceled;

        public SyncOnline() {
            super((BWidget)BWorkbenchLicenseTree.this, LEX.getText("WorkbenchLicenseTree.syncOnline.label"), null, null, LEX.getText("WorkbenchLicenseTree.syncOnline.description"));
            this.canceled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doInvokeAsync() {
            block21: {
                try {
                    TreeNode[] selected = BWorkbenchLicenseTree.this.getSelection().getNodes();
                    int updatedLicenses = 0;
                    int updatedCerts = 0;
                    if (selected.length == 0) {
                        if (4 != BDialog.confirm((BWidget)BWorkbenchLicenseTree.this, (String)LEX.getText("WorkbenchLicenseTree.syncAll.confirmTitle"), (Object)LEX.getText("WorkbenchLicenseTree.syncAll.confirmMessage"))) {
                            return;
                        }
                        this.canceled = false;
                        BLabel progressLabel = new BLabel(LEX.getText("WorkbenchLicenseTree.syncAll.working", new Object[]{"0"}));
                        progressLabel.setHalign(BHalign.left);
                        BDialog dialog = new BDialog(this.getOwner(), LEX.getText("WorkbenchLicenseTree.syncAll.workingTitle"), false, (BWidget)new BEdgePane((BWidget)new BBox(300.0, 0.0), (BWidget)new BBorderPane((BWidget)new BButtonPane(new Command[]{new CancelSync()}), 0.0, 10.0, 10.0, 10.0), null, null, (BWidget)new BBorderPane((BWidget)progressLabel, 10.0, 10.0, 10.0, 10.0)));
                        dialog.setBoundsCenteredOnOwner();
                        dialog.open();
                        try {
                            ArrayList pending = new ArrayList();
                            Iterator licenses = LicenseDatabase.LOCAL_INSTANCE.iterator();
                            while (licenses.hasNext()) {
                                VendorLicense[] vendorLicenseArray;
                                if (this.canceled) {
                                    pending.clear();
                                    break;
                                }
                                pending.add(licenses.next());
                                if (pending.size() < 100) continue;
                                for (VendorLicense update : vendorLicenseArray = PortalLicenseUtil.getPortalUpdates((VendorLicense[])((VendorLicense[])ArrayUtil.arrayFromCollection(pending, VendorLicense[]::new)))) {
                                    if (!LicenseDatabase.LOCAL_INSTANCE.add(update)) continue;
                                    progressLabel.setText(LEX.getText("WorkbenchLicenseTree.syncAll.working", new Object[]{String.valueOf(++updatedLicenses)}));
                                }
                                pending.clear();
                            }
                            if (pending.size() > 0) {
                                for (VendorCertificate vendorCertificate : PortalLicenseUtil.getPortalUpdates((VendorLicense[])((VendorLicense[])ArrayUtil.arrayFromCollection(pending, VendorLicense[]::new)))) {
                                    if (!LicenseDatabase.LOCAL_INSTANCE.add((VendorLicense)vendorCertificate)) continue;
                                    progressLabel.setText(LEX.getText("WorkbenchLicenseTree.syncAll.working", new Object[]{String.valueOf(++updatedLicenses)}));
                                }
                            }
                            for (VendorCertificate vendorCertificate : PortalLicenseUtil.getPortalUpdates((VendorCertificate[])CertificateDatabase.LOCAL_INSTANCE.getCertificates())) {
                                if (!CertificateDatabase.LOCAL_INSTANCE.add(vendorCertificate)) continue;
                                progressLabel.setText(LEX.getText("WorkbenchLicenseTree.syncAll.cert.working", new Object[]{String.valueOf(++updatedCerts)}));
                            }
                        }
                        finally {
                            dialog.close();
                        }
                        if (updatedLicenses > 0 || updatedCerts > 0) {
                            BWorkbenchLicenseTree.this.reload();
                        }
                        BDialog.message((BWidget)this.getOwner(), (String)LEX.getText("WorkbenchLicenseTree.syncOnline.completeTitle"), (Object)new BEdgePane((BWidget)new BBox(300.0, 1.0), null, null, null, (BWidget)new BLabel(LEX.getText("WorkbenchLicenseTree.syncOnline.completeMessage", new Object[]{String.valueOf(updatedLicenses), String.valueOf(updatedCerts)}), BHalign.left)));
                        break block21;
                    }
                    ArrayList<BEnvLicenseSummary> pending = new ArrayList<BEnvLicenseSummary>();
                    for (TreeNode treeNode : selected) {
                        if (treeNode instanceof HostNode) {
                            HostNode hostNode = (HostNode)treeNode;
                            for (LicenseNode kid : hostNode.getChildren()) {
                                pending.add(BEnvLicenseSummary.make((VendorLicense)kid.getVendorLicense()));
                            }
                            continue;
                        }
                        LicenseNode licenseNode = (LicenseNode)treeNode;
                        pending.add(BEnvLicenseSummary.make((VendorLicense)licenseNode.getVendorLicense()));
                    }
                    for (TreeNode treeNode : PortalLicenseUtil.getPortalUpdates((BEnvLicenseSummary[])((BEnvLicenseSummary[])ArrayUtil.arrayFromCollection(pending, BEnvLicenseSummary[]::new)))) {
                        if (!LicenseDatabase.LOCAL_INSTANCE.add((VendorLicense)treeNode)) continue;
                        ++updatedLicenses;
                    }
                    for (TreeNode treeNode : PortalLicenseUtil.getPortalUpdates((VendorCertificate[])CertificateDatabase.LOCAL_INSTANCE.getCertificates())) {
                        if (!CertificateDatabase.LOCAL_INSTANCE.add((VendorCertificate)treeNode)) continue;
                        ++updatedCerts;
                    }
                    if (updatedLicenses > 0 || updatedCerts > 0) {
                        BWorkbenchLicenseTree.this.reload();
                    }
                    BDialog.message((BWidget)this.getOwner(), (String)LEX.getText("WorkbenchLicenseTree.syncOnline.completeTitle"), (Object)LEX.getText("WorkbenchLicenseTree.syncOnline.completeMessage", new Object[]{String.valueOf(updatedLicenses), String.valueOf(updatedCerts)}));
                }
                catch (Exception e) {
                    CommandUtil.error(this, e);
                }
            }
        }
    }

    private class CancelSync
    extends Command {
        public CancelSync() {
            super((BWidget)BWorkbenchLicenseTree.this, UiLexicon.bajaui().getText("cancel"), null, null, null);
        }

        public CommandArtifact doInvoke() {
            ((BWorkbenchLicenseTree)BWorkbenchLicenseTree.this).syncOnline.canceled = true;
            return null;
        }
    }

    private class Delete
    extends Command {
        public Delete() {
            super((BWidget)BWorkbenchLicenseTree.this, LEX.getText("WorkbenchLicenseTree.delete.label"), null, null, LEX.getText("WorkbenchLicenseTree.delete.description"));
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() throws Exception {
            TreeNode[] selectedNodes = BWorkbenchLicenseTree.this.getSelection().getNodes();
            if (selectedNodes.length > 0 && 4 == BDialog.confirm((BWidget)BWorkbenchLicenseTree.this, (String)LEX.getText("WorkbenchLicenseTree.delete.confirmTitle"), (Object)LEX.getText("WorkbenchLicenseTree.delete.confirmMessage"))) {
                for (TreeNode node : selectedNodes) {
                    if (node instanceof HostNode) {
                        for (int ixChild = 0; ixChild < node.getChildCount(); ++ixChild) {
                            LicenseDatabase.LOCAL_INSTANCE.remove(((LicenseNode)node.getChild(ixChild)).getVendorLicense());
                        }
                        continue;
                    }
                    LicenseDatabase.LOCAL_INSTANCE.remove(((LicenseNode)node).getVendorLicense());
                }
                BWorkbenchLicenseTree.this.getSelection().deselectAll();
                BWorkbenchLicenseTree.this.reload();
            }
            return null;
        }
    }

    private class ExportFile
    extends Command {
        public ExportFile() {
            super((BWidget)BWorkbenchLicenseTree.this, LEX.getText("WorkbenchLicenseTree.exportFile.label"), null, null, LEX.getText("WorkbenchLicenseTree.exportFile.description"));
        }

        public CommandArtifact doInvoke() throws Exception {
            TreeNode[] selected = BWorkbenchLicenseTree.this.getSelection().getNodes();
            if (selected.length == 0 && 8 == BDialog.confirm((BWidget)BWorkbenchLicenseTree.this, (String)LEX.getText("WorkbenchLicenseTree.exportFile.confirmTitle"), (Object)LEX.getText("WorkbenchLicenseTree.exportFile.confirmMessage"))) {
                return null;
            }
            BDirectory initialDir = FavoriteDirectory.loadByPath(TYPE.toString(), "larDir", null);
            FilePath path = BFileChooserDialog.chooseFilePath((BWidget)BWorkbenchLicenseTree.this, null, LEX.getText("WorkbenchLicenseTree.exportFile.title"), LEX.getText("WorkbenchLicenseTree.exportFile.message"), (BIFile)initialDir, LAR_FILTER, LAR_PATH_FILTER, null, "licenses.lar");
            if (path == null) {
                return null;
            }
            BIFile dest = BFileSystem.INSTANCE.findFile(path);
            if (dest == null) {
                dest = BFileSystem.INSTANCE.makeFile(path);
            } else if (8 == BDialog.confirm((BWidget)BWorkbenchLicenseTree.this, (String)LEX.getText("WorkbenchLicenseTree.exportFile.replaceTitle"), (Object)LEX.getText("WorkbenchLicenseTree.exportFile.replaceMessage", new Object[]{path.getName()}))) {
                return null;
            }
            FavoriteDirectory.savePath(TYPE.toString(), "larDir", (BDirectory)dest.getNavParent());
            try (OutputStream out = dest.getOutputStream();){
                if (selected.length == 0) {
                    LicenseDatabase.LOCAL_INSTANCE.exportLicenses(out);
                } else {
                    LicenseDatabase.LOCAL_INSTANCE.exportLicenses(BWorkbenchLicenseTree.this.getSelectedHostIds(), out);
                }
                BDialog.message((BWidget)BWorkbenchLicenseTree.this, (Object)LEX.getText("WorkbenchLicenseTree.exportFile.success"));
            }
            return null;
        }
    }

    private class ImportFile
    extends Command {
        public ImportFile() {
            super((BWidget)BWorkbenchLicenseTree.this, LEX.getText("WorkbenchLicenseTree.importFile.label"), null, null, LEX.getText("WorkbenchLicenseTree.importFile.description"));
        }

        public CommandArtifact doInvoke() throws Exception {
            BIFile file = BFileChooserDialog.chooseFile((BWidget)BWorkbenchLicenseTree.this, null, LEX.getText("WorkbenchLicenseTree.importFile.title"), LEX.getText("WorkbenchLicenseTree.importFile.message"), (BIFile)FavoriteDirectory.loadByPath(TYPE.toString(), "larDir", null), LICENSE_FILTER, LICENSE_FILTER);
            if (file == null) {
                return null;
            }
            LicenseDatabase.LOCAL_INSTANCE.importFile(file);
            BWorkbenchLicenseTree.this.reload();
            BDialog.message((BWidget)BWorkbenchLicenseTree.this, (Object)LEX.getText("WorkbenchLicenseTree.importFile.success"));
            return null;
        }
    }

    private class LicenseNode
    extends TreeNode {
        private VendorLicense vendorLicense;
        private Context cx;

        public LicenseNode(HostNode parent, VendorLicense vendorLicense, Context cx) {
            super((TreeNode)parent);
            this.update(vendorLicense);
            this.cx = cx;
        }

        public String getText() {
            return LicenseInfo.getSummaryText((VendorLicense)this.vendorLicense, (Context)this.cx);
        }

        public boolean update(VendorLicense value) {
            if (this.vendorLicense == null || !value.getSignature().equals(this.vendorLicense.getSignature())) {
                this.vendorLicense = value;
                return true;
            }
            return false;
        }

        public BImage getIcon() {
            return BImage.make((BIcon)LICENSE_ICON);
        }

        public int getChildCount() {
            return 0;
        }

        public TreeNode getChild(int index) {
            throw new ArrayIndexOutOfBoundsException();
        }

        public VendorLicense getVendorLicense() {
            return this.vendorLicense;
        }

        public String getHostId() {
            return this.getVendorLicense().getHostId();
        }

        public String getContents() throws Exception {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            this.vendorLicense.save((OutputStream)bytesOut);
            return bytesOut.toString();
        }
    }

    private class HostNode
    extends TreeNode {
        private String hostId;
        private LicenseNode[] children;
        private Context cx;

        public HostNode(TreeModel model, String hostId, Context cx) {
            super(model);
            this.children = null;
            this.hostId = hostId;
            this.cx = cx;
        }

        public String getHostId() {
            return this.hostId;
        }

        public String getText() {
            return this.getHostId();
        }

        public BImage getIcon() {
            return BImage.make((BIcon)HOST_ICON);
        }

        public int getChildCount() {
            return this.getChildren().length;
        }

        public TreeNode getChild(int index) {
            return this.getChildren()[index];
        }

        public synchronized boolean update() throws Exception {
            if (this.children == null) {
                return false;
            }
            TreeMap<String, LicenseNode> childrenByText = new TreeMap<String, LicenseNode>();
            TreeSet<String> allTextToRemove = new TreeSet<String>();
            boolean anyUpdates = false;
            boolean rebuildArray = false;
            for (LicenseNode child : this.children) {
                allTextToRemove.add(child.getText());
                childrenByText.put(child.getText(), child);
            }
            VendorLicense[] licenses = LicenseDatabase.LOCAL_INSTANCE.getLicenses(this.hostId);
            for (VendorLicense license : licenses) {
                String text = LicenseInfo.getSummaryText((VendorLicense)license, (Context)this.cx);
                LicenseNode node = (LicenseNode)((Object)childrenByText.get(text));
                if (node == null) {
                    childrenByText.put(text, new LicenseNode(this, license, this.cx));
                    anyUpdates = true;
                    rebuildArray = true;
                    continue;
                }
                anyUpdates = node.update(license) || anyUpdates;
                allTextToRemove.remove(node.getText());
            }
            for (String textToRemove : allTextToRemove) {
                childrenByText.remove(textToRemove);
                rebuildArray = true;
                anyUpdates = true;
            }
            if (rebuildArray) {
                this.children = new LicenseNode[childrenByText.size()];
                childrenByText.values().toArray(this.children);
            }
            return anyUpdates;
        }

        public LicenseNode[] getChildren() {
            try {
                if (this.children == null) {
                    VendorLicense[] licenses = LicenseDatabase.LOCAL_INSTANCE.getLicenses(this.hostId);
                    this.children = new LicenseNode[licenses.length];
                    for (int i = 0; i < licenses.length; ++i) {
                        this.children[i] = new LicenseNode(this, licenses[i], this.cx);
                    }
                }
                return this.children;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
    }

    private class Model
    extends TreeModel {
        private HostNode[] hostNodes = new HostNode[0];
        private Context cx;

        private Model() {
        }

        public synchronized void load(Context cx) throws Exception {
            this.cx = cx;
            String[] hostIds = LicenseDatabase.LOCAL_INSTANCE.getHostIds();
            TreeMap<Object, HostNode> hostNodesByHostId = new TreeMap<Object, HostNode>();
            boolean anyUpdates = false;
            boolean rebuildArray = false;
            TreeSet<String> hostIdsToRemove = new TreeSet<String>();
            for (HostNode hostNode : this.hostNodes) {
                hostNodesByHostId.put(hostNode.getHostId(), hostNode);
                hostIdsToRemove.add(hostNode.getHostId());
            }
            for (HostNode hostNode : hostIds) {
                HostNode node = (HostNode)((Object)hostNodesByHostId.get((Object)hostNode));
                if (node == null) {
                    hostNodesByHostId.put((Object)hostNode, new HostNode(this, (String)((Object)hostNode), cx));
                    rebuildArray = true;
                    continue;
                }
                hostIdsToRemove.remove((Object)hostNode);
                anyUpdates = node.update() || anyUpdates;
            }
            for (String hostIdToRemove : hostIdsToRemove) {
                hostNodesByHostId.remove(hostIdToRemove);
                rebuildArray = true;
            }
            if (rebuildArray) {
                anyUpdates = true;
                this.hostNodes = new HostNode[hostNodesByHostId.size()];
                hostNodesByHostId.values().toArray(this.hostNodes);
            }
            if (anyUpdates) {
                this.updateTree();
                BWorkbenchLicenseTree.this.fireValueUpdated(null);
            }
        }

        public synchronized void reload() throws Exception {
            this.load(this.cx);
        }

        public int getRootCount() {
            return this.hostNodes.length;
        }

        public TreeNode getRoot(int index) {
            return this.hostNodes[index];
        }

        public Context getContext() {
            return this.cx;
        }
    }
}

