/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx.util;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.hx.util.NotNullStringValidator;
import com.tridium.platform.hx.util.SimpleValidator;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;

public class TcpIpAddressValidator
implements SimpleValidator {
    public static TcpIpAddressValidator INSTANCE = new TcpIpAddressValidator(false, false);
    public static TcpIpAddressValidator INSTANCE_SUBNET = new TcpIpAddressValidator(false, false, true);
    public static TcpIpAddressValidator INSTANCEv6 = new TcpIpAddressValidator(true, false);
    public static TcpIpAddressValidator INSTANCE_PERMIT_NULL = new TcpIpAddressValidator(false, true);
    public static TcpIpAddressValidator INSTANCEv6_PERMIT_NULL = new TcpIpAddressValidator(true, true);
    private boolean isIpv6 = false;
    private boolean allowNull = false;
    private boolean isSubnet = false;

    private TcpIpAddressValidator() {
        this(false, false);
    }

    private TcpIpAddressValidator(boolean isIpv6, boolean allowNull) {
        this(isIpv6, allowNull, false);
    }

    private TcpIpAddressValidator(boolean isIpv6, boolean allowNull, boolean isSubnet) {
        this.isIpv6 = isIpv6;
        this.allowNull = allowNull;
        this.isSubnet = isSubnet;
    }

    @Override
    public void checkValid(String fieldName, BSimple value, Context cx) throws Exception {
        if (!this.allowNull) {
            NotNullStringValidator.INSTANCE.checkValid(fieldName, value, cx);
        }
        String s = value.toString();
        if (this.allowNull && s.length() == 0) {
            return;
        }
        if (!this.isIpv6) {
            if (!this.isSubnet) {
                if (!IPAddressUtil.isIpv4Address((String)s)) {
                    throw new LocalizableRuntimeException("platform", "validator.error.badIpAddress", (Object[])new String[]{fieldName, s});
                }
            } else if (!IPAddressUtil.isIpv4SubnetMask((String)s)) {
                throw new LocalizableRuntimeException("platform", "validator.error.badSubnetMask", (Object[])new String[]{fieldName, s});
            }
        } else if (!IPAddressUtil.isIpv6Address((String)s)) {
            throw new LocalizableRuntimeException("platform", "validator.error.badIpv6Address", (Object[])new String[]{fieldName, s});
        }
    }
}

