/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx;

import com.tridium.file.types.text.BCertificateFile;
import com.tridium.file.types.text.BLicenseFile;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.IFileInfo;
import com.tridium.platform.license.LicenseInfo;
import javax.baja.file.BIFile;
import javax.baja.hx.HxOp;
import javax.baja.hx.table.Table;
import javax.baja.hx.table.TableModel;
import javax.baja.hx.table.TableRenderer;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.Array;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.util.LexiconText;

public class FileInfoTable {
    protected String fieldName;
    protected Renderer renderer = new Renderer();

    public FileInfoTable(String fieldName) {
        this.fieldName = fieldName;
    }

    public void write(BObject value, HxOp op) throws Exception {
        HxOp fieldOp = op.make(this.fieldName, new OrdTarget((OrdTarget)op, value));
        Table table = new Table((TableModel)new Model());
        table.setHeaderVisible(false);
        table.setRenderer((TableRenderer)this.renderer);
        table.write(fieldOp);
    }

    public IFileInfo[] getSelected(HxOp op) throws Exception {
        HxOp fieldOp = op.make(this.fieldName, new OrdTarget((OrdTarget)op, op.get()));
        String[] keys = fieldOp.getFormKeys();
        Array result = new Array(IFileInfo.class);
        for (String key : keys) {
            BIFile file;
            if (!key.startsWith("_") || (file = (BIFile)BOrd.make((String)fieldOp.getUnsafeFormValue(key)).get()) == null) continue;
            if (file instanceof BLicenseFile) {
                result.add((Object)new LicenseInfo(file));
                continue;
            }
            if (!(file instanceof BCertificateFile)) continue;
            result.add((Object)new CertificateInfo(file));
        }
        return (IFileInfo[])result.trim();
    }

    public static class Model
    extends TableModel {
        private Array<LicenseInfo> licenses = new Array(LicenseInfo.class);
        private Array<CertificateInfo> certs = new Array(CertificateInfo.class);
        private LexiconText[] groupHeaders = new LexiconText[]{LexiconText.make((String)"platform", (String)"LicensePlatformServicePlugin.licenseList.header"), LexiconText.make((String)"platform", (String)"LicensePlatformServicePlugin.certList.header")};

        public Model() {
            this.licenses.addAll((Object[])LicenseInfo.listLocal());
            this.certs.addAll((Object[])CertificateInfo.listLocal());
        }

        public boolean getGroupHeaderVisible() {
            return false;
        }

        public int getGroupCount() {
            return 2;
        }

        public String getGroupName(int group, HxOp op) {
            return this.groupHeaders[group].getHtmlSafeText((Context)op);
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col, HxOp op) {
            return " ";
        }

        public int getRowCount(int group) {
            return group == 0 ? this.licenses.size() : this.certs.size();
        }

        public IFileInfo getInfoAt(int group, int row) {
            return group == 0 ? (IFileInfo)this.licenses.get(row) : (IFileInfo)this.certs.get(row);
        }

        public Object getValueAt(int group, int row, int col, HxOp op) {
            return this.getInfoAt(group, row).toString((Context)op);
        }
    }

    public static class Renderer
    extends TableRenderer {
        public void writeCellValue(Object value, int group, int row, int col, HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            IFileInfo info = ((Model)this.getModel()).getInfoAt(group, row);
            if (col == 0) {
                out.w((Object)"<input type='checkbox' ").attr("name", op.scope("_" + row)).w((Object)"'");
                out.w((Object)" value='").w((Object)info.getFile().getFilePath()).w((Object)"'/>");
            } else {
                out.w((Object)"<a href='").w((Object)info.getFile().getNavOrd()).w((Object)"|view:web:FileDownloadView'>");
                super.writeCellValue(value, group, row, col, op);
                out.w((Object)"</a>");
            }
        }
    }
}

