/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx;

import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.ReloadLicenseMessage;
import com.tridium.platform.hx.FileInfoTable;
import com.tridium.platform.hx.util.HxBooleanHelper;
import com.tridium.platform.hx.util.HxMessageHelper;
import com.tridium.platform.hx.util.HxViewHelper;
import com.tridium.platform.license.BLicenseArchiveFile;
import com.tridium.platform.license.BLicensePlatformService;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.IFileInfo;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.sys.Nre;
import com.tridium.sys.license.dom.VendorLicense;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.gx.BColor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

public class BHxLicensePlatformServiceEditor
extends BHxView {
    public static final BHxLicensePlatformServiceEditor INSTANCE = new BHxLicensePlatformServiceEditor();
    public static final Type TYPE = Sys.loadType(BHxLicensePlatformServiceEditor.class);
    private FileInfoTable table = new FileInfoTable("table");
    private Delete delete = new Delete(this.table);
    private HxViewHelper rebootFE;
    private HxViewHelper restartFE;

    public Type getType() {
        return TYPE;
    }

    protected BHxLicensePlatformServiceEditor() {
        this.registerEvent((Event)this.delete);
        this.rebootFE = HxBooleanHelper.makeFE("systemReboot", null);
        this.restartFE = HxBooleanHelper.makeFE("systemRestart", null);
    }

    public void write(HxOp op) throws Exception {
        BDaemonSession localSession;
        op.setMultiPartForm();
        BLicensePlatformService service = (BLicensePlatformService)op.get();
        HtmlWriter out = op.getHtmlWriter();
        HxMessageHelper.writeMessage("LicensePlatformServiceEditor", op);
        BSystemPlatformService sysService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        sysService.poll();
        BLicensePlatformService licService = (BLicensePlatformService)Sys.getService((Type)BLicensePlatformService.TYPE);
        licService.poll();
        boolean licenseReadonly = sysService.getIsLicenseReadonly();
        boolean canRestart = sysService.getAllowStationRestart() && !licenseReadonly;
        boolean canReboot = false;
        if (!sysService.getIsServiceReadonly() && !licenseReadonly && (localSession = LocalSessionUtil.getLocalSession()) != null) {
            canReboot = true;
        }
        out.w((Object)"<div class='tableViewHeader';'>");
        out.w((Object)"<b>").w((Object)op.getLexicon("platform").getHtmlSafeText("HxLicensePlatformServiceEditor.files.header")).w((Object)"</b>");
        out.w((Object)"</div>");
        try {
            AccessController.doPrivileged(() -> {
                this.table.write((BObject)service, op);
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        out.w((Object)"<div class='tableViewToolbar'; style='border-bottom: 1px solid black;'>");
        this.delete.writeButton(op);
        out.w((Object)"</div>");
        out.w((Object)"<br/>");
        out.w((Object)"<br/>");
        out.w((Object)"<div class='tableViewHeader'; style='border-top: 1px solid black;'>");
        out.w((Object)"<b>").w((Object)op.getLexicon("platform").getHtmlSafeText("HxLicensePlatformServiceEditor.upload.header")).w((Object)"</b>");
        out.w((Object)"</div>");
        out.w((Object)"<table cellpadding='5'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)op.getLexicon("platform").getHtmlSafeText("HxLicensePlatformServiceEditor.upload.file")).w((Object)"</b></td>");
        out.w((Object)"<td><input ");
        out.attr("type", "file");
        out.w(' ');
        out.attr("name", op.scope("file"));
        if (licenseReadonly || !BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)licService).hasAdminInvoke()) {
            out.w((Object)" ").attr("disabled", "disabled");
        }
        out.w((Object)"/></td>\n");
        out.w((Object)"</tr>");
        if (canRestart) {
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)op.getLexicon("platform").getHtmlSafeText("HxLicensePlatformServiceEditor.restart")).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.restartFE.write((BObject)BBoolean.TRUE, op);
            out.w((Object)"</td>\n");
            out.w((Object)"</tr>");
            out.w((Object)("<input type='hidden' name='" + op.scope("systemReboot.value") + "' value='false' />"));
        } else if (canReboot) {
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)op.getLexicon("platform").getHtmlSafeText("HxLicensePlatformServiceEditor.reboot")).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.rebootFE.write((BObject)BBoolean.TRUE, op);
            out.w((Object)"</td>\n");
            out.w((Object)"</tr>");
            out.w((Object)("<input type='hidden' name='" + op.scope("systemRestart.value") + "' value='false' />"));
        } else {
            out.w((Object)("<input type='hidden' name='" + op.scope("systemReboot.value") + "' value='false' />"));
            out.w((Object)("<input type='hidden' name='" + op.scope("systemRestart.value") + "' value='false' />"));
        }
        out.w((Object)"</table>");
        out.w((Object)"<div class='tableViewToolbar'; style='border-bottom: 1px solid black;'>");
        out.w((Object)"<input ").attr("class", "button").w((Object)" ").attr("type", "submit").w((Object)" ");
        out.attr("value", op.getLexicon("platform").getHtmlSafeText("HxLicensePlatformServiceEditor.upload.button"));
        if (licenseReadonly || !BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)licService).hasAdminInvoke()) {
            out.w((Object)" ").attr("disabled", "disabled");
        }
        out.w((Object)"/>&nbsp;");
        out.w((Object)"</div>");
    }

    public BObject save(HxOp op) throws Exception {
        BSystemPlatformService sysService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        sysService.poll();
        boolean licenseReadonly = sysService.getIsLicenseReadonly();
        BLicensePlatformService licService = (BLicensePlatformService)Sys.getService((Type)BLicensePlatformService.TYPE);
        licService.poll();
        BPermissions perms = BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)licService);
        if (licenseReadonly || !BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)licService).hasAdminInvoke()) {
            throw new PermissionException("licenses readonly (" + licenseReadonly + ") or insufficient permissions " + perms.toString(null) + " < " + BPermissions.adminInvoke.toString(null));
        }
        BIFile file = op.getFile("file");
        if (file != null) {
            String extension = BajaFileUtil.getExtension((String)op.getFormValue("file"));
            if (extension == null) {
                extension = "";
            }
            if (extension.equalsIgnoreCase("lar")) {
                LicenseSync licenseSync;
                BLicenseArchiveFile lar = new BLicenseArchiveFile();
                lar.setStore(file.getStore());
                try {
                    licenseSync = AccessController.doPrivileged(() -> PortalLicenseUtil.syncLicenses((String)Nre.getHostId(), (LicenseInfo[])LicenseInfo.listLocal(), (LicenseInfo[])LicenseInfo.make((VendorLicense[])lar.getLicenses())));
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                if (this.sync(op, (LicenseSync<? extends IFileInfo>)licenseSync, "LicensePlatformServicePlugin.sync.currentMessage", "LicensePlatformServicePlugin.sync.successMessage")) {
                    BBoolean reboot = (BBoolean)this.rebootFE.save((BObject)BBoolean.FALSE, op);
                    BBoolean restart = (BBoolean)this.restartFE.save((BObject)BBoolean.FALSE, op);
                    if (reboot.getBoolean()) {
                        sysService.reboot();
                        HxMessageHelper.appendMessage("LicensePlatformServiceEditor", LexiconText.make((String)"platform", (String)"HxLicensePlatformServiceEditor.systemReboot.message"), op);
                    } else {
                        LocalSessionUtil.getLocalSession().sendMessage((DaemonMessage)new ReloadLicenseMessage());
                        if (restart.getBoolean()) {
                            sysService.restartStation();
                            HxMessageHelper.appendMessage("LicensePlatformServiceEditor", LexiconText.make((String)"platform", (String)"HxLicensePlatformServiceEditor.systemRestart.message"), op);
                        } else {
                            HxMessageHelper.appendMessage("LicensePlatformServiceEditor", LexiconText.make((String)"platform", (String)"HxLicensePlatformServiceEditor.needRestart.message"), op);
                        }
                    }
                }
            } else if (extension.equalsIgnoreCase("license")) {
                LicenseSync licenseSync;
                LicenseInfo license = new LicenseInfo(file);
                if (!license.vendorLicense.getHostId().equals(Nre.getHostId())) {
                    throw new LocalizableRuntimeException("platform", "LicensePlatformServicePlugin.badHostId.message", new Object[]{op.getFormValue("file")});
                }
                LicenseInfo[] toInstall = new LicenseInfo[]{license};
                try {
                    licenseSync = AccessController.doPrivileged(() -> PortalLicenseUtil.syncLicenses((String)Nre.getHostId(), (LicenseInfo[])LicenseInfo.listLocal(), (LicenseInfo[])toInstall));
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                if (this.sync(op, (LicenseSync<? extends IFileInfo>)licenseSync, "LicensePlatformServicePlugin.sync.currentMessage", "LicensePlatformServicePlugin.sync.successMessage")) {
                    BBoolean reboot = (BBoolean)this.rebootFE.save((BObject)BBoolean.FALSE, op);
                    BBoolean restart = (BBoolean)this.restartFE.save((BObject)BBoolean.FALSE, op);
                    if (reboot.getBoolean()) {
                        sysService.reboot();
                        HxMessageHelper.appendMessage("LicensePlatformServiceEditor", LexiconText.make((String)"platform", (String)"HxLicensePlatformServiceEditor.systemReboot.message"), op);
                    } else {
                        LocalSessionUtil.getLocalSession().sendMessage((DaemonMessage)new ReloadLicenseMessage());
                        if (restart.getBoolean()) {
                            sysService.restartStation();
                            HxMessageHelper.appendMessage("LicensePlatformServiceEditor", LexiconText.make((String)"platform", (String)"HxLicensePlatformServiceEditor.systemRestart.message"), op);
                        } else {
                            HxMessageHelper.appendMessage("LicensePlatformServiceEditor", LexiconText.make((String)"platform", (String)"HxLicensePlatformServiceEditor.needRestart.message"), op);
                        }
                    }
                }
            } else if (extension.equalsIgnoreCase("certificate")) {
                LicenseSync certSync;
                CertificateInfo[] toInstall = new CertificateInfo[]{new CertificateInfo(file)};
                try {
                    certSync = AccessController.doPrivileged(() -> PortalLicenseUtil.syncCertificates((CertificateInfo[])CertificateInfo.listLocal(), (CertificateInfo[])toInstall));
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                if (this.sync(op, (LicenseSync<? extends IFileInfo>)certSync, "LicensePlatformServicePlugin.sync.currentMessage", "LicensePlatformServicePlugin.sync.successMessage")) {
                    LocalSessionUtil.getLocalSession().sendMessage((DaemonMessage)new ReloadLicenseMessage());
                }
            } else {
                throw new LocalizableRuntimeException("platform", "HxLicensePlatformServiceEditor.badFileType.message", new Object[]{op.getFormValue("file")});
            }
        }
        return super.save(op);
    }

    private boolean sync(HxOp op, LicenseSync<? extends IFileInfo> sync, String currentMessage, String successMessage) throws Exception {
        int i;
        if (sync == null) {
            return false;
        }
        StringBuilder m = new StringBuilder();
        Lexicon lex = op.getLexicon("platform");
        if (sync.unchanged()) {
            HxMessageHelper.addMessage("LicensePlatformServiceEditor", null, lex.getHtmlSafeText(currentMessage), BColor.blue, op);
            return false;
        }
        m.append("<table cellpadding='5'>");
        m.append("<tr><td colspan='2'>");
        m.append(lex.getHtmlSafeText(successMessage));
        m.append("</td></tr>");
        int count = sync.toRemove.size();
        if (count > 0) {
            m.append("<tr><td colspan='2'>");
            m.append(lex.getHtmlSafeText("UiUtil.removed"));
            m.append("</td></tr>");
            for (i = 0; i < count; ++i) {
                IFileInfo remove = (IFileInfo)sync.toRemove.get(i);
                try {
                    AccessController.doPrivileged(() -> {
                        remove.getFile().delete();
                        return null;
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                m.append("<tr><td>&nbsp;</td><td width='100%'>");
                m.append(remove.toString((Context)op));
                m.append("</td></tr>");
            }
        }
        if ((count = sync.toAdd.size()) > 0) {
            m.append("<tr><td colspan='2'>");
            m.append(lex.getHtmlSafeText("UiUtil.added"));
            m.append("</td></tr>");
            for (i = 0; i < count; ++i) {
                IFileInfo add = (IFileInfo)sync.toAdd.get(i);
                try {
                    AccessController.doPrivileged(() -> {
                        BIFile file = BFileSystem.INSTANCE.makeFile(add.getInstalledFilePath(true));
                        add.write(file.getOutputStream());
                        return null;
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                m.append("<tr><td>&nbsp;</td><td width='100%'>");
                m.append(add.toString((Context)op));
                m.append("</td></tr>");
            }
        }
        if ((count = sync.toUpdate.size()) > 0) {
            m.append("<tr><td colspan='2'>");
            m.append(lex.getHtmlSafeText("UiUtil.updated"));
            m.append("</td></tr>");
            for (i = 0; i < count; ++i) {
                IFileInfo update = (IFileInfo)sync.toUpdate.get(i);
                try {
                    AccessController.doPrivileged(() -> {
                        BIFile file = BFileSystem.INSTANCE.makeFile(update.getInstalledFilePath(true));
                        update.write(file.getOutputStream());
                        return null;
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                m.append("<tr><td>&nbsp;</td><td width='100%'>");
                m.append(update.toString((Context)op));
                m.append("</td></tr>");
            }
        }
        m.append("</table>");
        HxMessageHelper.addMessage("LicensePlatformServiceEditor", null, m.toString(), BColor.blue, op);
        return true;
    }

    private class Delete
    extends Command {
        private FileInfoTable table;
        private LexiconText label;

        public Delete(FileInfoTable table) {
            super((BHxView)BHxLicensePlatformServiceEditor.this);
            this.label = LexiconText.make((String)"bajaui", (String)"commands.delete.label");
            this.table = table;
        }

        public String getInvokeCode(HxOp op) {
            return "if (confirm(\"" + op.getLexicon("platform").getHtmlSafeText("FileInfoTable.confirmDelete") + "\"))" + super.getInvokeCode(op);
        }

        public void writeButton(HxOp op) throws Exception {
            BSystemPlatformService sysService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            sysService.poll();
            boolean licenseReadonly = sysService.getIsLicenseReadonly();
            BLicensePlatformService licService = (BLicensePlatformService)Sys.getService((Type)BLicensePlatformService.TYPE);
            licService.poll();
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<input ").attr("class", "button").w((Object)" ").attr("type", "button").w((Object)" ");
            out.w((Object)"onclick='").w((Object)this.getInvokeCode(op)).w((Object)"' ");
            out.attr("value", this.getDisplayName(op));
            if (licenseReadonly || !BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)licService).hasAdminInvoke()) {
                out.w((Object)" ").attr("disabled", "disabled");
            }
            out.w((Object)"/>&nbsp;");
        }

        public void handle(HxOp op) throws Exception {
            BSystemPlatformService sysService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            sysService.poll();
            boolean licenseReadonly = sysService.getIsLicenseReadonly();
            BLicensePlatformService licService = (BLicensePlatformService)Sys.getService((Type)BLicensePlatformService.TYPE);
            licService.poll();
            BPermissions perms = BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)licService);
            if (licenseReadonly || !BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)licService).hasAdminInvoke()) {
                throw new PermissionException("licenses readonly (" + licenseReadonly + ") or insufficient permissions " + perms.toString(null) + " < " + BPermissions.adminInvoke.toString(null));
            }
            try {
                AccessController.doPrivileged(() -> {
                    IFileInfo[] fileInformation;
                    for (IFileInfo info : fileInformation = this.table.getSelected(op)) {
                        info.getFile().delete();
                    }
                    if (fileInformation.length > 0) {
                        this.refresh(op);
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }

        public String getDisplayName(HxOp op) {
            return this.label.getHtmlSafeText((Context)op);
        }
    }
}

