/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platIEEE8021X.ui;

import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.platIEEE8021X.BIEEE8021XHostSettings;
import com.tridium.platIEEE8021X.IEEE8021XUtil;
import com.tridium.platIEEE8021X.ui.BIEEE8021XHostSettingsEditor;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.ui.theme.Theme;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.LexiconModule;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"platform:DaemonSession"})})
public class BIEEE8021XDaemonSessionPlugin
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BIEEE8021XDaemonSessionPlugin.class);
    private static final Logger log = Logger.getLogger("platIEEE8021X.daemon.plugin");
    private BDaemonSession session;
    private ICoreCryptoManager coreCryptoManager;
    private BIEEE8021XHostSettingsEditor hostEditor = new BIEEE8021XHostSettingsEditor();
    private BScrollPane scrollPane;
    protected static final LexiconModule LEXICON = LexiconModule.make((Type)TYPE);
    private static final int PARENT_BORDER_PANE_TOP = 10;
    private static final int PARENT_BORDER_PANE_RIGHT = 10;
    private static final int PARENT_BORDER_PANE_BOTTOM = 5;
    private static final int PARENT_BORDER_PANE_LEFT = 10;
    private static final int SUB_BORDER_PANE_TOP = 5;
    private static final int SUB_BORDER_PANE_RIGHT = 10;
    private static final int SUB_BORDER_PANE_BOTTOM = 0;
    private static final int SUB_BORDER_PANE_LEFT = 10;

    public Type getType() {
        return TYPE;
    }

    public BIEEE8021XDaemonSessionPlugin() {
        BBrush bgcolor = Theme.scrollPane().getControlBackground();
        this.scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.hostEditor, 10.0, 10.0, 5.0, 10.0));
        this.scrollPane.setViewportBackground(bgcolor);
        this.linkTo(null, (BComponent)this.hostEditor, (Slot)BIEEE8021XHostSettingsEditor.pluginModified, (Slot)setModified);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        int rc;
        this.session = (BDaemonSession)value;
        try {
            this.coreCryptoManager = new BPlatCryptoManager(this.session);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LEXICON.getText("IEEE8021XHostSettingsEditor.crypto.failure.msg", cx), e);
            throw new LocalizableException("platIEEE8021X", "IEEE8021XHostSettingsEditor.crypto.failure.msg", (Throwable)e);
        }
        if (!this.coreCryptoManager.isSecure() && (rc = BDialog.open((BWidget)this, (String)LEXICON.getText("IEEE8021XHostSettingsEditor.warning.dialog.title", cx), (Object)LEXICON.getText("IEEE8021XHostSettingsEditor.warning.dialog.msg", cx), (int)12, (BImage)BDialog.WARNING_ICON, (String)null)) == 8) {
            log.log(Level.SEVERE, LEXICON.getText("IEEE8021XHostSettingsEditor.warning.terminated.msg", cx));
            throw new LocalizableException("platIEEE8021X", "IEEE8021XHostSettingsEditor.warning.terminated.msg");
        }
        this.hostEditor.setCryptoManager(this.coreCryptoManager);
        try {
            BIEEE8021XHostSettings hostSettings = new BIEEE8021XHostSettings();
            IEEE8021XUtil.loadFromSession((BIEEE8021XHostSettings)hostSettings, (BDaemonSession)this.session);
            BWbShell shell = this.getWbShell();
            if (shell != null) {
                BButtonPane buttons = new BButtonPane();
                buttons.addWorkbenchButtons((BWidget)this);
                BEdgePane edge = new BEdgePane();
                edge.setCenter((BWidget)new BBorderPane((BWidget)this.scrollPane, BBorder.inset, BInsets.DEFAULT));
                edge.setBottom((BWidget)new BBorderPane((BWidget)buttons, 5.0, 10.0, 0.0, 10.0));
                this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(cx), (BWidget)edge));
            } else {
                this.setContent((BWidget)new BBorderPane((BWidget)this.scrollPane, BBorder.inset, BInsets.DEFAULT));
            }
            this.hostEditor.loadValue((BObject)hostSettings);
            boolean readonly = hostSettings.getIeee8021XReadonly();
            if (this.isReadonly() == readonly) {
                this.doSetReadonly(readonly);
            } else {
                this.setReadonly(readonly);
            }
        }
        catch (RuntimeException re) {
            log.log(Level.SEVERE, "Failed to lo ad IEEE8021X daemon session view", re);
            throw new LocalizableRuntimeException("platIEEE8021X", "IEEE8021XDaemonSessionPlugin.parseError", (Throwable)re);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to lo ad IEEE8021X daemon session view", e);
            throw new LocalizableException("platIEEE8021X", "IEEE8021XDaemonSessionPlugin.parseError", (Throwable)e);
        }
    }

    protected final BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (!this.isModified()) {
            return value;
        }
        if (this.isReadonly()) {
            return value;
        }
        BIEEE8021XHostSettings newSettings = (BIEEE8021XHostSettings)this.hostEditor.saveValue();
        try {
            IEEE8021XUtil.saveToSession((BIEEE8021XHostSettings)newSettings, (BDaemonSession)this.session, (ICoreCryptoManager)this.coreCryptoManager);
            if (this.session.getHostProperties().getAccessLevel().atLeast(BDaemonAccessLevel.full)) {
                this.promptForReboot(true);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to save IEEE8021X daemon session view", e);
            throw new CannotSaveException("Failed to save IEEE8021X daemon session view", (Throwable)e);
        }
        return value;
    }

    protected void doSetReadonly(boolean readonly) {
        if (this.hostEditor != null) {
            this.hostEditor.setReadonly(readonly);
        }
    }

    protected void promptForReboot(boolean optional) {
        block5: {
            if (optional && !this.session.usesLocalNiagaraHome() && 4 != BDialog.confirm((BWidget)this, (String)LEXICON.getText("IEEE8021XDaemonSessionPlugin.reboot.promptTitle", null, new Object[]{this.session.getRemoteAddressString()}), (Object)LEXICON.getText("IEEE8021XDaemonSessionPlugin.reboot.promptMessage", null, new Object[]{this.session.getRemoteAddressString()}), (int)12)) {
                return;
            }
            if (this.session.usesLocalNiagaraHome()) {
                BDialog.message((BWidget)this, (String)LEXICON.getText("IEEE8021XDaemonSessionPlugin.rebootLocal.title", null, new Object[]{this.session.getRemoteAddressString()}), (Object)LEXICON.getText("IEEE8021XDaemonSessionPlugin.rebootLocal.message", null, new Object[]{this.session.getRemoteAddressString()}));
                return;
            }
            try {
                BWidgetShell shell = this.getShell();
                this.session.sendRebootRequest();
                if (shell != null) {
                    BDialog.message((BWidget)shell, (String)LEXICON.getText("IEEE8021XDaemonSessionPlugin.reboot.notifyTitle", null, new Object[]{this.session.getRemoteAddressString()}), (Object)LEXICON.getText("IEEE8021XDaemonSessionPlugin.reboot.notifyMessage", null, new Object[]{this.session.getRemoteAddressString()}));
                }
            }
            catch (AuthenticationException ae) {
                if (!log.isLoggable(Level.FINEST)) break block5;
                log.finest("Authentication exception occurred while sending reboot request (" + (Object)((Object)ae) + ")");
            }
        }
    }
}

