/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.queryTable.hx;

import com.tridium.query.BProjCol;
import com.tridium.queryTable.BQueryTable;
import com.tridium.queryTable.QueryUtil;
import com.tridium.queryTable.hx.BHxQueryTableConfig;
import com.tridium.queryTable.ui.BQueryTableOptions;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.DynamicDialog;
import com.tridium.smartTableHx.HxOptionsManager;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import java.util.ArrayList;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.BSingleExtent;
import javax.baja.sys.BComplex;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.options.BOptions;
import javax.baja.util.BTypeSpec;
import javax.baja.util.LexiconModule;
import javax.baja.util.LexiconText;

public class BHxQueryColumnTable
extends BHxSmartTableView {
    public static final BHxQueryColumnTable INSTANCE = new BHxQueryColumnTable();
    public static final Type TYPE = Sys.loadType(BHxQueryColumnTable.class);
    protected SmartCommand tableCommand = new TableCommand((BHxView)this);
    protected SmartCommand delete;
    protected SmartCommand edit;
    protected SmartCommand save;
    protected SmartCommand moveUp;
    protected SmartCommand moveDown;
    private static final LexiconModule lex = LexiconModule.make(BHxQueryColumnTable.class);

    public Type getType() {
        return TYPE;
    }

    public BHxQueryColumnTable() {
        this.registerEvent((Event)this.tableCommand);
        this.delete = new Delete((BHxView)this);
        this.registerEvent((Event)this.delete);
        this.edit = new Edit((BHxView)this);
        this.registerEvent((Event)this.edit);
        this.save = new Save((BHxView)this);
        this.registerEvent((Event)this.save);
        this.moveUp = new MoveUp((BHxView)this);
        this.registerEvent((Event)this.moveUp);
        this.moveDown = new MoveDown((BHxView)this);
        this.registerEvent((Event)this.moveDown);
    }

    public String getPageTitle(HxOp op) throws Exception {
        BQueryTable queryTable = (BQueryTable)op.get();
        return lex.getText("columnsFor", (Context)op, new Object[]{queryTable.getDisplayName((Context)op)});
    }

    public void write(HxOp op) throws Exception {
        super.write(op);
    }

    public void writeTableHeader(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<th>");
        out.safe((Object)lex.getText("name", (Context)op));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.safe((Object)lex.getText("displayName", (Context)op));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.safe((Object)lex.getText("fromType", (Context)op));
        out.w((Object)"</th>");
    }

    public TableContents writeContents(HxOp op) throws Exception {
        TableContents contents = new TableContents(op.scope("records"));
        BQuery query = (BQuery)op.getRequest().getSession().getAttribute("working");
        BProjectionColumn[] columns = query.getProjection().getProjectionColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (Flags.isHidden((BComplex)query.getProjection(), (Slot)columns[i].getPropertyInParent())) continue;
            TableContents.Tr tr = new TableContents.Tr();
            tr.id = "" + columns[i].getName();
            tr.td.add(new TableContents.Td(SlotPath.unescape((String)columns[i].getName())));
            tr.td.add(new TableContents.Td(columns[i].getAlias()));
            tr.td.add(new TableContents.Td("" + columns[i].get("typeSpec")));
            contents.tr.add(tr);
        }
        return contents;
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.edit, this.delete, this.save, this.moveUp, this.moveDown, this.tableCommand};
    }

    public static class Edit
    extends SmartCommand {
        private EditDialog dlg = new EditDialog((Command)this, this.getDisplayName(null));

        public Edit(BHxView view) {
            super(view);
        }

        public boolean isDefaultAction() {
            return true;
        }

        public String getName(HxOp op) {
            return "edit";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            SaveCommand.setModified((HxOp)op);
            BQuery query = (BQuery)op.getRequest().getSession().getAttribute("working");
            String[] propNames = Edit.getSelectionList((HxOp)op);
            String displayName = "";
            BString value = null;
            BProjCol column = (BProjCol)query.getProjection().get(propNames[0]);
            Property prop = query.getProjection().getProperty(propNames[0]);
            value = BString.make((String)column.getAlias());
            BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)value, (Context)op);
            BObject newValue = editor.save(op.make("displayName", (BObject)value, null));
            if (!newValue.toString().equals(value.toString())) {
                column.setAlias(newValue.toString());
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"var elem = hx.$('").w((Object)column.getName()).w((Object)"');");
                out.w((Object)"elem.firstChild.nextSibling.textContent='");
                out.w((Object)HxUtil.escapeJsStringLiteral((String)column.getAlias()));
                out.w((Object)"';");
                BHxQueryTableConfig.setSaveToOptions(true, op);
            }
        }

        private class EditDialog
        extends Dialog {
            EditDialog(Command handler, String title) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                BQuery query = (BQuery)op.getRequest().getSession().getAttribute("working");
                String[] propNames = SmartCommand.getSelectionList((HxOp)op);
                String displayName = "";
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"<table>");
                out.w((Object)"<tr><td ");
                out.attr("class", "smartTable-setup-label");
                out.w((Object)">");
                out.w((Object)"Display Name");
                out.w((Object)"</td><td>");
                String propName = propNames[0];
                BProjCol column = (BProjCol)query.getProjection().get(propName);
                BString value = BString.make((String)column.getAlias());
                BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)value, (Context)op);
                editor.write(op.make("displayName", (BObject)value, null));
                out.w((Object)"</td></tr>");
                out.w((Object)"</table>");
            }
        }
    }

    public class SaveDialog
    extends DynamicDialog {
        SaveDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.safe((Object)lex.getText("saveColumnsForAllUsersQuestion", (Context)op));
        }

        public Command[] getCommands() {
            return new Command[]{this.makeSubmitCommand("yes", LexiconText.make((BModule)Sys.getModuleForClass(BHxQueryColumnTable.class), (String)"yes")), this.makeSubmitCommand("no", LexiconText.make((BModule)Sys.getModuleForClass(BHxQueryColumnTable.class), (String)"no"))};
        }
    }

    public class Save
    extends SaveCommand {
        private SaveDialog dlg;

        public Save(BHxView view) {
            super(view);
            this.dlg = new SaveDialog(this.getDisplayName(null), (Command)this);
        }

        public void onHandle(HxOp op) throws Exception {
            this.saveTable(op);
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void saveTable(HxOp op) throws Exception {
            BQuery result = ((BQueryTable)op.get()).getQuery();
            BQuery working = (BQuery)op.getRequest().getSession().getAttribute("working");
            BTypeSpec typeSpec = QueryUtil.getRowType(working);
            BSingleExtent extent = (BSingleExtent)result.getExtent();
            extent.setBaseExtent(typeSpec);
            HxOp tx = op;
            BQuery copy = QueryUtil.makeQuery(typeSpec);
            BProjection projection = copy.getProjection();
            ArrayList<Property> toRemove = new ArrayList<Property>(16);
            SlotCursor c = projection.getProperties();
            while (c.next(BProjCol.class)) {
                toRemove.add(c.property());
            }
            for (Property prop : toRemove) {
                projection.remove(prop);
            }
            BProjCol[] cols = (BProjCol[])working.getProjection().getChildren(BProjCol.class);
            for (int i = 0; i < cols.length; ++i) {
                int flags = projection.getFlags((Slot)cols[i].getPropertyInParent());
                String escape = SlotPath.escape((String)TextUtil.fromFriendly((String)cols[i].getAlias()));
                projection.add(escape, cols[i].newCopy(true), flags);
            }
            QueryUtil.addHiddenColumns(copy);
            BQueryTableOptions options = (BQueryTableOptions)new HxOptionsManager(op).load(BQueryTableOptions.TYPE);
            if (QueryUtil.isDefaultProjection(copy)) {
                options.removeProjection(copy);
                if (result.get("projection") != null) {
                    result.remove("projection");
                }
                return;
            }
            if (BHxQueryTableConfig.getSaveToOptions(op) && op.getUser().getPermissions().isSuperUser()) {
                if (!this.dlg.isSubmit(op)) {
                    this.dlg.open(op);
                    return;
                }
                if (op.getFormValue("yes") != null) {
                    BHxQueryTableConfig.setSaveToOptions(false, op);
                }
            }
            BProjectionColumn[] newColumns = (BProjectionColumn[])projection.getChildren(BProjectionColumn.class);
            if (BHxQueryTableConfig.getSaveToOptions(op)) {
                if (newColumns.length > 0) {
                    options.setProjection(copy, projection, (Context)op);
                } else {
                    options.removeProjection(copy);
                }
            } else {
                options.removeProjection(result);
                result.select((BProjection)projection.newCopy(true));
                QueryUtil.reorderColumns(result);
            }
            new HxOptionsManager(op).save((BOptions)options);
        }
    }

    public static class Delete
    extends SmartCommand {
        public Delete(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        public String getName(HxOp op) {
            return "delete";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            SaveCommand.setModified((HxOp)op);
            HtmlWriter out = op.getHtmlWriter();
            BQuery working = (BQuery)op.getRequest().getSession().getAttribute("working");
            String[] propNames = Delete.getSelectionList((HxOp)op);
            for (int i = 0; i < propNames.length; ++i) {
                working.getProjection().remove(propNames[i]);
                out.w((Object)"var elem = hx.$('").w((Object)propNames[i]).w((Object)"');");
                out.w((Object)"smartTable.remove(elem);");
                out.w((Object)"smartTable.setForm('").w((Object)op.scope("")).w((Object)"');");
                out.w((Object)"elem.parentNode.removeChild(elem);");
            }
            BHxQueryTableConfig.setSaveToOptions(true, op);
        }
    }

    public static class MoveDown
    extends SmartCommand {
        public MoveDown(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "moveDown";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            SaveCommand.setModified((HxOp)op);
            HtmlWriter out = op.getHtmlWriter();
            BQuery working = (BQuery)op.getRequest().getSession().getAttribute("working");
            BProjection projection = working.getProjection();
            String propName = MoveDown.getSelectionList((HxOp)op)[0];
            Array props = new Array((Object[])projection.getDynamicPropertiesArray());
            for (int i = 0; i < props.size() - 1; ++i) {
                Property p = (Property)props.get(i);
                if (!p.getName().equals(propName)) continue;
                for (int j = i + 1; j < props.size(); ++j) {
                    Property otherProp = (Property)props.get(j);
                    if (!(projection.get(otherProp) instanceof BProjectionColumn) || Flags.isHidden((BComplex)projection, (Slot)otherProp)) continue;
                    props.swap(i, j);
                    out.w((Object)"var elem = hx.$('").w((Object)propName).w((Object)"');");
                    out.w((Object)"var otherElem = hx.$('").w((Object)otherProp.getName()).w((Object)"');");
                    out.w((Object)"var parent = elem.parentNode;");
                    out.w((Object)"parent.insertBefore(otherElem, elem);");
                    projection.reorder((Property[])props.trim());
                    BHxQueryTableConfig.setSaveToOptions(true, op);
                    return;
                }
            }
        }
    }

    public static class MoveUp
    extends SmartCommand {
        public MoveUp(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "moveUp";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            SaveCommand.setModified((HxOp)op);
            HtmlWriter out = op.getHtmlWriter();
            BQuery working = (BQuery)op.getRequest().getSession().getAttribute("working");
            BProjection projection = working.getProjection();
            String propName = MoveUp.getSelectionList((HxOp)op)[0];
            Array props = new Array((Object[])projection.getDynamicPropertiesArray());
            for (int i = 1; i < props.size(); ++i) {
                Property p = (Property)props.get(i);
                if (!p.getName().equals(propName)) continue;
                for (int j = i - 1; j >= 0; --j) {
                    Property otherProp = (Property)props.get(j);
                    if (!(projection.get(otherProp) instanceof BProjectionColumn) || Flags.isHidden((BComplex)projection, (Slot)otherProp)) continue;
                    props.swap(i, j);
                    out.w((Object)"var elem = hx.$('").w((Object)propName).w((Object)"');");
                    out.w((Object)"var otherElem = hx.$('").w((Object)otherProp.getName()).w((Object)"');");
                    out.w((Object)"var parent = elem.parentNode;");
                    out.w((Object)"parent.insertBefore(elem, otherElem);");
                    projection.reorder((Property[])props.trim());
                    BHxQueryTableConfig.setSaveToOptions(true, op);
                    return;
                }
            }
        }
    }

    public static class TableCommand
    extends SmartCommand {
        public TableCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "table";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            BOrd ord = op.getOrdWithoutViewQuery();
            this.redirect(op, op.toUri(ord));
        }
    }
}

