/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.queryTable;

import com.tridium.query.BProjCol;
import com.tridium.query.expression.BField;
import com.tridium.query.expression.BFunction;
import com.tridium.queryTable.BColumnsProvider;
import com.tridium.queryTable.BEmptyExtent;
import com.tridium.queryTable.TypeSpecPath;
import com.tridium.queryTable.ui.BQueryTableOptions;
import com.tridium.smartTableHx.HxOptionsManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.hx.HxOp;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BExtent;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.BSingleExtent;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Funcs;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.util.BTypeSpec;

public abstract class QueryUtil {
    public static final BColumnsProvider defaultProvider = new BColumnsProvider();
    public static final String STANDARD_COLUMNS = "columns";

    public static BTypeSpec getRowType(BQuery query) {
        BSingleExtent extent = (BSingleExtent)query.getExtent();
        if (extent != null) {
            return extent.getBaseExtent();
        }
        return BTypeSpec.DEFAULT;
    }

    public static BQuery getWorkingCopy(BQuery query, Context cx) {
        query.lease(10);
        BQuery q = (BQuery)query.newCopy(true);
        q.select(QueryUtil.getWorkingProjection(query, cx));
        if (q.getExtent() == null) {
            q.from((BExtent)new BSingleExtent(BTypeSpec.DEFAULT));
        }
        return q;
    }

    public static BQueryTableOptions getOptions(Context cx) {
        if (cx instanceof HxOp) {
            BQueryTableOptions options = (BQueryTableOptions)new HxOptionsManager((HxOp)cx).load(BQueryTableOptions.TYPE);
            return options;
        }
        BQueryTableOptions options = null;
        if (BWidget.getApplication() != null) {
            options = BQueryTableOptions.make();
        }
        return options;
    }

    public static boolean isDefaultProjection(BQuery query) {
        BProjectionColumn[] columns;
        BQuery defaultQuery = QueryUtil.makeQuery(QueryUtil.getRowType(query));
        BProjection defaultProjection = defaultQuery.getProjection();
        BProjection projection = query.getProjection();
        if (projection == null) {
            return true;
        }
        BProjectionColumn[] defaultColumns = (BProjectionColumn[])defaultProjection.getChildren(BProjectionColumn.class);
        if (defaultColumns.length != (columns = (BProjectionColumn[])projection.getChildren(BProjectionColumn.class)).length) {
            return false;
        }
        for (int i = 0; i < defaultColumns.length; ++i) {
            if (defaultColumns[i].equivalent((Object)columns[i])) continue;
            return false;
        }
        return true;
    }

    public static String getColumnName(BProjectionColumn c) {
        if (c.getColumnExpression() instanceof BField) {
            return ((BField)c.getColumnExpression()).getFieldPath();
        }
        return ((BFunction)c.getColumnExpression()).getFunctionName();
    }

    public static BProjection getWorkingProjection(BQuery query, Context cx) {
        BQueryTableOptions options = QueryUtil.getOptions(cx);
        BProjection projection = null;
        if (options != null) {
            projection = options.getProjection(query, cx);
        }
        if (projection != null) {
            return (BProjection)projection.newCopy(true);
        }
        projection = query.getProjection();
        if (projection != null && ((BProjectionColumn[])projection.getChildren(BProjectionColumn.class)).length > 0) {
            return (BProjection)projection.newCopy(true);
        }
        BQuery copy = (BQuery)query.newCopy(true);
        BTypeSpec rowType = QueryUtil.getRowType(query);
        if (rowType == BTypeSpec.DEFAULT) {
            return new BProjection();
        }
        projection = (copy = QueryUtil.makeQuery(copy, rowType)).getProjection();
        if (projection != null && ((BProjectionColumn[])projection.getChildren(BProjectionColumn.class)).length > 0) {
            return (BProjection)projection.newCopy(true);
        }
        throw new IllegalStateException("no working projection found");
    }

    public static void addHiddenColumns(BQuery query) {
        BTypeSpec typeSpec = ((BSingleExtent)query.getExtent()).getBaseExtent();
        TypeSpecPath[] keys = QueryUtil.getProvider(query).getHiddenColumns(query);
        for (int i = 0; i < keys.length; ++i) {
            QueryUtil.addHiddenColumn(query, keys[i]);
        }
    }

    public static void addHiddenColumn(BQuery query, TypeSpecPath key) {
        QueryUtil.addColumn(query, key, 4);
    }

    public static Property addSlotFacetColumn(BProjection projection, Type returnType, String name, String colDisplayName) {
        BFunctionExpression exp = Funcs.make((String)"queryTable:QueryTableOptions.getSlotFacetValue", (Type)BObject.TYPE, (BExpression)Exprs.simple((BSimple)BString.make((String)name)));
        BProjCol col = new BProjCol((BExpression)exp);
        col.setAlias(colDisplayName);
        col.add("typeSpec", (BValue)returnType.getTypeSpec());
        return projection.add(SlotPath.escape((String)name) + "?", (BValue)col);
    }

    public static Property addColumn(BQuery query, TypeSpecPath key) {
        return QueryUtil.addColumn(query, key, 0);
    }

    public static Property addColumn(BQuery query, TypeSpecPath key, int flags) {
        BTypeSpec tableTypeSpec = QueryUtil.getRowType(query);
        BProjection projection = query.getProjection();
        if (projection == null) {
            projection = new BProjection();
            query.select(projection);
        }
        String escaped = SlotPath.escape((String)TextUtil.fromFriendly((String)key.alias));
        BProjCol projCol = QueryUtil.makeColumn(query, key);
        if (projection.get(escaped) == null) {
            return projection.add(escaped, (BValue)projCol, flags);
        }
        Property p = projection.getProperty(escaped);
        if (flags == 0 && Flags.isHidden((BComplex)projection, (Slot)p)) {
            projection.setFlags((Slot)p, projection.getFlags((Slot)p) & 0xFFFFFFFB);
        }
        return projection.getProperty(escaped);
    }

    public static BProjCol makeColumn(BQuery query, TypeSpecPath key) {
        return QueryUtil.getProvider(query).makeColumn(key, query);
    }

    public static int getHiddenColumnsCount(BQuery query) {
        BProjection projection = query.getProjection();
        int count = 0;
        Property[] props = projection.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            if (!Flags.isHidden((BComplex)projection, (Slot)props[i])) continue;
            ++count;
        }
        return count;
    }

    public static void reorderColumns(BQuery query) {
        BProjection projection = query.getProjection();
        if (projection == null) {
            return;
        }
        QueryUtil.reorderColumns(projection);
    }

    public static void reorderColumns(BProjection projection) {
        ArrayList<Property> a = new ArrayList<Property>(Arrays.asList(projection.getDynamicPropertiesArray()));
        Collections.sort(a, (p1, p2) -> {
            if (Flags.isHidden((BComplex)projection, (Slot)p1) && !Flags.isHidden((BComplex)projection, (Slot)p2)) {
                return 1;
            }
            if (!Flags.isHidden((BComplex)projection, (Slot)p1) && Flags.isHidden((BComplex)projection, (Slot)p2)) {
                return -1;
            }
            return 0;
        });
        projection.reorder(a.toArray(new Property[a.size()]));
    }

    public static boolean hasDefaultFilters(BQuery query) {
        BProjectionColumn[] columns = query.getProjection().getProjectionColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].get("defaultFilter") == null) continue;
            return true;
        }
        return false;
    }

    public static BQuery makeQuery(BTypeSpec typeSpec) {
        BQuery query = QueryUtil.makeQuery(new BQuery(), typeSpec);
        if (query.getProjection() != null && query.getProjection().get("in") != null) {
            query.getProjection().remove("in");
        }
        return query;
    }

    public static BQuery makeQuery(BQuery query, BTypeSpec typeSpec) {
        BSingleExtent extent = new BSingleExtent(typeSpec);
        if (query.getExtent() == null) {
            query.from((BExtent)extent);
        } else if (!(query.getExtent() instanceof BEmptyExtent) && !extent.equivalent((Object)query.getExtent())) {
            query.set("extent", (BValue)extent);
        }
        BColumnsProvider provider = QueryUtil.getProvider(query);
        TypeSpecPath[] columns = provider.getDefaultColumns(query);
        BProjection projection = new BProjection();
        query.select(projection);
        for (int i = 0; i < columns.length; ++i) {
            QueryUtil.addColumn(query, columns[i]);
        }
        TypeSpecPath[] keys = provider.getHiddenColumns(query);
        for (int i = 0; i < keys.length; ++i) {
            QueryUtil.addHiddenColumn(query, keys[i]);
        }
        if (query.getProjection() != null && query.getProjection().get("in") != null) {
            query.getProjection().remove("in");
        }
        return query;
    }

    public static BQuery makeQuery(BTypeSpec typeSpec, String[] directProps) {
        Object propTypeSpec = null;
        BComplex instance = (BComplex)typeSpec.getInstance();
        ArrayList<TypeSpecPath> a = new ArrayList<TypeSpecPath>();
        for (int i = 0; i < directProps.length; ++i) {
            Property prop = instance.getProperty(directProps[i]);
            if (prop == null) {
                throw new IllegalStateException("" + typeSpec + "." + directProps[i] + " does not exist");
            }
            a.add(new TypeSpecPath(prop));
        }
        return QueryUtil.makeQuery(typeSpec, a.toArray(new TypeSpecPath[a.size()]));
    }

    public static BQuery makeQuery(BTypeSpec typeSpec, TypeSpecPath[] columns) {
        BQuery query = new BQuery();
        query.from((BExtent)new BSingleExtent(typeSpec));
        query.select(new BProjection());
        for (int i = 0; i < columns.length; ++i) {
            QueryUtil.addColumn(query, columns[i]);
        }
        BColumnsProvider provider = QueryUtil.getProvider(query);
        TypeSpecPath[] keys = provider.getHiddenColumns(query);
        for (int i = 0; i < keys.length; ++i) {
            QueryUtil.addHiddenColumn(query, keys[i]);
        }
        return query;
    }

    public static void ensureValidQuery(BQuery query) {
        if (query.getProjection() == null) {
            query.select(new BProjection());
        }
        boolean validColumn = false;
        BProjectionColumn[] columns = query.getProjection().getProjectionColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (Flags.isHidden((BComplex)query.getProjection(), (Slot)columns[i].getPropertyInParent())) continue;
            validColumn = true;
        }
        if (!validColumn) {
            BTypeSpec typeSpec = QueryUtil.getRowType(query);
            BExtent extent = query.getExtent();
            query.getProjection().removeAll();
            if (!(extent == null || query.getProperty("extent") != null && query.getProperty("extent").isFrozen())) {
                query.from(extent);
            }
            QueryUtil.makeQuery(query, typeSpec);
        }
    }

    public static TypeSpecPath[] getDefaultColumns(BQuery query) {
        BColumnsProvider provider = QueryUtil.getProvider(query);
        return provider.getDefaultColumns(query);
    }

    public static BColumnsProvider getProvider(BQuery query) {
        BColumnsProvider[] providers = (BColumnsProvider[])query.getChildren(BColumnsProvider.class);
        if (providers.length > 0) {
            return providers[providers.length - 1];
        }
        BTypeSpec typeSpec = QueryUtil.getRowType(query);
        if (typeSpec == BTypeSpec.DEFAULT) {
            return defaultProvider;
        }
        Type type = typeSpec.getResolvedType();
        AgentList list = Sys.getRegistry().getAgents(type.getTypeInfo()).filter(AgentFilter.is((Type)BColumnsProvider.TYPE));
        if (list.size() == 0) {
            return defaultProvider;
        }
        return (BColumnsProvider)list.getDefault().getInstance();
    }

    public static TypeSpecPath[] getStandardColumns() {
        ArrayList<TypeSpecPath> a = new ArrayList<TypeSpecPath>();
        Method[] methods = BComponent.class.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getReturnType().equals(Void.TYPE) || methods[i].getReturnType().toString().indexOf("[L") != -1 || methods[i].getParameterTypes().length != 0 && (methods[i].getParameterTypes().length != 1 || !Context.class.isAssignableFrom(methods[i].getParameterTypes()[0]))) continue;
            String name = methods[i].getName();
            if (name.indexOf("get") == 0) {
                name = name.substring(3);
                name = TextUtil.decapitalize((String)name);
            }
            TypeSpecPath tsp = new TypeSpecPath(BTypeSpec.make((String)"baja:String"), name);
            a.add(tsp);
        }
        Collections.sort(a, (s1, s2) -> s1.path.compareTo(s2.path));
        return a.toArray(new TypeSpecPath[a.size()]);
    }
}

