/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaServer;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.SecureIdentityException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaApplication;
import com.prosysopc.ua.UserTokenPolicies;
import com.prosysopc.ua.server.NodeBuilderException;
import com.prosysopc.ua.server.ServerUserIdentity;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManagerListener;
import com.prosysopc.ua.server.UaInstantiationException;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.UaServerException;
import com.prosysopc.ua.server.UserValidator;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.cert.PkiDirectoryCertificateStore;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.ApplicationType;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.stack.core.UserTokenType;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.types.opcua.server.BuildInfoTypeNode;
import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.poll.BNPollScheduler;
import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.opcUaCore.BOpcTcpSecurityModes;
import com.tridium.opcUaCore.BOpcTcpSecurityPolicies;
import com.tridium.opcUaCore.BOpcUserAuthenticationMethods;
import com.tridium.opcUaCore.OpcUaSecurityMode;
import com.tridium.opcUaServer.BOpcTcpEndpoint;
import com.tridium.opcUaServer.BOpcUaBuildInfo;
import com.tridium.opcUaServer.BOpcUaNamespace;
import com.tridium.opcUaServer.BOpcUaServerDeviceFolder;
import com.tridium.opcUaServer.BOpcUaServerSessions;
import com.tridium.opcUaServer.event.BOpcUaAlarmClass;
import com.tridium.opcUaServer.event.BOpcUaAlarmRecipient;
import com.tridium.opcUaServer.util.OpcUaCertificateValidator;
import com.tridium.opcUaServer.util.OpcUaServerUtil;
import com.tridium.opcUaServer.util.OpcUaUserValidator;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.util.CompUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Instant;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmService;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BModule;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pollScheduler", type="BNPollScheduler", defaultValue="new BNPollScheduler()"), @NiagaraProperty(name="opcUaServerName", type="String", defaultValue="N4OpcUaServer"), @NiagaraProperty(name="opcTcpEndpoint", type="BOpcTcpEndpoint", defaultValue="new BOpcTcpEndpoint()"), @NiagaraProperty(name="userAuthenticationMethods", type="BOpcUserAuthenticationMethods", defaultValue="BOpcUserAuthenticationMethods.DEFAULT"), @NiagaraProperty(name="minWorkerThreads", type="int", defaultValue="Math.max(8, OpcUaServerUtil.getBaseThreadCount(Runtime.getRuntime().availableProcessors()))", facets={@Facet(name="BFacets.MIN", value="Math.max(8, OpcUaServerUtil.getBaseThreadCount(Runtime.getRuntime().availableProcessors()))")}), @NiagaraProperty(name="maxSessionCount", type="int", defaultValue="500"), @NiagaraProperty(name="maxSessionTimeout", type="BRelTime", defaultValue="BRelTime.makeMinutes(5)"), @NiagaraProperty(name="maxSubcriptionCount", type="int", defaultValue="50"), @NiagaraProperty(name="maxMonitoredItemsPerSubscription", type="int", defaultValue="10000"), @NiagaraProperty(name="opcTcpConnectionAddress", type="String", defaultValue="", flags=3), @NiagaraProperty(name="serverInfo", type="BOpcUaBuildInfo", defaultValue="new BOpcUaBuildInfo()", flags=3), @NiagaraProperty(name="sessionInfo", type="BOpcUaServerSessions", defaultValue="new BOpcUaServerSessions()", flags=3)})
@NiagaraAction(name="shutdown", parameterType="BInteger", defaultValue="BInteger.make(5)", flags=20)
public class BOpcUaServer
extends BNNetwork
implements SessionManagerListener {
    public static final Property pollScheduler = BOpcUaServer.newProperty((int)0, (BValue)new BNPollScheduler(), null);
    public static final Property opcUaServerName = BOpcUaServer.newProperty((int)0, (String)"N4OpcUaServer", null);
    public static final Property opcTcpEndpoint = BOpcUaServer.newProperty((int)0, (BValue)new BOpcTcpEndpoint(), null);
    public static final Property userAuthenticationMethods = BOpcUaServer.newProperty((int)0, (BValue)BOpcUserAuthenticationMethods.DEFAULT, null);
    public static final Property minWorkerThreads = BOpcUaServer.newProperty((int)0, (int)Math.max(8, OpcUaServerUtil.getBaseThreadCount(Runtime.getRuntime().availableProcessors())), (BFacets)BFacets.make((String)"min", (int)Math.max(8, OpcUaServerUtil.getBaseThreadCount(Runtime.getRuntime().availableProcessors()))));
    public static final Property maxSessionCount = BOpcUaServer.newProperty((int)0, (int)500, null);
    public static final Property maxSessionTimeout = BOpcUaServer.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)5), null);
    public static final Property maxSubcriptionCount = BOpcUaServer.newProperty((int)0, (int)50, null);
    public static final Property maxMonitoredItemsPerSubscription = BOpcUaServer.newProperty((int)0, (int)10000, null);
    public static final Property opcTcpConnectionAddress = BOpcUaServer.newProperty((int)3, (String)"", null);
    public static final Property serverInfo = BOpcUaServer.newProperty((int)3, (BValue)new BOpcUaBuildInfo(), null);
    public static final Property sessionInfo = BOpcUaServer.newProperty((int)3, (BValue)new BOpcUaServerSessions(), null);
    public static final Action shutdown = BOpcUaServer.newAction((int)20, (BValue)BInteger.make((int)5), null);
    public static final Type TYPE = Sys.loadType(BOpcUaServer.class);
    boolean debug = false;
    private final UserValidator userValidator = new OpcUaUserValidator();
    public UaServer server;
    private CountDownLatch syncShutdownServerStart;
    public static final String APP_NAME = "N4_OpcUaServer";
    public static final Lexicon LEX = Lexicon.make(BOpcUaServer.class);
    private static final Logger logger = Logger.getLogger("opcUaServer.server");

    public BNPollScheduler getPollScheduler() {
        return (BNPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BNPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    public String getOpcUaServerName() {
        return this.getString(opcUaServerName);
    }

    public void setOpcUaServerName(String v) {
        this.setString(opcUaServerName, v, null);
    }

    public BOpcTcpEndpoint getOpcTcpEndpoint() {
        return (BOpcTcpEndpoint)this.get(opcTcpEndpoint);
    }

    public void setOpcTcpEndpoint(BOpcTcpEndpoint v) {
        this.set(opcTcpEndpoint, (BValue)v, null);
    }

    public BOpcUserAuthenticationMethods getUserAuthenticationMethods() {
        return (BOpcUserAuthenticationMethods)this.get(userAuthenticationMethods);
    }

    public void setUserAuthenticationMethods(BOpcUserAuthenticationMethods v) {
        this.set(userAuthenticationMethods, (BValue)v, null);
    }

    public int getMinWorkerThreads() {
        return this.getInt(minWorkerThreads);
    }

    public void setMinWorkerThreads(int v) {
        this.setInt(minWorkerThreads, v, null);
    }

    public int getMaxSessionCount() {
        return this.getInt(maxSessionCount);
    }

    public void setMaxSessionCount(int v) {
        this.setInt(maxSessionCount, v, null);
    }

    public BRelTime getMaxSessionTimeout() {
        return (BRelTime)this.get(maxSessionTimeout);
    }

    public void setMaxSessionTimeout(BRelTime v) {
        this.set(maxSessionTimeout, (BValue)v, null);
    }

    public int getMaxSubcriptionCount() {
        return this.getInt(maxSubcriptionCount);
    }

    public void setMaxSubcriptionCount(int v) {
        this.setInt(maxSubcriptionCount, v, null);
    }

    public int getMaxMonitoredItemsPerSubscription() {
        return this.getInt(maxMonitoredItemsPerSubscription);
    }

    public void setMaxMonitoredItemsPerSubscription(int v) {
        this.setInt(maxMonitoredItemsPerSubscription, v, null);
    }

    public String getOpcTcpConnectionAddress() {
        return this.getString(opcTcpConnectionAddress);
    }

    public void setOpcTcpConnectionAddress(String v) {
        this.setString(opcTcpConnectionAddress, v, null);
    }

    public BOpcUaBuildInfo getServerInfo() {
        return (BOpcUaBuildInfo)this.get(serverInfo);
    }

    public void setServerInfo(BOpcUaBuildInfo v) {
        this.set(serverInfo, (BValue)v, null);
    }

    public BOpcUaServerSessions getSessionInfo() {
        return (BOpcUaServerSessions)this.get(sessionInfo);
    }

    public void setSessionInfo(BOpcUaServerSessions v) {
        this.set(sessionInfo, (BValue)v, null);
    }

    public void shutdown(BInteger parameter) {
        this.invoke(shutdown, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "opcUaServer");
    }

    public void started() throws Exception {
        this.initializeAlarmService();
        super.started();
        if (Sys.getService((Type)TYPE) != this) {
            this.configFatal(LEX.getText("opcUaServer.moreThanOneServer"));
            throw new IllegalStateException(LEX.getText("opcUaServer.moreThanOneServer"));
        }
        this.startServer();
    }

    public void stopped() throws Exception {
        if (this.server != null && this.server.isRunning()) {
            this.doShutdown(BInteger.make((int)5));
        }
        super.stopped();
    }

    public final AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.remove("ndriver:NDeviceManager");
        return list;
    }

    private void initializeAlarmService() {
        BComponent service = Sys.getService((Type)BAlarmService.TYPE);
        if (service instanceof BAlarmService) {
            BOpcUaAlarmClass[] children = (BOpcUaAlarmClass[])service.getChildren(BOpcUaAlarmClass.class);
            if (children == null || children.length == 0) {
                Property classProp = service.add("OpcUaAlarmClass?", (BValue)new BOpcUaAlarmClass());
                Property recipientProp = service.add("OpcUaAlarmRecipient?", (BValue)new BOpcUaAlarmRecipient());
                BOpcUaAlarmClass almClass = (BOpcUaAlarmClass)service.get(classProp);
                BOpcUaAlarmRecipient recipient = (BOpcUaAlarmRecipient)service.get(recipientProp);
                recipient.add("l?", (BValue)recipient.makeLink((BComponent)almClass, (Slot)BAlarmClass.alarm, (Slot)BAlarmRecipient.routeAlarm, null));
            }
            if (children != null && children.length != 0) {
                this.getAlarmSourceInfo().setAlarmClass(children[0].getName());
            }
        }
    }

    private void startServer() {
        try {
            if (!this.isServerLicensed()) {
                return;
            }
            if (this.getStatus().isDisabled()) {
                return;
            }
            AccessController.doPrivileged(() -> {
                if (this.syncShutdownServerStart != null) {
                    try {
                        this.syncShutdownServerStart.await();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Exception occurred while waiting for existing server to shutdown", e);
                    }
                }
                String serverName = this.getOpcUaServerName();
                this.initialize(this.getOpcTcpEndpoint().getPort(), this.getOpcTcpEndpoint().getEnabled(), serverName.isEmpty() ? APP_NAME : serverName);
                this.server.start();
                if (this.server != null && this.server.isRunning()) {
                    logger.log(Level.INFO, "OpcUaServer started on port " + this.server.getPort());
                }
                ApplicationIdentity applicationIdentity = this.server.getApplicationIdentity();
                ApplicationDescription applicationDescription = applicationIdentity.getApplicationDescription();
                for (String epUrls : applicationDescription.getDiscoveryUrls()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("OpcUaServer registered at endpoint: " + epUrls);
                    }
                    if (!epUrls.startsWith("opc.tcp:")) continue;
                    this.setOpcTcpConnectionAddress(epUrls);
                }
                this.createAddressSpace();
                return null;
            });
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred while starting server", e);
        }
    }

    private boolean isServerLicensed() {
        try {
            this.getLicenseFeature();
        }
        catch (FeatureNotLicensedException e) {
            this.setFaultCause(LEX.getText("opcUaServer.licensed"));
            return false;
        }
        return true;
    }

    public void doShutdown(BInteger delay) {
        if (this.server != null && this.server.isRunning()) {
            try {
                AccessController.doPrivileged(() -> {
                    this.syncShutdownServerStart = new CountDownLatch(1);
                    LocalizedText reason = new LocalizedText("OpcUaServer stopped", Locale.ENGLISH);
                    if (this.getStatus().isDisabled()) {
                        reason = new LocalizedText("OpcUaServer has been disabled", Locale.ENGLISH);
                    }
                    this.server.shutdown(delay.getInt(), reason);
                    this.server = null;
                    this.syncShutdownServerStart.countDown();
                    this.syncShutdownServerStart = null;
                    logger.log(Level.INFO, reason.getText());
                    return null;
                });
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred while shutting down server", e);
            }
        } else {
            logger.log(Level.INFO, "OpcUaServer is already shut down or closed by user");
        }
    }

    public String getNetworkName() {
        return "OpcUaServer";
    }

    public Type getDeviceFolderType() {
        return BOpcUaServerDeviceFolder.TYPE;
    }

    public Type getDeviceType() {
        return BOpcUaNamespace.TYPE;
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning() || Context.decoding.equals(cx)) {
            super.changed(p, cx);
            return;
        }
        if (p.equals(status)) {
            if (this.getStatus().isDisabled()) {
                if (this.server != null && this.server.isRunning()) {
                    this.shutdown(BInteger.make((int)5));
                }
            } else {
                this.startServer();
            }
        }
        super.changed(p, cx);
    }

    private void initialize(int port, boolean tcpEnable, String applicationName) throws SecureIdentityException, IOException, UaServerException {
        try {
            AccessController.doPrivileged(() -> {
                logger.fine("Initializing OpcUaServer...");
                if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx)) {
                    int adjustedNonBlockingPriority = 7;
                    int adjustedBlockingPriority = 7;
                    int adjustedSelectorPriority = 5;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("OPCUA using adjustedNonBlockingPriority = " + adjustedNonBlockingPriority);
                        logger.fine("OPCUA using adjustedBlockingPriority = " + adjustedBlockingPriority);
                        logger.fine("OPCUA using adjustedSelectorPriority = " + adjustedSelectorPriority);
                    }
                    StackUtils.setNonBlockingWorkExecutorThreadPriority((Integer)adjustedNonBlockingPriority);
                    StackUtils.setBlockingWorkExecutorThreadPriority((Integer)adjustedBlockingPriority);
                    StackUtils.setAsyncSelectorThreadPriority((Integer)adjustedSelectorPriority);
                }
                StackUtils.setBlockingWorkerThreadPoolCoreSize((int)this.getMinWorkerThreads());
                StackUtils.getBlockingWorkExecutor();
                StackUtils.getNonBlockingWorkExecutor();
                this.server = new UaServer();
                if (tcpEnable) {
                    this.server.setPort(UaApplication.Protocol.OpcTcp, port);
                }
                this.server.setServerName("OPCUA/" + applicationName);
                HashSet<InetAddress> bindAddresses = new HashSet<InetAddress>();
                bindAddresses.add(InetAddress.getByAddress(new byte[]{0, 0, 0, 0}));
                this.server.setBindAddresses(bindAddresses);
                OpcUaCertificateValidator validator = new OpcUaCertificateValidator();
                this.server.setCertificateValidator((CertificateValidator)validator);
                ApplicationDescription appDescription = new ApplicationDescription();
                appDescription.setApplicationName(new LocalizedText(applicationName + "@localhost"));
                appDescription.setApplicationUri("urn:localhost:OPCUA:" + applicationName);
                appDescription.setProductUri("urn:tridium.com:OPCUA:" + applicationName);
                appDescription.setApplicationType(ApplicationType.Server);
                String stationHome = Sys.getStationHome().toString();
                PkiDirectoryCertificateStore applicationCertificateStore = new PkiDirectoryCertificateStore(stationHome + File.separator + "PKI" + File.separator + "CA");
                File privatePath = new File(applicationCertificateStore.getBaseDir(), "private");
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("OPCUA using certificate store " + applicationCertificateStore.getBaseDir());
                }
                ApplicationIdentity identity = ApplicationIdentity.loadOrCreateCertificate((ApplicationDescription)appDescription, (String)"Tridium", (String)"opcua", (File)privatePath, null, null, (boolean)true, (String[])new String[0]);
                this.server.setApplicationIdentity(identity);
                List securityModes = OpcUaSecurityMode.makeSecurityModes((BOpcTcpSecurityModes)this.getOpcTcpEndpoint().getSecurityMode(), (BOpcTcpSecurityPolicies)this.getOpcTcpEndpoint().getSecurityPolicies());
                this.server.getSecurityModes().addAll(securityModes);
                BOpcUserAuthenticationMethods userAuthenticationMethods = this.getUserAuthenticationMethods();
                if (userAuthenticationMethods.includes(1)) {
                    this.server.addUserTokenPolicy(UserTokenPolicies.ANONYMOUS);
                }
                if (userAuthenticationMethods.includes(2)) {
                    this.server.addUserTokenPolicy(new UserTokenPolicy("username_plain", UserTokenType.UserName, null, null, SecurityPolicy.NONE.getPolicyUri()));
                }
                this.server.setUserValidator(this.userValidator);
                this.server.init();
                this.initBuildInfo();
                this.server.getSessionManager().setMaxSessionCount(this.getMaxSessionCount());
                this.server.getSessionManager().setMaxSessionTimeout((double)this.getMaxSessionTimeout().getMillis());
                this.server.getSubscriptionManager().setMaxSubscriptionCount(this.getMaxSubcriptionCount());
                this.server.getSubscriptionManager().setMaxMonitoredItemsPerSubscription(this.getMaxMonitoredItemsPerSubscription());
                this.server.getSessionManager().addListener((SessionManagerListener)this);
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            logger.log(Level.SEVERE, "Exception occurred while initializing server", pae);
        }
    }

    private void createAddressSpace() throws StatusException, UaInstantiationException, NodeBuilderException {
        BOpcUaNamespace[] nodeSpaces;
        this.loadInformationModels();
        logger.fine("Creating OPCUA address space");
        for (BOpcUaNamespace nodeSpace : nodeSpaces = (BOpcUaNamespace[])CompUtil.getDescendants((BComponent)this, BOpcUaNamespace.class)) {
            try {
                nodeSpace.startNodeSpace();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred while starting NodeSpace", e);
            }
        }
    }

    private void loadInformationModels() {
    }

    private void initBuildInfo() {
        BuildInfoTypeNode buildInfo = this.server.getNodeManagerRoot().getServerData().getServerStatusNode().getBuildInfoNode();
        buildInfo.setProductName(APP_NAME);
        BModule module = Sys.getModuleForClass(BOpcUaServer.class);
        String classVersion = BModule.getClassVersion(BOpcUaServer.class).toString();
        String classVendor = BModule.getClassVendor(BOpcUaServer.class);
        buildInfo.setManufacturerName(classVendor);
        buildInfo.setSoftwareVersion(classVersion);
        int splitIndex = classVersion.lastIndexOf(".");
        String substring = classVersion.substring(splitIndex + 1);
        buildInfo.setBuildNumber(substring);
        ModuleInfo moduleInfo = module.getModuleInfo(RuntimeProfile.rt);
        if (moduleInfo instanceof NModuleInfo) {
            long buildTime = ((NModuleInfo)moduleInfo).getBuildTime();
            GregorianCalendar c = new GregorianCalendar();
            c.setTimeInMillis(buildTime);
            buildInfo.setBuildDate(DateTime.fromInstant((Instant)c.toInstant()));
        }
    }

    public boolean onActivateSession(Session session, ServerUserIdentity serverUserIdentity) throws StatusException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("onActivateSession " + session.getSessionName() + " " + serverUserIdentity.getName());
        }
        return true;
    }

    public void onActivateSessionError(Session session, UserIdentityToken userIdentityToken, Exception e) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("onActivateSessionError " + session.getSessionName() + " " + e);
        }
    }

    public void onAfterActivateSession(Session session) {
        this.getSessionInfo().addSession(session);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("onAfterActivateSession " + session.getSessionName());
        }
    }

    public void onCancelSession(Session session) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("onCancelSession " + session.getSessionName());
        }
    }

    public void onCloseSession(Session session, boolean b) {
        this.getSessionInfo().removeSession(session);
        OpcUaUserValidator.invalidateSessionForNodeId(session.getSessionId());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("onCloseSession " + session.getSessionName() + " " + b);
        }
    }

    public void onCreateSession(Session session) throws StatusException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("onCreateSession " + session.getSessionName());
        }
    }
}

