/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProUtil;

import com.vykon.vykonProUtil.enums.BPointTypeEnum;
import com.vykon.vykonProUtil.util.BActionSlotBits;
import com.vykon.vykonProUtil.util.BCommandNotification;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBatchConfigFlagsTool
extends BComponent {
    public static final Property startOrd = BBatchConfigFlagsTool.newProperty((int)4, (BValue)BOrd.make((String)"station:|slot:/"), null);
    public static final Property componentName = BBatchConfigFlagsTool.newProperty((int)4, (String)"enter component name", null);
    public static final Property findExactName = BBatchConfigFlagsTool.newProperty((int)4, (boolean)true, null);
    public static final Property componentType = BBatchConfigFlagsTool.newProperty((int)4, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BPointTypeEnum.TYPE)), null);
    public static final Property displayConfirmation = BBatchConfigFlagsTool.newProperty((int)0, (boolean)true, null);
    public static final Property flagBits = BBatchConfigFlagsTool.newProperty((int)5, (int)0, null);
    public static final Property actionSlotBits = BBatchConfigFlagsTool.newProperty((int)5, (int)0, null);
    public static final Action hideSlots = BBatchConfigFlagsTool.newAction((int)4, null);
    public static final Action unhideSlots = BBatchConfigFlagsTool.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BBatchConfigFlagsTool.class);
    private static final BIcon icon = BIcon.std((String)"flag.png");
    private BActionSlotBits slotBits;

    public BOrd getStartOrd() {
        return (BOrd)this.get(startOrd);
    }

    public void setStartOrd(BOrd v) {
        this.set(startOrd, (BValue)v, null);
    }

    public String getComponentName() {
        return this.getString(componentName);
    }

    public void setComponentName(String v) {
        this.setString(componentName, v, null);
    }

    public boolean getFindExactName() {
        return this.getBoolean(findExactName);
    }

    public void setFindExactName(boolean v) {
        this.setBoolean(findExactName, v, null);
    }

    public BEnum getComponentType() {
        return (BEnum)this.get(componentType);
    }

    public void setComponentType(BEnum v) {
        this.set(componentType, (BValue)v, null);
    }

    public boolean getDisplayConfirmation() {
        return this.getBoolean(displayConfirmation);
    }

    public void setDisplayConfirmation(boolean v) {
        this.setBoolean(displayConfirmation, v, null);
    }

    public int getFlagBits() {
        return this.getInt(flagBits);
    }

    public void setFlagBits(int v) {
        this.setInt(flagBits, v, null);
    }

    public int getActionSlotBits() {
        return this.getInt(actionSlotBits);
    }

    public void setActionSlotBits(int v) {
        this.setInt(actionSlotBits, v, null);
    }

    public void hideSlots() {
        this.invoke(hideSlots, null, null);
    }

    public void unhideSlots() {
        this.invoke(unhideSlots, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doHideSlots() {
        StringBuffer message = new StringBuffer();
        BOrd qord = BOrd.make((String)this.buildQuery());
        BITable list = (BITable)qord.resolve().get();
        this.slotBits = new BActionSlotBits(this.getActionSlotBits());
        int[] ordinals = this.slotBits.getOrdinals();
        try (TableCursor cursor = list.cursor();){
            while (cursor.next()) {
                BComponent comp = (BComponent)cursor.get();
                for (int j = 0; j < ordinals.length; ++j) {
                    if (!this.slotBits.getBit(ordinals[j]) || comp.getSlot(this.slotBits.getTag(ordinals[j])) == null) continue;
                    Slot s = comp.getSlot(this.slotBits.getTag(ordinals[j]));
                    comp.setFlags(s, comp.getFlags(s) | 4);
                }
                if (!this.getDisplayConfirmation()) continue;
                message.append("hiding slots for " + comp.getSlotPath() + '\n');
            }
        }
        catch (Exception e) {
            System.out.println(this.getSlotPath() + " - error hiding slots");
            e.printStackTrace();
        }
        if (this.getDisplayConfirmation()) {
            BCommandNotification notify = new BCommandNotification();
            notify.setDialogTitle("Batch config flags tool confirmation");
            notify.setDialogMessage(message.toString());
            notify.raise(false);
        }
    }

    public void doUnhideSlots() {
        StringBuffer message = new StringBuffer();
        BOrd qord = BOrd.make((String)this.buildQuery());
        BITable list = (BITable)qord.resolve().get();
        this.slotBits = new BActionSlotBits(this.getActionSlotBits());
        int[] ordinals = this.slotBits.getOrdinals();
        try (TableCursor cursor = list.cursor();){
            while (cursor.next()) {
                BComponent comp = (BComponent)cursor.get();
                for (int j = 0; j < ordinals.length; ++j) {
                    if (!this.slotBits.getBit(ordinals[j]) || comp.getSlot(this.slotBits.getTag(ordinals[j])) == null) continue;
                    Slot s = comp.getSlot(this.slotBits.getTag(ordinals[j]));
                    comp.setFlags(s, comp.getFlags(s) & 0xFFFFFFFB);
                }
                if (!this.getDisplayConfirmation()) continue;
                message.append("unhiding slots for " + comp.getSlotPath() + '\n');
            }
        }
        catch (Exception e) {
            System.out.println(this.getSlotPath() + " - error unhiding slots");
            e.printStackTrace();
        }
        if (this.getDisplayConfirmation()) {
            BCommandNotification notify = new BCommandNotification();
            notify.setDialogTitle("Batch config flags tool confirmation");
            notify.setDialogMessage(message.toString());
            notify.raise(false);
        }
    }

    private String buildQuery() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getStartOrd().toString());
        sb.append("|bql:select * ");
        int t = this.getComponentType().getOrdinal();
        switch (t) {
            case 0: {
                sb.append("from control:BooleanWritable");
                break;
            }
            case 1: {
                sb.append("from control:EnumWritable");
                break;
            }
            case 2: {
                sb.append("from control:NumericWritable");
                break;
            }
            case 3: {
                sb.append("from control:StringWritable");
            }
        }
        if (this.getFindExactName()) {
            sb.append(" where name='" + this.getComponentName() + "'");
        } else {
            sb.append(" where name like '*" + this.getComponentName() + "*'");
        }
        return sb.toString();
    }

    public BIcon getIcon() {
        return icon;
    }
}

