/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui.tag;

import com.tridium.template.ui.file.BWbDeployableNtplFile;
import com.tridium.ui.theme.Theme;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Tag;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraAction(name="selectTemplate")
public class BTemplateTagChooser
extends BEdgePane {
    public static final Action selectTemplate = BTemplateTagChooser.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BTemplateTagChooser.class);
    private Map<BWbDeployableNtplFile, HashSet<Tag>> tagMap;
    private TemplateTagTableModel completeTableModel;
    private TemplateTagTableModel selectedTableModel;
    private TemplateResultsTableModel resultsTableModel;
    private BListDropDown templateList;
    private BTextField defaultTagId;
    private BTextField defaultValue;
    private static final Lexicon lex = Lexicon.make((String)"template");
    private static BImage redBall = BImage.make((String)"module://icons/x16/shapes/circleRed.png");
    private static BImage greenBall = BImage.make((String)"module://icons/x16/shapes/circleGreen.png");
    private final String LEX_SELECTED = lex.getText("bulkDeploy.excelExport.columnSelect");
    private final String LEX_TEMPLATE = lex.getText("bulkDeploy.excelExport.columnFile");
    private final String LEX_TAG = lex.getText("bulkDeploy.excelExport.columnTag");
    private final String LEX_DEFAULT = lex.getText("bulkDeploy.excelExport.columnDefault");
    private static final int SELECTED_COL = 0;
    private static final int TEMPLATE_COL = 1;
    private static final int TAG_COL = 2;
    private static final int DEFAULT_COL = 3;
    private static final int VISIBLE_ROWS = 5;

    public void selectTemplate() {
        this.invoke(selectTemplate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BTemplateTagChooser(Map<BWbDeployableNtplFile, HashSet<Tag>> tagMap) {
        if (tagMap == null || tagMap.isEmpty()) {
            return;
        }
        this.tagMap = tagMap;
        this.completeTableModel = new TemplateTagTableModel();
        this.completeTableModel.loadFromTagMap();
        this.selectedTableModel = new TemplateTagTableModel();
        this.resultsTableModel = new TemplateResultsTableModel();
        this.templateList = new BListDropDown();
        tagMap.keySet().forEach(templateFile -> this.templateList.getList().addItem((Object)templateFile.getTitle()));
        this.linkTo((BComponent)this.templateList, (Slot)BListDropDown.valueModified, (Slot)selectTemplate);
        BLabel helpLabel = new BLabel(lex.getText("bulkDeploy.excelExport.selectTemplatesHelp"));
        helpLabel.setHalign(BHalign.left);
        this.setTop((BWidget)helpLabel);
        BInsets defaultInsets = BInsets.make((double)7.0);
        BFlowPane leftPane = new BFlowPane();
        leftPane.add(null, (BValue)this.templateList);
        this.setLeft((BWidget)new BBorderPane((BWidget)leftPane, defaultInsets));
        if (this.templateList.getList().getItemCount() > 0) {
            this.templateList.setSelectedIndex(0);
        }
        TemplateSelectTable selectTable = new TemplateSelectTable();
        BConstrainedPane selectPane = new BConstrainedPane((BWidget)selectTable);
        selectPane.setMinHeight(selectTable.getCellRenderer().getCellHeight() * 5.0);
        selectPane.setMaxHeight(selectTable.getCellRenderer().getCellHeight() * 5.0);
        this.setCenter((BWidget)new BBorderPane((BWidget)selectPane, defaultInsets));
        TemplateResultsTable resultsTable = new TemplateResultsTable();
        BConstrainedPane resultsTablePane = new BConstrainedPane((BWidget)resultsTable);
        resultsTablePane.setMinHeight(resultsTable.getCellRenderer().getCellHeight() * 5.0);
        resultsTablePane.setMaxHeight(resultsTable.getCellRenderer().getCellHeight() * 5.0);
        BGridPane resultsPane = new BGridPane(1);
        resultsPane.add(null, (BValue)new BBorderPane((BWidget)resultsTablePane, defaultInsets));
        BFlowPane defaultsPane = new BFlowPane();
        defaultsPane.add(null, (BValue)new BLabel(lex.getText("bulkDeploy.excelExport.tagIdLabel")));
        this.defaultTagId = new BTextField("", 16, false);
        defaultsPane.add(null, (BValue)this.defaultTagId);
        defaultsPane.add(null, (BValue)new BLabel(lex.getText("bulkDeploy.excelExport.defaultLabel")));
        this.defaultValue = new BTextField("", 16, true);
        defaultsPane.add(null, (BValue)this.defaultValue);
        SetDefault setDefaultCommand = new SetDefault();
        defaultsPane.add(null, (BValue)new BButton((Command)setDefaultCommand, true, false));
        resultsPane.add(null, (BValue)defaultsPane);
        this.setBottom((BWidget)new BBorderPane((BWidget)resultsPane, defaultInsets));
    }

    public void doSelectTemplate() {
        String item = (String)this.templateList.getSelectedItem();
        this.selectedTableModel.setSelectedTemplate(item);
        this.selectedTableModel.updateTable(true);
    }

    public Map<BWbDeployableNtplFile, HashSet<Tag>> getResult() {
        if (this.resultsTableModel == null) {
            return null;
        }
        HashMap<BWbDeployableNtplFile, HashSet<Tag>> tagResults = new HashMap<BWbDeployableNtplFile, HashSet<Tag>>();
        for (int i = 0; i < this.resultsTableModel.getRowCount(); ++i) {
            HashSet selectedTemplateTags;
            boolean isSelected = (Boolean)this.resultsTableModel.getValueAt(i, 0);
            if (!isSelected) continue;
            BWbDeployableNtplFile templateFile = (BWbDeployableNtplFile)((Object)this.resultsTableModel.getValueAt(i, 1));
            String tagName = (String)this.resultsTableModel.getValueAt(i, 2);
            String defaultValue = (String)this.resultsTableModel.getValueAt(i, 3);
            if (!tagResults.containsKey((Object)templateFile)) {
                selectedTemplateTags = new HashSet();
                tagResults.put(templateFile, selectedTemplateTags);
            } else {
                selectedTemplateTags = (HashSet)tagResults.get((Object)templateFile);
            }
            selectedTemplateTags.add(Tag.newTag((String)tagName, (String)defaultValue));
        }
        return tagResults;
    }

    private String getTagValue(Tag tag) {
        try {
            return tag.getValue().encodeToString();
        }
        catch (IOException e) {
            return "";
        }
    }

    public class SetDefault
    extends Command {
        public SetDefault() {
            super((BWidget)BTemplateTagChooser.this, lex.getText("bulkDeploy.excelExport.setDefaultValue"));
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BTemplateTagChooser.this.defaultTagId.getText() == null || BTemplateTagChooser.this.defaultTagId.getText().length() == 0) {
                return null;
            }
            if (BTemplateTagChooser.this.resultsTableModel.getSelection() == null || BTemplateTagChooser.this.resultsTableModel.getSelection().getRow() < 0) {
                return null;
            }
            String newValue = BTemplateTagChooser.this.defaultValue.getText();
            TemplateTagRow tableRow = BTemplateTagChooser.this.resultsTableModel.getRow(BTemplateTagChooser.this.resultsTableModel.getSelection().getRow());
            tableRow.setDefaultValue(newValue);
            BTemplateTagChooser.this.resultsTableModel.updateTable(true);
            return null;
        }
    }

    class TemplateTagRow {
        private boolean selected = false;
        private BWbDeployableNtplFile templateFile;
        private String qName;
        private String defaultValue;

        public TemplateTagRow(BWbDeployableNtplFile templateFile, Tag tag) {
            this.templateFile = templateFile;
            this.qName = tag.getId().getQName();
            this.defaultValue = "";
        }

        public void setDefaultValue(Tag tag) {
            String tagValue = BTemplateTagChooser.this.getTagValue(tag);
            this.setDefaultValue(tagValue);
        }

        public void setDefaultValue(String tagValue) {
            this.defaultValue = tagValue;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public BWbDeployableNtplFile getTemplateFile() {
            return this.templateFile;
        }

        public String getTagName() {
            return this.qName;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }

    class TemplateTagTableModel
    extends TableModel {
        ArrayList<TemplateTagRow> rows = new ArrayList();

        protected TemplateTagTableModel() {
        }

        public void loadFromTagMap() {
            BTemplateTagChooser.this.tagMap.forEach((templateFile, tags) -> {
                if (tags.isEmpty()) {
                    return;
                }
                tags.forEach(tag -> {
                    TemplateTagRow row = this.getRow((BWbDeployableNtplFile)((Object)templateFile), (Tag)tag);
                    if (row == null) {
                        this.rows.add(new TemplateTagRow((BWbDeployableNtplFile)((Object)templateFile), (Tag)tag));
                    }
                });
            });
        }

        public void setSelectedTemplate(String selectedTitle) {
            this.rows.clear();
            for (int i = 0; i < BTemplateTagChooser.this.completeTableModel.getRowCount(); ++i) {
                TemplateTagRow tableRow = BTemplateTagChooser.this.completeTableModel.getRow(i);
                BWbDeployableNtplFile tableFile = tableRow.getTemplateFile();
                if (!tableFile.getTitle().contentEquals(selectedTitle)) continue;
                this.rows.add(tableRow);
            }
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 3;
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.rows.get(row).isSelected();
                }
                case 1: {
                    return this.rows.get(row).getTemplateFile();
                }
                case 2: {
                    return this.rows.get(row).getTagName();
                }
            }
            return null;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return BTemplateTagChooser.this.LEX_SELECTED;
                }
                case 1: {
                    return BTemplateTagChooser.this.LEX_TEMPLATE;
                }
                case 2: {
                    return BTemplateTagChooser.this.LEX_TAG;
                }
            }
            return "?";
        }

        public TemplateTagRow getRow(int row) {
            if (row >= this.rows.size()) {
                return null;
            }
            return this.rows.get(row);
        }

        public TemplateTagRow getRow(BWbDeployableNtplFile file, Tag tag) {
            String tagName = tag.getId().getQName();
            return this.getRow(file, tagName);
        }

        public TemplateTagRow getRow(BWbDeployableNtplFile file, String tagName) {
            if (this.rows.size() == 0) {
                return null;
            }
            AtomicInteger tagIndex = new AtomicInteger(-1);
            this.rows.forEach(row -> {
                if (((TemplateTagRow)row).templateFile.getTitle().contentEquals(file.getTitle()) && ((TemplateTagRow)row).qName.contentEquals(tagName)) {
                    tagIndex.set(this.rows.indexOf(row));
                    return;
                }
            });
            if (tagIndex.get() >= 0) {
                return this.rows.get(tagIndex.get());
            }
            return null;
        }

        public synchronized BImage getRowIcon(int row) {
            if (this.getRow(row).isSelected()) {
                return greenBall;
            }
            return redBall;
        }

        public boolean containsTag(Tag tag) {
            if (this.rows.size() == 0) {
                return false;
            }
            String tagName = tag.getId().getQName();
            AtomicBoolean tagExists = new AtomicBoolean(false);
            this.rows.forEach(row -> {
                if (((TemplateTagRow)row).qName.contentEquals(tagName)) {
                    tagExists.set(true);
                    return;
                }
            });
            return tagExists.get();
        }
    }

    class TemplateResultsController
    extends TableController {
        TemplateResultsController() {
        }

        public void cellPulsed(BMouseEvent event, int row, int col) {
            super.cellDoubleClicked(event, row, col);
            TemplateTagRow selectedRow = ((TemplateResultsTableModel)this.getModel()).getRow(row);
            String selectedTagName = selectedRow.getTagName();
            String selectedDefaultValue = selectedRow.getDefaultValue();
            BTemplateTagChooser.this.defaultTagId.setText(selectedTagName);
            BTemplateTagChooser.this.defaultValue.setText(selectedDefaultValue);
        }
    }

    class TemplateSelectController
    extends TableController {
        TemplateSelectController() {
        }

        public void cellPulsed(BMouseEvent event, int row, int col) {
            super.cellDoubleClicked(event, row, col);
            TemplateTagRow selectedRow = ((TemplateTagTableModel)this.getModel()).getRow(row);
            BWbDeployableNtplFile selectedFile = selectedRow.getTemplateFile();
            boolean selected = selectedRow.isSelected();
            if (!selected) {
                selectedRow.setSelected(true);
            } else {
                selectedRow.setSelected(false);
            }
            this.getModel().updateTable(true);
            for (int i = 0; i < BTemplateTagChooser.this.completeTableModel.getRowCount(); ++i) {
                TemplateTagRow tableRow = BTemplateTagChooser.this.completeTableModel.getRow(i);
                BWbDeployableNtplFile tableFile = tableRow.getTemplateFile();
                String tableTagName = tableRow.getTagName();
                if (!tableFile.getTitle().contentEquals(selectedFile.getTitle()) || !tableTagName.equals(selectedRow.getTagName())) continue;
                tableRow.setSelected(!selected);
                break;
            }
            BTemplateTagChooser.this.completeTableModel.updateTable(true);
            boolean resultRowFound = false;
            for (int i = 0; i < BTemplateTagChooser.this.resultsTableModel.getRowCount(); ++i) {
                TemplateTagRow tableRow = BTemplateTagChooser.this.resultsTableModel.getRow(i);
                BWbDeployableNtplFile tableFile = tableRow.getTemplateFile();
                String tableTagName = tableRow.getTagName();
                if (!tableFile.getTitle().contentEquals(selectedFile.getTitle()) || !tableTagName.equals(selectedRow.getTagName())) continue;
                resultRowFound = true;
                if (selected) {
                    BTemplateTagChooser.this.resultsTableModel.removeResultsRow(selectedRow);
                }
                BTemplateTagChooser.this.defaultTagId.setText("");
                BTemplateTagChooser.this.defaultValue.setText("");
                break;
            }
            if (!resultRowFound && !selected) {
                BTemplateTagChooser.this.resultsTableModel.addResultsRow(selectedRow);
                BTemplateTagChooser.this.defaultTagId.setText("");
                BTemplateTagChooser.this.defaultValue.setText("");
            }
            BTemplateTagChooser.this.resultsTableModel.updateTable(true);
        }
    }

    class TemplateCellRenderer
    extends TableCellRenderer {
        TemplateCellRenderer() {
        }

        public String getCellText(TableCellRenderer.Cell cell) {
            TemplateTagTableModel model = (TemplateTagTableModel)this.getModel();
            TemplateTagRow row = model.getRow(cell.row);
            switch (cell.column) {
                case 0: {
                    if (row.isSelected()) {
                        return "true";
                    }
                    return "false";
                }
                case 1: {
                    return row.getTemplateFile().getTitle();
                }
                case 2: {
                    return row.getTagName();
                }
                case 3: {
                    return row.getDefaultValue();
                }
            }
            return "";
        }
    }

    class TemplateHeaderRenderer
    extends TableHeaderRenderer {
        TemplateHeaderRenderer() {
        }

        public double getPreferredHeaderWidth(TableHeaderRenderer.Header header) {
            if (header.column == 1) {
                double sw = Theme.table().getHeaderFont().width(header.name);
                for (int i = 0; i < BTemplateTagChooser.this.templateList.getList().getItemCount(); ++i) {
                    String item = (String)BTemplateTagChooser.this.templateList.getList().getItem(i);
                    double itemWidth = Theme.table().getHeaderFont().width(item);
                    if (!(itemWidth > sw)) continue;
                    sw = itemWidth;
                }
                return sw + 6.0;
            }
            return super.getPreferredHeaderWidth(header);
        }
    }

    class TemplateResultsTable
    extends BTable {
        public TemplateResultsTable() {
            this.setModel(BTemplateTagChooser.this.resultsTableModel);
            this.setController(new TemplateResultsController());
            this.setVscrollBarVisible(true);
            this.setCellRenderer(new TemplateCellRenderer());
            this.setHeaderRenderer(new TemplateHeaderRenderer());
        }
    }

    class TemplateSelectTable
    extends BTable {
        public TemplateSelectTable() {
            this.setModel(BTemplateTagChooser.this.selectedTableModel);
            this.setController(new TemplateSelectController());
            this.setVscrollBarVisible(true);
            this.setCellRenderer(new TemplateCellRenderer());
            this.setHeaderRenderer(new TemplateHeaderRenderer());
        }
    }

    class TemplateResultsTableModel
    extends TemplateTagTableModel {
        private TemplateResultsTableModel() {
        }

        public void addResultsRow(TemplateTagRow addRow) {
            this.rows.add(addRow);
        }

        public void removeResultsRow(TemplateTagRow removeRow) {
            this.rows.remove(removeRow);
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return ((TemplateTagRow)this.rows.get(row)).isSelected();
                }
                case 1: {
                    return ((TemplateTagRow)this.rows.get(row)).getTemplateFile();
                }
                case 2: {
                    return ((TemplateTagRow)this.rows.get(row)).getTagName();
                }
                case 3: {
                    return ((TemplateTagRow)this.rows.get(row)).getDefaultValue();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return BTemplateTagChooser.this.LEX_SELECTED;
                }
                case 1: {
                    return BTemplateTagChooser.this.LEX_TEMPLATE;
                }
                case 2: {
                    return BTemplateTagChooser.this.LEX_TAG;
                }
                case 3: {
                    return BTemplateTagChooser.this.LEX_DEFAULT;
                }
            }
            return "?";
        }
    }
}

