/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui.tag;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BImage;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableCellRenderer;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.treetable.TreeTableSelection;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.view.BWbView;

public class BTagTable
extends BTreeTable {
    public static final Type TYPE = Sys.loadType(BTagTable.class);
    protected static final BIcon tagIcon = BIcon.std((String)"tag.png");
    MgrColumn[] cols = new MgrColumn[]{new MgrColumn.Name(), new MgrColumn.PropString("Kind", "kind", 0), new MgrColumn.PropString("TargetType", "targetType", 0)};
    DynamicTableModel dynamicModel;
    Model treeTableModel;
    BWbView view;
    Object[] roots = new Object[0];

    public Type getType() {
        return TYPE;
    }

    public BTagTable() {
    }

    public BTagTable(BWbView view) {
        this.view = view;
        this.treeTableModel = new Model();
        this.dynamicModel = new DynamicTableModel((TableModel)this.treeTableModel);
        this.updateColumns();
        this.setModel((TableModel)this.dynamicModel);
        this.setSelection((TableSelection)new Selection());
        this.setController((TableController)new Controller());
        this.setCellRenderer((TableCellRenderer)new Renderer());
    }

    public void setRoots(Object[] discovery) {
        this.treeTableModel.setDiscovery(discovery);
    }

    public MgrColumn columnIndexToMgrColumn(int column) {
        return this.cols[this.dynamicModel.toRootColumnIndex(column)];
    }

    public Object getObjectAt(int row) {
        TagTableNode node = (TagTableNode)this.treeTableModel.rowToNode(row);
        if (node != null) {
            return node.discovery;
        }
        return null;
    }

    public Object getSelectedObject() {
        int sel = this.getSelection().getRow();
        if (sel < 0) {
            return null;
        }
        return this.getObjectAt(sel);
    }

    public Object[] getSelectedObjects() {
        int[] sel = this.getSelection().getRows();
        Object[] obj = new Object[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            obj[i] = this.getObjectAt(sel[i]);
        }
        return obj;
    }

    public void mouseDragStarted(BMouseEvent event) {
        int[] rows = this.getSelection().getRows();
        if (rows.length == 0) {
            return;
        }
        int rowY = this.getRowAt(event.getY());
        boolean found = false;
        for (int i = 0; i < rows.length; ++i) {
            if (rowY != rows[i]) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        BImage[] icons = new BImage[rows.length];
        String[] text = new String[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            TagTableNode node = (TagTableNode)this.treeTableModel.rowToNode(row);
            icons[i] = node.getIcon();
            text[i] = "" + node.getValueAt(0);
        }
        SimpleDragRenderer dragRenderer = new SimpleDragRenderer(icons, text);
        dragRenderer.font = Theme.table().getCellFont();
    }

    void updateColumns() {
        for (int i = 0; i < this.cols.length; ++i) {
            this.dynamicModel.setShowColumn(i, !this.cols[i].isUnseen());
        }
    }

    static TagTableNode[] sort(TagTableNode[] roots, int col, boolean ascending) {
        TagTableNode[] sorted = (TagTableNode[])roots.clone();
        Object[] keys = new Object[sorted.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = sorted[i].getValueAt(col);
        }
        SortUtil.sort((Object[])keys, (Object[])sorted, (boolean)ascending);
        return sorted;
    }

    class TagTableNode
    extends TreeTableNode {
        Object discovery;
        TagTableNode[] children;
        BImage icon;

        TagTableNode(Model model, Object discovery) {
            super((TreeTableModel)model);
            this.discovery = discovery;
        }

        TagTableNode(TagTableNode parent, Object discovery) {
            super((TreeTableNode)parent);
            this.discovery = discovery;
        }

        public Object getSubject() {
            return this.discovery;
        }

        public boolean hasChildren() {
            if (this.discovery instanceof BComponent) {
                return ((BComponent)this.discovery).getChildComponents().length > 0;
            }
            return false;
        }

        public int getChildCount() {
            return this.getChildren().length;
        }

        public TreeTableNode getChild(int index) {
            return this.getChildren()[index];
        }

        TreeTableNode[] getChildren() {
            if (this.children == null) {
                BComponent[] kidDis = ((BComponent)this.discovery).getChildComponents();
                TagTableNode[] kidNodes = new TagTableNode[kidDis.length];
                for (int i = 0; i < kidNodes.length; ++i) {
                    kidNodes[i] = new TagTableNode(this, (Object)kidDis[i]);
                }
                this.children = kidNodes;
            }
            return this.children;
        }

        public Object getValueAt(int col) {
            return BTagTable.this.cols[col].get(this.discovery);
        }

        public BImage getIcon() {
            if (this.icon == null) {
                this.icon = BImage.make((BIcon)tagIcon);
            }
            return this.icon;
        }
    }

    class Renderer
    extends TreeTableCellRenderer {
        Renderer() {
        }

        public String getCellText(TableCellRenderer.Cell cell) {
            try {
                Object obj = BTagTable.this.getObjectAt(cell.row);
                MgrColumn col = BTagTable.this.columnIndexToMgrColumn(cell.column);
                return col.toDisplayString(obj, cell.value, BTagTable.this.view.getCurrentContext());
            }
            catch (Exception e) {
                return "";
            }
        }
    }

    class Model
    extends TreeTableModel {
        TagTableNode[] roots = new TagTableNode[0];
        Object[] discovery;

        Model() {
        }

        public void setDiscovery(Object[] nodes) {
            this.discovery = (Object[])nodes.clone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateTreeTable(boolean resize) {
            BWbShell shell = BTagTable.this.view.getWbShell();
            shell.enterBusy();
            try {
                TagTableNode[] roots = new TagTableNode[this.discovery.length];
                for (int i = 0; i < roots.length; ++i) {
                    TagTableNode root = this.discoveryToRoot(this.discovery[i]);
                    if (root == null) {
                        root = new TagTableNode(this, this.discovery[i]);
                    }
                    roots[i] = root;
                }
                int sortCol = BTagTable.this.dynamicModel.toRootColumnIndex(BTagTable.this.getSortColumn());
                if (sortCol >= 0) {
                    roots = BTagTable.sort(roots, sortCol, BTagTable.this.isSortAscending());
                }
                this.roots = roots;
                super.updateTreeTable(resize);
            }
            finally {
                shell.exitBusy();
            }
        }

        public int getRootCount() {
            return this.roots.length;
        }

        public TreeTableNode getRoot(int index) {
            return this.roots[index];
        }

        public boolean isDepthExpandable(int depth) {
            return true;
        }

        public int getColumnCount() {
            return BTagTable.this.cols.length;
        }

        public String getColumnName(int col) {
            return BTagTable.this.cols[col].getDisplayName();
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            this.getSelection().deselectAll();
            this.roots = BTagTable.sort(this.roots, col, ascending);
            super.updateTreeTable(false);
        }

        TagTableNode discoveryToRoot(Object discovery) {
            TagTableNode[] roots = this.roots;
            for (int i = 0; i < roots.length; ++i) {
                if (roots[i].discovery != discovery) continue;
                return roots[i];
            }
            return null;
        }
    }

    class Controller
    extends TreeTableController {
        Controller() {
        }

        public void cellDoubleClicked(BMouseEvent event, int row, int col) {
        }
    }

    class Selection
    extends TreeTableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
        }
    }
}

