/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui.makeapp;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.sys.transfer.FileToFile;
import com.tridium.template.BTemplateService;
import com.tridium.template.api.NiagaraTemplate;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.job.BMakeTemplateJob;
import com.tridium.template.ui.file.TmplUtil;
import java.util.Objects;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.ui.BDialog;
import javax.baja.ui.BIHyperlinkShell;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;

public abstract class MakeTemplateCommand
extends Command {
    private static final int JOB_CHECK_SLEEP_TIME = 20;
    private static final Lexicon LEX = Lexicon.make(MakeTemplateCommand.class);
    private BStation station;
    private Command legacyCommand;

    MakeTemplateCommand(BWidget owner, BStation station, String keyBase, Command legacyCommand) {
        super(owner, (Lexicon)UiLexicon.bajaui(), keyBase);
        this.station = station;
        this.legacyCommand = legacyCommand;
    }

    abstract boolean templateServiceCanMakeThisTemplate(BTemplateService var1);

    abstract BMakeTemplateJob startMakingTemplateInService(BStation var1, BTemplateService var2) throws Exception;

    abstract NiagaraTemplate makeTemplate(BStation var1);

    abstract String getTemplateDirectory();

    abstract String getTemplateFileExtension();

    abstract String getLogMessagePrefix();

    public CommandArtifact doInvoke() throws Exception {
        if (this.legacyCommand == null || TmplUtil.stationHasAce(this.station)) {
            return this.invokeImpl();
        }
        return this.legacyCommand.doInvoke();
    }

    private CommandArtifact invokeImpl() throws Exception {
        try {
            BWidgetShell shell;
            boolean isSuperUser;
            BNtplFile destFile = null;
            BComponentSpace space = this.station.getComponentSpace();
            boolean isOnline = space != null && space.isProxyComponentSpace();
            BTemplateService templateService = this.resolveTemplateService();
            boolean templateServiceIsCapable = this.templateServiceCanMakeThisTemplate(templateService);
            BUserService userService = this.resolveUserService();
            boolean bl = isSuperUser = userService != null && this.isSessionUserSuper(userService);
            if (isOnline && templateServiceIsCapable && isSuperUser) {
                BMakeTemplateJob job = this.startMakingTemplateInService(this.station, templateService);
                while (!job.getJobState().isComplete()) {
                    Thread.sleep(20L);
                }
                if (BJobState.success.equals((Object)job.getJobState())) {
                    BOrd fileOrd = job.getTemplateFileOrd();
                    BIFile sourceFile = (BIFile)fileOrd.get((BObject)this.station);
                    String templateName = job.getTemplateName();
                    FilePath destDirectoryPath = new FilePath("~" + this.getTemplateDirectory());
                    BDirectory destDirectory = BFileSystem.INSTANCE.makeDir(destDirectoryPath);
                    String destFilename = FileToFile.getUniqueFilename((BDirectory)destDirectory, (String)(templateName + "." + this.getTemplateFileExtension()));
                    destFile = (BNtplFile)BFileSystem.INSTANCE.makeFile(destDirectoryPath.merge(destFilename));
                    BajaFileUtil.pipe((BIFile)sourceFile, (BIFile)destFile);
                    sourceFile.delete();
                } else {
                    BDialog.error((BWidget)this.getOwner(), (String)this.getLabel(), (Object)LEX.get(this.getLogMessagePrefix() + "failedMake"));
                }
            } else {
                boolean goAhead = true;
                if (isOnline) {
                    if (!isSuperUser) {
                        goAhead = 4 == BDialog.confirm((BWidget)this.getOwner(), (Object)LEX.get(this.getLogMessagePrefix() + "lesserUser"));
                    } else {
                        boolean bl2 = goAhead = 4 == BDialog.confirm((BWidget)this.getOwner(), (Object)LEX.get(this.getLogMessagePrefix() + "missingService"));
                    }
                }
                if (goAhead) {
                    NiagaraTemplate template = this.makeTemplate(this.station);
                    destFile = (BNtplFile)template.save().get();
                }
            }
            if (destFile != null && (shell = this.getShell()) instanceof BIHyperlinkShell) {
                ((BIHyperlinkShell)shell).hyperlink(destFile.getAbsoluteOrd());
            }
        }
        catch (Exception err) {
            BDialog.error((BWidget)this.getOwner(), (String)this.getLabel(), (Object)LEX.get(this.getLogMessagePrefix() + "cannotMake"), (Throwable)err);
        }
        return null;
    }

    private BTemplateService resolveTemplateService() {
        return (BTemplateService)this.resolveService("template:TemplateService");
    }

    private BUserService resolveUserService() {
        return (BUserService)this.resolveService("baja:UserService");
    }

    private BComponent resolveService(String serviceTypespec) {
        try {
            return (BComponent)BOrd.make((String)("service:" + serviceTypespec)).get((BObject)this.station);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isSessionUserSuper(BUserService userService) {
        Objects.requireNonNull(userService);
        BUser user = null;
        BISession session = userService.getSession();
        if (session instanceof BFoxSession) {
            BFoxSession foxSession = (BFoxSession)session;
            try {
                String userName = foxSession.getUsername();
                userService.lease();
                user = userService.getUser(userName);
                user.lease();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return user != null && user.getPermissions().isSuperUser();
    }
}

