/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui.makeapp;

import com.tridium.template.BTemplateService;
import com.tridium.template.api.NiagaraTemplate;
import com.tridium.template.job.BMakeTemplateJob;
import com.tridium.template.ui.BTemplateOptions;
import com.tridium.template.ui.makeapp.MakeTemplateCommand;
import java.util.Objects;
import javax.baja.naming.BOrd;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;

public class MakeStationTemplateCommand
extends MakeTemplateCommand {
    public MakeStationTemplateCommand(BWidget owner, BStation station, Command legacyCommand) {
        super(owner, station, "commands.makeStationTemplate", legacyCommand);
    }

    @Override
    boolean templateServiceCanMakeThisTemplate(BTemplateService templateService) {
        return templateService != null && templateService.getAction("makeStationTemplate") != null;
    }

    @Override
    BMakeTemplateJob startMakingTemplateInService(BStation station, BTemplateService templateService) throws Exception {
        BOrd makeTemplateJobOrd = templateService.makeStationTemplate(BBoolean.make((boolean)BTemplateOptions.get().getUseMinorVersionOnDeployment()));
        BComponentSpace componentSpace = Objects.requireNonNull(station.getComponentSpace());
        componentSpace.sync();
        return (BMakeTemplateJob)makeTemplateJobOrd.relativizeToSession().get((BObject)station);
    }

    @Override
    NiagaraTemplate makeTemplate(BStation station) {
        return NiagaraTemplate.createStationTemplateFrom((BStation)station);
    }

    @Override
    String getTemplateDirectory() {
        return "stationTemplates";
    }

    @Override
    String getTemplateFileExtension() {
        return "ntpl";
    }

    @Override
    String getLogMessagePrefix() {
        return "makeStationTemplate.";
    }
}

