/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui.file;

import com.tridium.excel.ExcelUiUtils;
import com.tridium.raster.viewer.BPictureGrid;
import com.tridium.template.file.NtplUtil;
import com.tridium.template.ui.BulkDeployUtil;
import com.tridium.template.ui.file.BExportConfigsPasswordPrompt;
import com.tridium.template.ui.file.BWbDeployableNtplFile;
import com.tridium.template.ui.tag.BTemplateTagChooser;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.zip.BZipSpace;
import javax.baja.naming.BOrd;
import javax.baja.security.BPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Localizable;
import javax.baja.tag.Tag;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableSubject;
import javax.baja.ui.text.BTextEditor;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;
import javax.baja.workbench.nav.tree.BNavTree;

public class ExportConfigsCommand
extends Command {
    private static final Lexicon lex = Lexicon.make((String)"template");
    private static final Logger log = Logger.getLogger("ntpl");
    private static BOrd exportFileOrd;

    public ExportConfigsCommand(BWidget owner) {
        super(owner, lex, "commands.exportConfigs");
    }

    protected Command doMerge(Command c) {
        return this;
    }

    public CommandArtifact doInvoke() {
        if (ExcelUiUtils.informIfNoExcelSupportIsInstalledLocally(this.getOwner())) {
            return null;
        }
        BObject[] objs = this.getSelectedObjects(this.getOwner());
        if (objs == null) {
            return null;
        }
        ArrayList<BWbDeployableNtplFile> fileList = new ArrayList<BWbDeployableNtplFile>();
        for (BObject obj : objs) {
            if (!(obj instanceof BWbDeployableNtplFile)) continue;
            fileList.add((BWbDeployableNtplFile)obj);
        }
        if (fileList.size() == 0) {
            return null;
        }
        try {
            StringBuilder replyMessage;
            File exportFile;
            BWbDeployableNtplFile[] files = fileList.toArray(new BWbDeployableNtplFile[0]);
            for (int i = 0; i < fileList.size(); ++i) {
                BWbDeployableNtplFile templateFile;
                files[i] = templateFile = (BWbDeployableNtplFile)((BWbDeployableNtplFile)((Object)fileList.get(i))).getAbsoluteOrd().resolve().get();
            }
            if (exportFileOrd == null) {
                boolean isZip;
                exportFileOrd = files[0].getAbsoluteOrd().getParent();
                boolean bl = isZip = files[0].getSpace() instanceof BZipSpace;
                if (isZip || exportFileOrd == null) {
                    exportFileOrd = NtplUtil.getTemplateDirectory().getAbsoluteOrd();
                }
            }
            BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getOwner());
            String defaultFileName = files[0].getFileName();
            if (defaultFileName.length() > 5) {
                defaultFileName = defaultFileName.substring(0, defaultFileName.length() - 5);
            }
            defaultFileName = defaultFileName + ".xlsx";
            chooser.setDefaultFileName(defaultFileName);
            chooser.setCurrentDirectory(exportFileOrd);
            BulkDeployUtil deployUtil = new BulkDeployUtil();
            boolean passwordsInTemplates = deployUtil.templatesHaveConfigPasswords(files);
            BIFile exportPath = null;
            while (exportPath == null) {
                BOrd ord = chooser.show();
                if (ord == null) {
                    return null;
                }
                BIFile candidateExportPath = (BIFile)ord.resolve().get();
                if (passwordsInTemplates && candidateExportPath.getExtension().equalsIgnoreCase("xls")) {
                    String filename = candidateExportPath.getFileName();
                    filename = filename.substring(0, filename.length() - "xls".length()) + "xlsx";
                    try {
                        candidateExportPath.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    BDialog.warning((BWidget)this.getOwner(), (String)lex.getText("bulkDeploy.excelExport.insecureFile.title"), (Object)lex.getText("bulkDeploy.excelExport.insecureFile.message"));
                    chooser.setDefaultFileName(filename);
                    chooser.setCurrentDirectory(ord.getParent());
                    continue;
                }
                exportFileOrd = ord;
                exportPath = candidateExportPath;
            }
            BPassword encryptPassword = null;
            boolean strongPassword = false;
            do {
                if ((encryptPassword = BExportConfigsPasswordPrompt.getPassword(this.getOwner(), passwordsInTemplates, encryptPassword != null)) == BExportConfigsPasswordPrompt.DLG_CANCELLED) {
                    try {
                        exportPath.delete();
                    }
                    catch (Exception filename) {
                        // empty catch block
                    }
                    return null;
                }
                if (encryptPassword == null) continue;
                boolean bl = strongPassword = !encryptPassword.isDefault();
                if (!strongPassword) {
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("bulkDeploy.excelExport.invalidPassword.title"), (Object)lex.getText("bulkDeploy.excelExport.invalidPassword.message"));
                    continue;
                }
                AtomicReference messageReference = new AtomicReference();
                strongPassword = BPasswordStrength.DEFAULT.isPasswordValid(encryptPassword.getValue().toCharArray(), messageReference::set);
                if (strongPassword) continue;
                BDialog.error((BWidget)this.getOwner(), (String)lex.getText("bulkDeploy.excelExport.invalidPassword.title"), (Object)((Localizable)messageReference.get()).toString(null));
            } while (encryptPassword != null && !strongPassword);
            BTextEditor msg = new BTextEditor(lex.getText("bulkDeploy.excelExport.addTagsToConfig.details"), false);
            BTextEditorPane pane = new BTextEditorPane(msg, 4, 80);
            Map<BWbDeployableNtplFile, HashSet<Tag>> selectedTagMap = new HashMap<BWbDeployableNtplFile, HashSet<Tag>>();
            if (4 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("bulkDeploy.excelExport.addTagsToConfig.title"), (Object)pane, (int)12)) {
                HashMap<BWbDeployableNtplFile, HashSet<Tag>> tagMap = new HashMap<BWbDeployableNtplFile, HashSet<Tag>>();
                for (BWbDeployableNtplFile file : files) {
                    HashSet<Tag> fileTags = deployUtil.getStringTagsInTemplate(file);
                    if (fileTags.isEmpty()) continue;
                    tagMap.put(file, fileTags);
                }
                if (!tagMap.isEmpty()) {
                    BTemplateTagChooser tagChooser = new BTemplateTagChooser(tagMap);
                    if (1 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("bulkDeploy.excelExport.addTagsToConfig.title"), (Object)((Object)tagChooser), (int)3)) {
                        selectedTagMap = tagChooser.getResult();
                    }
                }
            }
            if ((exportFile = deployUtil.exportTemplateToExcel(exportPath, encryptPassword, files, selectedTagMap, replyMessage = new StringBuilder())) == null) {
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelExport.exportError"));
                BDialog.error((BWidget)this.getOwner(), (String)lex.getText("templateSideBar.exportConfigsFailure"), (Object)BString.make((String)(lex.getText("templateSideBar.exportConfigsFailure.fileExported", new Object[]{exportPath.getFileName()}) + "\n" + replyMessage.toString())));
                File exportBase = BFileSystem.INSTANCE.pathToLocalFile(exportPath.getFilePath());
                if (exportBase == null) {
                    return null;
                }
                exportFile = new File(exportBase.getParent(), exportBase.getName());
                if (exportFile.length() == 0L) {
                    exportFile.delete();
                }
                return null;
            }
            BDialog.info((BWidget)this.getOwner(), (String)lex.getText("templateSideBar.exportConfigs"), (Object)BString.make((String)lex.getText("templateSideBar.exportConfigs.fileExported", new Object[]{exportFile.getName()})));
        }
        catch (Exception e) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelExport.exportError"), e);
        }
        return null;
    }

    private BObject[] getSelectedObjects(BWidget owner) {
        BObject[] objs = null;
        if (owner instanceof BNavTree) {
            objs = ((BNavTree)owner).getSelectedObjects();
        } else {
            TableSubject subject = null;
            if (owner instanceof BTable) {
                subject = ((BTable)owner).getSelection().getSubject();
            } else if (owner instanceof BPictureGrid) {
                subject = ((BPictureGrid)owner).getSubject(null);
            }
            if (subject != null) {
                ArrayList<BObject> listOfObjects = new ArrayList<BObject>();
                for (int i = 0; i < subject.size(); ++i) {
                    Object x = subject.get(i);
                    if (!(x instanceof BObject)) continue;
                    listOfObjects.add((BObject)x);
                }
                if (listOfObjects.size() > 0) {
                    objs = listOfObjects.toArray(new BObject[0]);
                }
            }
        }
        return objs;
    }
}

