/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui.file;

import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.user.BConfirmPasswordFE;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="applyEncryption", type="boolean", defaultValue="false")
public class BExportConfigsPasswordPrompt
extends BGridPane {
    public static final Property applyEncryption = BExportConfigsPasswordPrompt.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BExportConfigsPasswordPrompt.class);
    static final BPassword DLG_CANCELLED = BPassword.make((String)"");
    private static final Lexicon lex = Lexicon.make((String)"template");
    private BOptionDialog dialog;
    private final BCheckBox encryptBox = new BCheckBox(lex.getText("bulkDeploy.excelExport.encryptDialog.encryptCheckbox"), false);
    private final BConfirmPasswordFE passwordFE = new BConfirmPasswordFE();
    private final BLabel noteLabel = new BLabel(lex.getText("bulkDeploy.excelExport.encryptDialog.noteLabel"));
    private final BLabel cautionLabel = new BLabel(lex.getText("bulkDeploy.excelExport.encryptDialog.cautionLabel"));
    private final BLabel reminderLabel = new BLabel(lex.getText("bulkDeploy.excelExport.encryptDialog.reminderLabel"));

    public boolean getApplyEncryption() {
        return this.getBoolean(applyEncryption);
    }

    public void setApplyEncryption(boolean v) {
        this.setBoolean(applyEncryption, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    private BExportConfigsPasswordPrompt(boolean forceEncryption, boolean defaultToEncrypt) {
        super(1);
        this.setHalign(BHalign.left);
        this.setValign(BValign.top);
        this.encryptBox.setSelected(forceEncryption || defaultToEncrypt);
        this.encryptBox.setEnabled(!forceEncryption);
        this.add(null, (BValue)this.encryptBox);
        this.noteLabel.setHalign(BHalign.left);
        this.noteLabel.setWordWrapEnabled(true, 300.0);
        this.add(null, (BValue)this.noteLabel);
        this.add(null, (BValue)this.passwordFE);
        this.cautionLabel.setHalign(BHalign.left);
        this.cautionLabel.setWordWrapEnabled(true, 300.0);
        this.add(null, (BValue)this.cautionLabel);
        this.reminderLabel.setHalign(BHalign.left);
        this.reminderLabel.setWordWrapEnabled(true, 300.0);
        this.add(null, (BValue)this.reminderLabel);
        this.linkTo(null, (BComponent)this.encryptBox, (Slot)BCheckBox.selected, (Slot)applyEncryption);
    }

    public static BPassword getPassword(BWidget owner, boolean forceEncryption, boolean defaultToEncrypt) {
        BOptionDialog dialog;
        BExportConfigsPasswordPrompt prompt = new BExportConfigsPasswordPrompt(forceEncryption, defaultToEncrypt);
        prompt.dialog = dialog = new BOptionDialog(owner, lex.getText("bulkDeploy.excelExport.encryptDialog.title"), (BWidget)prompt, 3, null, null);
        dialog.setBoundsCenteredOnOwner();
        prompt.changed(applyEncryption, null);
        dialog.open();
        if (dialog.getResult() == 1) {
            return prompt.getPassword();
        }
        return DLG_CANCELLED;
    }

    public void changed(Property property, Context context) {
        if (property == applyEncryption) {
            boolean encrypt = this.getApplyEncryption();
            this.passwordFE.setVisible(encrypt);
            this.cautionLabel.setVisible(encrypt);
            this.reminderLabel.setVisible(encrypt);
            if (this.dialog != null) {
                this.dialog.setSize(this.dialog.getWidth(), this.dialog.getHeight() + (encrypt ? 1.0 : -1.0));
            }
        }
    }

    private BPassword getPassword() {
        BPassword password = null;
        if (this.encryptBox.getSelected()) {
            try {
                password = (BPassword)this.passwordFE.saveValue();
                if (password.getValue().isEmpty()) {
                    password = BPassword.DEFAULT;
                }
            }
            catch (Exception ignore) {
                password = BPassword.DEFAULT;
            }
        }
        return password;
    }
}

